<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl" -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- xmlns:iso19115="http://www.isotc211.org/iso19115/" -->
	<xsl:output encoding="ISO-8859-1"/>
	<!-- 
	
    	Autor:   Mapi Torres (IAAA).
    	Fecha: noviembre 2003
    	Comentarios: Hoja de estilo para la visualizacion en Migra de un fichero ISO (largos) version 0.7.  La visualizacion se hace segun el estilo Migra del IGN.
    	Historial:  Finalizada 25/11/2003
        [jnog 5/2/2004] eliminar uso de namespace "iso19115:"
        [jnog 6/2/2004] Tratamiento de clases. 
                        Cambio el emparejamiento del PRODUCTOR_ORGANISMO
                        Elimino PRODUCTOR_ORGANISMO.ACRONIMO y DISTRIBUIDOR_ORGANISMO.ACRONIMO
                        Elimino NOMBRE,FIN y PROCESO en GENEALOGIA porque van a mostrar lo mismo que DESCRIPCION y no merece la pena
                        parsear el texto contenido en DESCRIPCION
                        Dejar una etiqueta generica PRECIO
                        Arreglar SOPORTES_DISPONIBLES
                        Que muestre siempre el ESTADO_VERSION
      [jnog 7/2/2004]	Se unifica PRODUCTOR_ORGANISMO y PRODUCTOR_CONTACTO.
                        Se unifica DISTRIBUIDOR_ORGANISMO y DISTRIBUIDOR_CONTACTO.
                        Se aade seccion: CREACION_DE_METADATOS
			Se elimina COBERTURA_COMPLETADA, NUMERO_COORDENADAS, UNIDADES_X_Y, UNIDADES_Z, CERTIFICACIONES_CALIDAD
	[jlacasta 10/02/2004] Linage no es correcto aunque esta en el estandard, se pone lineage
	                                  Se duplica tarifas para que contmple texto directamente en fees
	[jnog 11/02/2004] Eliminar UNIDADES_TAMAO_TEXTO, TRAMOS_SUELTOS, TIPO_NODO, NOTAS_SOBRE_CALIDAD
	                  Se unifica la presentacion de los INFORMES DE CALIDAD
		-->
	<xsl:template match="/">
		<HTML>
			<HEAD>

				<META HTTP-EQUIV="content-Type" CONTENT="text/html; CHARSET=iso-8859-1"/>
				<META NAME="AUTHOR" CONTENT="Software AG Spain"/>
				<META NAME="DESCRIPTION" CONTENT="SIRTEX DIGA"/>
				<META NAME="KEYWORDS" CONTENT="SIRTEX TEXT RETRIEVAL INTEGRATED               SYSTEM SOFTWARE AG SPAIN"/>
				<TITLE>Visualizacin Documento</TITLE>
			</HEAD>
			<BODY>
				<!--/BODY>BACKGROUND="/sirico/fondo1.gif"-->
				<TABLE WIDTH="100%" BORDER="0">
					<tr>
						<td width="100%" colspan="3"/>
					</tr>
					<tr>
						<td width="100%" colspan="3"/>
					</tr>
					<tr>
						<TD WIDTH="50%">
							<!--FONT SIZE="4" COLOR="#6B3139">    Visualizacin Documento </FONT-->
						</TD>
						<TD WIDTH="25%" ALIGN="right">
						</TD>
					</tr>
				</TABLE>
				<!--HR/-->
				<!-- Esto imprime una linea -->
				<TABLE>
   					 <xsl:variable name="xsltsl-str-lower" select="'a;b;c;d;e;f;g;h;i;j;k;l;m;n;o;p;q;r;s;t;u;v;w;x;y;z'"/>
    					<xsl:variable name="xsltsl-str-upper" select="'A;B;C;D;E;F;G;H;I;J;K;L;M;N;O;P;Q;R;S;T;U;V;W;X;Y;Z'"/>
    							
					<!-- Title: ISO: hasta n ocurrencias;mandatory;texto;  Migra: max card 1; mandatory; texto.-->
					<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
					<xsl:for-each select="MD_Metadata/identificationInfo/*/citation/*/title">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">NOMBRE_DE_PRODUCTO=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="."/>
									</P>
								</B>
							</TD>
						</TR>
					</xsl:for-each>
					<!-- AlternateTitle:  ISO: hasta n ocurrencias, optional.  MIGRA: 1 ocurrencia, mandatory.-->
					<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
					<xsl:choose>
						<xsl:when test="MD_Metadata/identificationInfo/*/citation/*/alternateTitle">
							<xsl:for-each select="MD_Metadata/identificationInfo/*/citation/*/alternateTitle">
								<TR>
									<TD VALIGN="TOP">
										<B>
											<FONT COLOR="#800000">
												<P ALIGN="right">ACRONIMO=</P>
											</FONT>
										</B>
									</TD>
									<TD VALIGN="middle">
										<B>
											<P>
												<xsl:value-of select="."/>
											</P>
										</B>
									</TD>
								</TR>
							</xsl:for-each>
						</xsl:when>
<!-- si no hay valor, es mejor no mostrarlo	<xsl:otherwise>
							<TR>
								<TD VALIGN="TOP">
									<B>
										<FONT COLOR="#800000">
											<P ALIGN="right">ACRONIMO=</P>
										</FONT>
									</B>
								</TD>
								<TD VALIGN="middle">
									<B>
										<P>
											<xsl:text>ND</xsl:text>
										</P>
									</B>
								</TD>
							</TR>
						</xsl:otherwise> -->
					</xsl:choose>
					<!-- date:  ISO:  n ocurrencias, mandatory. MIGRA:  1 ocurrencia, mandatory -->
					<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
					<xsl:for-each select="MD_Metadata/identificationInfo/*/citation/*/date/*">
					<xsl:if test="./dateType= 'publication'">
						<TR>

							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">FECHA_DE_LA_VERSIN=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="./date"/>
									</P>
								</B>
							</TD>
						</TR>
					</xsl:if>						
					</xsl:for-each>
					<!-- Estado de la version:  ISO: n ocurrencias, optional. MIGRA: 1 ocurrencia, mandatory.-->
					<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
					<!-- LISTAS DE CODIGOS-->
					<xsl:choose>
						<xsl:when test="MD_Metadata/identificationInfo/*/status">
							<xsl:for-each select="MD_Metadata/identificationInfo/*/status">
           							<xsl:variable name="estado">
							              <!-- it's translated to lower case -->
							              <xsl:value-of select="translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower)"/>
						            </xsl:variable>							
								<TR>
									<TD VALIGN="TOP">
										<B>
											<FONT COLOR="#800000">
												<P ALIGN="right">ESTADO_DE_LA_VERSIN=</P>
											</FONT>
										</B>
									</TD>
									<TD VALIGN="middle">
										<B>
											<P>
												<xsl:choose>
													<xsl:when test="$estado='001' or $estado='completed' or $estado='completado'">
														<xsl:text>Vigente</xsl:text>
													</xsl:when>
													<xsl:when test="$estado='002' or $estado='historicalarchive' or $estado='archivo histrico' or $estado='archivo historico'">
														<xsl:text>Historico</xsl:text>
													</xsl:when>
													<xsl:when test="$estado='003' or $estado='obsolete' or $estado='obsoleto'">
														<xsl:text>Historico</xsl:text>
													</xsl:when>
													<xsl:when test="$estado='004' or $estado='ongoing' or $estado='en curso'">
														<xsl:text>Vigente</xsl:text>
													</xsl:when>
													<xsl:when test="$estado='005' or $estado='planned' or $estado='planeado'">
														<xsl:text>Vigente</xsl:text>
													</xsl:when>
													<xsl:when test="$estado='006' or $estado='required' or $estado='requerido'">
														<xsl:text>Vigente</xsl:text>
													</xsl:when>
													<xsl:when test="$estado='007' or $estado='underdevelopment' or $estado='en desarrollo'">
														<xsl:text>Provisional</xsl:text>
													</xsl:when>																														
													<xsl:otherwise>
														<xsl:value-of select="$estado"/>
														<!-- Esto no debera ocurrir -> indica dato en iso no correcto. -->
													</xsl:otherwise>					
												</xsl:choose>											
											</P>
										</B>
									</TD>
								</TR>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<TR>
								<TD VALIGN="TOP">
									<B>
										<FONT COLOR="#800000">
											<P ALIGN="right">ESTADO_DE_LA_VERSIN=</P>
										</FONT>
									</B>
								</TD>
								<TD VALIGN="middle">
									<B>
										<P>
											<xsl:text>ND</xsl:text>
											<!-- ?????-->
										</P>
									</B>
								</TD>
							</TR>
						</xsl:otherwise>
					</xsl:choose>
					<!-- Descripcin del contenido: ambos son n ocurrencias, mandatory.-->
					<xsl:for-each select="MD_Metadata/identificationInfo/*/abstract">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">DESCRIPCIN_DEL_CONTENIDO=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="."/>
									</P>
								</B>
							</TD>
						</TR>
					</xsl:for-each>
					<!-- idioma: ambos son n ocurrencias, mandatory.-->
					<xsl:for-each select="MD_Metadata/identificationInfo/*/language">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">IDIOMA/DIALECTO_DEL_CONTENIDO=</P>

									</FONT>
								</B>
							</TD>
							<!-- concuerda con el FGDC nuestro!!!-->
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="."/>
									</P>
								</B>
							</TD>
						</TR>
					</xsl:for-each>
					<!--escala: migra: 1 mandatory.  ISO: n optional.-->
					<xsl:choose>
						<xsl:when test="MD_Metadata/identificationInfo/*/spatialResolution/equivalentScale">
							<xsl:for-each select="MD_Metadata/identificationInfo/*/spatialResolution/equivalentScale">
								<TR>
									<TD VALIGN="TOP">
										<B>
											<FONT COLOR="#800000">
												<P ALIGN="right">ESCALA=</P>
											</FONT>
										</B>
									</TD>
									<TD VALIGN="middle">
										<B>

											<P>
												<xsl:value-of select="."/>
											</P>
										</B>
									</TD>
								</TR>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<TR>
								<TD VALIGN="TOP">
									<B>
										<FONT COLOR="#800000">
											<P ALIGN="right">ESCALA=</P>
										</FONT>
									</B>
								</TD>
								<TD VALIGN="middle">
									<B>
										<P>
											<xsl:text>ND</xsl:text>
											<!-- ?????-->
										</P>
									</B>
								</TD>
							</TR>
						</xsl:otherwise>
					</xsl:choose>
					<!-- Zona:  ISO: n ocurrencias, optional. MIGRA: 1 ocurrencia, mandatory.-->
					<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
					<xsl:choose>
						<xsl:when test="MD_Metadata/identificationInfo/*/descriptiveKeywords/MD_Keywords">
							<xsl:for-each select="MD_Metadata/identificationInfo/*/descriptiveKeywords/MD_Keywords">
								<xsl:choose>
									<xsl:when test="type='place'">
										<TR>
											<TD VALIGN="TOP">
												<B>
													<FONT COLOR="#800000">
														<P ALIGN="right">ZONA=</P>
													</FONT>
												</B>
											</TD>
											<TD VALIGN="middle">
												<B>
													<P>
														<xsl:value-of select="./keyword"/>
													</P>
												</B>
											</TD>
										</TR>
									</xsl:when>
								</xsl:choose>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<TR>
								<TD VALIGN="TOP">
									<B>
										<FONT COLOR="#800000">
											<P ALIGN="right">ZONA=</P>
										</FONT>
									</B>
								</TD>
								<TD VALIGN="middle">
									<B>
										<P>
											<xsl:text>ND</xsl:text>
											<!-- ?????-->
										</P>
									</B>
								</TD>
							</TR>
						</xsl:otherwise>
					</xsl:choose>
<!-- SE ELIMINA LA ETIQUETA COBERTURA_COMPLETADA APARECE COMO COMENTARIO DENTRO DE NOTAS-->
					<!-- tipo de producto:  ISO: n, optional  Migra: 1, Mandatory-->
					<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
					<xsl:choose>
						<xsl:when test="MD_Metadata/identificationInfo/*/citation/*/presentationForm">
							<xsl:for-each select="MD_Metadata/identificationInfo/*/citation/*/presentationForm">
								<TR>
									<TD VALIGN="TOP">
										<B>
											<FONT COLOR="#800000">
												<P ALIGN="right">TIPO_DE_PRODUCTO=</P>
											</FONT>
										</B>
									</TD>
									<TD VALIGN="middle">
										<B>
											<P>
												<xsl:value-of select="."/>
											</P>
										</B>
									</TD>
								</TR>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<TR>
								<TD VALIGN="TOP">
									<B>
										<FONT COLOR="#800000">
											<P ALIGN="right">TIPO_DE_PRODUCTO=</P>
										</FONT>
									</B>
								</TD>
								<TD VALIGN="middle">
									<B>
										<P>
											<xsl:text>ND</xsl:text>
											<!-- ?????-->
										</P>
									</B>
								</TD>
							</TR>
						</xsl:otherwise>
					</xsl:choose>
					<!-- Modelo de datos:  ISO: n, optional  Migra: 1, Mandatory-->
					<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
					<!-- LISTAS DE CODIGOS-->
					<xsl:choose>
						<xsl:when test="MD_Metadata/identificationInfo/*/spatialRepresentationType">
							<xsl:for-each select="MD_Metadata/identificationInfo/*/spatialRepresentationType">
          							<xsl:variable name="modelo">
							              <!-- it's translated to lower case -->
							              <xsl:value-of select="translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower)"/>
						            </xsl:variable>								
								<TR>
									<TD VALIGN="TOP">
										<B>
											<FONT COLOR="#800000">
												<P ALIGN="right">MODELO_DE_DATOS=</P>
											</FONT>
										</B>
									</TD>
									<TD VALIGN="middle">
										<B>
											<P>
												<!--	En el dtd, <!ELEMENT spdoinfo (indspref?, (direct, ((ptvctinf | rastinfo))?)?)> -->
												<!-- como en el fichero original pueden estar las dos etiquetas (indspref y direct), -->
												<!-- se traslada el contenido de las dos separado con un espacio en blanco -->
												<xsl:choose>
													<xsl:when test="$modelo='001' or $modelo='vector'">
														<xsl:text>Vectorial</xsl:text>
													</xsl:when>			
													<xsl:when test="$modelo='002' or $modelo='grid' or $modelo='cuadricula' or $modelo='cuadrcula'">
														<xsl:text>Raster</xsl:text>
													</xsl:when>	
													<xsl:when test="$modelo='003' or $modelo='textTable' or $modelo='Tabla de texto'">
														<xsl:text>Alfanumerico</xsl:text>
													</xsl:when>	
													<xsl:when test="$modelo='004' or $modelo='tin'">
														<xsl:text>Vectorial</xsl:text>
													</xsl:when>
													<xsl:when test="$modelo='005' or $modelo='stereoModel' or $modelo='modelo estreo' or $modelo='modelo estereo'">
														<!-- Sin equivalente en Migra -->
													</xsl:when>
													<xsl:when test="$modelo='006' or $modelo='video'">
														<!-- Sin equivalente en Migra -->
													</xsl:when>																	
													<xsl:otherwise>
													<xsl:value-of select="$modelo"/>
														<!-- Esto no debera ocurrir -> indica dato en iso no correcto. -->
													</xsl:otherwise>														
												</xsl:choose>
											</P>
										</B>
									</TD>
								</TR>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<TR>
								<TD VALIGN="TOP">
									<B>
										<FONT COLOR="#800000">
											<P ALIGN="right">MODELO_DE_DATOS=</P>
										</FONT>
									</B>
								</TD>
								<TD VALIGN="middle">
									<B>
										<P>
											<xsl:text>ND</xsl:text>
											<!-- ?????-->
										</P>
									</B>
								</TD>
							</TR>
						</xsl:otherwise>
					</xsl:choose>
					<!-- Numero de coordenadas:  ISO: n, optional  Migra: 1, Mandatory-->
					<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
          				<xsl:variable name="modelo">
					          <!-- it's translated to lower case -->
					          <xsl:value-of select="translate(normalize-space(MD_Metadata/identificationInfo/*/spatialRepresentationType),$xsltsl-str-upper, $xsltsl-str-lower)"/>
					</xsl:variable>	

<!-- Utilizo la variable modelo, definida un poco mas arriba en el elemeno modelo de datos. Cuando es raster, tengo campo especifico para numero de coordenadas -->				
<xsl:choose>
	<xsl:when test="$modelo='002' or $modelo='grid' or $modelo='cuadricula' or $modelo='cuadrcula' or $modelo='Malla'">
          				<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">NUMERO_DE_COORDENADAS=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
		<xsl:value-of select="MD_Metadata/spatialRepresentationInfo/MD_GridSpatialRepresentation/numberOfDimensions"/>
								</P>
							</B>
						</TD>
					</TR>
	</xsl:when>										
</xsl:choose>
			
<!-- SE ELIMINA UNIDADES_X_Y, APARECEN EN NOTAS-->
<!-- SE ELIMINA UNIDADES_Z, APARECEN EN NOTAS-->
					<xsl:apply-templates select="MD_Metadata/spatialRepresentationInfo/MD_VectorSpatialRepresentation"/>

					<xsl:apply-templates select="MD_Metadata/identificationInfo/*/citation/CI_Citation"/>
					<!-- notas:  en ambos cardinalidad maxima n, optional-->
					<!-- Tres posibles emparejamientos: informacin suplementaria, referenceSystemIdentifier.code y maintenanceAndUpdateFrequency-->
					<xsl:for-each select="MD_Metadata/identificationInfo/*/supplementalInformation">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">NOTAS=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="."/>
									</P>
								</B>
							</TD>
						</TR>
					</xsl:for-each>
					<xsl:for-each select="MD_Metadata/referenceSystemInfo/*/referenceSystemIdentifier/*/code">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">NOTAS=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="."/>
									</P>
								</B>
							</TD>
						</TR>
					</xsl:for-each>
					<xsl:for-each select="MD_Metadata/identificationInfo/*/resourceMaintenance/*/maintenanceAndUpdateFrequency">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">NOTAS=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="."/>
									</P>
								</B>
							</TD>
						</TR>
					</xsl:for-each>
<!-- SE ELIMINA certificaciones de calidad. Aparece dentro de NOTAS -->
<!-- Se homogeneiza la presentacion de los informes de calidad: TEORICA, DETERMINADA, 
     EXACTITUD SEMANTICA EN NOMBRES Y CODIGOS, COHERENCIA GEOMETRICA, COHERENCIA TOPOLOGICA
     , COHERENCIA SEMANTICA, COMPLETITUD -->
					<xsl:for-each select="MD_Metadata/dataQualityInfo/DQ_DataQuality/report">
						<xsl:apply-templates select="."/>
					</xsl:for-each>


					<!-- Seccion GENEALOGIA:  seccin n optional, mientras que sus elementos son 1 optionales.  -->
					<xsl:for-each select="MD_Metadata/dataQualityInfo/DQ_DataQuality/lineage/LI_Lineage/processStep/LI_ProcessStep">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">[GENEALOGIA]</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P/>
								</B>
							</TD>
						</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">[GRUPO_DE_DATOS_<xsl:value-of select="position()"/>]
										</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P/>
								</B>
							</TD>
						</TR>
<!-- Se elimina NOMBRE, FIN, y PROCESO porque muestran lo mismo que DESCRIPCION -->
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">DESCRIPCION=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="./description"/>
									</P>
								</B>
							</TD>
						</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">PRODUCTOR=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="./processor"/>
									</P>
								</B>
							</TD>
						</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">FECHA=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="./dateTime"/>
									</P>
								</B>
							</TD>
						</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">FUENTE=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<p>
										<xsl:value-of select="./source/LI_Source/sourceCitation/*/title"/>
									</p>
								</B>
							</TD>
						</TR>
					</xsl:for-each>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">USO=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="MD_Metadata/identificationInfo/*/purpose"/>
								</P>
							</B>
						</TD>
					</TR>
					<!-- homogeneidad es n optional en Migra...-->
					<xsl:for-each select="MD_Metadata/dataQualityInfo/*/report/DQ_NonQuantitativeAttributeAccuracy">
						<xsl:if test="./nameOfMeasure='HOMOGENEIDAD'">
							<TR>
								<TD VALIGN="TOP">
									<B>
										<FONT COLOR="#800000">
											<P ALIGN="right">HOMOGENEIDAD=</P>
										</FONT>
									</B>
								</TD>
								<TD VALIGN="middle">
									<B>
										<P>
											<xsl:value-of select="./evaluationMethodDescription"/>
										</P>
									</B>
								</TD>
							</TR>
						</xsl:if>
					</xsl:for-each>
		<!-- Se elimina NOTAS_SOBRE_CALIDAD -->
					<!-- Seccion productor organismo es 1 mandatory en Migra. N optional en ISO. Se unifica la informacion del organismo y del contacto-->
					<xsl:for-each select="MD_Metadata/identificationInfo/*/citation/*/citedResponsibleParty/CI_ResponsibleParty[role='originator']">
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">[PRODUCTOR]</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P/>
							</B>
						</TD>
					</TR>
		<xsl:apply-templates select="."/>
					</xsl:for-each>
					<!-- SECCION DISTRIBUIDOR ORGANISMO: 1 mandatory en Migra, n optional en ISO.-->
					<xsl:for-each select="MD_Metadata/distributionInfo/MD_Distribution/distributor/MD_Distributor/distributorContact">
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">[DISTRIBUIDOR]</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P/>
							</B>
						</TD>
					</TR>
		<xsl:apply-templates select="./CI_ResponsibleParty"/>
					</xsl:for-each>
				
					<!-- SECCION DITRIBUCION: la seccin es 1 optional.  Sin embargo sus elementos son n optionales (todo esto en migra).-->
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">[DISTRIBUCION]</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P/>
							</B>
						</TD>
					</TR>
					<xsl:for-each select="MD_Metadata/distributionInfo/MD_Distribution/*/MD_Format/name">
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">FORMATOS_DISPONIBLES=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="."/>
								</P>
							</B>
						</TD>
					</TR>
					</xsl:for-each>
					<xsl:for-each select="MD_Metadata/distributionInfo/MD_Distribution/transferOptions/MD_DigitalTransferOptions/offLine/MD_Medium">
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">SOPORTES_DISPONIBLES=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<p>
									<xsl:value-of select="./name"/>
								</p>
							</B>
						</TD>
					</TR>
					</xsl:for-each>
					<xsl:for-each select="MD_Metadata/identificationInfo/*/resourceConstraints/MD_LegalConstraints/useConstraints">
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">TIPO_DE_DISTRIBUCION=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<p>
									<xsl:value-of select="."/>
								</p>
							</B>
						</TD>
					</TR>
					</xsl:for-each>
					
					<!-- SECCION GRUPO_UNIDADES_DE_DISTRIBUCION: seccion n optional en migra, mientras que sus elementos son 1 optionales.  En Iso: n optional.  -->
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">[GRUPO_UNIDADES_DE_DISTRIBUCION]</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P/>
							</B>
						</TD>
					</TR>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">UNIDAD_DE_DISTRIBUCION_<xsl:value-of select="position()"/>=</P>
								</FONT>
							</B>
						</TD>
						<!--ojo que puede que tenga que ser autogenerable-->
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="MD_Metadata/distributionInfo/MD_Distribution/transferOptions/MD_DigitalTransferOptions/unitsOfDistribution"/>
								</P>
							</B>
						</TD>
					</TR>
<!-- No merece la pena hacer la distincion de moneda <TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">PRECIO_PTAS_<xsl:value-of select="position()"/></P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<p>
									<xsl:if test="MD_Metadata/distributionInfo/MD_Distribution/distributor/MD_Distributor/distributionOrderProcess/MD_StandardOrderProcess/fees/monetaryType/isoName = 'Spanish Peseta'">
										<xsl:value-of select="MD_Metadata/distributionInfo/MD_Distribution/distributor/MD_Distributor/distributionOrderProcess/MD_StandardOrderProcess/fees/monetaryAmt"/>
									</xsl:if>
								</p>
							</B>
						</TD>
					</TR> -->
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">PRECIO_<xsl:value-of select="position()"/>=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<p>
									<!--xsl:if test="MD_Metadata/distributionInfo/MD_Distribution/distributor/MD_Distributor/distributionOrderProcess/MD_StandardOrderProcess/fees/monetaryType/isoName = 'Euro'"-->
										<xsl:value-of select="MD_Metadata/distributionInfo/MD_Distribution/distributor/MD_Distributor/distributionOrderProcess/MD_StandardOrderProcess/fees/monetaryAmt"/>
										<xsl:value-of select="MD_Metadata/distributionInfo/MD_Distribution/distributor/MD_Distributor/distributionOrderProcess/MD_StandardOrderProcess/fees"/>
									<!--/xsl:if-->
								</p>
							</B>
						</TD>
					</TR>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">[CREACION_METADATOS]</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P/>
							</B>
						</TD>
					</TR>

						<TR>

							
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">FECHA_CREACION_METADATOS=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="MD_Metadata/dateStamp"/>
									</P>
								</B>
							</TD>
						</TR>
					<xsl:for-each select="MD_Metadata/contact">
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">[CREADOR_METADATOS]</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P/>
							</B>
						</TD>
					</TR>
		<xsl:apply-templates select="./CI_ResponsibleParty"/>
					</xsl:for-each>
				</TABLE>

				<!--HR/-->
				<!-- Esto imprime una linea -->
				<TABLE WIDTH="100%" BORDER="0">
					<TR>
						<!--TD WIDTH="100%" ALIGN="center">
							<A HREF="#TOP" onMouseOver="showStatus('Inicio Pgina')"> Inicio Pgina</A>
						</TD-->
					</TR>


				</TABLE>
			</BODY>
		</HTML>
	</xsl:template>
	
	<xsl:template match="MD_Metadata/spatialRepresentationInfo/MD_VectorSpatialRepresentation">
		 <xsl:variable name="xsltsl-str-lower" select="'a;b;c;d;e;f;g;h;i;j;k;l;m;n;o;p;q;r;s;t;u;v;w;x;y;z'"/>
		<xsl:variable name="xsltsl-str-upper" select="'A;B;C;D;E;F;G;H;I;J;K;L;M;N;O;P;Q;R;S;T;U;V;W;X;Y;Z'"/>
			
		<!-- Extension vertical:  Migra: 1 optional.  ISO: n optional.-->
		<xsl:for-each select="../../identificationInfo/*/extent/*/verticalElement">
			<TR>
				<TD VALIGN="TOP">
					<B>
						<FONT COLOR="#800000">
							<P ALIGN="right">EXTENSION_VERTICAL=</P>
						</FONT>
					</B>
				</TD>
				<TD VALIGN="middle">
					<B>
						<p>
							<xsl:text>Valor minimo:</xsl:text>
							<xsl:value-of select="./*/minimumValue"/>
							<xsl:text>; Valor maximo:</xsl:text>
							<xsl:value-of select="./*/maximumValue"/>
							<xsl:text>; Unidad de medida:</xsl:text>
							<xsl:value-of select="./*/unitOfMeasure"/>
							<xsl:text>; </xsl:text>
						</p>
					</B>
				</TD>
			</TR>
		</xsl:for-each>
<!-- Se elimina UNIDADES_TAMAO_DEL_TEXTO porque ha quedado obsoleto -->
		<!-- Estructura topologica:  Migra: 1 optional.  ISO: n optional.-->
		<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
		<xsl:for-each select="./topologyLevel">
           		<xsl:variable name="topologia">
			             <!-- it's translated to lower case -->
			             <xsl:value-of select="translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower)"/>
			</xsl:variable>		
			<TR>
				<TD VALIGN="TOP">
					<B>
						<FONT COLOR="#800000">
							<P ALIGN="right">ESTRUCTURA_TOPOLOGICA=</P>
						</FONT>
					</B>
				</TD>
				<TD VALIGN="middle">
					<B>
						<P>
							<xsl:choose>
								<xsl:when test="$topologia='001' or $topologia='geometryonly' or $topologia='slo geometra' or $topologia='solo geometria'">
									<xsl:text>espagueti</xsl:text>
								</xsl:when>
								<xsl:when test="$topologia='002' or $topologia='topology1d' or $topologia='topologa uni-dimensional' or $topologia='topologia uni-dimensional'">
									<xsl:text>cadena nodo</xsl:text>
								</xsl:when>
								<xsl:when test="$topologia='003' or $topologia='planargraph' or $topologia='grafo planar'">
									<xsl:text>topologa parcial</xsl:text>
								</xsl:when>
								<xsl:when test="$topologia='004' or $topologia='fullplanargraph' or $topologia='grafo planar completo'">
									<xsl:text>topologa completa</xsl:text>
								</xsl:when>																										<xsl:when test="$topologia='005' or $topologia='surfacegraph' or $topologia='grafo de superficies'">
									<xsl:text>topologa parcial</xsl:text>
								</xsl:when>
								<xsl:when test="$topologia='006' or $topologia='fullsurfacegraph' or $topologia='grafo de superficies completo'">
									<xsl:text>topologa parcial</xsl:text>
								</xsl:when>
								<xsl:when test="$topologia='007' or $topologia='topology3d' or $topologia='topologia tri-dimensional' or $topologia='topologa tri-dimensional'">
									<xsl:text>topologa parcial</xsl:text>
								</xsl:when>
								<xsl:when test="$topologia='008' or $topologia='fulltopology3d' or $topologia='topologia tri-dimensional completa' or $topologia='topologa tri-dimensional completa'">
									<xsl:text>topologa completa</xsl:text>
								</xsl:when>																										<xsl:when test="$topologia='009' or $topologia='abstract' or $topologia='abstracto'">
									<xsl:text>espagueti</xsl:text>
								</xsl:when>												
							</xsl:choose>
						</P>
					</B>
				</TD>
			</TR>
		</xsl:for-each>
<!-- TRAMOS ya se muestra con los informes de CALIDAD -->
<!-- Se elimina TRAMOS_SUELTOS porque se ha quedado obsoleto -->
<!-- Se elimina TIPOS_DE_NODOS porque se ha quedado obsoleto -->
	</xsl:template>

	<xsl:template match="MD_Metadata/identificationInfo/*/citation/CI_Citation">
		<!-- Tipos de datos Raster.  Migra: 1 optional. ISO:  n optional. -->
		<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
		<!-- Codigos !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!-->
		<xsl:variable name="xsltsl-str-lower" select="'a;b;c;d;e;f;g;h;i;j;k;l;m;n;o;p;q;r;s;t;u;v;w;x;y;z'"/>
		<xsl:variable name="xsltsl-str-upper" select="'A;B;C;D;E;F;G;H;I;J;K;L;M;N;O;P;Q;R;S;T;U;V;W;X;Y;Z'"/>
	
		<xsl:for-each select="../../../contentInfo/MD_CoverageDescription/contentType">

           	<xsl:variable name="tiposraster">
		             <!-- it's translated to lower case -->
		             <xsl:value-of select="translate(normalize-space(.),$xsltsl-str-upper, $xsltsl-str-lower)"/>
		</xsl:variable>			
		<TR>
			<TD VALIGN="TOP">
				<B>
					<FONT COLOR="#800000">
						<P ALIGN="right">TIPOS_DE_DATOS_RASTER=</P>
					</FONT>
				</B>
			</TD>
			<TD VALIGN="middle">
				<B>
					<P>
						<xsl:choose>
							<xsl:when test="$tiposraster='001' or $tiposraster='image' or $tiposraster='imagen'">
								<xsl:text>Areo</xsl:text>
							</xsl:when>
							<xsl:when test="$tiposraster='002' or $tiposraster='thematicclassification' or $tiposraster='clasificacin temtica' or $tiposraster='clasificacion tematica'">
								<xsl:text>Temtico</xsl:text>
							</xsl:when>
							<xsl:when test="$tiposraster='003' or $tiposraster='physicalmeasurement' or $tiposraster='medida fsica' or $tiposraster='medida fisica'">
								<xsl:text>Modelo</xsl:text>
							</xsl:when>														
						</xsl:choose>
					</P>
				</B>
			</TD>
		</TR>
		</xsl:for-each>		
		<!-- Bandas espectrales.  Migra: 1 optional. ISO:  n optional. -->
		<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
		<xsl:for-each select="../../../contentInfo/MD_CoverageDescription/dimension/MD_Band">
			<TR>
				<TD VALIGN="TOP">
					<B>
						<FONT COLOR="#800000">
							<P ALIGN="right">BANDAS_ESPECTRALES=</P>
						</FONT>
					</B>
				</TD>
				<TD VALIGN="middle">
					<B>
						<p>
							<!-- De momento meto tres elementos, podria meter mas... -->
							<xsl:if test="./descriptor">
								<xsl:text>Descriptor: </xsl:text>
								<xsl:value-of select="./descriptor"/>
								<xsl:text>; </xsl:text>
							</xsl:if>
							<xsl:if test="./maxValue">
								<xsl:text>Valor maximo: </xsl:text>
								<xsl:value-of select="./maxValue"/>
								<xsl:text>; </xsl:text>
							</xsl:if>
							<xsl:if test="./minValue">
								<xsl:text>Valor minimo: </xsl:text>
								<xsl:value-of select="./minValue"/>
								<xsl:text>; </xsl:text>
							</xsl:if>
						</p>
					</B>
				</TD>
			</TR>
		</xsl:for-each>
		<!-- Elemento sin emparejamiento en ISO -->
		<TR>
			<TD VALIGN="TOP">
				<B>
					<FONT COLOR="#800000">
						<P ALIGN="right">PLATAFORMA=</P>
					</FONT>
				</B>
			</TD>
			<TD VALIGN="middle">
				<B>
					<P/>
				</B>
			</TD>
		</TR>
		<!-- Elemento sin emparejamiento en ISO -->
		<TR>
			<TD VALIGN="TOP">
				<B>
					<FONT COLOR="#800000">
						<P ALIGN="right">SENSOR=</P>
					</FONT>
				</B>
			</TD>
			<TD VALIGN="middle">
				<B>
					<P/>
				</B>
			</TD>
		</TR>
		<!--nivel de proceso: en ambos n y optional -->
		<!--En migra hay unos valores determinados, pero no hay transformacion de codigos.  Se transcribe lo que hay en code directamente.-->
		<xsl:for-each select="../../../contentInfo/*/processingLevelCode">
			<TR>
				<TD VALIGN="TOP">
					<B>
						<FONT COLOR="#800000">
							<P ALIGN="right">NIVEL_DE_PROCESO=</P>
						</FONT>
					</B>
				</TD>
				<TD VALIGN="middle">
					<B>
						<p>
							<xsl:value-of select="./code"/>
						</p>
					</B>
				</TD>
			</TR>
		</xsl:for-each>
		<!-- malla:  Migra: 1 optional.  Iso: n, optional. -->
		<!-- [Convencion]Repeticin de la etiqueta Migra tantas veces como sea necesario -->
		<xsl:for-each select="../spatialResolution">
			<TR>
				<TD VALIGN="TOP">
					<B>
						<FONT COLOR="#800000">
							<P ALIGN="right">MALLA=</P>
						</FONT>
					</B>
				</TD>
				<TD VALIGN="middle">
					<B>
						<P>
							<xsl:if test="equivalentScale">
								<xsl:value-of select="./equivalentScale"/>
							</xsl:if>
							<xsl:if test="distance">
								<xsl:value-of select="./distance"/>
							</xsl:if>
						</P>
					</B>
				</TD>
			</TR>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="MD_Metadata/identificationInfo/*/spatialRepresentationType">
		<xsl:value-of select="."/>
	</xsl:template>
	<!--xsl:template match="metadata/spdoinfo/direct">
	<xsl:value-of select="."/>
</xsl:template-->

<xsl:template match="CI_ResponsibleParty">
<!--	SE ELIMINA LA ETIQUETA ACRONIMO YA QUE NO SE PUEDE REFLEFAR EN CI_ResponsibleParty -->
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">ORGANISMO=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="./organisationName"/>
								</P>
							</B>
						</TD>
					</TR>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">DIRECCION=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="./contactInfo/*/address/*/deliveryPoint"/>
								</P>
							</B>
						</TD>
					</TR>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">CODIGO_POSTAL=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="./contactInfo/*/address/*/postalCode"/>
								</P>
							</B>
						</TD>
					</TR>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">LOCALIDAD=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="./contactInfo/*/address/*/city"/>
								</P>
							</B>

						</TD>
					</TR>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">PROVINCIA=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="./contactInfo/*/address/*/administrativeArea"/>
								</P>
							</B>
						</TD>
					</TR>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">PAIS=</P>
								</FONT>
							</B>
						</TD>
						<TD VALIGN="middle">
							<B>
								<P>
									<xsl:value-of select="./contactInfo/*/address/*/country"/>
								</P>
							</B>
						</TD>
					</TR>
					<TR>
						<TD VALIGN="TOP">
							<B>
								<FONT COLOR="#800000">
									<P ALIGN="right">DIRECCION_URL=</P>
								</FONT>
							</B>
						</TD>
						<xsl:variable name="url">
							<xsl:value-of select="./contactInfo/*/onlineResource/*/linkage"/>
						</xsl:variable>
						<TD VALIGN="middle">
							<B>
								<P>
									<A HREF="{$url}">
										<xsl:value-of select="./contactInfo/*/onlineResource/*/linkage"/>
									</A>
								</P>
							</B>
						</TD>
					</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">CONTACTO_NOMBRE=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="./individualName"/>
									</P>
								</B>
							</TD>
						</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">CONTACTO_PUESTO_DE_TRABAJO=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P>
										<xsl:value-of select="./positionName"/>
									</P>
								</B>
							</TD>
						</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">TELEFONO=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<p>
										<xsl:value-of select="./contactInfo/*/phone/*/voice"/>
									</p>
								</B>
							</TD>
						</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">TELEFAX=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<p>
										<xsl:value-of select="./contactInfo/*/phone/*/facsimile"/>
									</p>
								</B>
							</TD>
						</TR>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">CORREO_ELECTRONICO=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<p>
										<xsl:value-of select="./contactInfo/*/address/*/electronicMailAddress"/>
									</p>
								</B>
							</TD>
						</TR>

</xsl:template>


<!-- Template para los informes -->
<xsl:template match="report">
	<xsl:variable name="xsltsl-str-lower" select="'a;b;c;d;e;f;g;h;i;j;k;l;m;n;o;p;q;r;s;t;u;v;w;x;y;z; ;;;;;'"/>
	<xsl:variable name="xsltsl-str-upper" select="'A;B;C;D;E;F;G;H;I;J;K;L;M;N;O;P;Q;R;S;T;U;V;W;X;Y;Z;_;A;E;I;O;U'"/>
	
        <xsl:variable name="nombreMedida">
	  <!-- cambiar a mayusculas -->
	  <xsl:value-of select="translate(normalize-space(./*/nameOfMeasure),$xsltsl-str-lower,$xsltsl-str-upper)"/>
	</xsl:variable>			

						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">[
							<xsl:choose>
							  <xsl:when test="$nombreMedida!=''">
							    <xsl:value-of select="$nombreMedida"/>
							  </xsl:when>
							  <xsl:when test="./DQ_CompletenessCommission">
							    COMPLETITUD_POR_EXCESO
							  </xsl:when>
							  <xsl:when test="./DQ_CompletenessOmmission">
							    COMPLETITUD_POR_DEFECTO
							  </xsl:when>
							  <xsl:when test="./DQ_AbsoluteExternalPositionalAccuracy">
							    EXACTITUD_POSICIONAL_EXTERNA_ABSOLUTA
							  </xsl:when>
							  <xsl:when test="./DQ_QuantitativeAtributeAccuracy">
							    EXACTITUD_DE_LOS_ATRIBUTOS_CUANTITATIVOS
							  </xsl:when>
							  <xsl:when test="./DQ_ConceptualConsistency">
							    CONSISTENCIA_CONCEPTUAL
							  </xsl:when>
							  <xsl:when test="./DQ_TopologicalConsistency">
							    CONSISTENCIA_TOPOLOGICA
							  </xsl:when>
							  <xsl:otherwise>
							    <xsl:text>INFORME_CALIDAD</xsl:text>
							  </xsl:otherwise>
							 </xsl:choose>
										]</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<P/>
								</B>
							</TD>
						</TR>
						<xsl:if test="./*/evaluationMethodType">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">TIPO_METODO_EVALUACION=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<p>
										<xsl:value-of select="./*/evaluationMethodType"/>
									</p>
								</B>
							</TD>
						</TR>
						</xsl:if>
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">DESCRIPCION_METODO_EVALUACION=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<p>
										<xsl:choose>
												<xsl:when test="./*/evaluationMethodDescription">
													<xsl:value-of select="./*/evaluationMethodDescription"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:text>ND</xsl:text>
												</xsl:otherwise>
											</xsl:choose>
									</p>
								</B>
							</TD>
						</TR>
						<xsl:if test="./*/result/DQ_QuantitativeResult/value">
						<TR>
							<TD VALIGN="TOP">
								<B>
									<FONT COLOR="#800000">
										<P ALIGN="right">VALOR_RESULTADO_CUANTITATIVO=</P>
									</FONT>
								</B>
							</TD>
							<TD VALIGN="middle">
								<B>
									<p>
  									    <xsl:value-of select="./*/result/DQ_QuantitativeResult/value"/>
									</p>
								</B>
							</TD>
						</TR>
						</xsl:if>
</xsl:template>

</xsl:stylesheet>

