<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output encoding="ISO-8859-1"/>

<!-- An xsl template for displaying metadata in ArcInfo8 with the
     look and feel of "View Details" in the Geography Network

     Copyright (C) 2000 Environmental Systems Research Institute, Inc. (ESRI)

     Revision History: Created 9/12/00 mlyszkiewicz
     	15/07/2002 IAAA, http://iaaa.cps.unizar.es
-->

<xsl:template match="/">
  <HTML>
  <HEAD>
	<STYLE>
	  BODY {font-size:10pt; font-family:Verdana,Arial,sans-serif}
	  TD   {font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9pt; color: #333333}
	  .big   {  font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11pt; color: #333333; font-weight: bold}
	</STYLE>
  </HEAD>

  <BODY>
	<TABLE BORDER="0" CELLPADDING="2" CELLSPACING="2">

	<!-- Display Content Citation if it exists -->
	<xsl:if test="/metadata/idinfo/citation/citeinfo[(title | geoform | origin | pubinfo/pubplace | pubdate != '')]">
	<TR><TD COLSPAN="2" CLASS="big">Content Citation</TD></TR>

	<!-- Display the title -->
	<xsl:if test="/metadata/idinfo/citation[citeinfo/title != '']">
	<TR>
		<TD WIDTH="1%">&#160;</TD>
		<TD WIDTH="30%"><b>Title of Content:</b></TD>
		<TD WIDTH="70%"><font color="#4682B4"><b>
			<xsl:value-of select="metadata/idinfo/citation/citeinfo/title"/></b></font>
		</TD>
	</TR>
	</xsl:if>

	<!-- Display the type of content -->
	<xsl:if test="/metadata/idinfo/citation[citeinfo/geoform != '']">
	<TR>
	<TD>&#160;</TD>
	<TD><b>Type of Content:</b></TD>
	<TD>
		<xsl:for-each select="metadata/idinfo/citation/citeinfo/geoform">
                  <xsl:value-of select="."/>
		<!--<xsl:eval>this.text</xsl:eval>--><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
                                   <!-- <xsl:if test="context()[not(end()) and . != '']">, </xsl:if>-->
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the publisher -->
	<xsl:if test="/metadata/idinfo/citation[citeinfo/origin != '']">
	<TR>
	<TD>&#160;</TD>
	<TD><b>Content Publisher:</b></TD>
	<TD>
		<xsl:for-each select="metadata/idinfo/citation/citeinfo/origin">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the publishing place -->
	<xsl:if test="/metadata/idinfo/citation[citeinfo/pubinfo/pubplace != '']">
	<TR>
	<TD>&#160;</TD>
	<TD><b>Publication Place:</b></TD>
	<TD>
		<xsl:for-each select="metadata/idinfo/citation/citeinfo/pubinfo/pubplace">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the date of publishing -->
	<xsl:if test="/metadata/idinfo/citation[citeinfo/pubdate != '']">
	<TR>
	<TD>&#160;</TD>
	<TD><b>Publication Date:</b></TD>
	<TD>
		<xsl:for-each select="metadata/idinfo/citation/citeinfo/pubdate">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	</xsl:if> <!-- End Content Citation -->


	<!-- Display Content Description if it exists -->
	<xsl:if test="/metadata/idinfo/descript[(abstract | purpose | supplinf != '')]">

	<TR><TD>&#160;</TD></TR>
	<TR><TD COLSPAN="2" CLASS="big">Content Description</TD></TR>

	<!-- Display the abstract -->
	<xsl:if test="/metadata/idinfo[descript/abstract != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top" colspan="2"><b>Content Summary:</b>
		<xsl:for-each select="metadata/idinfo/descript/abstract">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the purpose -->
	<xsl:if test="/metadata/idinfo[descript/purpose != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top" colspan="2"><b>Content Purpose:</b>
		<xsl:for-each select="metadata/idinfo/descript/purpose">
			<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the Supplemental information -->
	<xsl:if test="/metadata/idinfo[descript/supplinf != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top" colspan="2"><b>Supplemental Information:</b>

		<xsl:for-each select="metadata/idinfo/descript/supplinf">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	</xsl:if> <!-- End Content Description -->


	<!-- Display Time Period of Content if it exists -->
	<xsl:if test="/metadata/idinfo/timeperd/timeinfo[(rngdates/begdate | rngdates/enddate != '')
			or (sngdate/caldate != '') or (mdattim/sngdate/caldate != '') ]">

	<TR><TD>&#160;</TD></TR>
	<TR><TD COLSPAN="2" CLASS="big">Time Period of Content</TD></TR>


	<!-- check to see if the dates are a single date, multiple dates, or a range -->
	<xsl:choose>

	<!-- Display a single date -->
	<xsl:when test="/metadata/idinfo/timeperd/timeinfo[sngdate/caldate != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Date:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/timeperd/timeinfo/sngdate/caldate">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:when>

	<xsl:otherwise>

	<xsl:choose>

	<!-- Display multiple dates -->
	<xsl:when test="/metadata/idinfo/timeperd/timeinfo/mdattim[sngdate/caldate != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Date:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/timeperd/timeinfo/mdattim/sngdate">
		<xsl:value-of select="caldate" /><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:when>
	<xsl:otherwise>

	<!-- Display a range of dates (the beginning date) -->
	<xsl:if test="/metadata/idinfo/timeperd/timeinfo[rngdates/begdate != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Beginning Date:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/timeperd/timeinfo/rngdates/begdate">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- the ending date of the range -->
	<xsl:if test="/metadata/idinfo/timeperd/timeinfo[rngdates/enddate != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Ending Date:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/timeperd/timeinfo/rngdates/enddate">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>
	</xsl:otherwise>
	</xsl:choose>
	</xsl:otherwise>
	</xsl:choose>


	</xsl:if> <!-- End Time Period Of Content -->

	<!-- Display Content Status if it exists -->
	<xsl:if test="/metadata/idinfo/status[( progress | update != '')]">

	<TR><TD>&#160;</TD></TR>
	<TR><TD COLSPAN="2" CLASS="big">Content Status</TD></TR>

	<!-- Display the progress -->
	<xsl:if test="/metadata/idinfo[status/progress != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Progress:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/status/progress">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the update frequency -->
	<xsl:if test="/metadata/idinfo[status/update != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Update Frequency:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/status/update">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	</xsl:if> <!-- End Content Status -->


	<!-- Display Spatial Domain if it exists -->
	<xsl:if test="/metadata/idinfo/spdom/bounding[(westbc | eastbc | northbc | southbc != '')
		or (keywords/place/placekey != '')]">

	<TR><TD>&#160;</TD></TR>
	<TR><TD COLSPAN="2" CLASS="big">Spatial Domain</TD></TR>

	<!-- Display the west coordinate -->
	<xsl:if test="/metadata/idinfo/spdom[bounding/westbc != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>West Coordinate:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/spdom/bounding/westbc">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the east coordinate -->
	<xsl:if test="/metadata/idinfo/spdom[bounding/eastbc != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>East Coordinate:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/spdom/bounding/eastbc">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the north coordinate -->
	<xsl:if test="/metadata/idinfo/spdom[bounding/northbc != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>North Coordinate:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/spdom/bounding/northbc">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the south coordinate -->
	<xsl:if test="/metadata/idinfo/spdom[bounding/southbc != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>South Coordinate:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/spdom/bounding/southbc">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the place/area -->
	<xsl:if test="/metadata/idinfo/keywords[place/placekey != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Coverage Area:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/keywords/place/placekey">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	</xsl:if> <!-- End Spatial Domain -->

	<!-- Display Content Keywords if it exists -->
	<xsl:if test="/metadata/idinfo/keywords[(theme/themekey != '') or (place/placekey != '')]">


	<TR><TD>&#160;</TD></TR>
	<TR><TD COLSPAN="2" CLASS="big">Content Keywords</TD></TR>

	<!-- Display theme keywords -->
	<xsl:if test="/metadata/idinfo/keywords[theme/themekey != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Theme Keywords:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/keywords/theme">
			<xsl:for-each select="themekey">
				<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>
			<xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display place keywords -->
	<xsl:if test="/metadata/idinfo/keywords[place/placekey != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Place Keywords:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/keywords/place">
			<xsl:for-each select="placekey">
				<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>
			<xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	</xsl:if>  <!-- End Content Keywords -->

	<!-- Spatial Data Information will always exist...the projection if not specified will always say "geographic" -->

	<TR><TD>&#160;</TD></TR>
	<TR><TD COLSPAN="2" CLASS="big">Spatial Data Information</TD></TR>

	<!-- Display the data type -->
	<xsl:if test="/metadata/idinfo/citation[citeinfo/geoform != '']">
	<TR>
	<TD>&#160;</TD>
	<TD><b>Data Type:</b></TD>
	<TD>
		<xsl:for-each select="metadata/idinfo/citation/citeinfo/geoform">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display the data format -->
	<xsl:if test="/metadata[idinfo/natvform != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Data Format:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/natvform">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Data Projection:</b></TD>
	<TD valign="top">

	<!-- Display the data projection if it is specified under any of the following four elements:
			 mapproj, gridsys, localp or local -->
	<xsl:choose>

	<xsl:when test="/metadata/spref/horizsys[(planar/mapproj != '') or 	(planar/gridsys != '')
					 or (planar/localp != '') or (local != '')]">

		<xsl:for-each select="metadata/spref/horizsys/planar">
			<!-- Display projections defined under the mapproj element -->
			<xsl:for-each select="mapproj/mapprojn">
				<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>

			<!-- Separate projections specified under different metadata elements by a comma -->
			<xsl:if test="./mapproj!= '' and ./gridsys!= ''">, </xsl:if>

			<!-- Display projections defined under the gridsys element -->
			<xsl:for-each select="gridsys">
				<xsl:value-of select="gridsysn" /><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>

			<!-- Separate projections specified under different metadata elements by a comma -->
			<xsl:if test="./gridsys != '' and ./localp != ''">, </xsl:if>

			<!-- Display projections defined under the localp element -->
			<xsl:for-each select="localp">
				Local Planar Coordinate System<xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>

			<xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>

		<!-- Separate projections specified under different metadata elements by a comma -->
		<xsl:if test="metadata/spref/horizsys[ (local != '') and ((planar/mapproj != '') or
			(planar/gridsys != '') or (planar/localp != '') )]">, </xsl:if>

		<!-- Display projections defined under the local element -->
		<xsl:for-each select="metadata/spref/horizsys/local">
			Local Coordinate System<xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>

	</xsl:when>
	<xsl:otherwise>
		Geographic
	</xsl:otherwise>
	</xsl:choose>
	</TD>
	</TR>

	<!-- Display the source scale -->
	<xsl:if test="/metadata/dataqual/lineage[srcinfo/srcscale != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Data Scale:</b></TD>
	<TD valign="top">
		<xsl:value-of select="metadata/dataqual/lineage/srcinfo/srcscale"/>
	</TD>
	</TR>
	</xsl:if>


	<!-- Display Access and Usage Information if it exists -->
	<xsl:if test="/metadata/idinfo[(accconst | useconst != '')]">

	<TR><TD>&#160;</TD></TR>
	<TR><TD COLSPAN="2" CLASS="big">Access and Usage Information</TD></TR>


	<!-- Display access constraints -->
	<xsl:if test="/metadata[idinfo/accconst != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Access Constraints:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/accconst">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	<!-- Display usage constraints -->
	<xsl:if test="/metadata[idinfo/useconst != '']">
	<TR>
	<TD>&#160;</TD>
	<TD valign="top"><b>Use Constraints:</b></TD>
	<TD valign="top">
		<xsl:for-each select="metadata/idinfo/useconst">
		<xsl:value-of select="."/><xsl:if test="not (position()=last())"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>
	</TD>
	</TR>
	</xsl:if>

	</xsl:if> <!-- End Access and Usage Information -->

	</TABLE>

	<BR/><BR/><BR/><CENTER><FONT COLOR="#6495ED">Stylesheet design courtesy of <A TARGET="viewer" HREF="http://www.esri.com">ESRI</A>, &#169; 2000</FONT></CENTER>

  </BODY>
  </HTML>
</xsl:template>


</xsl:stylesheet>