<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dc="http://purl.org/dc/elements/1.1/"
xmlns:dcterms="http://purl.org/dc/terms/"
xmlns:ows="http://www.opengis.net/ows"
xmlns:csw="http://www.opengis.net/cat/csw/2.0.2"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">

  <!-- Stylesheet that translates a correct qualifieddc into a correct CSW Full  -->
  <!-- Author: carlos  IAAA                                                      -->
  <!-- noviembre 2005: -->

  <xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
  
  <xsl:variable name="valid-elements-URI" select="'xml\\fullElements.xml'"/>
  <xsl:variable name="valid-elements" select="document($valid-elements-URI)"/>

  <xsl:template match="/">
    <xsl:apply-templates select="qualifieddc"/>
  </xsl:template>

  <xsl:template match="qualifieddc">	

    <!--xsl:element name="Record"-->
    <csw:Record>

	<!-- Extraer el atributo xml:lang -->
    <xsl:if test="@xml:lang">
	  <!-- xml:lang -->
    <!--  <xsl:attribute name="xml:lang">    	
        <xsl:value-of select="@xml:lang"/>
	  </xsl:attribute> -->
	  
	   <!-- dc:language -->
	  <xsl:element name="dc:language">
	    <xsl:value-of select="@xml:lang"/>
	  </xsl:element>
    </xsl:if>
	
	<!-- Extraer el atributo fileID -->
	<xsl:if test="@fileID">
  	  <!-- fileID -->
    <!--  <xsl:attribute name="xml:fileID">    	
        <xsl:value-of select="@fileID"/>
	  </xsl:attribute> -->

	  <!-- dc:identifier -->
	  <xsl:element name="dc:identifier">
	    <xsl:value-of select="@fileID"/>
	  </xsl:element>
  	</xsl:if>

    <!-- Resto de elementos vlidos -->
    <xsl:for-each select="*">
    		<xsl:variable name="tagname" select="name()"/>
		<xsl:if test="contains($valid-elements,$tagname)">
			<xsl:variable name="coords" select="."/>
			<xsl:if test="not(contains($coords,'northlimit'))">
	      			<xsl:element name="{name()}">
       	   			<xsl:value-of select="normalize-space(.)"/>
        			</xsl:element>
        		</xsl:if>
	  	</xsl:if>
    </xsl:for-each>

    <!-- ows:BoundingBox -->
    <xsl:for-each select="dcterms:spatial">
		<xsl:variable name="coords" select="."/>
		<xsl:if test="contains($coords,'northlimit')">
			<xsl:element name="ows:BoundingBox">
				<xsl:element name="ows:LowerCorner">
					<xsl:value-of select="substring-before(substring-after(normalize-space($coords), 'westlimit='),';')"/>
					<xsl:value-of select="' '"/>
					<xsl:value-of select="substring-before(substring-after(normalize-space($coords), 'southlimit='),';')"/>
				</xsl:element>
				<xsl:element name="ows:UpperCorner">
					<xsl:value-of select="substring-before(substring-after(normalize-space($coords), 'eastlimit='),';')"/>
					<xsl:value-of select="' '"/>
					<xsl:value-of select="substring-before(substring-after(normalize-space($coords), 'northlimit='),';')"/>
				</xsl:element>
			</xsl:element>
	  </xsl:if>
   </xsl:for-each>


    </csw:Record>

  </xsl:template>
</xsl:stylesheet>