# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DialogForCAS
                                 A QGIS plugin
 Tools for management of Data on mesh (Telemac, Uhaina)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-03-24
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Artelia/BRGM/ISL
        email                : a@a
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os

from qgis.PyQt import uic
from qgis.PyQt.QtGui import QFont
from qgis.PyQt.QtWidgets import QApplication, QDialog

FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), "..", "ui", "dialog_for_cas.ui"))


class DialogForCAS(QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        super(DialogForCAS, self).__init__()
        self.setupUi(self)

        font = QFont()
        font.setFamily("monospace [Consolas]")
        font.setFixedPitch(True)
        font.setStyleHint(QFont.TypeWriter)

        self.textBrowser.setFont(font)

        self.btn_copy.clicked.connect(self.copyCodeText)

    def setText(self, txt):
        self.label.setText(txt)

    def appendCodeText(self, txt):
        wrappedText = wrap_custom(
            txt,
            [";", "="],
            width=72,
            subsequent_indent="  ",
        )
        self.textBrowser.append(wrappedText)

    def copyCodeText(self):
        clipboard = QApplication.clipboard()
        clipboard.setText(self.textBrowser.toPlainText())

        self.close()


# https://stackoverflow.com/a/65038809
def wrap_custom(source_text, separator_chars, width=70, keep_separators=True, subsequent_indent=""):
    current_length = 0
    latest_separator = -1
    current_chunk_start = 0
    output = ""
    char_index = 0
    while char_index < len(source_text):
        if source_text[char_index] in separator_chars:
            latest_separator = char_index
        output += source_text[char_index]
        current_length += 1
        if current_length == width:
            if latest_separator >= current_chunk_start:
                # Valid earlier separator, cut there
                cutting_length = char_index - latest_separator
                if not keep_separators:
                    cutting_length += 1
                if cutting_length:
                    output = output[:-cutting_length]
                output += "\n" + subsequent_indent
                current_chunk_start = latest_separator + 1
                char_index = current_chunk_start
            else:
                # No separator found, hard cut
                output += "\n" + subsequent_indent
                current_chunk_start = char_index + 1
                latest_separator = current_chunk_start - 1
                char_index += 1
            current_length = len(subsequent_indent)
        else:
            char_index += 1
    return output
