# -*- coding: utf-8 -*-

"""
/***************************************************************************
 MeshQuality
                                 A QGIS plugin
 Tools for management of Data on mesh (Telemac, Uhaina)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-03-24
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Artelia/BRGM/ISL
        email                : a@a
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import math
import os

from qgis.core import QgsCoordinateTransform, QgsMapLayerProxyModel, QgsMesh, QgsPointXY
from qgis.gui import QgsVertexMarker
from qgis.PyQt import uic
from qgis.PyQt.QtGui import QColor

from ..mesh_tools_dockwidget import MeshToolsDockWidget
from .MeshUtils import MeshUtils

FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), "..", "ui", "mesh_quality.ui"))


class MeshQuality(MeshToolsDockWidget, FORM_CLASS):
    def __init__(self, parent=None):
        super(MeshQuality, self).__init__(parent)
        self.setupUi(self)
        self.prt = parent
        self.path_icon = os.path.join(os.path.dirname(__file__), "..", "icons/")

        self.lay_mesh = self.mMapLayerComboBox.currentLayer()
        self.native_mesh = None
        self.native_mesh_faces_count = None
        self.xform = None

        self.bad_faces_center = []

        self.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.MeshLayer)
        self.mMapLayerComboBox.layerChanged.connect(self.mesh_lay_changed)

        self.mesh_lay_changed()

        self.btn_analyse_mesh.clicked.connect(self.analyse_mesh)
        self.btn_reset_marker.clicked.connect(self.resetVertexMarker)

    def clean(self):
        self.resetVertexMarker()

    ######################################################################################
    #                                                                                    #
    #                                     MESH LAYER                                     #
    #                                                                                    #
    ######################################################################################

    def mesh_lay_changed(self):
        self.lay_mesh = self.mMapLayerComboBox.currentLayer()

        if self.lay_mesh:
            self.writeInfo(self.tr("Current mesh changed : {}").format(self.lay_mesh.name()))
            self.xform = QgsCoordinateTransform(
                self.lay_mesh.crs(),
                self.canvas.mapSettings().destinationCrs(),
                self.project,
            )
        else:
            self.lay_mesh = None
            self.native_mesh = None
            self.xform = None
        self.cur_mesh_changed()

    def cur_mesh_changed(self):
        if self.lay_mesh:
            self.native_mesh = QgsMesh()
            self.lay_mesh.dataProvider().populateMesh(self.native_mesh)

    def analyse_mesh(self):
        if not self.lay_mesh:
            self.writeError(self.tr("No mesh selected"))

        wasInEditMode = False
        if self.lay_mesh.isEditable():
            wasInEditMode = True
            self.lay_mesh.commitFrameEditing(self.xform, False)
            self.cur_mesh_changed()

        self.resetVertexMarker()

        self.native_mesh_faces_count = self.native_mesh.faceCount()

        for index in range(self.native_mesh_faces_count):
            triangle = MeshUtils.faceToTriangle(self.native_mesh, index)
            centroid = self.xform.transform(QgsPointXY(triangle.centroid()))

            if self.chk_equilateralness.isChecked():
                if checkAngles(triangle.angles(), self.qdsb_bad_angle_1.value()):
                    self.addVertexMarker(centroid, "bad_angle_1")
                elif checkAngles(triangle.angles(), self.qdsb_bad_angle_2.value()):
                    self.addVertexMarker(centroid, "bad_angle_2")
                elif checkAngles(triangle.angles(), self.qdsb_bad_angle_3.value()):
                    self.addVertexMarker(centroid, "bad_angle_3")

            if self.chk_min_size.isChecked():
                if any(length < self.qdsb_min_element_length.value() for length in triangle.lengths()):
                    self.addVertexMarker(centroid, "bad_length")
                if triangle.area() < self.qdsb_min_face_area.value():
                    self.addVertexMarker(centroid, "bad_area")

        if self.bad_faces_center:
            self.btn_reset_marker.setEnabled(True)
            self.showVertexMarker()

        if wasInEditMode:
            self.lay_mesh.startFrameEditing(self.xform)

    def addVertexMarker(self, point, type):
        marker = QgsVertexMarker(self.canvas)
        marker.setCenter(QgsPointXY(point))

        if type == "bad_angle_1":
            marker.setColor(QColor(255, 0, 0))
            marker.setPenWidth(2)
            marker.setIconType(QgsVertexMarker.ICON_X)
            marker.setIconSize(10)
        elif type == "bad_angle_2":
            marker.setColor(QColor(255, 255, 0))
            marker.setPenWidth(2)
            marker.setIconType(QgsVertexMarker.ICON_X)
            marker.setIconSize(10)
        elif type == "bad_angle_3":
            marker.setColor(QColor(0, 0, 255))
            marker.setPenWidth(2)
            marker.setIconType(QgsVertexMarker.ICON_X)
            marker.setIconSize(10)
        elif type == "bad_length":
            marker.setColor(QColor(255, 0, 0))
            marker.setPenWidth(2)
            marker.setIconType(QgsVertexMarker.ICON_BOX)
            marker.setIconSize(10)
        elif type == "bad_area":
            marker.setColor(QColor(255, 0, 0))
            marker.setPenWidth(2)
            marker.setIconType(QgsVertexMarker.ICON_TRIANGLE)
            marker.setIconSize(10)

        marker.hide()

        self.bad_faces_center.append(marker)

    def showVertexMarker(self, id=None):
        if id:
            self.bad_faces_center[id].show()
        else:
            for marker in self.bad_faces_center:
                marker.show()

    def hideVertexMarker(self, id=None):
        if id:
            self.bad_faces_center[id].hide()
        else:
            for marker in self.bad_faces_center:
                marker.hide()

    def resetVertexMarker(self):
        if self.bad_faces_center:
            for marker in self.bad_faces_center:
                marker.hide()
                self.canvas.scene().removeItem(marker)
        self.bad_faces_center = []
        self.btn_reset_marker.setEnabled(False)


def checkAngles(angles, checkValue):
    angles = [math.degrees(a) for a in angles]

    # We need to trick because of a strange behavior of QgsTriangle.angles()
    # Sum all angles and check if it's lower than 179 (case of rounding issue...)
    # https://lists.osgeo.org/pipermail/qgis-developer/2021-December/064349.html
    if sum(angles) < 179:
        angles[angles.index(min(angles))] += 90

    return any(a < checkValue for a in angles)
