# -*- coding: utf-8 -*-

"""
/***************************************************************************
 MeshToolsDockWidget
                                 A QGIS plugin
 Tools for management of Data on mesh (Telemac, Uhaina)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-03-24
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Artelia/BRGM/ISL
        email                : a@a
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from contextlib import suppress
from datetime import datetime

from qgis.core import QgsProject
from qgis.PyQt.QtCore import QCoreApplication, pyqtSignal
from qgis.PyQt.QtGui import QColor, QFont
from qgis.PyQt.QtWidgets import QDockWidget
from qgis.utils import iface


class MeshToolsDockWidget(QDockWidget):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        super(MeshToolsDockWidget, self).__init__(parent)

        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.project = QgsProject.instance()

    def closeEvent(self, event):
        with suppress(AttributeError, RuntimeError, TypeError):
            self.clean()

        self.closingPlugin.emit()
        event.accept()

    def clean(self):
        pass

    def tr(self, message):
        return QCoreApplication.translate(self.__class__.__name__, message)

    def write_log(self, txt, mode="Info"):
        self.log.setTextColor(QColor("black"))
        self.log.setFontWeight(QFont.Bold)
        self.log.append(f"{datetime.now().strftime('%H:%M:%S')} - ")
        if mode == "Success":
            self.log.setTextColor(QColor("green"))
        elif mode == "Info":
            self.log.setTextColor(QColor("black"))
        elif mode == "Error":
            self.log.setTextColor(QColor("red"))
        elif mode == "Warning":
            self.log.setTextColor(QColor("orange"))
        self.log.setFontWeight(QFont.Normal)
        self.log.insertPlainText(txt)
        self.log.verticalScrollBar().setValue(self.log.verticalScrollBar().maximum())

    def writeSuccess(self, txt):
        self.write_log(txt, "Success")

    def writeInfo(self, txt):
        self.write_log(txt, "Info")

    def writeError(self, txt):
        self.write_log(txt, "Error")

    def writeWarning(self, txt):
        self.write_log(txt, "Warning")
