# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Merqantile
                                 A QGIS plugin
 Easy visualisation of XYZ tile bounds
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-08-11
        copyright            : (C) 2024 by zabop
        email                : merqantile.sixtyfold818@passmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'zabop'
__date__ = '2024-08-11'
__copyright__ = '(C) 2024 by zabop'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.PyQt.QtGui import QColor
from PyQt5.QtCore import QVariant
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterMultipleLayers,
                       QgsSimpleLineSymbolLayer,
                       QgsProcessingParameterNumber,
                       QgsVectorLayer,
                       QgsFeature,
                       QgsGeometry,
                       QgsPointXY,
                       QgsProject,
                       QgsField,
                       QgsPalLayerSettings,
                       QgsVectorLayerSimpleLabeling,
                       )


import os
import inspect
from qgis.PyQt.QtGui import QIcon

class MerqantileAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(
            QgsProcessingParameterNumber(
                "Z", self.tr("Z"), QgsProcessingParameterNumber.Integer, 13
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                "X", self.tr("X"), QgsProcessingParameterNumber.Integer, 4224
            )
        )

        self.addParameter(
            QgsProcessingParameterNumber(
                "Y", self.tr("Y"), QgsProcessingParameterNumber.Integer, 2424
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        maxc = 20037508.342789244

        def sidelength(z):
            return 2 * maxc / (2 ** z)
        
        def tile_centre(z, x, y):
            x = -maxc + maxc / (2 ** z) + sidelength(z) * x
            y = maxc - maxc / (2 ** z) - sidelength(z) * y
            return x, y

        tileId = f"{parameters['Z']}/{parameters['X']}/{parameters['Y']}"

        vl = QgsVectorLayer("Polygon?crs=EPSG:3857", tileId,"memory")
        pr = vl.dataProvider()
        id_field = QgsField("ID", QVariant.String)
        pr.addAttributes([id_field])
        vl.updateFields()
        
        tc = tile_centre(parameters["Z"], parameters["X"], parameters["Y"])
        sl = sidelength(parameters["Z"])

        points = [
            QgsPointXY(tc[0]-sl/2,tc[1]-sl/2),
            QgsPointXY(tc[0]-sl/2,tc[1]+sl/2),
            QgsPointXY(tc[0]+sl/2,tc[1]+sl/2),
            QgsPointXY(tc[0]+sl/2,tc[1]-sl/2),
            QgsPointXY(tc[0]-sl/2,tc[1]-sl/2)
            ]
        polygon = [points]

        f = QgsFeature()
        f.setGeometry(QgsGeometry.fromPolygonXY(polygon))
        f.setAttributes([tileId])
        pr.addFeature(f)
        vl.updateExtents()
        l = QgsProject.instance().addMapLayer(vl)

        l.renderer().symbol().changeSymbolLayer(
            0, QgsSimpleLineSymbolLayer(QColor("#000000"), width=1)
        )

        # Set up labeling
        label = QgsPalLayerSettings()
        label.fieldName = "ID"
        label.placement = QgsPalLayerSettings.AroundPoint
        label.enabled = True

        # Apply labeling to the layer
        layer_settings = QgsVectorLayerSimpleLabeling(label)
        l.setLabelsEnabled(True)
        l.setLabeling(layer_settings)
        l.triggerRepaint()

        return {self.OUTPUT: "Successfully created layer"}

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Tile ID to Layer'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
    
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon

    def createInstance(self):
        return MerqantileAlgorithm()