# -*- coding: utf-8 -*-

"""
/***************************************************************************
 MergeSelectedFeatures
                                 A QGIS plugin
 Merge selected features in a polygon vector layer
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-08
        copyright            : (C) 2022 by Antonio Sobral Almeida
        email                : sobral.almeida@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Antonio Sobral Almeida'
__date__ = '2022-01-08'
__copyright__ = '(C) 2022 by Antonio Sobral Almeida'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'


from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterFeatureSink
import processing


class MergeSelectedFeaturesAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('inputvector', 'Input vector', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('MergedSelectedFeatures', 'Merged Selected Features', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(11, model_feedback)
        results = {}
        outputs = {}

        vl = self.parameterAsVectorLayer(parameters, 'inputvector', context)
        selcount = vl.selectedFeatureCount()
        if selcount<2 :
            vl.removeSelection()            

        # Extract selected features
        alg_params = {
            'INPUT': parameters['inputvector'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractSelectedFeatures'] = processing.run('native:saveselectedfeatures', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 1
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Area_ha',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,  # Float
            'INPUT': outputs['ExtractSelectedFeatures']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTable1'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Add field to attributes table 2
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'IdToMrg',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Integer
            'INPUT': outputs['AddFieldToAttributesTable1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AddFieldToAttributesTable2'] = processing.run('native:addfieldtoattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Field calculator 1
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'IdToMrg',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,  # Integer
            'FORMULA': '1',
            'INPUT': outputs['AddFieldToAttributesTable2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculator1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Fix geometries
        alg_params = {
            'INPUT': outputs['FieldCalculator1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FixGeometries'] = processing.run('native:fixgeometries', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Dissolve
        alg_params = {
            'FIELD': ['IdToMrg'],
            'INPUT': outputs['FixGeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolve'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Retain fields
        alg_params = {
            'FIELDS': ['IdToMrg','Area_ha'],
            'INPUT': outputs['Dissolve']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RetainFields'] = processing.run('native:retainfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Field calculator 2
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Area_ha',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': ' $area / 10000',
            'INPUT': outputs['RetainFields']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FieldCalculator2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        vl = self.parameterAsVectorLayer(parameters, 'inputvector', context)
        vl.invertSelection()

        # Extract selected features2
        alg_params = {
            'INPUT': parameters['inputvector'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractSelectedFeatures2'] = processing.run('native:saveselectedfeatures', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Merge vector layers
        alg_params = {
            'CRS': None,
            'LAYERS': [outputs['FieldCalculator2']['OUTPUT'],outputs['ExtractSelectedFeatures2']['OUTPUT']],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['MergeVectorLayers'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Field calculator 3
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Area_ha',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': ' $area / 10000',
            'INPUT': outputs['MergeVectorLayers']['OUTPUT'],
            'OUTPUT': parameters['MergedSelectedFeatures']
        }
        outputs['FieldCalculator3'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['MergedSelectedFeatures'] = outputs['FieldCalculator3']['OUTPUT']
        
        vl = self.parameterAsVectorLayer(parameters, 'inputvector', context)
        vl.invertSelection()            
        
        return results

    def name(self):
        return 'Merge Selected Features'

    def displayName(self):
        return 'Merge Selected Features Vers 0.1'

    def group(self):
        return 'Merge Selected Features'

    def groupId(self):
        return 

    def createInstance(self):
        return MergeSelectedFeaturesAlgorithm()

