# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MedirDistanciaEntre
                                 A QGIS plugin
 Plugin para medir la distancia mínima entre dos entidades.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-01
        git sha              : $Format:%H$
        copyright            : (C) 2022 by José A. Pérez Casares
        email                : jperezcasares_at_gmail_com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QPoint
from qgis.PyQt.QtGui import QIcon, QColor
from qgis.PyQt.QtWidgets import QAction, QWidgetAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .medir_distancia_entre_dialog import MedirDistanciaEntreDialog
import os.path

from .gui.identifygeometry import IdentifyGeometry

from qgis.core import QgsGeometry
from qgis.gui import QgsRubberBand


# Return the interactive measurements toolbox widget, if found.
def FindMeasurementsToolbox(iface):
	for action in iface.attributesToolBar().actions():
			if isinstance(action, QWidgetAction):
				first_action = action.defaultWidget().actions()[0]
				if first_action == iface.actionMeasure():
					return action.defaultWidget()

# Return the interactive measurements menu, if found.
def FindMeasurementsMenu(iface):
	for action in iface.viewMenu().actions():
			if action.menu():
				first_action = action.menu().actions()[0]
				if first_action == iface.actionMeasure():
					return action.menu()

class MedirDistanciaEntre:
	"""QGIS Plugin Implementation."""

	def __init__(self, iface):
		"""Constructor.
		:param iface: An interface instance that will be passed to this class
			which provides the hook by which you can manipulate the QGIS
			application at run time.
		:type iface: QgsInterface
		"""
		self.DebugMess = True
		if self.DebugMess:
			print ("===Iniciando constructor===")

		# Save reference to the QGIS interface
		self.iface = iface
		self.mapCanvas = iface.mapCanvas()
		# initialize plugin directory
		self.plugin_dir = os.path.dirname(__file__)

		# initialize locale
		locale = QSettings().value('locale/userLocale')[0:2]
		locale_path = os.path.join(
			self.plugin_dir,
			'i18n',
			'MedirDistanciaEntre_{}.qm'.format(locale))
		if os.path.exists(locale_path):
			self.translator = QTranslator()
			self.translator.load(locale_path)
			QCoreApplication.installTranslator(self.translator)

		# Declare instance attributes
		self.actions = []
		self.menu = self.tr(u'&MedirDistanciaEntre')
		
		self.OrigFeat = None
		self.DestFeat = None
		self.Distancia = 0.0

		# Check if plugin was started the first time in current QGIS session
		# Must be set in initGui() to survive plugin reloads
		self.first_start = None
		
		if self.DebugMess:
			print ("===Terminado constructor===")

	# noinspection PyMethodMayBeStatic
	def tr(self, message):
		"""Get the translation for a string using Qt translation API.

		We implement this ourselves since we do not inherit QObject.

		:param message: String for translation.
		:type message: str, QString

		:returns: Translated version of message.
		:rtype: QString
		"""
		# noinspection PyTypeChecker,PyArgumentList,PyCallByClass
		return QCoreApplication.translate('MedirDistanciaEntre', message)


	def add_action(
		self,
		icon_path,
		text,
		callback,
		enabled_flag=True,
		add_to_menu=True,
		add_to_toolbar=True,
		status_tip=None,
		whats_this=None,
		parent=None):
		"""Add a toolbar icon to the toolbar.

		:param icon_path: Path to the icon for this action. Can be a resource
			path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
		:type icon_path: str

		:param text: Text that should be shown in menu items for this action.
		:type text: str

		:param callback: Function to be called when the action is triggered.
		:type callback: function

		:param enabled_flag: A flag indicating if the action should be enabled
			by default. Defaults to True.
		:type enabled_flag: bool

		:param add_to_menu: Flag indicating whether the action should also
			be added to the menu. Defaults to True.
		:type add_to_menu: bool

		:param add_to_toolbar: Flag indicating whether the action should also
			be added to the toolbar. Defaults to True.
		:type add_to_toolbar: bool

		:param status_tip: Optional text to show in a popup when mouse pointer
			hovers over the action.
		:type status_tip: str

		:param parent: Parent widget for the new action. Defaults None.
		:type parent: QWidget

		:param whats_this: Optional text to show in the status bar when the
			mouse pointer hovers over the action.

		:returns: The action that was created. Note that the action is also
			added to self.actions list.
		:rtype: QAction
		"""

		icon = QIcon(icon_path)
		action = QAction(icon, text, parent)
		action.triggered.connect(callback)
		action.setEnabled(enabled_flag)

		if status_tip is not None:
			action.setStatusTip(status_tip)

		if whats_this is not None:
			action.setWhatsThis(whats_this)

		if add_to_toolbar:
			# Adds plugin icon to Plugins toolbar
			self.iface.addToolBarIcon(action)

		if add_to_menu:
			self.iface.addPluginToMenu(
				self.menu,
				action)

		self.actions.append(action)

		return action


	def initGui(self):
		"""Create the menu entries and toolbar icons inside the QGIS GUI."""

		if self.DebugMess:
			print ("Entrando en InitGui")
		icon_path = ':/plugins/medir_distancia_entre/mde_icon.png'
		self.map_tool_action = self.add_action(
			icon_path,
			text=self.tr(u'Medir distancia entre entidades'),
			add_to_menu=False,
			add_to_toolbar=False,
			callback=self.map_tool_init,
			parent=self.iface.mainWindow())
		self.map_tool_action.setCheckable(True)

		# Looks for the measurements toolbox and add this action to it, if found
		toolbox = FindMeasurementsToolbox(self.iface)
		if toolbox:
			toolbox.addAction(self.actions[0])
			if self.DebugMess:
				print("Añadida acción a ToolBox")

		# Looks for the measurements menu and add this action to it, if found
		menu = FindMeasurementsMenu(self.iface)
		if menu:
			menu.addAction(self.actions[0])
			if self.DebugMess:
				print("Añadida acción a menú")

		# will be set False in run()
		self.first_start = True


	def unload(self):
		"""Removes the plugin menu item and icon from QGIS GUI."""
		
		if self.DebugMess:
			print ("Entrando en unload")

		toolbox = FindMeasurementsToolbox(self.iface)
		if toolbox:
			toolbox.removeAction(self.actions[0])

		menu = FindMeasurementsMenu(self.iface)
		if menu:
			menu.removeAction(self.actions[0])

		"""
		for action in self.actions:
			self.iface.removePluginVectorMenu(
				self.tr(u'&MedirDistanciaEntre'),
				action)
			self.iface.removeToolBarIcon(action)
		"""

		#self.deactivate()


	def map_tool_init(self):
		# this function is called when the map tool icon is clicked
		
		if self.DebugMess:
			print ("Entrando en map_tool_init...")
		#canvas = self.iface.mapCanvas()
		if self.map_tool_action.isChecked():
			if self.DebugMess:
				print ("... con checked")
			# when the user activates the tool
			self.prev_tool = self.mapCanvas.mapTool()
			self.map_tool_action.setChecked( True )
			self.map_tool = IdentifyGeometry(self.mapCanvas)
			#QObject.connect(self.map_tool,SIGNAL("geomIdentified"),self.do_something )
			self.map_tool.geomIdentified.connect(self.setSelectedFeature)
			self.mapCanvas.setMapTool(self.map_tool)
			#QObject.connect(canvas,SIGNAL("mapToolSet(QgsMapTool *)"),self.map_tool_changed)
			self.mapCanvas.mapToolSet.connect(self.deactivate)
			
			if self.first_start == True:
				self.first_start = False

			self.firstFeatureRubberBand = QgsRubberBand( self.mapCanvas, False )
			self.firstFeatureRubberBand.setColor(QColor("red"))
			self.firstFeatureRubberBand.setWidth(3)
			self.secondFeatureRubberBand = QgsRubberBand( self.mapCanvas, False )
			self.secondFeatureRubberBand.setColor(QColor("blue"))
			self.secondFeatureRubberBand.setWidth(3)
			self.shortestLineRubberBand = QgsRubberBand( self.mapCanvas, False )
			self.shortestLineRubberBand.setColor(QColor("brown"))
			self.shortestLineRubberBand.setWidth(5)
			
			self.dlg = MedirDistanciaEntreDialog()
			self.dlg.reset.connect(self.resetMapTool)
			self.dlg.close.connect(self.close)
			mapcanvas_upperleft = self.mapCanvas.mapToGlobal(QPoint(0, 0))
			offset_x = 24
			offset_y = 43
			pos_x = mapcanvas_upperleft.x() + offset_x
			pos_y = mapcanvas_upperleft.y() + offset_y
			self.dlg.setGeometry(pos_x, pos_y, 0, 0)
			
			self.dlg.show()

			# Run the dialog event loop
			result = self.dlg.exec_()
			# See if OK was pressed
			if result:
				# We do not care about the dialog having been accepted()
				if self.DebugMess:
					print ("Saliendo por pass")
				pass
				#self.close()
		else:
			# when the user deactivates the tool
			if self.DebugMess:
				print ("... con deactivated")
			self.deactivate()


	def setMapTool(self):
		if self.DebugMess:
			print("Entrando en setMapTool")
		self.mapCanvas.setMapTool(self.mapTool)


	def resetMapTool(self):
		if self.DebugMess:
			print("Entrando en resetMapTool")
		# Clear the last measurement
		self.OrigFeat = None
		self.DestFeat = None
		self.dlg.distance_doubleSpinBox.setValue(0)
		self.firstFeatureRubberBand.reset()
		self.secondFeatureRubberBand.reset()
		self.shortestLineRubberBand.reset()


	def deactivate(self):
		if self.DebugMess:
			print("Entrando en Deactivate")
		# Clear the last measurement
		self.resetMapTool()
		self.mapCanvas.mapToolSet.disconnect(self.deactivate)
		self.mapCanvas.unsetMapTool(self.map_tool)
		if self.DebugMess:
			print ("restore prev tool %s" %(self.prev_tool))
		self.mapCanvas.setMapTool(self.prev_tool)
		self.map_tool_action.setChecked(False)
		self.dlg.hide()


	def close(self):
		if self.DebugMess:
			print("Cerrando (close)")
		self.deactivate()
		self.mapCanvas.scene().removeItem(self.firstFeatureRubberBand)
		self.mapCanvas.scene().removeItem(self.secondFeatureRubberBand)
		self.mapCanvas.scene().removeItem(self.shortestLineRubberBand)


	def setSelectedFeature(self, layer, feature):
		if self.DebugMess:
			print("Entrando en setSelectedFeature")
		if self.OrigFeat == None:
			if self.DebugMess:
				print("Elem. origen: %s" %(feature.id()))
			self.OrigFeat = feature
			self.firstFeatureRubberBand.setToGeometry(feature.geometry())
			#self.shortestLineRubberBand.setToGeometry(None)
			self.shortestLineRubberBand.reset()
		else:
			if self.DebugMess:
				print("Elem. destino: %s" %(feature.id()))
			self.DestFeat = feature
			self.secondFeatureRubberBand.setToGeometry(feature.geometry())
			self.updateMeasurement()


	def updateMeasurement(self):
		if self.DebugMess:
			print("Entrando en updateMeassurement")

		if self.OrigFeat and self.DestFeat:
			if self.DebugMess:
				print("Calculando distancia")

			#if self.dlg.isHidden():
			#	self.dlg.show()

			LinMin = self.OrigFeat.geometry().shortestLine(self.DestFeat.geometry() )
			DistMin = LinMin.length()
			self.shortestLineRubberBand.setToGeometry(LinMin)
			self.shortestLineRubberBand.updateCanvas()
			#self.shortestLineRubberBand.show()

			if self.DebugMess:
				print("Distancia mínima: %d" %DistMin)

			self.dlg.distance_doubleSpinBox.setValue(DistMin)
