"""
/***************************************************************************
 MDI-DE Metadata Search
                                 A QGIS plugin
 mdi-de metadata search module
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 12.2024
        git sha              : $Format:%H$
        copyright            : (C) 2024 by terrestris GmbH & Co. KG
        email                : info@terrestris.de
 ***************************************************************************/
 /**************************************************************************
    Based on
    https://github.com/qgis/QGIS/tree/master/python/plugins/MetaSearch
  ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import warnings

import owslib
import owslib.fes2
from owslib.namespaces import Namespaces

from mdi_de_metadatasearch.record.cswrecord import CSWRecord
from mdi_de_metadatasearch.record.recordtype import RecordType
from mdi_de_metadatasearch.search.csw_filters import CSWFilters

with warnings.catch_warnings():
    warnings.filterwarnings("ignore", category=ResourceWarning)
    warnings.filterwarnings("ignore", category=ImportWarning)
    from owslib.csw import CatalogueServiceWeb  # spellok

from qgis.core import Qgis

if owslib.__version__ < "0.25":
    OWSLIB_OAREC_SUPPORTED = False
else:
    OWSLIB_OAREC_SUPPORTED = True

from mdi_de_metadatasearch.search.catalogtype import CatalogType
from mdi_de_metadatasearch.search.searchbase import SearchBase

class CSW300Search(SearchBase):
    def __init__(self, url, timeout, username, password, auth, metadataUrl):
        super().__init__(url, timeout, username, password, auth)

        self.type = CatalogType.OGC_CSW_300
        self.format = "xml"
        self.service_info_template = "csw_service_metadata.html"
        self.record_info_template = "record_metadata_dc.html"
        self.constraints = []
        self.metadataUrl = metadataUrl

        self.conn = CatalogueServiceWeb(
            self.url,  # spellok
            timeout=self.timeout,
            username=self.username,
            password=self.password,
            auth=self.auth,
            version='3.0.0'
        )

        self.request = self.conn.request
        self.response = self.conn.response

    def query_records(self, keywords=None, limit=10, offset=1, type_filters=None, region_filters=None):
 
        csw300filters = CSWFilters(owslib.fes2)
        self.constraints = csw300filters.get_flat_filters(keywords, type_filters, region_filters)
        namespaces = Namespaces().get_namespaces()

        self.conn.getrecords(
            constraints=self.constraints,
            typenames="gmd:MD_Metadata",
            maxrecords=limit,
            startposition=offset,
            esn="full",
            outputschema=namespaces['gmd']
        )

        self.matches = self.conn.results["matches"]
        self.returned = self.conn.results["returned"]

        self.request = self.conn.request
        self.response = self.conn.response

    def records(self):
        recs = []

        for record in self.conn.records:
            rec = CSWRecord(self.conn.records[record], self)

            recs.append(rec)

        return recs

    def get_record(self, identifier):
        record = CSWRecord(self.conn.records[identifier], self)
        return record
