"""
/***************************************************************************
 MDI-DE Metadata Search
                                 A QGIS plugin
 mdi-de metadata search module
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 12.2024
        git sha              : $Format:%H$
        copyright            : (C) 2024 by terrestris GmbH & Co. KG
        email                : info@terrestris.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import itertools
import re
from mdi_de_metadatasearch.record.recordtype import RecordType

class CSWFilters():
    def __init__(self, fes):
        self.fes_module = fes

    def get_flat_filters(self, input_keywords, type_filters, region_filters):

        self.constraints = []
    
        # keyword filters
        keywords_constraints = self.get_keyword_constraints(input_keywords)
    
        # type filters
        type_constraints = self.get_type_constraints(type_filters)
    
        # region filters
        region_constraints = self.get_region_constraints(region_filters)
    
        product_types_regions = []
        if region_constraints and type_constraints:
            product_types_regions = list(itertools.product(type_constraints, region_constraints))
            product_types_regions = self.remove_depth(product_types_regions)    
        elif region_constraints:
            product_types_regions = region_constraints
        elif type_constraints:
            product_types_regions = type_constraints
    
        all_filters = []
        if product_types_regions and keywords_constraints:
            all_filters = [list(k) + keywords_constraints for k in product_types_regions]
        elif product_types_regions:
            all_filters = product_types_regions
        elif keywords_constraints:
            all_filters = [keywords_constraints]
        
        connected_parts = []
        for i in all_filters:
            part = i[0]
            if len(i) > 1:
                part = self.fes_module.And(operations=i)
            connected_parts.append(part)
        
        self.constraints = connected_parts
    
        if len(connected_parts) > 1:
            self.constraints = [self.fes_module.Or(connected_parts)]            
    
        return self.constraints
    
    def get_type_constraints(self, type_filters):

        # type options

        if type_filters is None:
            return []
    
        type_constraints = []
        
        if type_filters.get(RecordType.DATASET.value, False):
            type_constraints.append([self.fes_module.PropertyIsLike("apiso:Type", "dataset")])
        if type_filters.get(RecordType.TILE.value, False):
            type_constraints.append([self.fes_module.PropertyIsLike("apiso:Type", "tile")])
        if type_filters.get(RecordType.SERIES.value, False):
            type_constraints.append([self.fes_module.PropertyIsLike("apiso:Type", "series")])
        if type_filters.get(RecordType.APPLICATION.value, False):
            type_constraints.append([self.fes_module.PropertyIsLike("apiso:Type", "application")])
        if type_filters.get(RecordType.DOWNLOAD.value, False):
            service_constraint = [self.fes_module.PropertyIsLike("apiso:Type", "service")]
            service_type_constraints = [self.fes_module.PropertyIsLike("apiso:ServiceType", "download"), self.fes_module.PropertyIsLike("apiso:ServiceType", "WFS")]
            combi = list(itertools.product(service_constraint, service_type_constraints))
            type_constraints = type_constraints + combi
        if type_filters.get(RecordType.MAP.value, False):
            service_constraint = [self.fes_module.PropertyIsLike("apiso:Type", "service")]
            service_type_constraints = [self.fes_module.PropertyIsLike("apiso:ServiceType", "view"), self.fes_module.PropertyIsLike("apiso:ServiceType", "WMS")]
            combi = list(itertools.product(service_constraint, service_type_constraints))
            type_constraints = type_constraints + combi

        return type_constraints
        
    def get_region_constraints(self, region_filters):
    
        if region_filters is None:
            return []
    
        region_constraints = []
    
        if region_filters.get("BalticSea", False):
            region_constraints.append([self.fes_module.PropertyIsLike("csw:AnyText", "Ostsee")])
        if region_filters.get("NorthSea", False):
            region_constraints.append([self.fes_module.PropertyIsLike("csw:AnyText", "Nordsee")])
    
        return region_constraints 
    
    def get_keyword_constraints(self, input_keywords):
    
        if input_keywords == '':
            return []
        
        # handle multiple word searches
        split_pattern = r'[, ]'
        keywords = [k for k in re.split(split_pattern, input_keywords) if k != '']
        keywords_constraints = [self.fes_module.PropertyIsLike("csw:AnyText", k) for k in keywords]
    
        return keywords_constraints
    
    def remove_depth(self, product_types_regions):
        product_types_regions_flat = []
        for product in product_types_regions:
            flat = []
            for element in product:
                flat = flat + list(element)
            product_types_regions_flat.append(flat)
    
        return product_types_regions_flat
