"""
/***************************************************************************
 MDI-DE Metadata Search
                                 A QGIS plugin
 mdi-de metadata search module
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 12.2024
        git sha              : $Format:%H$
        copyright            : (C) 2024 by terrestris GmbH & Co. KG
        email                : info@terrestris.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from abc import ABC
from qgis.PyQt.QtCore import QCoreApplication, QUrl
from qgis.PyQt.QtNetwork import QNetworkRequest
from qgis.core import Qgis, QgsNetworkAccessManager, QgsMessageLog
from mdi_de_metadatasearch.mdi_de_metadata_search_dialog import MDIDEMetadataSearchDialog

class NotImplementedException(Exception):
    pass

class BaseRecord(ABC):
    record = None
    catalog = None

    def __init__(self, record, catalog):
        self.record = record
        self.catalog = catalog

    def render(self, dlg):
        raise NotImplementedException("Implement me")

    def get_category_type(self):
        raise NotImplementedException("Implement me")

    def get_identifier(self):
        raise NotImplementedException("Implement me")

    def get_title(self):
        raise NotImplementedException("Implement me")

    def _reset_resource_view(self, dlg, reset_input=False):
        if reset_input:
            dlg.textEditSearchText.clear()
        dlg.labelResourceType.setText('')
        dlg.labelResourceId.setText('')
        dlg.labelPreview.setText(self._tr('Preview...'))
        dlg.labelOrga.setText('')
        dlg.labelDate.setText('')
        dlg.labelAccessUrl.setText('')
        dlg.labelMetadata.setText('')
        dlg.textBrowserResourceAbstract.clear()
        dlg.tableWidgetExtent.clearContents()
        dlg.treeWidgetRestrictions.clear()

    def _open_remote(self, url, timeout=4000, content_type=False):
        """
        Howto to do it the QGIS way
        https://python.hotexamples.com/de/examples/qgis.core/QgsNetworkAccessManager/-/python-qgsnetworkaccessmanager-class-examples.html
        """
        na_manager = QgsNetworkAccessManager.instance()
        request = QNetworkRequest()
        request.setUrl(QUrl(url))
        if content_type:
            request.setHeader(QNetworkRequest.ContentTypeHeader, content_type)
        request.setHeader(QNetworkRequest.UserAgentHeader, "QGIS 3.X - Metadata search")
        na_manager.setTimeout(timeout)
        result = na_manager.blockingGet(request)
        if result.errorString() != "":
            QgsMessageLog.logMessage("An error occured while trying to make a network request - Error: " + result.errorString(), 'MDI-DE Metadata Search',
                                     level=Qgis.Critical)
        return result.content()

    def _tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MDI-DEMetadataSearch', message)
