"""
/***************************************************************************
 MDI-DE Metadata Search
                                 A QGIS plugin
 mdi-de metadata search module
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 12.2024
        git sha              : $Format:%H$
        copyright            : (C) 2024 by terrestris GmbH & Co. KG
        email                : info@terrestris.de
 ***************************************************************************/
 /**************************************************************************
    Based on
    https://github.com/qgis/QGIS/tree/master/python/plugins/MetaSearch
  ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import warnings

import owslib
from owslib.fes import BBox, PropertyIsLike

from owslib.namespaces import Namespaces

# from MetaSearch.util import log_message

with warnings.catch_warnings():
    warnings.filterwarnings("ignore", category=ResourceWarning)
    warnings.filterwarnings("ignore", category=ImportWarning)
    from owslib.csw import CatalogueServiceWeb  # spellok

from qgis.core import Qgis

if owslib.__version__ < "0.25":
    OWSLIB_OAREC_SUPPORTED = False
else:
    OWSLIB_OAREC_SUPPORTED = True

from mdi_de_metadatasearch.search.catalogtype import CatalogType
from mdi_de_metadatasearch.search.searchbase import SearchBase

class OARecSearch(SearchBase):
    def __init__(self, url, timeout, auth, metadataUrl):
        try:
            from owslib.ogcapi.records import Records
        except ModuleNotFoundError:
            # OWSLIB_OAREC_SUPPORTED already set to False
            pass

        super().__init__(url, timeout, auth)

        self.type = CatalogType.OGC_API_RECORDS
        self.format = "json"
        self.service_info_template = "oarec_service_metadata.html"
        self.record_info_template = "record_metadata_oarec.html"
        self.base_url = None
        self.record_collection = None
        self.metadataUrl = metadataUrl

        if "/collections/" in self.url:  # catalog is a collection
            # log_message("OARec endpoint is a collection", Qgis.MessageLevel.Info)
            self.base_url, self.record_collection = self.url.split(
                "/collections/"
            )  # noqa
            self.conn = Records(self.base_url, timeout=self.timeout, auth=self.auth)
            c = self.conn.collection(self.record_collection)
            try:
                self.conn.links = c["links"]
                self.conn.title = c["title"]
                self.conn.description = c["description"]
            except KeyError:
                pass
            self.request = self.conn.request
        else:
            # log_message("OARec endpoint is not a collection", Qgis.MessageLevel.Info)
            self.conn = Records(self.url, timeout=self.timeout, auth=self.auth)
            self.request = None

        self.response = self.conn.response

    def query_records(self, keywords=None, limit=10, offset=1):
        # set zero-based offset (default MetaSearch behavior is CSW-based
        # offset of 1
        offset2 = offset - 1

        params = {
            "collection_id": self.record_collection,
            "limit": limit,
            "offset": offset2,
        }

        if keywords:
            # log_message(f"Setting keyword search {keywords}", Qgis.MessageLevel.Info)
            params["q"] = keywords

        # log_message(f"Searching OARec: {self.url}", Qgis.MessageLevel.Info)
        self.response = self.conn.collection_items(**params)

        self.matches = self.response.get("numberMatched", 0)
        self.returned = self.response.get("numberReturned", 0)
        self.request = self.conn.request

        # log_message(f"Matches: {self.matches}", Qgis.MessageLevel.Info)
        # log_message(f"Returned: {self.returned}", Qgis.MessageLevel.Info)

    def records(self):
        recs = []

        for rec in self.response["features"]:
            rec1 = {
                "identifier": rec["id"],
                "type": rec["properties"]["type"],
                "bbox": None,
                "title": rec["properties"]["title"],
                "links": rec.get("links", []),
            }
            try:
                if rec.get("geometry") is not None:
                    rec1["bbox"] = bbox_list_to_dict(
                        [
                            rec["geometry"]["coordinates"][0][0][0],
                            rec["geometry"]["coordinates"][0][0][1],
                            rec["geometry"]["coordinates"][0][2][0],
                            rec["geometry"]["coordinates"][0][2][1],
                        ]
                    )
            except KeyError:
                pass

            recs.append(rec1)

        return recs

    def get_record(self, identifier):
        # log_message(
        #     f"Searching OARec endpoint for item {identifier}", Qgis.MessageLevel.Info
        # )
        return self.conn.collection_item(self.record_collection, identifier)

    def parse_link(self, link):
        link2 = {}
        if "href" in link:
            link2["url"] = link["href"]
        if "type" in link:
            link2["protocol"] = link["type"]
        if "title" in link:
            link2["title"] = link["title"]
        if "id" in link:
            link2["name"] = link["id"]
        return link2
