"""
/***************************************************************************
 MDI-DE Metadata Search
                                 A QGIS plugin
 mdi-de metadata search module
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 12.2024
        git sha              : $Format:%H$
        copyright            : (C) 2024 by terrestris GmbH & Co. KG
        email                : info@terrestris.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.core import Qgis, QgsMessageLog, QgsSettingsTree
from qgis.PyQt.QtWidgets import *
from qgis.PyQt.QtGui import QPixmap
from qgis.PyQt.QtCore import QUrl, QUrlQuery, QCoreApplication, Qt
from qgis.gui import QgsMessageViewer
from mdi_de_metadatasearch.record.baserecord import BaseRecord
from mdi_de_metadatasearch.record.recordtype import RecordType

class CSWRecord(BaseRecord):

    def _render_abstract(self, dlg):
        dlg.textBrowserResourceAbstract.append(self.record.identification[0].title)
        try:
            dlg.textBrowserResourceAbstract.append(self.record.identification[0].abstract)
        except:
            QgsMessageLog.logMessage("No attribute abstract for this resource", 'MDI-DE Metadata Search',
                                     level=Qgis.Info)

    def _render_preview_image(self, dlg):
        try:
            preview_url = self.record.identification[0].graphicoverview[0]
            result_content = self._open_remote(preview_url)
            if result_content:
                # build
                pixmap = QPixmap()
                pixmap.loadFromData(result_content)
                # draw preview
                dlg.labelPreview.setPixmap(pixmap.scaled(dlg.labelPreview.size(), Qt.KeepAspectRatio, Qt.SmoothTransformation))
            else:
                QgsMessageLog.logMessage("An error occured while try to open url: " + preview_url,
                                         'MDI-DE Metadata Search',
                                         level=Qgis.Critical)
        except:
            dlg.labelPreview.setText(QCoreApplication.translate("cswrecord", "No preview"))

    def _render_bbox(self, dlg):
        try:
            # get extent from json
            bbox = self.record.identification[0].bbox
            # table with coordinates
            dlg.tableWidgetExtent.setRowCount(1)
            dlg.tableWidgetExtent.setColumnCount(2)

            horizontalStringList = [QCoreApplication.translate("cswrecord", "SW Lon / Lat"), QCoreApplication.translate("cswrecord", "NE Lon / Lat")]
            dlg.tableWidgetExtent.setHorizontalHeaderLabels(horizontalStringList)
            verticalStringList = [QCoreApplication.translate("cswrecord", "Extent of the Dataset")]
            dlg.tableWidgetExtent.setVerticalHeaderLabels(verticalStringList)

            coordinateSW = QTableWidgetItem(bbox.minx + " / " + bbox.miny)
            dlg.tableWidgetExtent.setItem(0, 0, coordinateSW)
            coordinateNO = QTableWidgetItem(bbox.maxx + " / " + bbox.maxy)
            dlg.tableWidgetExtent.setItem(0, 1, coordinateNO)
            dlg.tableWidgetExtent.resizeRowsToContents()
            dlg.tableWidgetExtent.resizeColumnsToContents()
        except:
            QgsMessageLog.logMessage("No attribute bbox for this resource", 'MDI-DE Metadata Search',
                                     level=Qgis.Critical)

    def _render_resource_id(self, dlg):
        try:
            dlg.labelResourceId.setText(str(self.record.identification[0].uricode[0]))
            dlg.labelResourceId.setWordWrap(True)
        except:
            QgsMessageLog.logMessage("No attribute uricode for this resource", 'MDI-DE Metadata Search',
                                     level=Qgis.Info)

    def _render_metadata(self, dlg):
        if self.catalog.metadataUrl:
            uuid = self.record.identifier # corresponds to the uuid
            complete_metadata_url = self.catalog.metadataUrl + uuid
            dlg.labelMetadata.setText('<a href="' + complete_metadata_url + '">' + QCoreApplication.translate("cswrecord", "Online Metadata") + '</a>')
            dlg.labelMetadata.setOpenExternalLinks(True)
        else:
            dlg.labelMetadata.setText('')
            QgsMessageLog.logMessage("No attribute mdLink for this resource", 'MDI-DE Metadata Search',
                                     level=Qgis.Info)

    def _render_date(self, dlg):
        try:
            date = self.record.datestamp
            dlg.labelDate.setText(date)
        except:
            QgsMessageLog.logMessage("No attribute date for this resource", 'MDI-DE Metadata Search',
                                     level=Qgis.Info)

    def _render_orga(self, dlg):
        try:
            # pointOfContact / organisationName: contact info for organisation associated with resource
            resp_orga = self.record.identification[0].contact[0].organization
            dlg.labelOrga.setText(resp_orga)
            dlg.labelOrga.setWordWrap(True)
        except:
            QgsMessageLog.logMessage("No attribute respOrg for this resource", 'MDI-DE Metadata Search',
                                     level=Qgis.Info)

    def _render_resource_type(self, dlg):
        dlg.labelResourceType.setText(str(self.record.hierarchy))

    def _update_load_button(self, dlg, iface):
        try:
            dlg.pushButtonLoad.disconnect()
        except:
            pass
        category = self.get_category_type()
        enabled = category is RecordType.MAP or (category is RecordType.DOWNLOAD and not self._is_atom_feed())
        dlg.pushButtonLoad.setEnabled(enabled)
        if enabled:
            getCapabilitiesUrl = self._get_getCapabilities_url()
            dlg.pushButtonLoad.clicked.connect(lambda: self._on_load_click(iface, getCapabilitiesUrl, str(category.value).lower()))

    def _on_load_click(self, iface, data_url="", given_service_type="map"):

        QgsMessageLog.logMessage("Load cleaned WMS url: " + self._clean_ows_url(data_url), 'MDI-DE Metadata Search', level=Qgis.Info)

        qgis_version = Qgis.versionInt()

        provider_name = self._load_service_in_newer_version(iface, data_url, given_service_type) if qgis_version >= 33000 else self._load_service_in_older_version(iface, data_url, given_service_type)

        output = QgsMessageViewer()
        output.setFixedSize(500,200)
        output.setTitle(QCoreApplication.translate("cswrecord", "Resource registration"))
        output_text = QCoreApplication.translate("cswrecord", "%s Resource added to QGIS Browser under 'Result from MDI-DE Metadata search plugin'. You may open the Browser and add it to your Layers.") % provider_name
        output.setMessageAsPlainText(output_text)
        output.showMessage()
        return

    def _load_service_in_newer_version(self, iface, data_url="", given_service_type="map"):

        service_name = QCoreApplication.translate("cswrecord", "Result from MDI-DE Metadata search plugin")

        if given_service_type == "map":
            service_type = 'OGC:WMS/OGC:WMTS'
            sname = 'WMS'
            dyn_param = ['wms', service_name]
            provider_name = 'wms'
        if given_service_type == "download":
            service_type = 'OGC:WFS'
            sname = 'WFS'
            dyn_param = ['wfs', service_name]
            provider_name = 'WFS'

            # WFS connection needs to be removed before loading a new one
            setting_node = QgsSettingsTree.node('connections').childNode('ows').childNode('connections')
            setting_node.childSetting('url').remove(dyn_param)
            iface.reloadConnections()
        
        # new connection added
        setting_node = QgsSettingsTree.node('connections').childNode('ows').childNode('connections')
        setting_node.childSetting('url').setVariantValue(self._clean_ows_url(data_url), dyn_param)
        iface.reloadConnections()

        return provider_name
    
    def _load_service_in_older_version(self, iface, data_url="", given_service_type="map" ):
        if given_service_type == "map":
            service_type = ['OGC:WMS/OGC:WMTS', 'wms', 'wms']
            provider_name = 'WMS'
        if given_service_type == "download":
            service_type = ['OGC:WFS', 'wfs', 'WFS']
            provider_name = 'WFS'
        service_name = QCoreApplication.translate("cswrecord", "Result from MDI-DE Metadata search plugin")
        conn_name_matches = []
        # store connection in browser
        # check if there is a connection with same name
        self.settings.beginGroup('/qgis/connections-%s' % service_type[1])
        keys = self.settings.childGroups()
        self.settings.endGroup()
        for key in keys:
            if key.startswith(service_name):
                QgsMessageLog.logMessage("found key in childGroups: " + key)
                conn_name_matches.append(key)
        if conn_name_matches:
            service_name = conn_name_matches[-1]
        QgsMessageLog.logMessage("Service name to register: " + service_name)
        
        self.settings.beginGroup('/qgis/connections-%s' % service_type[1])
        self.settings.setValue('/%s/url' % service_name + 'test', self._clean_ows_url(data_url))
        self.settings.endGroup()
        #refresh browser content - but howto reload tree?
        # only refresh the view not the model!
        # self.browser_model.initialize()

        iface.reloadConnections()
        browser_dock_widget = iface.mainWindow().findChildren(QWidget, 'Browser')[0]
        tree = browser_dock_widget.findChildren(QTreeView)
        tree_0 = tree[0]
        proxy = tree_0.model()

        return provider_name
        
    def _clean_ows_url(self, url):
        """clean an OWS URL of added basic service parameters"""
        url = QUrl(url)
        query_string = url.query()
        if query_string:
            query_string = QUrlQuery(query_string)
            query_string.removeQueryItem('service')
            query_string.removeQueryItem('SERVICE')
            query_string.removeQueryItem('request')
            query_string.removeQueryItem('REQUEST')
            url.setQuery(query_string)
        return url.toString()
    
    def _get_getCapabilities_url(self):
            operations = self.record.identification[0].operations
            if self._is_atom_feed():
               atomUrl = operations[0].get('connectpoint')[0].url
               return atomUrl
            getCapabilitiesOperation = [entry for entry in operations if entry["name"] == "GetCapabilities"]
            getCapabilitiesUrl = getCapabilitiesOperation[0].get('connectpoint')[0].url if len(getCapabilitiesOperation) > 0 else ''
            return getCapabilitiesUrl
    
    def _is_atom_feed(self):
        return str(self.record.identification[0].version).lower().__contains__("atom")

    def _render_restrictions(self, dlg):
        dlg.treeWidgetRestrictions.clear()

        # anwendungseinschränkung
        useLimitations = self.record.identification[0].uselimitation
        # nutzungseinschränkung
        useConstraints = self.record.identification[0].useconstraints
        # zugriffseinschränkung
        accessConstraints = self.record.identification[0].accessconstraints

        node_use_limitation = QCoreApplication.translate("cswrecord", 'Use limitation')
        node_use_constraint = QCoreApplication.translate("cswrecord", 'Use constraint')
        node_access_constraint = QCoreApplication.translate("cswrecord", 'Access constraint')
        node_further_explanations = QCoreApplication.translate("cswrecord", 'Further explanations')

        nodes = {
            node_use_limitation: None,
            node_use_constraint: None,
            node_access_constraint: None,
            node_further_explanations: None
        }

        otherConstraintsPresent = False

        if useLimitations:
            nodes[node_use_limitation] = useLimitations
            
        if useConstraints:
            nodes[node_use_constraint] = useConstraints
            if 'otherRestrictions' in useConstraints:
                otherConstraintsPresent = True
            
        if accessConstraints:
            nodes[node_access_constraint] = accessConstraints
            if 'otherRestrictions' in accessConstraints:
                otherConstraintsPresent = True
        
        if otherConstraintsPresent:
            nodes[node_further_explanations] = self.record.identification[0].otherconstraints
        
        self._setup_restrictions_tree(nodes, dlg)

    def _setup_restrictions_tree(self, nodes, dlg):
        for key in nodes:
            if nodes[key] is not None:
                parent_node = QTreeWidgetItem()
                parent_node.setText(0, key) 
                for item in nodes[key]:
                    item_label = QLabel()
                    item_label.setText(item)
                    item_label.setWordWrap(True)

                    col_buffer = 50
                    column_width = dlg.treeWidgetRestrictions.columnWidth(0) - col_buffer
                    label_height = item_label.heightForWidth(column_width)
                    if label_height > 0:
                        item_label.setFixedHeight(label_height)
                    item_label.adjustSize()

                    item_node = QTreeWidgetItem()
                    parent_node.addChild(item_node)
                    dlg.treeWidgetRestrictions.setItemWidget(item_node, 0, item_label)
                dlg.treeWidgetRestrictions.addTopLevelItem(parent_node)
        dlg.treeWidgetRestrictions.expandAll()
    
    def _render_access_url(self, dlg):
        category = self.get_category_type()
        if (category is RecordType.MAP or category is RecordType.DOWNLOAD): 
            capabilitiesUrl = self._get_getCapabilities_url()
            completeCapabilitiesUrl = self._complete_capabilities_url(capabilitiesUrl, category)
            dlg.labelAccessUrl.setText('<a href="' + completeCapabilitiesUrl + '">' + QCoreApplication.translate("cswrecord", 'GetCapabilities') + '</a>')
            dlg.labelAccessUrl.setOpenExternalLinks(True)

        if (category is RecordType.APPLICATION):
            try:
                applicationUrl = self.record.distribution.online[0].url # correct?
                dlg.labelAccessUrl.setText('<a href="' + applicationUrl + '">' + QCoreApplication.translate("cswrecord", 'Application') + '</a>')
                dlg.labelAccessUrl.setOpenExternalLinks(True)
            except:
                QgsMessageLog.logMessage("No application link for this resource", 'MDI-DE Metadata Search',
                                     level=Qgis.Info)
                
    def _complete_capabilities_url(self, capabilitiesUrl, category):
        # add service or request to getCapabilties url if absent
        url = QUrl(capabilitiesUrl)
        query_string = url.query()

        if not query_string.lower().__contains__('service'):
            query_string = QUrlQuery(query_string)
            # category can be only download or map
            service_string = 'WFS' if category is RecordType.DOWNLOAD else 'WMS'
            query_string.addQueryItem('Service', service_string)
            query_string = query_string.toString()
        if not query_string.lower().__contains__('request'):
            query_string = QUrlQuery(query_string)
            query_string.addQueryItem('Request', 'GetCapabilities')
        url.setQuery(query_string)
        return url.toString()   

    def render(self, dlg, iface):
        self._reset_resource_view(dlg)
        self._render_resource_type(dlg)
        self._render_resource_id(dlg)
        self._render_preview_image(dlg)
        self._render_bbox(dlg)
        self._update_load_button(dlg, iface)
        self._render_orga(dlg)
        self._render_date(dlg)
        self._render_restrictions(dlg)
        self._render_abstract(dlg)
        self._render_access_url(dlg)
        self._render_metadata(dlg)

    def get_title(self):
        if self.record.identification[0].title:
            return self.record.identification[0].title

    def get_identifier(self):
        if self.record.identifier:
            return self.record.identifier

    def get_category_type(self):
        hierarchy = self.record.hierarchy.lower()
        if not hierarchy:
            return RecordType.OTHER
        if hierarchy == 'dataset':
            return RecordType.DATASET
        if hierarchy == 'tile':
            return RecordType.TILE
        if hierarchy == 'series':
            return RecordType.SERIES
        if hierarchy == 'application':
            return RecordType.APPLICATION

        if hierarchy == 'service':
            if (self.record.identification) is not None:
                servicetype = self.record.identification[0].type.lower()
                if servicetype == 'view' or servicetype == 'wms':
                    return RecordType.MAP
                if servicetype == 'download' or servicetype == 'wfs':
                    return RecordType.DOWNLOAD

        return RecordType.OTHER
