# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MASSPlugin
                                 A QGIS plugin
 Algorithm for fast product kernel density estimation and spatial analysis of large geospatial datasets

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2026-01-18
        git sha              : $Format:%H$
        copyright            : (C) 2026 by MASS-group
        email                : yovela12138@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .mass_fast_product_kernel_density_analysis_dialog import MASSPluginDialog
import os.path

from .run_mass import run_mass
from qgis.PyQt.QtWidgets import QFileDialog, QMessageBox
import os


class MASSPlugin:
    """QGIS Plugin Implementation."""


    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MASSPlugin_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&MASS: A Fast Product Kernel Density Analysis')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MASSPlugin', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/mass_fast_product_kernel_density_analysis/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'MASS: A Fast Product Kernel Density Analysis'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&MASS: A Fast Product Kernel Density Analysis'),
                action)
            self.iface.removeToolBarIcon(action)

    from qgis.PyQt.QtWidgets import QFileDialog, QMessageBox
    from .run_mass import run_mass
    import os



    def run(self):
        if self.first_start:
            self.first_start = False
            self.dlg = MASSPluginDialog()

        self.dlg.show()
        result = self.dlg.exec_()
        if not result:
            return

        QMessageBox.information(
            self.iface.mainWindow(),
            "MASS Plugin Instructions",
            "This plugin runs Fast Product Kernel Density Analysis.\n"
            "Please select your input data file (.dat)."
        )

        input_file, _ = QFileDialog.getOpenFileName(
            self.iface.mainWindow(),
            "Select input file",
            "",
            "Data files (*.dat);;All files (*)"
        )
        if not input_file:
            return

        QMessageBox.information(
            self.iface.mainWindow(),
            "MASS Plugin Instructions",
            "Then choose where to save the output result."
        )

        output_file, _ = QFileDialog.getSaveFileName(
            self.iface.mainWindow(),
            "Select output file",
            "",
            "Text files (*.txt);;All files (*)"
        )
        if not output_file:
            return

        try:
            output_text = run_mass(input_file, output_file)

            QMessageBox.information(
                self.iface.mainWindow(),
                "MASS Plugin Finished",
                f"Finished! Output saved to:\n{output_file}\n\nmass_pkdv output:\n{output_text}"
            )
        except Exception as e:
            QMessageBox.critical(
                self.iface.mainWindow(),
                "MASS Plugin Error",
                str(e)
            )
