# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MarinrTools
 A QGIS plugin
 Marine tools for analysis and interpretation.  These tools include:
 
 Benthic Terrain Modeller - geomorphological interpretation of bathymetry data
 OBIA - Object Based Image Analysis using a simple k-means algorithm
 MBES Segmentation - Classification using OBIA on bathymetry and backscatter data from a Multibeam Echosounder
 Bathymetry Morphometry - Create several derivatives from bathymetry data
 Tools for multibeam survey design (new surveys and filling in surveys)
 Imagery manipulation - removing outliers and changing null settings
 
 Partially generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-2-1
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Tim Le Bas
        email                : tlb@noc.ac.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtWidgets import QAction, QMenu
from PyQt5.QtCore import QCoreApplication, QObject
from qgis.PyQt.QtGui import QIcon
from qgis.core import *
import marinetools
import os.path

class MarineTools:
    def __init__( self, iface ):
        self.iface = iface

    def MarineTools_add_submenu2(self, submenu, icon):
        if self.MarineTools != None:
            submenu.setIcon(QIcon(icon))
            self.MarineTools.addMenu(submenu)
        else:
            self.iface.addPluginToMenu("&MarineTools", submenu.menuAction())

    def initGui(self):
        plugin_dir = os.path.dirname(__file__)
        
        self.MarineTools = QMenu(QCoreApplication.translate("MarineTools", "MarineTools"))
        self.iface.mainWindow().menuBar().insertMenu(self.iface.firstRightStandardMenu().menuAction(), self.MarineTools)
        
        # Bathymetry submenu
        self.Bathymetry_menu = QMenu(u'Bathymetry')
        icon = QIcon(os.path.dirname(__file__) + "/icons/Bathymetry.PNG")
        self.MarineTools_add_submenu2(self.Bathymetry_menu, icon)
        
        icon = QIcon(os.path.dirname(__file__) + "/icons/RemoveValues.png")
        self.Bathymetry_action = QAction(icon, u'Alter Raster Values', self.iface.mainWindow())
        self.Bathymetry_action.triggered.connect(self.RemoveValues1)
        self.Bathymetry_menu.addAction(self.Bathymetry_action)

        icon = QIcon(os.path.dirname(__file__) + "/icons/BathyMorph.png")
        self.actionBathyMorph = QAction(icon, 'Bathymetry Morphometry',  self.iface.mainWindow() )
        self.actionBathyMorph.triggered.connect( self.BathyMorph1 )
        self.Bathymetry_menu.addAction( self.actionBathyMorph )

        # Interpretation submenu
        self.Interpretation_menu = QMenu(u'Interpretation')
        icon = QIcon(os.path.dirname(__file__) + "/icons/Interpretation.png")
        self.MarineTools_add_submenu2(self.Interpretation_menu, icon)

        icon = QIcon(plugin_dir+"/icons/BTM.png")
        self.actionBTM = QAction(icon,'Benthic Terrain Modeller',  self.iface.mainWindow() )
        self.actionBTM.triggered.connect( self.BTM1 ) # Link to def below
        self.Interpretation_menu.addAction( self.actionBTM )

        icon = QIcon(plugin_dir+"/icons/MBESseg.png")
        self.actionMBESseg = QAction(icon, 'MBES segmentation',  self.iface.mainWindow() )
        self.actionMBESseg.triggered.connect( self.MBESseg1 )
        self.Interpretation_menu.addAction( self.actionMBESseg )
        
        icon = QIcon(plugin_dir+"/icons/OBIA.png")
        self.actionOBIA = QAction(icon, 'OBIA',  self.iface.mainWindow() )
        self.actionOBIA.triggered.connect( self.OBIA1 )
        self.Interpretation_menu.addAction( self.actionOBIA )
        
        icon = QIcon(plugin_dir+"/icons/randomforest.png")
        self.actionRandomForest = QAction(icon, 'Random Forest',  self.iface.mainWindow() )
        self.actionRandomForest.triggered.connect( self.RandomForest1 )
        self.Interpretation_menu.addAction( self.actionRandomForest )
        
        # Utilities submenu
        self.Utilities_menu = QMenu(u'Utilities')
        icon = QIcon(os.path.dirname(__file__) + "/icons/Utilities.png")
        self.MarineTools_add_submenu2(self.Utilities_menu, icon)

        icon = QIcon(plugin_dir+"/icons/GLCM.png")
        self.actionGLCM = QAction(icon, 'Grey Level Co-occurence Matrices',  self.iface.mainWindow() )
        self.actionGLCM.triggered.connect( self.GLCM1 )
        self.Utilities_menu.addAction( self.actionGLCM )

        icon = QIcon(plugin_dir+"/icons/estimatecoverage.png")
        self.actionEstimateCoverage = QAction(icon, 'Estimate new MBES Coverage',  self.iface.mainWindow() )
        self.actionEstimateCoverage.triggered.connect( self.EstimateCoverage1 )
        self.Utilities_menu.addAction( self.actionEstimateCoverage )

        icon = QIcon(plugin_dir+"/icons/rastercoverage.png")
        self.actionRasterCoverage = QAction(icon, 'Raster Coverage',  self.iface.mainWindow() )
        self.actionRasterCoverage.triggered.connect( self.RasterCoverage1 )
        self.Utilities_menu.addAction( self.actionRasterCoverage )
        
        icon = QIcon(plugin_dir+"/icons/surveylines.png")
        self.actionSurveyLines = QAction(icon, 'Survey Lines',  self.iface.mainWindow() )
        self.actionSurveyLines.triggered.connect( self.SurveyLines1 )
        self.Utilities_menu.addAction( self.actionSurveyLines )
         
        # CSV point to Shapefile
        icon = QIcon(os.path.dirname(__file__) + "/icons/CSV2Grid.png")
        self.CSV2Grid_action = QAction(icon, u'CSV to Grid', self.iface.mainWindow())
        self.CSV2Grid_action.triggered.connect(self.CSV2Grid1)
        self.Utilities_menu.addAction(self.CSV2Grid_action)

        # Single Menu - reminder if needed
        """menuBar = self.iface.mainWindow().menuBar()
        surveyDesignMenu = QMenu( QCoreApplication.translate("MarineTools","MarineTools") ,  menuBar)

        self.actionRemoveValues = QAction( 'Alter Raster Values',  self.iface.mainWindow() )
        self.actionRemoveValues.setIcon(QIcon(plugin_dir+"/icons/RemoveValues.png"))
        self.actionRemoveValues.triggered.connect( self.RemoveValues1 )
        surveyDesignMenu.addAction( self.actionRemoveValues )
        
        self.surveyDesignAction = menuBar.addMenu( surveyDesignMenu )"""

    def unload(self):
        a=1
        #self.iface.mainWindow().menuBar().removeAction( self.surveyDesignAction )

    def BathyMorph1(self):
        from marinetools.bathymorph.BathyMorph_dialog import BathyMorphDialog
        from marinetools.bathymorph import BathyMorph
        self.first_start = True
        BathyMorph.BathyMorph.run(self)

    def BTM1(self):
        from marinetools.btm.BTM_dialog import BTMDialog
        from marinetools.btm import BTM
        self.first_start = True
        BTM.BTM.run(self)

    def CSV2Grid1(self):
        from marinetools.CSV2Grid.CSV2Grid import CSV2Grid_dialog
        #dialog = CSV2Grid_dialog(self.iface)
        #dialog.exec_()
        from marinetools.CSV2Grid import CSV2Grid
        CSV2Grid.CSV2Grid_dialog(self.iface).exec_()

    def EstimateCoverage1(self):
        from marinetools.estimatecoverage.EstimateCoverage_dialog import EstimateCoverageDialog
        from marinetools.estimatecoverage import EstimateCoverage
        self.first_start = True
        EstimateCoverage.EstimateCoverage.run(self)
        
    def GLCM1(self):
        from marinetools.GLCM.GLCM_dialog import GLCMDialog
        from marinetools.GLCM import GLCM
        self.first_start = True
        GLCM.GLCM.run(self)
        
    def MBESseg1(self):
        from marinetools.MBESseg.MBESseg_dialog import MBESsegDialog
        from marinetools.MBESseg import MBESseg
        self.first_start = True
        MBESseg.MBESseg.run(self)
        
    def OBIA1(self):
        from marinetools.obia.OBIA_dialog import OBIADialog
        from marinetools.obia import OBIA
        self.first_start = True
        OBIA.OBIA.run(self)

    def RandomForest1(self):
        from marinetools.randomForest.randomForest_dialog import randomForestDialog
        from marinetools.randomForest import randomForest
        self.first_start = True
        randomForest.randomForest.run(self)

    def RasterCoverage1(self):
        from marinetools.rastercoverage.RasterCoverage_dialog import RasterCoverageDialog
        from marinetools.rastercoverage import RasterCoverage
        self.first_start = True
        RasterCoverage.RasterCoverage.run(self)

    def RemoveValues1(self):
        from marinetools.removevalues.RemoveValues_dialog import RemoveValuesDialog
        from marinetools.removevalues import RemoveValues
        self.first_start = True
        RemoveValues.RemoveValues.run(self)

    def SurveyLines1(self):
        from marinetools.surveylines.SurveyLines_dialog import SurveyLinesDialog
        from marinetools.surveylines import SurveyLines
        self.first_start = True
        SurveyLines.SurveyLines.run(self)

