# -*- coding: utf-8 -*-

# /***************************************************************************
#  MarcheALOmbre
#                                  A QGIS plugin
#  This plugin calculates for a given hike the shady and sunny parts
#  Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
#                               -------------------
#         begin                : 2025-12-11
#         copyright            : (C) 2025 by Yolanda Seifert
#         email                : yolanda.seifert@gmx.de
#  ***************************************************************************/

# /***************************************************************************
#  *                                                                         *
#  *   This program is free software; you can redistribute it and/or modify  *
#  *   it under the terms of the GNU General Public License as published by  *
#  *   the Free Software Foundation; either version 2 of the License, or     *
#  *   (at your option) any later version.                                   *
#  *                                                                         *
#  ***************************************************************************/

__author__ = 'Yolanda Seifert'
__date__ = '2025-12-11'
__copyright__ = '(C) 2025 by Yolanda Seifert'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
import webbrowser

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .marche_a_lombre_provider import MarcheALOmbreProvider
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessingAlgorithm, QgsApplication
import processing

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class MarcheALOmbrePlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = MarcheALOmbreProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

        icon = os.path.join(os.path.join(cmd_folder, 'logo.png'))
        self.action = QAction(  QIcon(icon),
                                u"Marche à l'ombre", 
                                self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.help_action = QAction(u"Help", self.iface.mainWindow())
        self.help_action.triggered.connect(self.open_help)

        self.iface.addPluginToMenu(u"&MarcheALOmbre", self.action)
        self.iface.addPluginToMenu(u"&MarcheALOmbre", self.help_action)
        self.iface.addToolBarIcon(self.action)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.iface.removePluginMenu(u"&MarcheALOmbre", self.action)
        self.iface.removePluginMenu(u"&MarcheALOmbre", self.help_action)
        self.iface.removeToolBarIcon(self.action)

    def open_help(self):
        """Opens the documentation in a web browser"""
        help_path = os.path.join(cmd_folder, 'help', 'build', 'html', 'index.html')
        if os.path.exists(help_path):
             webbrowser.open(f"file://{help_path}")
        else:
             # Fallback if local help isn't built
             webbrowser.open("https://github.com/yolanda225/qgis-marche-a-lombre")

    def run(self):
        processing.execAlgorithmDialog("marchealombre:marche_a_lombre")
