# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MappyDockWidget
                                 A QGIS plugin
 helper for consistent goelogical map generation
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-06-24
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Luca Penasa, PLANMAP and GMAP team
        email                : luca.penasa@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
from typing import List, Tuple

import numpy as np
from PyQt5.QtWidgets import QComboBox
from qgis.PyQt import QtWidgets, uic, QtCore
from qgis.PyQt.QtCore import pyqtSignal
from qgis.PyQt.QtWidgets import QFileDialog, QLineEdit, QCheckBox
from qgis._core import QgsMessageLog, QgsExpressionContextUtils
from qgis._gui import QgsFileWidget
from qgis.core import QgsCategorizedSymbolRenderer
from qgis.gui import QgsMapLayerComboBox, QgsFieldComboBox, QgsDoubleSpinBox
from qgis.core import QgsProject, QgsMapLayerProxyModel, QgsSymbol, QgsRendererCategory, \
    QgsVectorLayer

import logging as log

# log.getLogger().setLevel(log.DEBUG)

from pathlib import Path


# from qgis.gui import QgsMapLayerComboBox
from mappy.mappy_utils import getChangeSignal, parameters_widgets, readWidgetContent, serialize_value_for_settings

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'qgismappy_dockwidget_base.ui'))





class MappyDockWidget(QtWidgets.QDockWidget, FORM_CLASS):
    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""

        super(MappyDockWidget, self).__init__(parent)

        self.setupUi(self)
        self.log_message("Initializing Mappy")
        self.initConstruct()

        self.units_field.setLayer(self.points.currentLayer())
        self.restoreSettingsFromProject()

        proj = QgsProject.instance()
        proj.readProject.connect(self.restoreSettingsFromProject)

        self.infobox.setTextInteractionFlags(QtCore.Qt.TextBrowserInteraction)
        self.infobox.setOpenExternalLinks(True)

        self.connect_widgets()
        import mappy

    def get_available_settings(self):
        settings = []
        for name in self.__dict__.copy():
            w = getattr(self, name)

            if type(w) in parameters_widgets:
                settings.append(name)

    def get_widget_by_name(self, name):
        return getattr(self, name)

    def get_current_parameter_value(self, name):
        w = self.get_widget_by_name(name)
        return readWidgetContent(w)

    def connect_widgets(self):
        for name in self.__dict__.copy():
            w = getattr(self, name)

            wtype = type(w)
            if wtype not in parameters_widgets:
                continue

            def generate_method(name):
                def call_trigger(self, value):
                    self.value_changed( name, value)
                return call_trigger

            slot_name = f"widget_parameter_{name}_changed"
            setattr(self.__class__, slot_name, generate_method(name))
            s = getChangeSignal(w)
            s.connect(getattr(self, slot_name))

    def value_changed(self,name,  value):
        log.debug(f"Detected parameter change in {name} to value {value}")
        proj = QgsProject.instance()

        if name =="points":
            log.debug("points layer were changed")
            self.units_field.setLayer(value)
            points_layer = serialize_value_for_settings(self.get_current_parameter_value(name))
            key = points_layer + "_preferred_field"
            log.debug("reading from settings")
            suggested, good = proj.readEntry("mappy", key)
            log.debug(f"suggested value {suggested}")
            if good:
                self.units_field: QgsFieldComboBox
                exists = self.units_field.findText(suggested)
                log.debug(exists)
                if suggested and exists:
                    log.debug("----> set back field to previsouly used assignement")
                    self.units_field.setField(suggested)



        if name == "units_field":
            # we store also this preference for being connected to this specific layer of points
            points_layer = serialize_value_for_settings(self.get_current_parameter_value("points"))
            key = points_layer + "_preferred_field"
            proj.writeEntry("mappy", key, value)
            log.debug(f"stored preference to key {key}")



        current = self.get_current_parameter_value(name)
        log.debug(f"CURRENT VALUE {current}")

        asstring = serialize_value_for_settings(value)

        proj.writeEntry("mappy", name, asstring)
        log.debug("Wrote to settings")

    # def saveSettingsToProject(self):
    #     log.debug("SAVING SETTINGS CALLED")
    #     from .mappy_utis import collect_parameters
    #     pars = collect_parameters(self)
    #     log.debug(f"found pars {pars}")
    #
    #     proj = QgsProject.instance()
    #
    #     for k, item in pars.items():
    #         if type(item) in [str, int]:
    #             proj.writeEntry("mappy", k, pars[k])
    #         elif type(item) in [np.double, float]:
    #             proj.writeEntryDouble("mappy", k, pars[k])
    #         elif type(item) in [bool]:
    #             proj.writeEntryBool("mappy", k, pars[k])
    #         elif type(item in [QgsVectorLayer]):
    #             log.debug(pars[k].id())
    #             proj.writeEntry("mappy", k, pars[k].id())
    #         else:
    #             log.debug(f"Cannot store value of type {type(item)}")

    def restoreSettingsFromProject(self):

        log.debug("Restoring values from settings")

        proj = QgsProject.instance()

        from .mappy_utils import collect_parameters
        pars = collect_parameters(self)
        log.debug(f"found pars {pars}")

        for k, item in pars.items():
            value, found = proj.readEntry("mappy", k, None)
            log.debug(f"just read {k}: {value}")
            if not found:
                continue
            ptype = type(pars[k])
            if ptype in [str]:
                pars[k] = value
            elif ptype in [float, np.double]:
                pars[k] = np.double(value)
            elif ptype in [bool]:
                pars[k] = bool(value)
            elif ptype in [QgsVectorLayer]:
                root = proj.layerTreeRoot()
                l = root.findLayer(pars[k])
                if l:
                    pars[k] = l.layer()
                log.debug(f"found layer {l}")


            else:
                raise TypeError(f"cannot convert type {type(value)} to {type(pars[k])}")

            from .mappy_utils import restoreWidgetContent
            w = self.get_widget_by_name(k)
            try:
                restoreWidgetContent(w, pars[k])
            except Exception as e:
                log.debug(f"Could not restore the value for the widget from the settings.\n Error: {e}")







        log.debug(f"resulting pars {pars}")

    def getUserHome(self):
        return str(Path.home())

    def initConstruct(self):
        self.lines.setFilters(QgsMapLayerProxyModel.LineLayer)
        self.points.setFilters(QgsMapLayerProxyModel.PointLayer)
        home = self.getUserHome()
        initfname = Path(home).joinpath("geomap.gpkg").as_posix()
        self.output.lineEdit().setText(initfname)
        self.output.setFilter('*.gpkg')

    def log_message(self, message, level=0, notifyUser=True):
        QgsMessageLog.logMessage(message, "Mappy", level, notifyUser)

    def lines_layerChanged(self, layer):
        log.debug("LINE LAYER CHANGED")
        if self.lines.currentLayer() != layer:
            self.saveSettingsToProject()

    def points_layerChanged(self, layer):
        self.units_field: QgsFieldComboBox

        log.debug("POINT LAYER CHANGED")

        if self.units_field.layer() != layer:
            self.units_field.setLayer(layer)
            self.saveSettingsToProject()

    def units_field_fieldChanged(self, id):
        log.debug(f"UNIT FIELD CHANGED to {id}, cfield is {self.units_field.currentField()}")
        if self.units_field.currentField() != id:
            self.saveSettingsToProject()

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()
