# -*- coding: utf-8 -*-

"""
/***************************************************************************
 MappiaPublisher
                                 A QGIS plugin
 Publish your maps easily
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-12-09
        copyright            : (C) 2019 by Danilo/CSR UFMG
        email                : danilo@csr.ufmg.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Danilo da Silveira Figueira / CSR UFMG'
__date__ = '2020-01-21'
__copyright__ = '(C) 2020 by Danilo da Silveira Figueira / CSR UFMG'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
import processing

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsApplication
from qgis.utils import iface
from mappia_publisher.mappia_publisher_provider import MappiaPublisherProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class MappiaPublisherPlugin(object):

    def __init__(self):
        self.provider = None
        self.dlg = None

    def initProcessing(self):
        self.provider = MappiaPublisherProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)
        icon = os.path.join(os.path.dirname(__file__), "icon.png")
        self.shareAction = QAction(QIcon(icon), u"Share your maps", iface.mainWindow())
        self.shareAction.triggered.connect(self.publishCallback)
        iface.addPluginToWebMenu(u"&Mappia", self.shareAction)
        iface.addToolBarIcon(self.shareAction)
        self.viewAction = QAction(QIcon(icon), u"View shared maps", iface.mainWindow())
        self.viewAction.triggered.connect(self.viewMapsCallback)
        iface.addPluginToWebMenu(u"&Mappia", self.viewAction)
        iface.addToolBarIcon(self.viewAction)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        iface.removePluginWebMenu(u"&Mappia", self.shareAction)
        iface.removeToolBarIcon(self.shareAction)
        iface.removePluginWebMenu(u"&Mappia", self.viewAction)
        iface.removeToolBarIcon(self.viewAction)

    def publishCallback(self):
        processing.execAlgorithmDialog("mappia:Publish")

    def viewMapsCallback(self):
        processing.execAlgorithmDialog("mappia:View")
