#!/usr/bin/env python
# coding: utf-8

"""
DestinationsApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from .. import configuration
from ..api_client import ApiClient

class DestinationsApi(object):

    def __init__(self, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            if not configuration.api_client:
                configuration.api_client = ApiClient('http://192.168.95.239:3000/api')
            self.api_client = configuration.api_client


    def get_destinations(self, **kwargs):
        """
        Fetch customer's destinations.



        :return: list[V01Destination]
        """

        all_params = []

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_destinations" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/destinations.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='list[V01Destination]', auth_settings=auth_settings)

        return response

    def import_destinations(self, **kwargs):
        """
        Import destinations by upload a CSV file or by JSON


        :param bool replace:
        :param File file: CSV file, encoding, separator and line return automatically detected, with localized CSV header according to HTTP header Accept-Language
        :param V01Destination destinations: In mutual exclusion with CSV file upload.

        :return: str
        """

        all_params = ['replace', 'file', 'destinations']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method import_destinations" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/destinations.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'replace' in params:
            form_params['replace'] = params['replace']

        if 'file' in params:
            files['file'] = params['file']

        body_params = None

        if 'destinations' in params:
            body_params = params['destinations']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def create_destination(self, name, **kwargs):
        """
        Create destination.


        :param str name:  (required)
        :param str street:
        :param str postalcode:
        :param str city:
        :param float lat:
        :param float lng:
        :param int quantity:
        :param DateTime open:
        :param DateTime close:
        :param str detail:
        :param str comment:
        :param str ref:
        :param DateTime take_over:
        :param str take_over_default:
        :param list[int] tag_ids:
        :param float geocoding_accuracy:

        :return: V01Destination
        """

        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `create_destination`")

        all_params = ['name', 'street', 'postalcode', 'city', 'lat', 'lng', 'quantity', 'open', 'close', 'detail', 'comment', 'ref', 'take_over', 'take_over_default', 'tag_ids', 'geocoding_accuracy']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method create_destination" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/destinations.{format}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'name' in params:
            form_params['name'] = params['name']

        if 'street' in params:
            form_params['street'] = params['street']

        if 'postalcode' in params:
            form_params['postalcode'] = params['postalcode']

        if 'city' in params:
            form_params['city'] = params['city']

        if 'lat' in params:
            form_params['lat'] = params['lat']

        if 'lng' in params:
            form_params['lng'] = params['lng']

        if 'quantity' in params:
            form_params['quantity'] = params['quantity']

        if 'open' in params:
            form_params['open'] = params['open']

        if 'close' in params:
            form_params['close'] = params['close']

        if 'detail' in params:
            form_params['detail'] = params['detail']

        if 'comment' in params:
            form_params['comment'] = params['comment']

        if 'ref' in params:
            form_params['ref'] = params['ref']

        if 'take_over' in params:
            form_params['take_over'] = params['take_over']

        if 'take_over_default' in params:
            form_params['take_over_default'] = params['take_over_default']

        if 'tag_ids' in params:
            form_params['tag_ids'] = params['tag_ids']

        if 'geocoding_accuracy' in params:
            form_params['geocoding_accuracy'] = params['geocoding_accuracy']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Destination', auth_settings=auth_settings)

        return response

    def delete_destinations(self, ids, **kwargs):
        """
        Delete multiple destinations.


        :param list[Integer] ids:  (required)

        :return: str
        """

        # verify the required parameter 'ids' is set
        if ids is None:
            raise ValueError("Missing the required parameter `ids` when calling `delete_destinations`")

        all_params = ['ids']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_destinations" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/destinations.{format}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        query_params = {}

        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def geocode_destination(self, **kwargs):
        """
        Geocode destination.


        :param str name:
        :param str street:
        :param str postalcode:
        :param str city:
        :param float lat:
        :param float lng:
        :param int quantity:
        :param DateTime open:
        :param DateTime close:
        :param str detail:
        :param str comment:
        :param str ref:
        :param DateTime take_over:
        :param str take_over_default:
        :param list[int] tag_ids:
        :param float geocoding_accuracy:

        :return: V01Destination
        """

        all_params = ['name', 'street', 'postalcode', 'city', 'lat', 'lng', 'quantity', 'open', 'close', 'detail', 'comment', 'ref', 'take_over', 'take_over_default', 'tag_ids', 'geocoding_accuracy']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method geocode_destination" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/destinations/geocode.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'name' in params:
            form_params['name'] = params['name']

        if 'street' in params:
            form_params['street'] = params['street']

        if 'postalcode' in params:
            form_params['postalcode'] = params['postalcode']

        if 'city' in params:
            form_params['city'] = params['city']

        if 'lat' in params:
            form_params['lat'] = params['lat']

        if 'lng' in params:
            form_params['lng'] = params['lng']

        if 'quantity' in params:
            form_params['quantity'] = params['quantity']

        if 'open' in params:
            form_params['open'] = params['open']

        if 'close' in params:
            form_params['close'] = params['close']

        if 'detail' in params:
            form_params['detail'] = params['detail']

        if 'comment' in params:
            form_params['comment'] = params['comment']

        if 'ref' in params:
            form_params['ref'] = params['ref']

        if 'take_over' in params:
            form_params['take_over'] = params['take_over']

        if 'take_over_default' in params:
            form_params['take_over_default'] = params['take_over_default']

        if 'tag_ids' in params:
            form_params['tag_ids'] = params['tag_ids']

        if 'geocoding_accuracy' in params:
            form_params['geocoding_accuracy'] = params['geocoding_accuracy']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Destination', auth_settings=auth_settings)

        return response

    def get_destination(self, id, **kwargs):
        """
        Fetch destination.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: V01Destination
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_destination`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_destination" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/destinations/{id}.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Destination', auth_settings=auth_settings)

        return response

    def update_destination(self, id, **kwargs):
        """
        Update destination.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param str name:
        :param str street:
        :param str postalcode:
        :param str city:
        :param float lat:
        :param float lng:
        :param int quantity:
        :param DateTime open:
        :param DateTime close:
        :param str detail:
        :param str comment:
        :param str ref:
        :param DateTime take_over:
        :param str take_over_default:
        :param list[int] tag_ids:
        :param float geocoding_accuracy:

        :return: V01Destination
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `update_destination`")

        all_params = ['id', 'name', 'street', 'postalcode', 'city', 'lat', 'lng', 'quantity', 'open', 'close', 'detail', 'comment', 'ref', 'take_over', 'take_over_default', 'tag_ids', 'geocoding_accuracy']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_destination" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/destinations/{id}.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'name' in params:
            form_params['name'] = params['name']

        if 'street' in params:
            form_params['street'] = params['street']

        if 'postalcode' in params:
            form_params['postalcode'] = params['postalcode']

        if 'city' in params:
            form_params['city'] = params['city']

        if 'lat' in params:
            form_params['lat'] = params['lat']

        if 'lng' in params:
            form_params['lng'] = params['lng']

        if 'quantity' in params:
            form_params['quantity'] = params['quantity']

        if 'open' in params:
            form_params['open'] = params['open']

        if 'close' in params:
            form_params['close'] = params['close']

        if 'detail' in params:
            form_params['detail'] = params['detail']

        if 'comment' in params:
            form_params['comment'] = params['comment']

        if 'ref' in params:
            form_params['ref'] = params['ref']

        if 'take_over' in params:
            form_params['take_over'] = params['take_over']

        if 'take_over_default' in params:
            form_params['take_over_default'] = params['take_over_default']

        if 'tag_ids' in params:
            form_params['tag_ids'] = params['tag_ids']

        if 'geocoding_accuracy' in params:
            form_params['geocoding_accuracy'] = params['geocoding_accuracy']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Destination', auth_settings=auth_settings)

        return response

    def delete_destination(self, id, **kwargs):
        """
        Delete destination.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `delete_destination`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_destination" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/destinations/{id}.{format}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response
