#!/usr/bin/env python
# coding: utf-8

"""
PlanningsApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from .. import configuration
from ..api_client import ApiClient

class PlanningsApi(object):

    def __init__(self, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            if not configuration.api_client:
                configuration.api_client = ApiClient('http://beta.app.mapotempo.com/api')
            self.api_client = configuration.api_client


    def get_plannings(self, **kwargs):
        """
        Fetch customer's plannings.



        :return: list[V01Planning]
        """

        all_params = []

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_plannings" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='list[V01Planning]', auth_settings=auth_settings)

        return response

    def create_planning(self, name, **kwargs):
        """
        Create planning.


        :param str name:  (required)
        :param str ref:
        :param str date:
        :param int zoning_id:
        :param bool out_of_date:
        :param list[int] route_ids:
        :param list[int] tag_ids:

        :return: V01Planning
        """

        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `create_planning`")

        all_params = ['name', 'ref', 'date', 'zoning_id', 'out_of_date', 'route_ids', 'tag_ids']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method create_planning" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings.{format}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'name' in params:
            form_params['name'] = params['name']

        if 'ref' in params:
            form_params['ref'] = params['ref']

        if 'date' in params:
            form_params['date'] = params['date']

        if 'zoning_id' in params:
            form_params['zoning_id'] = params['zoning_id']

        if 'out_of_date' in params:
            form_params['out_of_date'] = params['out_of_date']

        if 'route_ids' in params:
            form_params['route_ids'] = params['route_ids']

        if 'tag_ids' in params:
            form_params['tag_ids'] = params['tag_ids']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Planning', auth_settings=auth_settings)

        return response

    def delete_plannings(self, ids, **kwargs):
        """
        Delete multiple plannings.


        :param list[Integer] ids:  (required)

        :return: str
        """

        # verify the required parameter 'ids' is set
        if ids is None:
            raise ValueError("Missing the required parameter `ids` when calling `delete_plannings`")

        all_params = ['ids']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_plannings" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings.{format}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        query_params = {}

        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def get_planning(self, id, **kwargs):
        """
        Fetch planning.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: V01Planning
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_planning`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_planning" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Planning', auth_settings=auth_settings)

        return response

    def update_planning(self, id, **kwargs):
        """
        Update planning.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param str name:
        :param str ref:
        :param str date:
        :param int zoning_id:
        :param bool out_of_date:
        :param list[int] route_ids:
        :param list[int] tag_ids:

        :return: V01Planning
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `update_planning`")

        all_params = ['id', 'name', 'ref', 'date', 'zoning_id', 'out_of_date', 'route_ids', 'tag_ids']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_planning" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'name' in params:
            form_params['name'] = params['name']

        if 'ref' in params:
            form_params['ref'] = params['ref']

        if 'date' in params:
            form_params['date'] = params['date']

        if 'zoning_id' in params:
            form_params['zoning_id'] = params['zoning_id']

        if 'out_of_date' in params:
            form_params['out_of_date'] = params['out_of_date']

        if 'route_ids' in params:
            form_params['route_ids'] = params['route_ids']

        if 'tag_ids' in params:
            form_params['tag_ids'] = params['tag_ids']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Planning', auth_settings=auth_settings)

        return response

    def delete_planning(self, id, **kwargs):
        """
        Delete planning.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `delete_planning`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_planning" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}.{format}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def automatic_insert_stop(self, id, **kwargs):
        """
        Suggest a place for an unaffected stop.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `automatic_insert_stop`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method automatic_insert_stop" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}/automatic_insert.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def clone_planning(self, id, **kwargs):
        """
        Clone the planning.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: V01Planning
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `clone_planning`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method clone_planning" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}/duplicate.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Planning', auth_settings=auth_settings)

        return response

    def optimize_routes(self, id, **kwargs):
        """
        Starts asynchronous routes optimization.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `optimize_routes`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method optimize_routes" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}/optimize_each_routes.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def use_order_array(self, id, order_array_id, shift, **kwargs):
        """
        Use order_array in the planning.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param str order_array_id:  (required)
        :param int shift:  (required)

        :return: V01Planning
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `use_order_array`")

        # verify the required parameter 'order_array_id' is set
        if order_array_id is None:
            raise ValueError("Missing the required parameter `order_array_id` when calling `use_order_array`")

        # verify the required parameter 'shift' is set
        if shift is None:
            raise ValueError("Missing the required parameter `shift` when calling `use_order_array`")

        all_params = ['id', 'order_array_id', 'shift']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method use_order_array" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}/orders/{order_array_id}/{shift}.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        if 'order_array_id' in params:
            path_params['order_array_id'] = params['order_array_id']

        if 'shift' in params:
            path_params['shift'] = params['shift']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Planning', auth_settings=auth_settings)

        return response

    def refresh_planning(self, id, **kwargs):
        """
        Force recompute the planning after parameter update.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: V01Planning
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `refresh_planning`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method refresh_planning" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}/refresh.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Planning', auth_settings=auth_settings)

        return response

    def switch_vehicles(self, id, **kwargs):
        """
        Switch two vehicles.


        :param str id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `switch_vehicles`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method switch_vehicles" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{id}/switch.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def update_stop(self, planning_id, route_id, id, **kwargs):
        """
        Update stop.
        

        :param int planning_id:  (required)
        :param int route_id:  (required)
        :param int id:  (required)
        :param bool active:  
        
        :return: str
        """
        
        # verify the required parameter 'planning_id' is set
        if planning_id is None:
            raise ValueError("Missing the required parameter `planning_id` when calling `update_stop`")
        
        # verify the required parameter 'route_id' is set
        if route_id is None:
            raise ValueError("Missing the required parameter `route_id` when calling `update_stop`")
        
        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `update_stop`")
        
        all_params = ['planning_id', 'route_id', 'id', 'active']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_stop" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{planning_id}/routes/{route_id}/stops/{id}.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        
        if 'planning_id' in params:
            path_params['planning_id'] = params['planning_id']  
        
        if 'route_id' in params:
            path_params['route_id'] = params['route_id']  
        
        if 'id' in params:
            path_params['id'] = params['id']  
        
        query_params = {}
        
        header_params = {}
        
        form_params = {}

        files = {}
        
        if 'active' in params:
            form_params['active'] = bytes(params['active'])
        
        body_params = None
        
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)
        
        return response

    def get_routes(self, planning_id, **kwargs):
        """
        Fetch planning's routes.


        :param str planning_id: Id or the ref field value, then use \"ref:[value]\". (required)

        :return: list[V01Route]
        """

        # verify the required parameter 'planning_id' is set
        if planning_id is None:
            raise ValueError("Missing the required parameter `planning_id` when calling `get_routes`")

        all_params = ['planning_id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_routes" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{planning_id}/routes.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'planning_id' in params:
            path_params['planning_id'] = params['planning_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='list[V01Route]', auth_settings=auth_settings)

        return response

    def get_route(self, planning_id, id, **kwargs):
        """
        Fetch route.


        :param str planning_id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param int id:  (required)

        :return: V01Route
        """

        # verify the required parameter 'planning_id' is set
        if planning_id is None:
            raise ValueError("Missing the required parameter `planning_id` when calling `get_route`")

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_route`")

        all_params = ['planning_id', 'id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_route" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{planning_id}/routes/{id}.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'planning_id' in params:
            path_params['planning_id'] = params['planning_id']

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Route', auth_settings=auth_settings)

        return response

    def update_route(self, planning_id, id, **kwargs):
        """
        Update route.


        :param str planning_id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param int id:  (required)
        :param bool hidden:  
        :param bool locked:  
        :param str color:  

        :return: V01Route
        """

        # verify the required parameter 'planning_id' is set
        if planning_id is None:
            raise ValueError("Missing the required parameter `planning_id` when calling `update_route`")

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `update_route`")

        all_params = ['planning_id', 'id', 'hidden', 'locked', 'color']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_route" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{planning_id}/routes/{id}.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        if 'planning_id' in params:
            path_params['planning_id'] = params['planning_id']  

        if 'id' in params:
            path_params['id'] = params['id']  

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'hidden' in params:
            form_params['hidden'] = params['hidden']
        
        if 'locked' in params:
            form_params['locked'] = params['locked']

        if 'color' in params:
            form_params['color'] = params['color']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Route', auth_settings=auth_settings)

        return response

    def activation_stops(self, planning_id, id, active, **kwargs):
        """
        Change stops activation.


        :param str planning_id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param int id:  (required)
        :param str active:  (required)

        :return: V01Route
        """

        # verify the required parameter 'planning_id' is set
        if planning_id is None:
            raise ValueError("Missing the required parameter `planning_id` when calling `activation_stops`")

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `activation_stops`")

        # verify the required parameter 'active' is set
        if active is None:
            raise ValueError("Missing the required parameter `active` when calling `activation_stops`")

        all_params = ['planning_id', 'id', 'active']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method activation_stops" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{planning_id}/routes/{id}/active/{active}.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'planning_id' in params:
            path_params['planning_id'] = params['planning_id']

        if 'id' in params:
            path_params['id'] = params['id']

        if 'active' in params:
            path_params['active'] = params['active']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Route', auth_settings=auth_settings)

        return response

    def move_destinations(self, planning_id, id, destination_ids, **kwargs):
        """
        Move destination to routes. Append in order at end.


        :param str planning_id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param str id:  (required)
        :param list[Integer] destination_ids:  (required)

        :return: str
        """

        # verify the required parameter 'planning_id' is set
        if planning_id is None:
            raise ValueError("Missing the required parameter `planning_id` when calling `move_destinations`")

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `move_destinations`")

        # verify the required parameter 'destination_ids' is set
        if destination_ids is None:
            raise ValueError("Missing the required parameter `destination_ids` when calling `move_destinations`")

        all_params = ['planning_id', 'id', 'destination_ids']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method move_destinations" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{planning_id}/routes/{id}/destinations/moves.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'planning_id' in params:
            path_params['planning_id'] = params['planning_id']

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        if 'destination_ids' in params:
            form_params['destination_ids'] = bytes(params['destination_ids'])

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def optimize_route(self, planning_id, id, **kwargs):
        """
        Starts asynchronous route optimization.


        :param str planning_id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param int id:  (required)

        :return: str
        """

        # verify the required parameter 'planning_id' is set
        if planning_id is None:
            raise ValueError("Missing the required parameter `planning_id` when calling `optimize_route`")
        
        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `optimize_route`")
        
        all_params = ['planning_id', 'id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method optimize_route" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{planning_id}/routes/{id}/optimize.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'planning_id' in params:
            path_params['planning_id'] = params['planning_id']  

        if 'id' in params:
            path_params['id'] = params['id']  

        query_params = {}

        header_params = {}

        form_params = {}

        if 'planning_id' in params:
            form_params['planning_id'] = params['planning_id']

        if 'id' in params:
            form_params['id'] = params['id']

        files = {}
        
        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def move_stop(self, planning_id, id, stop_id, index, **kwargs):
        """
        Move stop position in routes.


        :param str planning_id: Id or the ref field value, then use \"ref:[value]\". (required)
        :param str id:  (required)
        :param int stop_id: Stop id to move (required)
        :param int index: New position in the route (required)

        :return: str
        """

        # verify the required parameter 'planning_id' is set
        if planning_id is None:
            raise ValueError("Missing the required parameter `planning_id` when calling `move_stop`")

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `move_stop`")

        # verify the required parameter 'stop_id' is set
        if stop_id is None:
            raise ValueError("Missing the required parameter `stop_id` when calling `move_stop`")

        # verify the required parameter 'index' is set
        if index is None:
            raise ValueError("Missing the required parameter `index` when calling `move_stop`")

        all_params = ['planning_id', 'id', 'stop_id', 'index']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method move_stop" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/plannings/{planning_id}/routes/{id}/stops/{stop_id}/move/{index}.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'planning_id' in params:
            path_params['planning_id'] = params['planning_id']

        if 'id' in params:
            path_params['id'] = params['id']

        if 'stop_id' in params:
            path_params['stop_id'] = params['stop_id']

        if 'index' in params:
            path_params['index'] = params['index']

        query_params = {}

        header_params = {}

        form_params = {}

        if 'planning_id' in params:
            form_params['planning_id'] = params['planning_id']

        if 'id' in params:
            form_params['id'] = params['id']

        if 'stop_id' in params:
            form_params['stop_id'] = params['stop_id']

        if 'index' in params:
            form_params['index'] = params['index']

        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response
