#!/usr/bin/env python
# coding: utf-8

"""
CustomersApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from .. import configuration
from ..api_client import ApiClient

class CustomersApi(object):

    def __init__(self, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            if not configuration.api_client:
                configuration.api_client = ApiClient('http://beta.app.mapotempo.com/api')
            self.api_client = configuration.api_client


    def get_customer(self, id, **kwargs):
        """
        Fetch customer.


        :param int id:  (required)

        :return: list[V01Customer]
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_customer`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_customer" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/customers/{id}.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='list[V01Customer]', auth_settings=auth_settings)

        return response

    def update_customer(self, id, **kwargs):
        """
        Update customer.


        :param int id:  (required)
        :param str end_subscription:
        :param int max_vehicles:
        :param str take_over:
        :param list[int] store_ids:
        :param int job_geocoding_id:
        :param int job_optimizer_id:
        :param str name:
        :param str tomtom_user:
        :param str tomtom_password:
        :param str tomtom_account:
        :param str masternaut_user:
        :param str masternaut_password:
        :param int router_id:
        :param  speed_multiplicator:
        :param int print_planning_annotating:
        :param str print_header:
        :param str alyacom_association:

        :return: V01Customer
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `update_customer`")

        all_params = ['id', 'end_subscription', 'max_vehicles', 'take_over', 'store_ids', 'job_geocoding_id', 'job_optimizer_id', 'name', 'tomtom_user', 'tomtom_password', 'tomtom_account', 'masternaut_user', 'masternaut_password', 'router_id', 'speed_multiplicator', 'print_planning_annotating', 'print_header', 'alyacom_association']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_customer" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/customers/{id}.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'end_subscription' in params:
            form_params['end_subscription'] = params['end_subscription']

        if 'max_vehicles' in params:
            form_params['max_vehicles'] = params['max_vehicles']

        if 'take_over' in params:
            form_params['take_over'] = params['take_over']

        if 'store_ids' in params:
            form_params['store_ids'] = params['store_ids']

        if 'job_geocoding_id' in params:
            form_params['job_geocoding_id'] = params['job_geocoding_id']

        if 'job_optimizer_id' in params:
            form_params['job_optimizer_id'] = params['job_optimizer_id']

        if 'name' in params:
            form_params['name'] = params['name']

        if 'tomtom_user' in params:
            form_params['tomtom_user'] = params['tomtom_user']

        if 'tomtom_password' in params:
            form_params['tomtom_password'] = params['tomtom_password']

        if 'tomtom_account' in params:
            form_params['tomtom_account'] = params['tomtom_account']

        if 'masternaut_user' in params:
            form_params['masternaut_user'] = params['masternaut_user']

        if 'masternaut_password' in params:
            form_params['masternaut_password'] = params['masternaut_password']

        if 'router_id' in params:
            form_params['router_id'] = params['router_id']

        if 'print_planning_annotating' in params:
            form_params['print_planning_annotating'] = params['print_planning_annotating']

        if 'print_header' in params:
            form_params['print_header'] = params['print_header']

        if 'alyacom_association' in params:
            form_params['alyacom_association'] = params['alyacom_association']

        body_params = None

        if 'speed_multiplicator' in params:
            body_params = params['speed_multiplicator']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Customer', auth_settings=auth_settings)

        return response

    def get_job(self, id, job_id, **kwargs):
        """
        Return a job


        :param int id:  (required)
        :param int job_id:  (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_job`")

        # verify the required parameter 'job_id' is set
        if job_id is None:
            raise ValueError("Missing the required parameter `job_id` when calling `get_job`")

        all_params = ['id', 'job_id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_job" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/customers/{id}/job/{job_id}.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        if 'job_id' in params:
            path_params['job_id'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def delete_job(self, id, job_id, **kwargs):
        """
        Cancel job


        :param int id:  (required)
        :param int job_id:  (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `delete_job`")

        # verify the required parameter 'job_id' is set
        if job_id is None:
            raise ValueError("Missing the required parameter `job_id` when calling `delete_job`")

        all_params = ['id', 'job_id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_job" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/customers/{id}/job/{job_id}.{format}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        if 'job_id' in params:
            path_params['job_id'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def get_tomtom_ids(self, id, **kwargs):
        """
        Fetch tomtom ids.


        :param int id:  (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_tomtom_ids`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_tomtom_ids" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/customers/{id}/tomtom_ids.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response
