#!/usr/bin/env python
# coding: utf-8

"""
VehiclesApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from .. import configuration
from ..api_client import ApiClient

class VehiclesApi(object):

    def __init__(self, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            if not configuration.api_client:
                configuration.api_client = ApiClient('http://beta.app.mapotempo.com/api')
            self.api_client = configuration.api_client


    def get_vehicles(self, **kwargs):
        """
        Fetch customer's vehicles.



        :return: list[V01Vehicle]
        """

        all_params = []

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_vehicles" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/vehicles.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='list[V01Vehicle]', auth_settings=auth_settings)

        return response

    def get_vehicle(self, id, **kwargs):
        """
        Fetch vehicle.


        :param int id:  (required)

        :return: V01Vehicle
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_vehicle" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/vehicles/{id}.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Vehicle', auth_settings=auth_settings)

        return response

    def update_vehicle(self, id, **kwargs):
        """
        Update vehicle.


        :param int id:  (required)
        :param str name:
        :param int emission:
        :param int consumption:
        :param int capacity:
        :param str color:
        :param str open:
        :param str close:
        :param str tomtom_id:
        :param int store_start_id:
        :param int store_stop_id:
        :param int router_id:
        :param  speed_multiplicator:
        :param str rest_start:
        :param str rest_stop:
        :param str rest_duration:
        :param int store_rest_id:

        :return: V01Vehicle
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `update_vehicle`")

        all_params = ['id', 'name', 'emission', 'consumption', 'capacity', 'color', 'open', 'close', 'tomtom_id', 'store_start_id', 'store_stop_id', 'router_id', 'speed_multiplicator', 'rest_start', 'rest_stop', 'rest_duration', 'store_rest_id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_vehicle" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/vehicles/{id}.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'name' in params:
            form_params['name'] = params['name']

        if 'emission' in params:
            form_params['emission'] = params['emission']

        if 'consumption' in params:
            form_params['consumption'] = params['consumption']

        if 'capacity' in params:
            form_params['capacity'] = params['capacity']

        if 'color' in params:
            form_params['color'] = params['color']

        if 'open' in params:
            form_params['open'] = params['open']

        if 'close' in params:
            form_params['close'] = params['close']

        if 'tomtom_id' in params:
            form_params['tomtom_id'] = params['tomtom_id']

        if 'store_start_id' in params:
            form_params['store_start_id'] = params['store_start_id']

        if 'store_stop_id' in params:
            form_params['store_stop_id'] = params['store_stop_id']

        if 'router_id' in params:
            form_params['router_id'] = params['router_id']

        if 'rest_start' in params:
            form_params['rest_start'] = params['rest_start']

        if 'rest_stop' in params:
            form_params['rest_stop'] = params['rest_stop']

        if 'rest_duration' in params:
            form_params['rest_duration'] = params['rest_duration']

        if 'store_rest_id' in params:
            form_params['store_rest_id'] = params['store_rest_id']

        body_params = None

        if 'speed_multiplicator' in params:
            body_params = params['speed_multiplicator']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Vehicle', auth_settings=auth_settings)

        return response
