#!/usr/bin/env python
# coding: utf-8

"""
OrderarraysApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from .. import configuration
from ..api_client import ApiClient

class OrderarraysApi(object):

    def __init__(self, api_client=None):
        if api_client:
            self.api_client = api_client
        else:
            if not configuration.api_client:
                configuration.api_client = ApiClient('http://beta.app.mapotempo.com/api')
            self.api_client = configuration.api_client


    def get_order_arrays(self, **kwargs):
        """
        Fetch customer's order_arrays.



        :return: list[V01OrderArray]
        """

        all_params = []

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_order_arrays" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='list[V01OrderArray]', auth_settings=auth_settings)

        return response

    def create_order_array(self, name, base_date, length, **kwargs):
        """
        Create order_array.


        :param str name:  (required)
        :param str base_date:  (required)
        :param str length:  (required)

        :return: V01OrderArray
        """

        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `create_order_array`")

        # verify the required parameter 'base_date' is set
        if base_date is None:
            raise ValueError("Missing the required parameter `base_date` when calling `create_order_array`")

        # verify the required parameter 'length' is set
        if length is None:
            raise ValueError("Missing the required parameter `length` when calling `create_order_array`")

        all_params = ['name', 'base_date', 'length']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method create_order_array" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays.{format}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'name' in params:
            form_params['name'] = params['name']

        if 'base_date' in params:
            form_params['base_date'] = params['base_date']

        if 'length' in params:
            form_params['length'] = params['length']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01OrderArray', auth_settings=auth_settings)

        return response

    def delete_order_arrays(self, ids, **kwargs):
        """
        Delete multiple order_arrays.


        :param list[Integer] ids:  (required)

        :return: str
        """

        # verify the required parameter 'ids' is set
        if ids is None:
            raise ValueError("Missing the required parameter `ids` when calling `delete_order_arrays`")

        all_params = ['ids']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_order_arrays" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays.{format}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        query_params = {}

        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def get_order_array(self, id, **kwargs):
        """
        Fetch order_array.


        :param int id:  (required)

        :return: V01OrderArray
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_order_array`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_order_array" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays/{id}.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01OrderArray', auth_settings=auth_settings)

        return response

    def update_order_array(self, id, **kwargs):
        """
        Update order_array.


        :param int id:  (required)
        :param str name:
        :param str base_date:
        :param str length:

        :return: V01OrderArray
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `update_order_array`")

        all_params = ['id', 'name', 'base_date', 'length']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_order_array" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays/{id}.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'name' in params:
            form_params['name'] = params['name']

        if 'base_date' in params:
            form_params['base_date'] = params['base_date']

        if 'length' in params:
            form_params['length'] = params['length']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01OrderArray', auth_settings=auth_settings)

        return response

    def delete_order_array(self, id, **kwargs):
        """
        Delete order_array.


        :param int id:  (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `delete_order_array`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method delete_order_array" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays/{id}.{format}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def mass_assignment_order(self, id, **kwargs):
        """
        Orders mass assignment.


        :param int id:  (required)

        :return: str
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `mass_assignment_order`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method mass_assignment_order" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays/{id}.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='str', auth_settings=auth_settings)

        return response

    def clone_order_array(self, id, **kwargs):
        """
        Clone the order_array.


        :param int id:  (required)

        :return: V01OrderArray
        """

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `clone_order_array`")

        all_params = ['id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method clone_order_array" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays/{id}/duplicate.{format}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01OrderArray', auth_settings=auth_settings)

        return response

    def get_orders(self, order_array_id, **kwargs):
        """
        Fetch order_array's orders.


        :param int order_array_id:  (required)

        :return: list[V01Order]
        """

        # verify the required parameter 'order_array_id' is set
        if order_array_id is None:
            raise ValueError("Missing the required parameter `order_array_id` when calling `get_orders`")

        all_params = ['order_array_id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_orders" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays/{order_array_id}/orders.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'order_array_id' in params:
            path_params['order_array_id'] = params['order_array_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='list[V01Order]', auth_settings=auth_settings)

        return response

    def get_order(self, order_array_id, id, **kwargs):
        """
        Fetch order.


        :param int order_array_id:  (required)
        :param int id:  (required)

        :return: V01Order
        """

        # verify the required parameter 'order_array_id' is set
        if order_array_id is None:
            raise ValueError("Missing the required parameter `order_array_id` when calling `get_order`")

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `get_order`")

        all_params = ['order_array_id', 'id']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method get_order" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays/{order_array_id}/orders/{id}.{format}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        if 'order_array_id' in params:
            path_params['order_array_id'] = params['order_array_id']

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Order', auth_settings=auth_settings)

        return response

    def update_order(self, order_array_id, id, **kwargs):
        """
        Update order.


        :param int order_array_id:  (required)
        :param int id:  (required)
        :param int destination_id:
        :param int shift:
        :param list[int] product_ids:

        :return: V01Order
        """

        # verify the required parameter 'order_array_id' is set
        if order_array_id is None:
            raise ValueError("Missing the required parameter `order_array_id` when calling `update_order`")

        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError("Missing the required parameter `id` when calling `update_order`")

        all_params = ['order_array_id', 'id', 'destination_id', 'shift', 'product_ids']

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s' to method update_order" % key)
            params[key] = val
        del params['kwargs']

        resource_path = '/0.1/order_arrays/{order_array_id}/orders/{id}.{format}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}

        if 'order_array_id' in params:
            path_params['order_array_id'] = params['order_array_id']

        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        if 'destination_id' in params:
            form_params['destination_id'] = params['destination_id']

        if 'shift' in params:
            form_params['shift'] = params['shift']

        if 'product_ids' in params:
            form_params['product_ids'] = params['product_ids']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type([])

        # Authentication setting
        auth_settings = ['api_key']

        response = self.api_client.call_api(resource_path, method, path_params, query_params, header_params,
                                            body=body_params, post_params=form_params, files=files,
                                            response='V01Order', auth_settings=auth_settings)

        return response
