import asyncio

from ..utils.utils import get_maphub_client


def async_thread(func):
    async def wrapper(*args, **kwargs):
        return await asyncio.to_thread(func, *args, **kwargs)

    return wrapper


@async_thread
def get_folder(folder_id):
    client = get_maphub_client()
    folder_info = client.folder.get_folder(folder_id)
    return folder_info


@async_thread
def get_workspaces():
    client = get_maphub_client()
    workspaces = client.workspace.get_workspaces()
    return workspaces


@async_thread
def get_folder_contents(folder_id):
    client = get_maphub_client()
    contents = client.folder.get_folder_contents(folder_id)
    return contents


@async_thread
def folder_has_project(folder_id):
    from ..utils.project_utils import folder_has_project as sync_folder_has_project
    return sync_folder_has_project(folder_id)
