"""
Test script for the scroll area stretch functionality.

This script tests that items in the folder selection area don't expand to fill the entire space when there are few items.

To run this test:
1. Open QGIS
2. Load some layers that are not connected to MapHub
3. Run this script from the QGIS Python console
"""

from qgis.utils import iface
from PyQt5.QtWidgets import QDialog

# Import the dialog
from ui.dialogs.BatchConnectLayersDialog import BatchConnectLayersDialog

def test_scroll_stretch():
    """Test that items don't stretch to fill the scroll area."""
    # Get all layers from the current project
    layers = iface.mapCanvas().layers()
    
    # Filter for layers that are not connected to MapHub
    not_connected_layers = [layer for layer in layers if layer.customProperty("maphub/map_id") is None]
    
    if not not_connected_layers:
        print("No unconnected layers found. Please add some layers to the project that are not connected to MapHub.")
        return
    
    # Create and show the BatchConnectLayersDialog
    dialog = BatchConnectLayersDialog(iface, not_connected_layers)
    
    # Get the ProjectNavigationWidget from the dialog
    workspace_nav_widget = dialog.workspace_nav_widget
    project_nav_widget = workspace_nav_widget.project_nav_widget
    
    # Check if the stretch is working
    print("Testing scroll area stretch functionality:")
    print("1. Items should be aligned at the top of the scroll area")
    print("2. Items should maintain their natural size")
    print("3. Empty space should appear at the bottom when there are few items")
    
    # Show the dialog for manual verification
    dialog.exec_()
    
    print("Test completed. Please verify that:")
    print("1. Folder items are not stretched vertically")
    print("2. Folder items are aligned at the top of the scroll area")
    print("3. There is empty space at the bottom of the scroll area when there are few items")

if __name__ == "__main__":
    test_scroll_stretch()