# MapHub Custom Layer Type

This document describes the implementation of the custom MapHub layer type.

## Overview

The MapHub plugin uses a custom QGIS layer type (`MapHubPluginLayer`) to represent maps from MapHub. This layer type:

- Delegates rendering to standard QGIS layer types
- Handles synchronization with MapHub
- Manages downloading and uploading data
- Persists connection information in QGIS projects
- Automatically downloads missing files when a project is opened

## Implementation Details

### MapHubPluginLayer

The `MapHubPluginLayer` class extends `QgsPluginLayer` and provides:

- Methods for initializing and managing the layer
- Methods for synchronizing with MapHub
- XML serialization for project save/load

The layer stores MapHub connection information directly in the layer itself, rather than in custom properties:

- `map_id`: The ID of the map on MapHub
- `folder_id`: The ID of the folder containing the map
- `workspace_id`: The ID of the workspace containing the folder
- `version_id`: The ID of the version of the map
- `last_sync`: Timestamp of the last synchronization
- `local_path`: Path to the local file
- `last_style_hash`: Hash of the last synchronized style

### MapHubLayerRenderer

The `MapHubLayerRenderer` class extends `QgsMapLayerRenderer` and delegates rendering to the underlying layer. This ensures that the custom layer type renders exactly the same as a standard QGIS layer.

### MapHubPluginLayerType

The `MapHubPluginLayerType` class extends `QgsPluginLayerType` and provides a factory for creating MapHub plugin layers.

## Integration with Existing Code

The custom layer type integrates with:

- **SyncManager**: Handles synchronization between local layers and MapHub
- **LayerDecorator**: Adds visual indicators to layers in the layer panel
- **LayerMenuProvider**: Adds MapHub-specific actions to the layer context menu
- **SynchronizeLayersDialog**: Provides a UI for synchronizing layers
- **MapBrowserDockWidget**: Displays maps from MapHub and allows downloading them

## Usage

MapHub layers are created when:

- A map is downloaded from MapHub
- A standard layer is converted to a MapHub layer

When a project containing MapHub layers is opened, the plugin automatically checks if the local files exist and downloads them if they are missing.

## Error Handling

The layer handles errors by:

- Showing error messages in the message bar
- Retrying failed downloads
- Cleaning up partial downloads

## Benefits

Using a custom layer type provides several benefits:

- **Automatic file handling**: The layer automatically downloads missing files when a project is opened
- **Improved persistence**: Connection information is stored directly in the layer, making it more robust
- **Better integration**: The layer integrates seamlessly with QGIS's layer handling system
- **Simplified code**: The layer encapsulates MapHub-specific functionality, making the code cleaner and more maintainable