# MapHub QGIS Plugin
## Overview
The MapHub QGIS Plugin enables seamless integration between QGIS and the MapHub platform, allowing users to view, edit, download, and upload geospatial maps directly within QGIS.
## About MapHub
MapHub is a community hub for GIS users to host, visualize, and share geospatial datasets. Visit [MapHub](https://maphub.co) for more information.
## Features (Implemented and coming soon)
- [x] Connect to your MapHub account using API key authentication
- [x] Share maps publicly or keep them private
- [x] Upload local maps to your MapHub projects
- [x] Browse your MapHub projects
- [x] Directly view MapHub maps in QGIS via tiling service
- [x] Download maps from MapHub to use in QGIS
- [x] Layer-based synchronization between QGIS and MapHub
- [x] Comprehensive synchronization dialog with clear visual indicators
- [x] Folder-level synchronization for batch operations
- [ ] And much more ...

## Installation
1. Open QGIS
2. Navigate to Plugins > Manage and Install Plugins
3. Search for "MapHub"
4. Click Install

## Getting Started
1. Obtain an API key from your MapHub account
2. Enter your API key in the plugin settings
3. Start uploading and downloading maps!
4. Use the layer-based synchronization to keep your local layers in sync with MapHub (see [documentation](docs/layer_sync.md))

## Requirements
- QGIS 3.0 or later
- Active MapHub account

## Support
For issues, questions, or feature requests, please visit our [tracker](https://github.com/maphub-co/maphub-qgis) or contact us on [Discord](https://discord.gg/ufqVjqpVGw).
## License
This plugin is developed by MapHub (maphub@meteory.eu) and is Licensed under a MIT License.
