"""
Test script for the MapBrowserDockWidget status indicators.

This script demonstrates how the status indicators are displayed in the MapBrowserDockWidget.
It verifies that the indicators appear at the end of the item text rather than as child nodes.

Usage:
    Run this script from the QGIS Python console:
    
    ```python
    import os
    os.chdir('/path/to/maphub-qgis')
    exec(open('test_map_browser_indicators.py').read())
    ```
"""

from qgis.utils import iface
from qgis.core import QgsProject

from ui.widgets.MapBrowserDockWidget import MapBrowserDockWidget


def test_map_browser_indicators():
    """Test the MapBrowserDockWidget status indicators."""
    print("Testing MapBrowserDockWidget status indicators...")
    
    # Create and show the MapBrowserDockWidget
    dock_widget = MapBrowserDockWidget(iface, iface.mainWindow())
    iface.addDockWidget(Qt.LeftDockWidgetArea, dock_widget)
    
    print("MapBrowserDockWidget created and shown.")
    print("Please verify that:")
    print("1. Status indicators appear at the end of map items, not as child nodes")
    print("2. The indicators are properly aligned and sized")
    print("3. Tooltips appear when hovering over the indicators")
    print("4. The indicators update correctly when synchronization status changes")
    
    # Keep a reference to the dock widget to prevent it from being garbage collected
    global map_browser_dock
    map_browser_dock = dock_widget


if __name__ == "__console__":
    # This will be true when run from the QGIS Python console
    from PyQt5.QtCore import Qt
    test_map_browser_indicators()
else:
    print("Please run this script from the QGIS Python console.")