"""
Test script for the batch connect layers functionality.

This script tests the new batch connect layers functionality by:
1. Opening the SynchronizeLayersDialog
2. Clicking the "Connect Layers" button
3. Verifying the BatchConnectLayersDialog opens correctly

To run this test:
1. Open QGIS
2. Load some layers that are not connected to MapHub
3. Run this script from the QGIS Python console
"""

from qgis.utils import iface
from PyQt5.QtWidgets import QDialog

# Import the dialog
from ui.dialogs.SynchronizeLayersDialog import SynchronizeLayersDialog
from ui.dialogs.BatchConnectLayersDialog import BatchConnectLayersDialog

def test_batch_connect():
    """Test the batch connect functionality."""
    # Create and show the SynchronizeLayersDialog
    dialog = SynchronizeLayersDialog(iface)
    
    # Simulate clicking the "Connect Layers" button
    dialog.on_batch_connect_clicked()
    
    # The BatchConnectLayersDialog should now be open
    # You can manually verify it's working correctly
    
    print("Test completed. Please verify that:")
    print("1. The BatchConnectLayersDialog opened correctly")
    print("2. It shows all not-connected layers")
    print("3. The WorkspaceNavigationWidget is displayed")
    print("4. You can select layers and a destination folder")
    print("5. The Connect Selected button works correctly")

if __name__ == "__main__":
    test_batch_connect()