# Testing MapHub Custom Layer Type

This document outlines the testing steps to verify that the custom MapHub layer type is working correctly and that the old management of connected layers with custom properties has been removed.

## Prerequisites

- QGIS 3.0 or later installed
- MapHub QGIS Plugin installed
- Valid MapHub API key configured

## Test Cases

### 1. Downloading a Map from MapHub

**Objective**: Verify that downloading a map from MapHub creates a MapHubPluginLayer instead of a standard layer with custom properties.

**Steps**:
1. Open QGIS
2. Click on the "Get map" button in the MapHub toolbar
3. Select a workspace and folder
4. Select a map to download
5. Click "OK" to download the map

**Expected Results**:
- The map should be added to the QGIS project as a MapHubPluginLayer
- The layer should have a visual indicator showing it's connected to MapHub
- The layer should render correctly

**Verification**:
- Right-click on the layer and verify that the context menu shows MapHub-specific actions
- Check the layer type in the Python console:
  ```python
  layer = iface.activeLayer()
  print(type(layer).__name__)  # Should print "MapHubPluginLayer"
  ```

### 2. Synchronizing a Layer with MapHub

**Objective**: Verify that synchronization works correctly with MapHubPluginLayer.

**Steps**:
1. Make changes to a MapHubPluginLayer (e.g., edit features, change style)
2. Click on the "Synchronize Layers with MapHub" button in the MapHub toolbar
3. Select the modified layer
4. Click "Synchronize Selected"

**Expected Results**:
- The layer should be synchronized with MapHub
- The synchronization status should be updated
- The visual indicator should reflect the new status

**Verification**:
- Check that the layer is still a MapHubPluginLayer after synchronization
- Verify that the changes are visible on MapHub

### 3. Disconnecting a Layer from MapHub

**Objective**: Verify that disconnecting a MapHubPluginLayer works correctly.

**Steps**:
1. Right-click on a MapHubPluginLayer
2. Select "Disconnect from MapHub"
3. Confirm the disconnection

**Expected Results**:
- The layer should be disconnected from MapHub
- The layer should be converted to a standard QGIS layer
- The layer name should be updated to indicate it's disconnected

**Verification**:
- Check that the layer no longer has MapHub-specific context menu actions
- Verify that the layer is no longer listed in the synchronization dialog

### 4. Project Save and Load

**Objective**: Verify that MapHubPluginLayers are correctly saved and loaded in QGIS projects.

**Steps**:
1. Create a new QGIS project
2. Download several maps from MapHub
3. Save the project
4. Close QGIS
5. Reopen QGIS
6. Open the saved project

**Expected Results**:
- All MapHubPluginLayers should be loaded correctly
- The layers should maintain their connection to MapHub
- The layers should render correctly

**Verification**:
- Check that the layers are still MapHubPluginLayers
- Verify that the synchronization status is correct
- Test synchronizing one of the layers

### 5. Missing File Handling

**Objective**: Verify that MapHubPluginLayers automatically download missing files.

**Steps**:
1. Download a map from MapHub
2. Save the project
3. Locate the downloaded file and delete it
4. Reopen the project

**Expected Results**:
- The plugin should detect that the file is missing
- The plugin should automatically download the file
- The layer should render correctly

**Verification**:
- Check that the file has been downloaded to the default download location
- Verify that the layer renders correctly

### 6. Style Synchronization

**Objective**: Verify that style synchronization works correctly with MapHubPluginLayers.

**Steps**:
1. Download a map from MapHub
2. Change the layer style (e.g., change colors, symbols)
3. Right-click on the layer and select "Upload Style to MapHub"
4. Create a new QGIS project
5. Download the same map again

**Expected Results**:
- The new layer should have the updated style
- The style should be correctly synchronized with MapHub

**Verification**:
- Compare the style of the new layer with the original layer
- Verify that the style changes are visible on MapHub

## Troubleshooting

If any of the tests fail, check the following:

1. QGIS Python Console for error messages
2. MapHub API key configuration
3. Network connectivity to MapHub
4. QGIS version compatibility

## Reporting Issues

If you encounter any issues during testing, please report them with the following information:

1. QGIS version
2. MapHub Plugin version
3. Operating system
4. Steps to reproduce the issue
5. Expected vs. actual results
6. Screenshots or error messages