# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mapbiomasfogo
                                 A QGIS plugin
 Este plugin permite acesso aos produtos de fogo do Mapbiomas diretamente no Qgis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-05
        git sha              : $Format:%H$
        copyright            : (C) 2025 by IPAM Amazonia
        email                : contato@mapbiomas.org
 ***************************************************************************/
            Desenvolvimento do plugin: @IPAM - Brasília, DF - BR
  Newton Monteiro, Wallace Silva, Felipe Martenexen, Vera Laísa, João Ribeiro
                   contato:newton.monteiro@ipam.org.br
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import datetime

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets, QtCore
from .parametros import ano_maximo, collection 

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'MapBiomas_fogo_dialog_base.ui'))

class MapbiomasfogoDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        super(MapbiomasfogoDialog, self).__init__(parent)
        self.setupUi(self)
        # Define o valor máximo como o ano atual - 1
        self.FireAnualYear.setMaximum(ano_maximo)
        self.FireAcumulatedT1.setMaximum(ano_maximo)
        self.FireFrequencyYearT1.setMaximum(ano_maximo)
        self.FireMonthlyYear.setMaximum(ano_maximo)
        self.FireLastYear.setMaximum(ano_maximo)
        self.FireSizeYear.setMaximum(ano_maximo)
        self.collection_version.setText(f"COLEÇÃO {collection}")
        self.collection_version.setStyleSheet("color: white;")

        # Lista de todas as QCheckBox relevantes
        self.checkboxes = [
            self.check_fire_annual_by_total_burned,
            self.check_fire_annual_by_class,
            self.check_fire_annual_by_natural_anthropic,
            self.check_fire_accumulated_by_total_burned,
            self.check_fire_accumulated_by_class,
            self.check_fire_accumulated_by_natural_anthropic,
            self.check_fire_frequency,
            self.check_fire_Monthly,
            self.check_fire_Last,
            self.check_fire_size
        ]

        # Conecta o evento de mudança de estado de cada checkbox ao método de validação
        for cb in self.checkboxes:
            cb.stateChanged.connect(self._validate_ok_button)

        # Valida o botão OK no início
        self._validate_ok_button()

    def _validate_ok_button(self):
        """Valida se pelo menos uma checkbox está selecionada e habilita/desabilita o botão OK"""
        # Verifica se pelo menos uma checkbox está marcada
        any_checked = any(cb.isChecked() for cb in self.checkboxes)
        
        # Habilita ou desabilita o botão OK baseado na validação
        ok_button = self.button_box.button(QtWidgets.QDialogButtonBox.Ok)
        if ok_button:
            ok_button.setEnabled(any_checked)

    def showEvent(self, event):
        # Desmarca todas as caixas de seleção toda vez que a janela for exibida
        for cb in self.checkboxes:
            cb.setChecked(False)
        # Valida o botão OK novamente
        self._validate_ok_button()
        super().showEvent(event)