# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mapbiomasfogo
                                 A QGIS plugin
 Este plugin permite acesso aos produtos de fogo do Mapbiomas diretamente no Qgis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-05
        git sha              : $Format:%H$
        copyright            : (C) 2025 by IPAM Amazonia
        email                : contato@mapbiomas.org
 ***************************************************************************/
            Desenvolvimento do plugin: @IPAM - Brasília, DF - BR
 Newton Monteiro, Wallace Silva, Felipe Martenexen, Vera Laísa, João Ribeiro
                   contato:newton.monteiro@ipam.org.br
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 ***************************************************************************/
         ESTE ARQUIVO DEFINI OS PARAMETROS DAS LEGENDA DO PLUGIN
/***************************************************************************
"""
from qgis.PyQt.QtWidgets import QWidget, QVBoxLayout, QLabel, QHBoxLayout
from qgis.PyQt.QtGui import QColor, QPixmap
from qgis.gui import QgsLayerTreeEmbeddedWidgetProvider
from .parametros import ano_minimo, ano_maximo

# Cria as legendas para aba OCORRÊNCIA DE FOGO ANUAL
# ABA OCORRÊNCIA DE FOGO ANUAL - Área total
class FireAnualTotalLegendWidget(QWidget):
    def __init__(self, Tyear, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        pix = QPixmap(20, 20)
        pix.fill(QColor("#e31a1c"))  # vermelho
        row = QHBoxLayout()
        lbl_color = QLabel()
        lbl_color.setPixmap(pix)
        texto = "Área total queimada em " + str(Tyear)
        lbl_value = QLabel(texto)
        row.addWidget(lbl_color)
        row.addWidget(lbl_value)
        row.addStretch()
        layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(20)
        self.setMinimumWidth(200)

class FireAnualTotalLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "fireanualtotallegend"

    def name(self):
        return "Legenda Área Total Fogo Anual"

    def createWidget(self, layer, widgetIndex):
        Tyear = int(layer.customProperty("firelegend/year", 0))
        return FireAnualTotalLegendWidget(Tyear)

 # ABA OCORRÊNCIA DE FOGO ANUAL - Área total por uso e cobertura
class FireAnualTotalByClassLegendWidget(QWidget):
    def __init__(self, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        legend_items = [
            # Floresta
            (0, "#1f8d49", "Floresta"),
            (1, "#1f8d49", "Formação Florestal"),
            (1, "#7dc975", "Formação Savânica"),
            (1, "#04381d", "Mangue"),
            (1, "#026975", "Floresta Alagável (beta)"),
            (1, "#02d659", "Restinga Arbórea"),
            # Formação Natural não Florestal
            (0, "#d6bc74", "Formação Natural não Florestal"),
            (1, "#519799", "Campo Alagado e Área Pantanosa"),
            (1, "#d6bc74", "Formação Campestre"),
            (1, "#fc8114", "Apicum"),
            (1, "#ffaa5f", "Afloramento Rochoso"),
            (1, "#ad5100", "Restinga Herbácea"),
            (1, "#d89f5c", "Outras Formações não Florestais"),
            # Agropecuária
            (0, "#ffefc3", "Agropecuária"),
            (1, "#edde8e", "Pastagem"),
            (1, "#E974ED", "Agricultura"),
            (2, "#C27BA0", "Lavoura Temporária"),
            (3, "#f5b3c8", "Soja"),
            (3, "#db7093", "Cana"),
            (3, "#c71585", "Arroz"),
            (3, "#ff69b4", "Algodão (beta)"),
            (3, "#f54ca9", "Outras Lavouras Temporárias"),
            (2, "#d082de", "Lavoura Perene"),
            (3, "#d68fe2", "Café"),
            (3, "#9932cc", "Citrus"),
            (3, "#9065d0", "Dendê (beta)"),
            (3, "#e6ccff", "Outras Lavouras Perenes"),
            (1, "#7a5900", "Silvicultura"),
            (1, "#ffefc3", "Mosaico de Usos"),
            # Área não Vegetada
            (0, "#d4271e", "Área não Vegetada"),
            (1, "#ffa07a", "Praia, Duna e Areal"),
            (1, "#d4271e", "Área Urbanizada"),
            (1, "#9c0027", "Mineração"),
            (1, "#db4d4f", "Outras Áreas não Vegetadas"),
            # Corpo D'água
            (0, "#2532e4", "Corpo D'água"),
            (1, "#2532e4", "Rio, Lago e Oceano"),
            (1, "#091077", "Aquicultura"),
        ]

        for indent, color, name in legend_items:
            row = QHBoxLayout()
            row.setContentsMargins(20 * indent, 0, 0, 0)  # Indenta subcategorias
            pix = QPixmap(20, 20)
            pix.fill(QColor(color))
            lbl_color = QLabel()
            lbl_color.setPixmap(pix)
            lbl_value = QLabel(name)
            row.addWidget(lbl_color)
            row.addWidget(lbl_value)
            row.addStretch()
            layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(5 + len(legend_items) * 20)
        self.setMinimumWidth(200)

class FireAnualTotalByClassLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "fireanualtotalbyclasslegend"

    def name(self):
        return "Legenda Área Total Fogo Anual por Classe"

    def createWidget(self, layer, widgetIndex):
        return FireAnualTotalByClassLegendWidget()

 # ABA OCORRÊNCIA DE FOGO ANUAL - Natural e Antropopico
class FireAnualTotalByNaturalAntropicWidget(QWidget):
    def __init__(self, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        # Defina as 15 cores e nomes aqui (exemplo com cores aleatórias e nomes genéricos)
        cores = [QColor("#139912"), QColor("#ffd966")]
        nomes = ["Fogo em área Natural", "Fogo em área Antropica"]

        for i in range(2):
            pix = QPixmap(20, 20)
            pix.fill(cores[i])
            row = QHBoxLayout()
            lbl_color = QLabel()
            lbl_color.setPixmap(pix)
            lbl_value = QLabel(nomes[i])
            row.addWidget(lbl_color)
            row.addWidget(lbl_value)
            row.addStretch()
            layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(15 + 2 * 15)
        self.setMinimumWidth(200)

class FireAnualTotalByNaturalAntropicLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "fireanualtotalbynaturalantropiclegend"

    def name(self):
        return "Legenda Área Total Fogo Anual em área Natural e Antropopico"

    def createWidget(self, layer, widgetIndex):
        return FireAnualTotalByNaturalAntropicWidget()


# Cria a legenda para aba FREQUÊNCIA DE QUEIMADAS
class FireFrequencyLegendWidget(QWidget):
    def __init__(self, min_val, max_val, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        cores_base = [
            "#faf3cd", "#fdf1b0", "#fbe981", "#fae258", "#f9de44", "#f8d71f", "#f1ca1e", "#e9bc1c",
            "#e2af1a", "#daa118", "#d29316", "#cc8715", "#c57b14", "#bd6c12", "#b76011", "#b0540f",
            "#a8450d", "#9f360b", "#992a0a", "#921e08", "#8c1307", "#810004", "#770105", "#6a0306",
            "#600407", "#5a0508", "#4b0709", "#450709", "#3f0708", "#390608", "#330607", "#2d0506",
            "#270506", "#220505", "#1c0404", "#170404", "#120303", "#0d0203", "#080202", "#040101"
        ]
        cor_final = "#080202"

        total_anos = max_val - min_val + 1
        n_cores_base = len(cores_base)

        cores = []
        if total_anos <= n_cores_base:
            cores = cores_base[:total_anos]
        else:
            cores = cores_base[:-1]
            n_interpoladas = total_anos - len(cores) - 1
            if n_interpoladas > 0:
                cor_inicio = QColor(cores_base[-2])
                cor_fim = QColor(cor_final)
                for i in range(1, n_interpoladas + 1):
                    ratio = i / (n_interpoladas + 1)
                    r = int(cor_inicio.red() + (cor_fim.red() - cor_inicio.red()) * ratio)
                    g = int(cor_inicio.green() + (cor_fim.green() - cor_inicio.green()) * ratio)
                    b = int(cor_inicio.blue() + (cor_fim.blue() - cor_inicio.blue()) * ratio)
                    cores.append(QColor(r, g, b).name())
            cores.append(cor_final)

        for i in range(total_anos):
            ano = min_val + i
            cor = QColor(cores[i])
            pix = QPixmap(20, 20)
            pix.fill(cor)
            row = QHBoxLayout()
            lbl_color = QLabel()
            lbl_color.setPixmap(pix)
            vezes = i + 1
            texto = "Queimou 1 vez" if vezes == 1 else f"Queimou {vezes} vezes"
            lbl_value = QLabel(texto)
            row.addWidget(lbl_color)
            row.addWidget(lbl_value)
            row.addStretch()
            layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(150)
        self.setMinimumWidth(200)

class FireFrequencyLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "firefrequencylegend"

    def name(self):
        return "Legenda Frequência de Queimadas"

    def createWidget(self, layer, widgetIndex):
        min_val = int(layer.customProperty("firelegend/min_val", ano_minimo))
        max_val = int(layer.customProperty("firelegend/max_val", ano_maximo))
        return FireFrequencyLegendWidget(min_val, max_val)
    
#Cria a legenda para aba OCORRÊNCIA DE FOGO MENSAL
class FireMonthlyLegendWidget(QWidget):
    def __init__(self, Myear, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        cores = [
            QColor("#a900ff"),  # Janeiro
            QColor("#6f02ff"),  # Fevereiro
            QColor("#020aff"),  # Março
            QColor("#0675ff"),  # Abril
            QColor("#06ffff"),  # Maio
            QColor("#ffee00"),  # Junho
            QColor("#ff7700"),  # Julho
            QColor("#ff0800"),  # Agosto
            QColor("#c20202"),  # Setembro
            QColor("#8b0000"),  # Outubro
            QColor("#0aa602"),  # Novembro
            QColor("#83f27e"),  # Dezembro
        ]
        nomes = [
            "Janeiro",
            "Fevereiro",
            "Março",
            "Abril",
            "Maio",
            "Junho",
            "Julho",
            "Agosto",
            "Setembro",
            "Outubro",
            "Novembro",
            "Dezembro"
        ]

        for i in range(12):
            pix = QPixmap(20, 20)
            pix.fill(cores[i])
            row = QHBoxLayout()
            lbl_color = QLabel()
            lbl_color.setPixmap(pix)
            lbl_value = QLabel(f"{nomes[i]} de {Myear}")
            row.addWidget(lbl_color)
            row.addWidget(lbl_value)
            row.addStretch()
            layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(5 + 12 * 20)
        self.setMinimumWidth(200)

class FireMonthlyLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "firemonthlylegend"

    def name(self):
        return "Legenda Fogo Mensal"

    def createWidget(self, layer, widgetIndex):
        Myear = int(layer.customProperty("firelegend/year", 0))
        return FireMonthlyLegendWidget(Myear)

#Cria as legendas para aba ÁREA QUEIMADA ACUMULADA
    # ABA ÁREA QUEIMADA ACUMULADA - Área total
class FireAccumulatedTotalLegendWidget(QWidget):
    def __init__(self, ACCT1, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        pix = QPixmap(20, 20)
        pix.fill(QColor("#e31a1c"))  # vermelho
        row = QHBoxLayout()
        lbl_color = QLabel()
        lbl_color.setPixmap(pix)
        texto = "Área total queimada acumulada de 1985 até " + str(ACCT1)
        lbl_value = QLabel(texto)
        row.addWidget(lbl_color)
        row.addWidget(lbl_value)
        row.addStretch()
        layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(20)
        self.setMinimumWidth(200)

class FireAccumulatedTotalLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "fireaccumulatedtotallegend" 
    
    def name(self):
        return "Legenda Área Total Acumulada Fogo"
    
    def createWidget(self, layer, widgetIndex):
        ACCT1 = int(layer.customProperty("firelegend/year", 0))
        return FireAccumulatedTotalLegendWidget(ACCT1)
    
    # ABA ÁREA QUEIMADA ACUMULADA - Uso e cobertura
class FireAccumulatedByClassLegendWidget(QWidget):
    def __init__(self, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        legend_items = [
            # Floresta
            (0, "#1f8d49", "Floresta"),
            (1, "#1f8d49", "Formação Florestal"),
            (1, "#7dc975", "Formação Savânica"),
            (1, "#04381d", "Mangue"),
            (1, "#026975", "Floresta Alagável (beta)"),
            (1, "#02d659", "Restinga Arbórea"),
            # Formação Natural não Florestal
            (0, "#d6bc74", "Formação Natural não Florestal"),
            (1, "#519799", "Campo Alagado e Área Pantanosa"),
            (1, "#d6bc74", "Formação Campestre"),
            (1, "#fc8114", "Apicum"),
            (1, "#ffaa5f", "Afloramento Rochoso"),
            (1, "#ad5100", "Restinga Herbácea"),
            (1, "#d89f5c", "Outras Formações não Florestais"),
            # Agropecuária
            (0, "#ffefc3", "Agropecuária"),
            (1, "#edde8e", "Pastagem"),
            (1, "#E974ED", "Agricultura"),
            (2, "#C27BA0", "Lavoura Temporária"),
            (3, "#f5b3c8", "Soja"),
            (3, "#db7093", "Cana"),
            (3, "#c71585", "Arroz"),
            (3, "#ff69b4", "Algodão (beta)"),
            (3, "#f54ca9", "Outras Lavouras Temporárias"),
            (2, "#d082de", "Lavoura Perene"),
            (3, "#d68fe2", "Café"),
            (3, "#9932cc", "Citrus"),
            (3, "#9065d0", "Dendê (beta)"),
            (3, "#e6ccff", "Outras Lavouras Perenes"),
            (1, "#7a5900", "Silvicultura"),
            (1, "#ffefc3", "Mosaico de Usos"),
            # Área não Vegetada
            (0, "#d4271e", "Área não Vegetada"),
            (1, "#ffa07a", "Praia, Duna e Areal"),
            (1, "#d4271e", "Área Urbanizada"),
            (1, "#9c0027", "Mineração"),
            (1, "#db4d4f", "Outras Áreas não Vegetadas"),
            # Corpo D'água
            (0, "#2532e4", "Corpo D'água"),
            (1, "#2532e4", "Rio, Lago e Oceano"),
            (1, "#091077", "Aquicultura"),
        ]

        for indent, color, name in legend_items:
            row = QHBoxLayout()
            row.setContentsMargins(20 * indent, 0, 0, 0)  # Indenta subcategorias
            pix = QPixmap(20, 20)
            pix.fill(QColor(color))
            lbl_color = QLabel()
            lbl_color.setPixmap(pix)
            lbl_value = QLabel(name)
            row.addWidget(lbl_color)
            row.addWidget(lbl_value)
            row.addStretch()
            layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(5 + len(legend_items) * 20)
        self.setMinimumWidth(250)

class FireAccumulatedByClassLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "fireaccumulatedbyclasslegend"

    def name(self): 
        return "Legenda Área Total Acumulada Fogo por Classe"

    def createWidget(self, layer, widgetIndex):
        return FireAccumulatedByClassLegendWidget()

    # ABA ÁREA QUEIMADA ACUMULADA - Natural e Antropopico
class FireAccumulatedByNaturalAntropicWidget(QWidget):
    def __init__(self, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        cores = [QColor("#139912"), QColor("#ffd966")]
        nomes = ["Fogo em área Natural", "Fogo em área Antropica"]

        for i in range(2):
            pix = QPixmap(20, 20)
            pix.fill(cores[i])
            row = QHBoxLayout()
            lbl_color = QLabel()
            lbl_color.setPixmap(pix)
            lbl_value = QLabel(nomes[i])
            row.addWidget(lbl_color)
            row.addWidget(lbl_value)
            row.addStretch()
            layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(15 + 2 * 15)
        self.setMinimumWidth(200)

class FireAccumulatedByNaturalAntropicLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "fireaccumulatedbynaturalantropiclegend"

    def name(self):
        return "Legenda Área Total Acumulada Fogo por Uso"

    def createWidget(self, layer, widgetIndex):
        return FireAccumulatedByNaturalAntropicWidget()

# Cria a legenda para aba TAMANHO DAS CICATRIZES
class FireSizeLegendWidget(QWidget):
    def __init__(self, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        cores = [
            QColor("#d0ae35"),  # < 10 ha
            QColor("#c68e2f"),  # 10 - 250 ha
            QColor("#b96d2b"),  # 250 - 500 ha
            QColor("#ac4b28"),  # 500 - 5.000 ha
            QColor("#933328"),  # 5.000 - 10.000 ha
            QColor("#72251d"),  # 10.000 - 50.000 ha
            QColor("#4e180f"),  # 50.000 - 100.000 ha
            QColor("#240d00"),  # >= 100.000 ha
        ]
        nomes = [
            "< 10 ha",
            "10 - 250 ha",
            "250 - 500 ha",
            "500 - 5.000 ha",
            "5.000 - 10.000 ha",
            "10.000 - 50.000 ha",
            "50.000 - 100.000 ha",
            ">= 100.000 ha"
        ]

        for i in range(len(cores)):
            pix = QPixmap(20, 20)
            pix.fill(cores[i])
            row = QHBoxLayout()
            lbl_color = QLabel()
            lbl_color.setPixmap(pix)
            lbl_value = QLabel(nomes[i])
            row.addWidget(lbl_color)
            row.addWidget(lbl_value)
            row.addStretch()
            layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(5 + len(cores) * 20)
        self.setMinimumWidth(200)

class FireSizeLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "firesizelegend"

    def name(self):
        return "Legenda Tamanho das Cicatrizes"

    def createWidget(self, layer, widgetIndex):
        return FireSizeLegendWidget()

# Cria a legenda para aba ANO DA ÚLTIMA OCORRÊNCIA DE FOGO
class FireLastOccurrenceLegendWidget(QWidget):
    def __init__(self, min_year, max_year, parent=None):
        super().__init__(parent)
        layout = QVBoxLayout()
        layout.setContentsMargins(10, 10, 10, 10)

        year_colors = {
            2024: "#730000", 2023: "#800000", 2022: "#850708", 2021: "#8B0E0F", 2020: "#901417",
            2019: "#961B1E", 2018: "#9B2226", 2017: "#9F2222", 2016: "#A3211E", 2015: "#A6211A",
            2014: "#AA2016", 2013: "#AE2012", 2012: "#B42E0F", 2011: "#B93C0C", 2010: "#BF4B08",
            2009: "#C45905", 2008: "#CA6702", 2007: "#BF7C27", 2006: "#B4924D", 2005: "#AAA772",
            2004: "#9FBD98", 2003: "#94D2BD", 2002: "#78C5B5", 2001: "#5DB9AD", 2000: "#41ACA6",
            1999: "#26A09E", 1998: "#0a9294", 1997: "#008998", 1996: "#007d96", 1995: "#007292",
            1994: "#00688c", 1993: "#005e86", 1992: "#00557f", 1991: "#004c7b", 1990: "#004080",
            1989: "#003781", 1988: "#002d81", 1987: "#00227f", 1986: "#00147d", 1985: "#000079"
        }

        for year in range(min_year, max_year + 1):
            if year in year_colors:
                pix = QPixmap(20, 20)
                pix.fill(QColor(year_colors[year]))
                row = QHBoxLayout()
                lbl_color = QLabel()
                lbl_color.setPixmap(pix)
                lbl_value = QLabel(f"Última ocorrência em {year}")
                row.addWidget(lbl_color)
                row.addWidget(lbl_value)
                row.addStretch()
                layout.addLayout(row)

        self.setLayout(layout)
        self.setMinimumHeight(150)
        self.setMinimumWidth(200)

class FireLastOccurrenceLegendProvider(QgsLayerTreeEmbeddedWidgetProvider):
    def id(self):
        return "firelastoccurrencelegend"

    def name(self):
        return "Legenda Última Ocorrência de Fogo"

    def createWidget(self, layer, widgetIndex):
        min_year = int(layer.customProperty("firelegend/min_year", ano_minimo))
        max_year = int(layer.customProperty("firelegend/max_year", ano_maximo))
        return FireLastOccurrenceLegendWidget(min_year, max_year)
