# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Mapbiomasfogo
                                 A QGIS plugin
 Este plugin permite acesso aos produtos de fogo do Mapbiomas diretamente no Qgis
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-05
        git sha              : $Format:%H$
        copyright            : (C) 2025 by IPAM Amazonia
        email                : contato@mapbiomas.org
 ***************************************************************************/
            Desenvolvimento do plugin: @IPAM - Brasília, DF - BR
 Newton Monteiro, Wallace Silva, Felipe Martenexen, Vera Laísa, João Ribeiro
                   contato:newton.monteiro@ipam.org.br
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtWidgets import QAction, QWidget, QVBoxLayout, QLabel, QHBoxLayout
from qgis.PyQt.QtGui import QColor, QPixmap, QIcon
from qgis.core import QgsRasterLayer, QgsProject
from qgis.gui import QgsLayerTreeEmbeddedWidgetProvider, QgsGui


import requests

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .MapBiomas_fogo_dialog import MapbiomasfogoDialog
import os.path
#importar parametros da legeda
from .legenda import *



class Mapbiomasfogo:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Mapbiomasfogo_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&MapBiomas Fogo')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Mapbiomasfogo', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = f'{self.plugin_dir}/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Acesse os dados de áera queimada'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&MapBiomas Fogo'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = MapbiomasfogoDialog()

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:

            ApiUrl = "https://api.mapbiomas.org/api/v1/brazil/maps"
            # Do something useful here - delete the line containing pass and
            # substitute with your code.

            # Acessa a API do MapBiomas para obter os dados do último fogo (ABA ANO DA ÚLTIMA CORRÊNCIA DE FOGO)
            url_fire_last = ApiUrl+"/fire_last"
            Lyear = self.dlg.FireLastYear.value() # Obtém o ano selecionado no QSpinBox

            #Para caixa de seleção "Frequencia de queimadas"
            if self.dlg.check_fire_Last.isChecked():
                # Define os parâmetros da requisição para fire_frequency
                params = {
                    "territoryIds": "10001",
                    "pixelValues":"-1",
                    "bboxSize": "256",
                    "year": str(Lyear)
                }

                fire_last_Tiles = requests.get(url_fire_last, params=params)
                print(fire_last_Tiles.text)

                if fire_last_Tiles.status_code == 200:
                    layer_name = f"Último Fogo "+str(Lyear)
                    xyz_url = fire_last_Tiles.text.strip()
                    print("URL retornada:", xyz_url)
                   
                    # Cria a camada XYZ
                    fire_last_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_last_layer.isValid():
                        # Registra o provider da legenda se ainda não estiver registrado
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("firelastoccurrencelegend"):
                            provider = FireLastOccurrenceLegendProvider()
                            registry.addProvider(provider)
                        
                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_last_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_last_layer.setCustomProperty('embeddedWidgets/0/id', "firelastoccurrencelegend")
                        fire_last_layer.setCustomProperty("firelegend/min_year", 1985)
                        fire_last_layer.setCustomProperty("firelegend/max_year", Lyear)
                        
                        # Adiciona a camada ao projeto
                        QgsProject.instance().addMapLayer(fire_last_layer)
                        print("Camada XYZ adicionada automaticamente!")
                    else:
                        print("Erro ao adicionar a camada XYZ.")
                else:
                    print(f"Erro na requisição: {fire_last_Tiles.status_code}")

                #Fim do acesso aos dados de Frequencia de queimadas (ABA ANO DA ÚLTIMA CORRÊNCIA DE FOGO)

            # Acessa a API do MapBiomas para obter os dados do tamanho da cicatriz (ABA TAMANHO DA CICATRIZES)
            url_fire_size = ApiUrl+"/fire_size"
            Syear = self.dlg.FireSizeYear.value() # Obtém o ano selecionado no QSpinBox

            #Para caixa de seleção "Frequencia de queimadas"
            if self.dlg.check_fire_size.isChecked():
                # Define os parâmetros da requisição para fire_frequency
                params = {
                    "territoryIds": "10001",
                    "pixelValues":"-1",
                    "bboxSize": "256",
                    "year": str(Syear)
                }

                fire_size_Tiles = requests.get(url_fire_size, params=params)
                print(fire_size_Tiles.text)

                if fire_size_Tiles.status_code == 200:
                    layer_name = f"Tamanho da cicatriz de queimada em "+str(Syear)
                    xyz_url = fire_size_Tiles.text.strip()
                    print("URL retornada:", xyz_url)

                    # Cria a camada XYZ
                    fire_size_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_size_layer.isValid():
                        # Registra o provider da legenda se ainda não estiver registrado
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("firesizelegend"):
                            provider = FireSizeLegendProvider()
                            registry.addProvider(provider)
                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_size_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_size_layer.setCustomProperty('embeddedWidgets/0/id', "firesizelegend")
                        fire_size_layer.setCustomProperty("firelegend/ano_final", Syear)
                        
                        QgsProject.instance().addMapLayer(fire_size_layer)
                        print("Camada XYZ adicionada automaticamente!")
                    else:
                        print("Erro ao adicionar a camada XYZ.")
                else:
                    print(f"Erro na requisição: {fire_size_Tiles.status_code}")

                #Fim do acesso aos dados de Frequencia de tamanho da cicatriz (ABA TAMANHO DA CICATRIZES)

            # Acessa a API do MapBiomas para obter os dados de fogo acumulado (ABA ÁREA QUEIMADA ACUMULADA)
            url_acumulated = ApiUrl+"/fire_accumulated"

            ACCT0 = 1985 
            ACCT1 = self.dlg.FireAcumulatedT1.value()# Obtém o ano final selecionado no QSpinBox

            #Para caixa de seleção "Área total queimada"
            if self.dlg.check_fire_accumulated_by_total_burned.isChecked():
                # Define os parâmetros da requisição para fire_accumulated_by_total_burned
                params = {
                    "territoryIds": "10001",
                    "pixelValues":"-1",
                    "bboxSize": "256",
                    "fromYear": str(ACCT0),
                    "toYear": str(ACCT1),
                    "legend": "fire_accumulated_by_total_burned"
                }

                fire_accumulated_by_total_burned_Tiles = requests.get(url_acumulated, params=params)
                print(fire_accumulated_by_total_burned_Tiles.text)

                if fire_accumulated_by_total_burned_Tiles.status_code == 200:
                    layer_name = f"Área total queimada de "+str(ACCT0)+" a "+str(ACCT1)
                    xyz_url = fire_accumulated_by_total_burned_Tiles.text.strip()
                    print("URL retornada:", xyz_url)

                    # Cria a camada XYZ
                    fire_accumulated_by_total_burned_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_accumulated_by_total_burned_layer.isValid():
                        # Registra o provider da legenda se ainda não estiver registrado
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("fireaccumulatedtotallegend"):
                            provider = FireAccumulatedTotalLegendProvider()
                            registry.addProvider(provider)
                        
                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_accumulated_by_total_burned_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_accumulated_by_total_burned_layer.setCustomProperty('embeddedWidgets/0/id', "fireaccumulatedtotallegend")
                        fire_accumulated_by_total_burned_layer.setCustomProperty("firelegend/year", ACCT1)

                        # Adiciona a camada ao projeto
                        QgsProject.instance().addMapLayer(fire_accumulated_by_total_burned_layer)
                        print("Camada XYZ adicionada automaticamente!")
                    else:
                        print("Erro ao adicionar a camada XYZ.")
                else:
                    print(f"Erro na requisição: {fire_annual_by_total_burned_Tiles.status_code}")

            #Para caixa de seleção "Área total queimada por uso e cobertura"
            if self.dlg.check_fire_accumulated_by_class.isChecked():
                # Define os parâmetros da requisição para fire_accumulated_by_class
                params = {
                    "territoryIds": "10001",
                    "pixelValues":"-1",
                    "bboxSize": "256",
                    "fromYear": str(ACCT0),
                    "toYear": str(ACCT1),
                    "legend": "fire_accumulated_by_class"
                }

                fire_accumulated_by_class_Tiles = requests.get(url_acumulated, params=params)
                print(fire_accumulated_by_class_Tiles.text)

                if fire_accumulated_by_class_Tiles.status_code == 200:
                    layer_name = f"Área total queimada por uso e cobertura de "+str(ACCT0)+" a "+str(ACCT1)
                    xyz_url = fire_accumulated_by_class_Tiles.text.strip()
                    print("URL retornada:", xyz_url)
                   
                    # Cria a camada XYZ
                    fire_accumulated_by_class_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_accumulated_by_class_layer.isValid():
                        # Registra o provider da legenda se ainda não estiver registrado
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("fireaccumulatedbyclasslegend"):
                            provider = FireAccumulatedByClassLegendProvider()
                            registry.addProvider(provider)
                        
                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_accumulated_by_class_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_accumulated_by_class_layer.setCustomProperty('embeddedWidgets/0/id', "fireaccumulatedbyclasslegend")
                       
                        # Adiciona a camada ao projeto
                        QgsProject.instance().addMapLayer(fire_accumulated_by_class_layer)
                        print("Camada XYZ adicionada automaticamente!")
                    else:
                        print("Erro ao adicionar a camada XYZ.")
                else:
                    print(f"Erro na requisição: {fire_annual_by_total_burned_Tiles.status_code}")
        
            #Para caixa de seleção "Área total queimada em natural e antropico"
            if self.dlg.check_fire_accumulated_by_natural_anthropic.isChecked():
                # Define os parâmetros da requisição para fire_accumulated_by_natural_anthropic
                params = {
                    "territoryIds": "10001",
                    "pixelValues":"-1",
                    "bboxSize": "256",
                    "fromYear": str(ACCT0),
                    "toYear": str(ACCT1),
                    "legend": "fire_accumulated_by_natural_anthropic"
                }

                fire_accumulated_by_natural_anthropic_Tiles = requests.get(url_acumulated, params=params)
                print(fire_accumulated_by_natural_anthropic_Tiles.text)

                if fire_accumulated_by_natural_anthropic_Tiles.status_code == 200:
                    layer_name = f"Área total queimada em natural e antropico de "+str(ACCT0)+" a "+str(ACCT1)
                    xyz_url = fire_accumulated_by_natural_anthropic_Tiles.text.strip()
                    print("URL retornada:", xyz_url)
                   
                    # Cria a camada XYZ
                    fire_accumulated_by_natural_anthropic_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_accumulated_by_natural_anthropic_layer.isValid():
                        # Registra o provider da legenda se ainda não estiver registrado
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("fireaccumulatedbynaturalantropiclegend"):
                            provider = FireAccumulatedByNaturalAntropicLegendProvider()
                            registry.addProvider(provider)
                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_accumulated_by_natural_anthropic_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_accumulated_by_natural_anthropic_layer.setCustomProperty('embeddedWidgets/0/id', "fireaccumulatedbynaturalantropiclegend")

                        # Adiciona a camada ao projeto
                        QgsProject.instance().addMapLayer(fire_accumulated_by_natural_anthropic_layer)
                        print("Camada XYZ adicionada automaticamente!")
                    else:
                        print("Erro ao adicionar a camada XYZ.")
                else:
                    print(f"Erro na requisição: {fire_accumulated_by_natural_anthropic_Tiles.status_code}")

                #Fim do acesso aos dados de fogo acumulado (ABA ÁREA QUEIMADA ACUMULADA)

            # Acessa a API do MapBiomas para obter os dados Frequencia de queimadas (ABA FREQUÊNCIA DE QUEIMADAS)
            url_fire_frequency = ApiUrl+"/fire_frequency"
            FRQT0 = 1985 # self.dlg.FireFrequencyYearT0.value()
            FRQT1 = self.dlg.FireFrequencyYearT1.value()


            #Para caixa de seleção "Frequencia de queimadas"
            if self.dlg.check_fire_frequency.isChecked():
                # Define os parâmetros da requisição para fire_frequency
                params = {
                    "territoryIds": "10001",
                    "pixelValues":"-1",
                    "bboxSize": "256",
                    "fromYear": '1985',
                    "toYear": str(FRQT1)
                }

                fire_frequency_Tiles = requests.get(url_fire_frequency, params=params)
                print(fire_frequency_Tiles.text)

                if fire_frequency_Tiles.status_code == 200:
                    layer_name = f"Frequência de queimadas de 1985 a {FRQT1}"
                    xyz_url = fire_frequency_Tiles.text.strip()
                    print("URL retornada:", xyz_url)

                    fire_frequency_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_frequency_layer.isValid():
                        # Parâmetros da legenda
                        min_val = 1985
                        max_val = FRQT1
                        steps = max_val - min_val

                        # Registra o provider (apenas uma vez por sessão)
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("firefrequencylegend"):
                            provider = FireFrequencyLegendProvider()
                            registry.addProvider(provider)

                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_frequency_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_frequency_layer.setCustomProperty('embeddedWidgets/0/id', "firefrequencylegend")
                        fire_frequency_layer.setCustomProperty("firelegend/min_val", min_val)
                        fire_frequency_layer.setCustomProperty("firelegend/max_val", max_val)
                        fire_frequency_layer.setCustomProperty("firelegend/steps", steps)

                        # Adicione a camada ao projeto
                        QgsProject.instance().addMapLayer(fire_frequency_layer)
                        print("Camada XYZ adicionada automaticamente!")

                else:
                    print(f"Erro na requisição: {fire_frequency_Tiles.status_code}")

                #Fim do acesso aos dados de Frequencia de queimadas (ABA FOGO FREQUÊNCIA)

            # Acessa a API do MapBiomas para obter os dados fogo mensal (ABA OCORRÊNCIA DE FOGO MENSAL)
            url_fire_monthly = ApiUrl+"/fire_monthly"
            Myear = self.dlg.FireMonthlyYear.value() # Obtém o ano selecionado no QSpinBox

            #Para caixa de seleção "Frequencia de queimadas"
            if self.dlg.check_fire_Monthly.isChecked():
                # Define os parâmetros da requisição para fire_frequency
                params = {
                    "territoryIds": "10001",
                    "pixelValues":"-1",
                    "bboxSize": "256",
                    "year": str(Myear)
                }

                fire_monthly_Tiles = requests.get(url_fire_monthly, params=params)
                print(fire_monthly_Tiles.text)

                if fire_monthly_Tiles.status_code == 200:
                    layer_name = f"Distribuição mensal das queimadas em "+str(Myear)
                    xyz_url = fire_monthly_Tiles.text.strip()
                    print("URL retornada:", xyz_url)

                    # Cria a camada XYZ
                    fire_monthly_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_monthly_layer.isValid():
                        # Registra o provider (apenas uma vez por sessão)
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("firemonthlylegend"):
                            provider = FireMonthlyLegendProvider()
                            registry.addProvider(provider)

                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_monthly_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_monthly_layer.setCustomProperty('embeddedWidgets/0/id', "firemonthlylegend")
                        fire_monthly_layer.setCustomProperty("firelegend/year", Myear)
                    
                    # Adiciona a camada ao projeto
                    QgsProject.instance().addMapLayer(fire_monthly_layer)
                    print("Camada XYZ adicionada automaticamente!")
                else:
                    print(f"Erro na requisição: {fire_monthly_Tiles.status_code}")

            #Fim do acesso aos dados de Frequencia de queimadas (ABA OCORRÊNCIA FOGO MENSAL)

            # Acessa a API do MapBiomas para obter os dados de fogo anual (ABA OCORRÊNCIA DE FOGO ANUAL)
            url_annual = ApiUrl+"/fire_annual"  # Define a URL da API
            Tyear = self.dlg.FireAnualYear.value() # Obtém o ano selecionado no QSpinBox

            if self.dlg.check_fire_annual_by_class.isChecked():
                params = {
                    "territoryIds": "10001",
                    "pixelValues": "-1",
                    "bboxSize": "256",
                    "year": Tyear,
                    "legend": "fire_annual_by_class"
                }

                fire_annual_by_class_Tiles = requests.get(url_annual, params=params)
                print(fire_annual_by_class_Tiles.text)

                if fire_annual_by_class_Tiles.status_code == 200:
                    layer_name = f"Área total queimada por uso e cobertura em " + str(Tyear)
                    xyz_url = fire_annual_by_class_Tiles.text.strip()
                    print("URL retornada:", xyz_url)

                    fire_annual_by_class_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_annual_by_class_layer.isValid():
                        # Registra o provider da legenda se ainda não estiver registrado
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("fireanualtotalbyclasslegend"):
                            registry.addProvider(FireAnualTotalByClassLegendProvider())
                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_annual_by_class_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_annual_by_class_layer.setCustomProperty('embeddedWidgets/0/id', "fireanualtotalbyclasslegend")
                        QgsProject.instance().addMapLayer(fire_annual_by_class_layer)
                        print("Camada XYZ adicionada automaticamente!")
                    else:
                        print("Erro ao adicionar a camada XYZ.")
                else:
                    print(f"Erro na requisição: {fire_annual_by_class_Tiles.status_code}")

            if self.dlg.check_fire_annual_by_natural_anthropic.isChecked():
                # Define os parâmetros da requisição para fire_annual_by_natural_anthropic
                params = {
                    "territoryIds": "10001",         # string, não lista
                    "pixelValues": "-1",             # string, não lista
                    "bboxSize": "256",
                    "year": Tyear,
                    "legend": "fire_annual_by_natural_anthropic"
                }

                fire_annual_by_natural_anthropic_Tiles = requests.get(url_annual, params=params)  # Faz uma requisição GET para a URL com os parâmetros definidos
                print(fire_annual_by_natural_anthropic_Tiles.text)

                if fire_annual_by_natural_anthropic_Tiles.status_code == 200:
                    layer_name = f"Área total queimada em área natural ou antropica em " + str(Tyear)
                    xyz_url = fire_annual_by_natural_anthropic_Tiles.text.strip()
                    print("URL retornada:", xyz_url)

                    # Cria a camada XYZ
                    fire_annual_by_natural_anthropic_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_annual_by_natural_anthropic_layer.isValid():
                        # Registra o provider da legenda se ainda não estiver registrado
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("fireanualtotalbynaturalantropiclegend"):
                            registry.addProvider(FireAnualTotalByNaturalAntropicLegendProvider())
                        # Associa o widget à camada ANTES de adicionar ao projeto
                        fire_annual_by_natural_anthropic_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_annual_by_natural_anthropic_layer.setCustomProperty('embeddedWidgets/0/id', "fireanualtotalbynaturalantropiclegend")
                        QgsProject.instance().addMapLayer(fire_annual_by_natural_anthropic_layer)
                        print("Camada XYZ adicionada automaticamente!")
                    else:
                        print("Erro ao adicionar a camada XYZ.")
                else:
                    print(f"Erro na requisição: {fire_annual_by_natural_anthropic_Tiles.status_code}")

            if self.dlg.check_fire_annual_by_total_burned.isChecked():
                # Define os parâmetros da requisição para fire_annual_by_total_burned
                params = {
                    "territoryIds": "10001",         # string, não lista
                    "pixelValues": "-1",             # string, não lista
                    "bboxSize": "256",
                    "year": Tyear,
                    "legend": "fire_annual_by_total_burned"
                }

                fire_annual_by_total_burned_Tiles = requests.get(url_annual, params=params)  # Faz uma requisição GET para a URL com os parâmetros definidos
                print(fire_annual_by_total_burned_Tiles.text)

                if fire_annual_by_total_burned_Tiles.status_code == 200:
                    layer_name = f"Área total queimada em {Tyear}"
                    xyz_url = fire_annual_by_total_burned_Tiles.text.strip()
                    print("URL retornada:", xyz_url)

                    # Cria a camada XYZ
                    fire_annual_by_total_burned_layer = QgsRasterLayer(f"type=xyz&url={xyz_url}", layer_name, "wms")

                    if fire_annual_by_total_burned_layer.isValid():
                        # Registra o provider da legenda se ainda não estiver registrado
                        registry = QgsGui.layerTreeEmbeddedWidgetRegistry()
                        if not registry.provider("fireanualtotallegend"):
                            provider = FireAnualTotalLegendProvider()
                            registry.addProvider(provider)

                        fire_annual_by_total_burned_layer.setCustomProperty('embeddedWidgets/count', 1)
                        fire_annual_by_total_burned_layer.setCustomProperty('embeddedWidgets/0/id', "fireanualtotallegend")
                        fire_annual_by_total_burned_layer.setCustomProperty("firelegend/year", Tyear)
                        QgsProject.instance().addMapLayer(fire_annual_by_total_burned_layer)
                        print("Camada XYZ adicionada automaticamente!")
                    else:
                        print("Erro ao adicionar a camada XYZ.")
                else:
                    print(f"Erro na requisição: {fire_annual_by_total_burned_Tiles.status_code}")
                
                #Fim do acesso aos dados de fogo anual (ABA OCORRÊNCIA DE FOGO ANUAL)
