# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MapaGlebowoRolniczaDialog
                                 A QGIS plugin
 Wtyczka do wizualizacji mapy glebowo rolniczej
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-08-13
        git sha              : $Format:%H$
        copyright            : (C) 2024 by GUGiK
        email                : gugik@gugik.com
        coded by             : Andrzej Kwiecień AprilIt
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import datetime

from qgis.PyQt import uic, QtWidgets
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import QFileDialog, QApplication
from .validation_service import ValidationService
from .display_service import DisplayService
from .constants import DEFAULT_COLOR, RED_COLOR, SCHEMA_GML, MAIN_ICON, DOWNLOAD_ICON, VALIDATION_ERROR_INFO, OK_INFO, PROCESSING_INFO, LOAD_ERROR_INFO, DOTS_INFO

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'mapa_glebowo_rolnicza_dialog_base.ui'))

class MapaGlebowoRolniczaDialog(QtWidgets.QDialog, FORM_CLASS):
    """Dialog class for the plugin."""
    def __init__(self, parent=None):
        """Constructor."""

        super(MapaGlebowoRolniczaDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        self.setWindowIcon(QIcon(os.path.join(self.plugin_dir, MAIN_ICON)))

        self.validation_service = ValidationService()
        self.display_service = DisplayService()

        self.odkrywki_gml_path = None
        self.kontury_gml_path = None
        self.odkrywki_errors = None
        self.kontury_errors = None

        self.schema= os.path.join(self.plugin_dir, "schema", SCHEMA_GML)

        icon = QIcon(os.path.join(self.plugin_dir, DOWNLOAD_ICON))
        self.pushButtonKonturyErrors.setIcon(icon)
        self.pushButtonKonturyErrors.setToolTip("Pobierz plik z błędami")
        self.pushButtonOdkrywkiErrors.setIcon(icon)
        self.pushButtonOdkrywkiErrors.setToolTip("Pobierz plik z błędami")

        self.pushButtonKonturyLoad.setVisible(False)
        self.pushButtonOdkrywkiLoad.setVisible(False)

        self.labelGugikRightsReserved.setText(f"(C) {datetime.datetime.now().year}")

    def clear_controls(self):
        """Clear all controls: set default values"""

        self.__kontury_controls_default()
        self.__odkrywki_controls_default()

    def on_select_odkrywki_gml(self):
        """On select odkrywki gml file event handler"""

        self.__odkrywki_controls_default()
        QApplication.processEvents()

        options = QFileDialog.Options()
        fileName, _ = QFileDialog.getOpenFileName(self,"QFileDialog.getOpenFileName()", "","All Files (*.gml *.xml)", options=options)
        if fileName:
            self.odkrywki_gml_path = fileName # save file path
            base_name = os.path.basename(fileName)
            self.labelOdkrywkiOpenResult.setText(base_name) # show file name

            # clear validation result and progress bar
            self.labelOdkrywkiValidateResult.setText(PROCESSING_INFO)
            self.progressBarOdkrywkiValidation.setValue(0)
            QApplication.processEvents()

            # validate
            validation_result, errors = self.validation_service.validate_odkrywki_with_schema(self.odkrywki_gml_path, self.schema, self.progressBarOdkrywkiValidation)
            self.odkrywki_errors = errors

            # show validation result
            if validation_result:
                self.__validation_odkrywki_controls_success()
                self.on_load_odkrywki()
            else:
                self.__validation_odkrywki_controls_error()

    def on_load_odkrywki(self):
        """On odkrywki load start event handler"""

        # clear load result and progress bar
        self.labelOdkrywkiLoadResult.setText(PROCESSING_INFO)
        self.progressBarOdkrywkiLoad.setValue(0)

        # load
        load_result = self.display_service.display_odkrywki(self.odkrywki_gml_path, self.progressBarOdkrywkiLoad)

        # show load result
        if load_result:
            self.__load_odkrywki_controls_success()
        else:
            self.__load_odkrywki_controls_error()

    def on_odkrywki_errors_download(self):
        """On odkrywki errors download event handler"""

        options = QFileDialog.Options()
        file_path, _ = QFileDialog.getSaveFileName(self, "Zapisz błędy walidacji jako ...", "", "Text Files (*.txt);;All Files (*)", options=options)
        if file_path:
            self.validation_service.save_errors_to_file(self.odkrywki_errors, file_path)

    def on_select_kontury_gml(self):
        """On select kontury gml file event handler"""

        self.__kontury_controls_default()
        QApplication.processEvents()

        options = QFileDialog.Options()
        fileName, _ = QFileDialog.getOpenFileName(self,"QFileDialog.getOpenFileName()", "","All Files (*.gml *.xml)", options=options)
        if fileName:
            self.kontury_gml_path = fileName # save file path
            base_name = os.path.basename(fileName)
            self.labelKonturyOpenResult.setText(base_name) # show file name

            # clear validation result and progress bar
            self.labelKonturyValidateResult.setText(PROCESSING_INFO)
            self.progressBarKonturyValidation.setValue(0)
            QApplication.processEvents()

            # validate
            validation_result, errors = self.validation_service.validate_kontury_with_schema(self.kontury_gml_path, self.schema, self.progressBarKonturyValidation)
            self.kontury_errors = errors

            # show validation result
            if validation_result:
                self.__validation_kontury_controls_success()
                self.on_load_kontury()
            else:
                self.__validation_kontury_controls_error()

    def on_load_kontury(self):
        """On kontury load start event handler"""

        # clrear load result and progress bar
        self.labelKonturyLoadResult.setText(PROCESSING_INFO)
        self.progressBarKonturyLoad.setValue(0)

        # load
        load_result = self.display_service.display_kontury(self.kontury_gml_path, self.progressBarKonturyLoad)

        # show load result
        if load_result:
            self.__load_kontury_controls_success()
        else:
            self.__load_kontury_controls_error()

    def showEvent(self, event):
        """Called every time the dialog is shown."""
        super(MapaGlebowoRolniczaDialog, self).showEvent(event)
        self.clear_controls()

    def on_kontury_errors_download(self):
        """On kontury errors download event handler"""

        options = QFileDialog.Options()
        file_path, _ = QFileDialog.getSaveFileName(self, "Zapisz błędy walidacji jako ...", "", "Text Files (*.txt);;All Files (*)", options=options)
        if file_path:
            self.validation_service.save_errors_to_file(self.kontury_errors, file_path)

    def __kontury_controls_default(self):
        """Set default values for kontury controls."""

        self.kontury_gml_path = None
        self.kontury_errors = None

        self.labelKonturyOpenResult.setText("")
        self.labelKonturyValidateResult.setText(DOTS_INFO)
        self.labelKonturyLoadResult.setText(DOTS_INFO)
        self.labelKonturyValidateResult.setFixedWidth(131)

        self.pushButtonKonturyErrors.setVisible(False)

        self.labelKonturyOpenResult.setStyleSheet(f"color: {DEFAULT_COLOR};")
        self.labelKonturyValidateResult.setStyleSheet(f"color: {DEFAULT_COLOR};")
        self.labelKonturyLoadResult.setStyleSheet(f"color: {DEFAULT_COLOR};")

        self.progressBarKonturyValidation.setValue(0)
        self.progressBarKonturyLoad.setValue(0)

    def __validation_kontury_controls_error(self):
        """Set error values for kontury validation controls."""

        self.labelKonturyValidateResult.setStyleSheet(f"color: {RED_COLOR};")
        self.labelKonturyValidateResult.setFixedWidth(91)
        self.labelKonturyValidateResult.setText(VALIDATION_ERROR_INFO)
        if len(self.kontury_errors) > 0:
            self.pushButtonKonturyErrors.setVisible(True)

    def __validation_kontury_controls_success(self):
        """Set success values for kontury validation controls."""

        self.labelKonturyValidateResult.setStyleSheet(f"color: {DEFAULT_COLOR};")
        self.labelKonturyValidateResult.setText(OK_INFO)

    def __load_kontury_controls_error(self):
        """Set error values for kontury load controls."""

        self.labelKonturyLoadResult.setStyleSheet(f"color: {RED_COLOR};")
        self.labelKonturyLoadResult.setText(LOAD_ERROR_INFO)

    def __load_kontury_controls_success(self):
        """Set success values for kontury load controls."""

        self.labelKonturyLoadResult.setStyleSheet(f"color: {DEFAULT_COLOR};")
        self.labelKonturyLoadResult.setText(OK_INFO)

    def __odkrywki_controls_default(self):
        """Set default values for odkrywki controls."""

        self.odkrywki_gml_path = None
        self.odkrywki_errors = None

        self.labelOdkrywkiOpenResult.setText("")
        self.labelOdkrywkiValidateResult.setText(DOTS_INFO)
        self.labelOdkrywkiLoadResult.setText(DOTS_INFO)
        self.labelOdkrywkiValidateResult.setFixedWidth(131)

        self.pushButtonOdkrywkiErrors.setVisible(False)

        self.labelOdkrywkiOpenResult.setStyleSheet(f"color: {DEFAULT_COLOR};")
        self.labelOdkrywkiValidateResult.setStyleSheet(f"color: {DEFAULT_COLOR};")
        self.labelOdkrywkiLoadResult.setStyleSheet(f"color: {DEFAULT_COLOR};")

        self.progressBarOdkrywkiValidation.setValue(0)
        self.progressBarOdkrywkiLoad.setValue(0)

    def __validation_odkrywki_controls_error(self):
        """Set error values for odkrywki validation controls."""

        self.labelOdkrywkiValidateResult.setStyleSheet(f"color: {RED_COLOR};")
        self.labelOdkrywkiValidateResult.setFixedWidth(91)
        self.labelOdkrywkiValidateResult.setText(VALIDATION_ERROR_INFO)
        if len(self.odkrywki_errors) > 0:
            self.pushButtonOdkrywkiErrors.setVisible(True)

    def __validation_odkrywki_controls_success(self):
        """Set success values for odkrywki validation controls."""

        self.labelOdkrywkiValidateResult.setStyleSheet(f"color: {DEFAULT_COLOR};")
        self.labelOdkrywkiValidateResult.setText(OK_INFO)

    def __load_odkrywki_controls_error(self):
        """Set error values for odkrywki load controls."""

        self.labelOdkrywkiLoadResult.setStyleSheet(f"color: {RED_COLOR};")
        self.labelOdkrywkiLoadResult.setText(LOAD_ERROR_INFO)

    def __load_odkrywki_controls_success(self):
        """Set success values for odkrywki load controls."""

        self.labelOdkrywkiLoadResult.setStyleSheet(f"color: {DEFAULT_COLOR};")
        self.labelOdkrywkiLoadResult.setText(OK_INFO)
