# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MapCornersCoordinates
                                 A QGIS plugin
 QGIS plugin for saving map canvas coordinates into a text file.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-04-06
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Kala, Kulovana, Landa
        email                : martin.landa@fsv.cvut.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, Qt, QFileInfo
from PyQt5.QtGui import QIcon
from PyQt5.QtWidgets import  QComboBox, QToolButton, QAction, QFileDialog
# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .map_corners_coordinates_dockwidget import MapCornersCoordinatesDockWidget
import os.path

from qgis.core import QgsCoordinateTransform, QgsCoordinateReferenceSystem, QgsProject, Qgis, QgsSettings


class MapCornersCoordinates:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'MapCornersCoordinates_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Map Corners Coordinates')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'MapCornersCoordinates')
        self.toolbar.setObjectName(u'MapCornersCoordinates')

        #print "** INITIALIZING MapCornersCoordinates"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('MapCornersCoordinates', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)
            # self.toolButton = QToolButton()
            # self.iface.addToolBarWidget(self.toolButton)
            # self.toolButton.setDefaultAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/map_corners_coordinates/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Map Corners Coordinates'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING MapCornersCoordinates"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD MapCornersCoordinates"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Map Corners Coordinates'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING MapCornersCoordinates"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = MapCornersCoordinatesDockWidget()

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)
            self.dockwidget.captureButton.clicked.connect(self.readCoor)
            self.dockwidget.saveButton.clicked.connect(self.saveCoor)
            self.dockwidget.dir_toolbutton.clicked.connect(self.dirButton)

            # Update system_Box on map crs changed
            self.iface.mapCanvas().destinationCrsChanged.connect(self.updateCrs)

            # Clear editable widgets
            self.dockwidget.coor_NEX.clear()
            self.dockwidget.coor_NEY.clear()
            self.dockwidget.coor_NWX.clear()
            self.dockwidget.coor_NWY.clear()
            self.dockwidget.coor_SEX.clear()
            self.dockwidget.coor_SEY.clear()
            self.dockwidget.coor_SWX.clear()
            self.dockwidget.coor_SWY.clear()

            self.dockwidget.dir_name.clear()
            self.dockwidget.system_box.clear()
            self.updateCrs()

            # Disable saveButton for future plugin reopening
            self.dockwidget.saveButton.setEnabled(False)

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()

    def dirButton(self):
        
        """Get the destination file, where captured coordinates are saved."""
        s = QgsSettings()
        # get the home directory
        home = os.path.expanduser("~")
        # get saved path to file or home directory if it does not exists
        path = s.value("qgis-map-coords-plugin/path", home + "/coords.txt")
        self.namedir = QFileDialog.getSaveFileName(self.dockwidget, self.tr("Select destination file"), path, '*.txt')
        self.dockwidget.dir_name.setText(self.namedir[0])
        # save the path to the settings
        s.setValue("qgis-map-coords-plugin/path", self.namedir[0])

        # Enable the saveButton if file is chosen
        if not self.dockwidget.dir_name.text():
            self.dockwidget.saveButton.setEnabled(False)
        else:
            self.dockwidget.saveButton.setEnabled(True)

    def transformCrs(self):

        """ Transform the actual crs to EPSG:4326 if the actual crs is not EPSG:4326 itself """

        # Get map canvas extent (W, E, N, S)
        self.e = self.iface.mapCanvas().extent()

        if self.dockwidget.system_box.currentText() == "EPSG:4326" and self.crs.authid() != "EPSG:4326":
            crsSrc = QgsCoordinateReferenceSystem(str(self.crs.authid()))
            if not crsSrc.isValid():
                self.iface.messageBar().pushMessage(self.tr("Error"),
                                                    self.tr("{} is not valid SRS.").format(self.crs.authid()),
                                                    level=Qgis.Critical, duration=3)
                return

            crsDest = QgsCoordinateReferenceSystem("EPSG:4326")
            tr = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
            self.e = tr.transform(self.e)

    def readCoor(self):
        
        """Get map canvas coordinates, write them to corresponding widgets."""
        
        self.transformCrs()

        self.dockwidget.coor_NEX.setText(str(self.e.xMaximum()))
        self.dockwidget.coor_NEY.setText(str(self.e.yMaximum()))
        self.dockwidget.coor_NWX.setText(str(self.e.xMinimum()))
        self.dockwidget.coor_NWY.setText(str(self.e.yMaximum()))
        self.dockwidget.coor_SEX.setText(str(self.e.xMaximum()))
        self.dockwidget.coor_SEY.setText(str(self.e.yMinimum()))
        self.dockwidget.coor_SWX.setText(str(self.e.xMinimum()))
        self.dockwidget.coor_SWY.setText(str(self.e.yMinimum()))

        for widget in (self.dockwidget.coor_NEX,
                       self.dockwidget.coor_NEY,
                       self.dockwidget.coor_NWX,
                       self.dockwidget.coor_NWY,
                       self.dockwidget.coor_SEX,
                       self.dockwidget.coor_SEY,
                       self.dockwidget.coor_SWX,
                       self.dockwidget.coor_SWY):
            widget.setCursorPosition(0)

    def saveCoor(self):
        
        """Save coordinates to file."""
        
        fileName = self.dockwidget.dir_name.text()
        if not fileName:
            self.iface.messageBar().pushMessage(self.tr("Error"),
                                                self.tr("No file given."),
                                                level=Qgis.Critical, duration = 3)
            return

        if not self.dockwidget.coor_NWX.text():
            self.iface.messageBar().pushMessage(self.tr("Error"),
                                                self.tr("No coordinates captured."),
                                                level=Qgis.Critical, duration = 3)
            return
        
        try:
            with open(fileName, 'w') as f:
                # use '\n', see https://docs.python.org/3/library/os.html#os.linesep
                f.write("{title}{ls}Project: {project}{ls}SRS: {crs}{ls}{ls}".format(
                    title='Map Corners Coordinates',
                    project=QFileInfo(QgsProject.instance().fileName()).fileName().split('.')[0],
                    crs=self.dockwidget.system_box.currentText(),
                    ls='\r\n'))
                f.write("NW (upper left){ls}X: {nw_x}{ls}Y: {nw_y}{ls}{ls}".format(
                    nw_x=self.dockwidget.coor_NWX.text(),
                    nw_y=self.dockwidget.coor_NWY.text(),
                    ls='\r\n'))
                f.write("NE (upper right){ls}X: {ne_x}{ls}Y: {ne_y}{ls}{ls}".format(
                    ne_x=self.dockwidget.coor_NEX.text(),
                    ne_y=self.dockwidget.coor_NEY.text(),
                    ls='\r\n'))
                f.write("SE (bottom right){ls}X: {se_x}{ls}Y: {se_y}{ls}{ls}".format(
                    se_x=self.dockwidget.coor_SEX.text(),
                    se_y=self.dockwidget.coor_SEY.text(),
                    ls='\r\n'))
                f.write("SW (bottom left){ls}X: {sw_x}{ls}Y: {sw_y}{ls}".format(
                    sw_x=self.dockwidget.coor_SWX.text(),
                    sw_y=self.dockwidget.coor_SWY.text(),
                    ls='\r\n'))
        except IOError as e:
            self.iface.messageBar().pushMessage("Error",
                                                "Unable open {} for writing. Reason: {}".format(fileName, e),
                                                level=Qgis.Critical, duration = 3)
            return

        self.iface.messageBar().pushMessage("Info",
                                            "File {} saved.".format(fileName),
                                            level=Qgis.Info, duration = 3)

    def updateCrs(self):

        """ Populate combo box with the actual crs and/or with EPSG:4326. """

        self.crs = self.getMapCanvasCrs()
        self.dockwidget.system_box.clear()
        if self.crs.authid() == "EPSG:4326":
            self.dockwidget.system_box.addItems([str(self.crs.authid())])
        else:
            self.dockwidget.system_box.addItems(["EPSG:4326", str(self.crs.authid())])


    def getMapCanvasCrs(self):

        """ Declare the actual crs, latest versions of qgis does not support 'mapRenderer()' """

        try:
            crs = self.iface.mapCanvas().mapSettings().destinationCrs()
        except:
            crs = self.iface.mapCanvas().mapRenderer().destinationCrs()

        return crs
