# -*- coding: utf-8 -*-
"""
/***************************************************************************
 EvaluateDialog
                                 A QGIS plugin
 Dialog for final evaluation and help windows.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-07-25
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Carvalho Neto, R.M./ Sustembio Environmental Services
        email                : romariocarvalho@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from PyQt5.QtWidgets import *
from PyQt5.QtCore import QCoreApplication
from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtWidgets import QMessageBox, QTableWidgetItem


# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'evaluate_dialog.ui'))


class EvaluateDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(EvaluateDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        EvaluateDialog.lista_manejos = [] #to have all the manejo layers
        EvaluateDialog.lista_Rede = [] #to have all the Rede buffers layers
        EvaluateDialog.lista_merge_APP = [] #to merge the APP poligons for the last evaluation
        EvaluateDialog.lista_temporary_layers = [] # to have all temporary layers to save
        EvaluateDialog.lista_exclude = [] # to exclude in the other comboboxes
        self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(False)


    def enableOkButton(self):
        """Allow the Ok button to be used"""    
        if EvaluateDialog.lista_manejos != [] and EvaluateDialog.lista_merge_APP != [] and EvaluateDialog.lista_Rede != []:
            self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(True)
        else:
            self.buttonBox.button(QDialogButtonBox.Ok).setEnabled(False)


    def select_input_APP_layer(self):
        """Selects the input APP for the evaluation and displays it on table"""
        row_number = 0
        column_number = 0
        nome_layer = self.mMapLayerComboBox.currentText()
        if nome_layer == '':
            pass
        else:
            layer_selecionado = self.mMapLayerComboBox.currentLayer() # gets the selected layer
            EvaluateDialog.lista_merge_APP.insert(0,layer_selecionado)
            EvaluateDialog.lista_exclude.insert(0,layer_selecionado)
            self.mMapLayerComboBox.setExceptedLayerList(EvaluateDialog.lista_exclude)
            self.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
            #layer_path_completo = layer_selecionado.source()

            self.tableWidget.insertRow(row_number)
            self.tableWidget.setItem(row_number, column_number, QTableWidgetItem(str(nome_layer)))
            self.enableOkButton()

    def select_input_Manejo_layer(self):
        """Selects the input forest managing area for the evaluation and displays it on table"""
        row_number = 0
        column_number = 1
        nome_layer = self.mMapLayerComboBox_4.currentText()
        layer_selecionado = self.mMapLayerComboBox_4.currentLayer() # gets the selected layer
        #layer_path_completo = layer_selecionado.source()

        self.tableWidget_2.insertRow(row_number)
        trad = QCoreApplication.translate("Table","Forest Managing Layer") #"Layer de Manejo")
        self.tableWidget_2.setItem(row_number, 0, QTableWidgetItem(trad))
        self.tableWidget_2.setItem(row_number, column_number, QTableWidgetItem(str(nome_layer)))
        EvaluateDialog.lista_manejos.insert(0, layer_selecionado)
        EvaluateDialog.lista_exclude.insert(0,layer_selecionado)
        self.mMapLayerComboBox.setExceptedLayerList(EvaluateDialog.lista_exclude)
        self.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
        self.addManejoButton.setEnabled(False)
        self.enableOkButton()

    def select_input_Rede_layer(self):
        """Selects the input network for the evaluation and displays it on table"""
        row_number = 0
        column_number = 1
        nome_layer = self.mMapLayerComboBox_2.currentText()
        layer_selecionado = self.mMapLayerComboBox_2.currentLayer() # gets the selected layer
        #layer_path_completo = layer_selecionado.source()

        self.tableWidget_2.insertRow(row_number)
        trad = QCoreApplication.translate("Table","Network Buffer Layer") #"Layer buffer da Rede")
        self.tableWidget_2.setItem(row_number, 0, QTableWidgetItem(trad))
        self.tableWidget_2.setItem(row_number, column_number, QTableWidgetItem(str(nome_layer)))
        EvaluateDialog.lista_Rede.insert(0, layer_selecionado)
        EvaluateDialog.lista_exclude.insert(0,layer_selecionado)
        self.mMapLayerComboBox_4.setExceptedLayerList(EvaluateDialog.lista_exclude)
        self.mMapLayerComboBox.setExceptedLayerList(EvaluateDialog.lista_exclude)
        self.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
        self.addRedeButton.setEnabled(False)
        self.enableOkButton()


    def select_input_temporary_layer(self):
        """Selects the input temporary layers for the evaluation and displays it on table"""
        row_number = 0
        column_number = 0
        nome_layer = self.mMapLayerComboBox_3.currentText()
        if nome_layer == '':
            pass
        else:
            layer_selecionado = self.mMapLayerComboBox_3.currentLayer() # gets the selected layer
            #layer_path_completo = layer_selecionado.source()

            self.tableWidget_3.insertRow(row_number)
            self.tableWidget_3.setItem(row_number, column_number, QTableWidgetItem(str(nome_layer)))
            EvaluateDialog.lista_temporary_layers.insert(0, layer_selecionado)
            EvaluateDialog.lista_exclude.insert(0,layer_selecionado)
            self.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
            #self.enableOkButton()

    def remove_input_Rede_layer(self):
        """Removes the selected network line from table"""
        selecionado = self.tableWidget_2.currentRow()
        if selecionado == -1: #only to not have an error message if no layer was selected
            pass
        else:
            trad = QCoreApplication.translate("Table","Network Buffer Layer") #"Layer buffer da Rede")
            if self.tableWidget_2.item(selecionado,0).text() == trad:
                self.tableWidget_2.removeRow(selecionado)
                remove_from_table = EvaluateDialog.lista_Rede.pop()
                EvaluateDialog.lista_exclude.remove(remove_from_table)
                self.mMapLayerComboBox_4.setExceptedLayerList(EvaluateDialog.lista_exclude)
                self.mMapLayerComboBox.setExceptedLayerList(EvaluateDialog.lista_exclude)
                self.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
                self.addRedeButton.setEnabled(True)
                self.enableOkButton()
            else:
                message = QCoreApplication.translate('Message to user','Select the layer corresponding to the network buffer to remove it using this button')
                QMessageBox.warning(self, QCoreApplication.translate('Message to user','Missing information or invalid'), message)

    def remove_input_Manejo_layer(self):
        """Removes the selected forest managing line from table"""
        selecionado = self.tableWidget_2.currentRow()
        if selecionado == -1: #only to not have an error message if no layer was selected
            pass
        else:
            trad = QCoreApplication.translate("Table","Forest Managing Layer") #"Layer de Manejo")
            if self.tableWidget_2.item(selecionado,0).text() == trad:
                self.tableWidget_2.removeRow(selecionado)
                remove_from_table = EvaluateDialog.lista_manejos.pop()
                EvaluateDialog.lista_exclude.remove(remove_from_table)
                self.mMapLayerComboBox_4.setExceptedLayerList(EvaluateDialog.lista_exclude)
                self.mMapLayerComboBox.setExceptedLayerList(EvaluateDialog.lista_exclude)
                self.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
                self.addManejoButton.setEnabled(True)
                self.enableOkButton()
            else:
                message = QCoreApplication.translate('Message to user','Select the layer corresponding to the forest managing area to remove it using this button')
                QMessageBox.warning(self, QCoreApplication.translate('Message to user','Missing information or invalid'), message)

    def remove_input_temporary_layer(self):
        """Removes the selected temporary layer line from table"""
        selecionado = self.tableWidget_3.currentRow()
        if selecionado == -1: #only to not have an error message if no layer was selected
            pass
        else:
            self.tableWidget_3.removeRow(selecionado)
            remove_from_table = EvaluateDialog.lista_temporary_layers.pop(selecionado)
            EvaluateDialog.lista_exclude.remove(remove_from_table)
            self.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
            #self.enableOkButton()


    def remove_input_APP_layer(self):
        """Removes the selected APP line from table"""
        selecionado = self.tableWidget.currentRow()
        if selecionado == -1: #only to not have an error message if no layer was selected
            pass
        else:
            self.tableWidget.removeRow(selecionado)
            remove_from_table = EvaluateDialog.lista_merge_APP.pop(selecionado)
            EvaluateDialog.lista_exclude.remove(remove_from_table)
            self.mMapLayerComboBox.setExceptedLayerList(EvaluateDialog.lista_exclude)
            self.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
            self.mMapLayerComboBox_4.setExceptedLayerList(EvaluateDialog.lista_exclude)
            self.enableOkButton()

    
    def evaluateDialog(self):
        """Shows the evaluate dialog"""
        self.stackedWidget.setCurrentIndex(0)
        self.show()

    def helpCreateDialog(self):
        """Shows the create help dialog"""
        self.stackedWidget.setCurrentIndex(1)
        self.show()

    def helpOutputDialog(self):
        """Shows the output help dialog"""
        self.stackedWidget.setCurrentIndex(2)
        self.show()

    def helpInputDialog(self):
        """Shows the input help dialog"""
        self.stackedWidget.setCurrentIndex(3)
        self.show()