# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Manejo
                                 A QGIS plugin
 Manejo main
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-07-25
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Carvalho Neto, R.M./ Sustembio Environmental Services
        email                : romariocarvalho@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsMapLayerProxyModel, QgsProject, QgsWkbTypes, QgsProviderRegistry
# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .manejo_dockwidget import ManejoDockWidget
from .evaluate_dialog import EvaluateDialog
import os.path


class Manejo:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'manejo_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Power Lines Network Forest Areas') #(u'&Áreas de Manejo')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'Manejo')
        self.toolbar.setObjectName(u'Manejo')

        #print "** INITIALIZING Manejo"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Manejo', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/manejo/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Manejo'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING Manejo"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD Manejo"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Power Lines Network Forest Areas'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING Manejo"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = ManejoDockWidget()
                self.dlg = EvaluateDialog()

            # filters
            self.dlg.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.PolygonLayer)
            self.dlg.mMapLayerComboBox_2.setFilters(QgsMapLayerProxyModel.PolygonLayer)
            self.dlg.mMapLayerComboBox_4.setFilters(QgsMapLayerProxyModel.PolygonLayer)
            providers = QgsProviderRegistry.instance().providerList()
            providers.remove('memory') # removes from the list the memory layers, so all the remainig names will continue in the list
            self.dlg.mMapLayerComboBox_3.setExcludedProviders(providers)
            #self.dlg.mMapLayerComboBox_3.setExceptedLayerList(EvaluateDialog.lista_exclude)
            self.dockwidget.mMapLayerComboBox_point.setFilters(QgsMapLayerProxyModel.PointLayer)
            self.dockwidget.mMapLayerComboBox.setFilters(QgsMapLayerProxyModel.LineLayer | QgsMapLayerProxyModel.PointLayer)

            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.RightDockWidgetArea, self.dockwidget)
            self.dockwidget.show()
            
            self.dockwidget.createLayersButton.clicked.connect(self.dockwidget.createLayers)
            self.dockwidget.createBufferButton.clicked.connect(self.dockwidget.createBufferLayers)
            self.dockwidget.createLineButton.clicked.connect(self.dockwidget.point2line)
            self.dockwidget.helpCreateLayersButton.clicked.connect(self.dlg.helpCreateDialog)
            self.dockwidget.helpEvaluateButton.clicked.connect(self.dlg.helpOutputDialog)
            self.dockwidget.helpInputButton.clicked.connect(self.dlg.helpInputDialog)
            self.dockwidget.evaluateButton.clicked.connect(self.dlg.evaluateDialog)
            signal_enable_evaluate = self.dockwidget.mQgsFileWidget.fileChanged.connect(self.dockwidget.enableEvaluateButton)
            
            self.dlg.addRedeButton.clicked.connect(self.dlg.select_input_Rede_layer)
            self.dlg.removeRedeButton.clicked.connect(self.dlg.remove_input_Rede_layer)
            self.dlg.addAPPButton.clicked.connect(self.dlg.select_input_APP_layer)
            self.dlg.removeAPPButton.clicked.connect(self.dlg.remove_input_APP_layer)
            self.dlg.addManejoButton.clicked.connect(self.dlg.select_input_Manejo_layer)
            self.dlg.removeManejoButton.clicked.connect(self.dlg.remove_input_Manejo_layer)
            self.dlg.addTemporaryButton.clicked.connect(self.dlg.select_input_temporary_layer)
            self.dlg.removeTemporaryButton.clicked.connect(self.dlg.remove_input_temporary_layer)
            self.dlg.buttonBox.accepted.connect(self.dockwidget.writeLayers)
            self.dlg.buttonBox.rejected.connect(self.dlg.close)