# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ManejoDockWidget
                                 A QGIS plugin
 DockWidget for the Manejo plugin
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2020-07-25
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Carvalho Neto, R.M./ Sustembio Environmental Services
        email                : romariocarvalho@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os, csv

from PyQt5.QtCore import QCoreApplication
from qgis.gui import QgsFileWidget, QgsProjectionSelectionWidget
from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal, QVariant
from PyQt5.QtWidgets import QDialog
from PyQt5.QtWidgets import *
from .evaluate_dialog import EvaluateDialog
from qgis.core import (QgsMapLayerProxyModel, QgsVectorDataProvider, QgsGeometry,
                       QgsFeature, QgsPoint, QgsFillSymbol, QgsPointXY,
                       QgsVectorLayer, QgsField, QgsProject, QgsVectorFileWriter,
                       QgsCoordinateReferenceSystem)  #,

from qgis import processing

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'manejo_dockwidget_base.ui'))


class ManejoDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(ManejoDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.mQgsFileWidget.setStorageMode(QgsFileWidget.GetDirectory)
        crs_start = QgsProject.instance().crs()  # will start with the CRS fro the project
        self.mQgsProjectionSelectionWidget.setCrs(crs_start) 
        trad = QCoreApplication.translate("New Layers","springs")
        self.name_new_point_layer = trad #'nascentes'
        trad = QCoreApplication.translate("New Layers","river")
        self.name_new_line_layer = trad #'rio'
        trad = QCoreApplication.translate("New Layers","managing")
        self.name_new_shapes_polygons = [trad] #['manejo']
        self.evaluateButton.setEnabled(False)   #button(QDialogButtonBox.Ok)

    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()

    def createLayers(self):
        """Creates the necessary layers for the evaluation"""
        self.load_layers = []
        EPSG_code = self.mQgsProjectionSelectionWidget.crs().authid()
        new_Layer_point = QgsVectorLayer('Point?crs={}'.format(EPSG_code),
                                         self.name_new_point_layer,
                                         'memory') #point
        self.load_layers.insert(0, new_Layer_point)
        new_Layer_line = QgsVectorLayer('LineString?crs={}'.format(EPSG_code),
                                        self.name_new_line_layer,
                                        'memory')   #line
        self.load_layers.insert(0, new_Layer_line)

        for tratos in self.name_new_shapes_polygons:
            new_Layer = QgsVectorLayer('Polygon?crs={}'.format(EPSG_code),
                                       tratos,
                                       'memory')
            self.load_layers.insert(0, new_Layer)
            caps = new_Layer.dataProvider().capabilities()
            if caps & QgsVectorDataProvider.AddAttributes:
                res = new_Layer.dataProvider().addAttributes([QgsField("Area", QVariant.Double)])
            new_Layer.updateFields()
        
        load = [QgsProject.instance().addMapLayer(layer) for layer in self.load_layers]


    def writeLayers(self):
        """Save layers and makes the evaluation"""
        layer_manejo = EvaluateDialog.lista_manejos[0]  #now just working with one polygon layer
        layer_rede = EvaluateDialog.lista_Rede[0]
        lista_merge = EvaluateDialog.lista_merge_APP
        lista_temp = EvaluateDialog.lista_temporary_layers
        trad_col_0 = QCoreApplication.translate("Report Header","Managing") #'Manejo'
        trad_col_1 = QCoreApplication.translate("Report Header","Area in hectare") #'Area em hectare'
        lista_report = [[trad_col_0, trad_col_1]] #[['Manejo', 'Area em hectare']]
        
        output_path = self.mQgsFileWidget.filePath()
        
        # saving layer_manejo
        save_options = QgsVectorFileWriter.SaveVectorOptions()
        save_options.driverName = "ESRI Shapefile"
        save_options.fileEncoding = "UTF-8"
        transform_context = QgsProject.instance().transformContext()
        layer_manejo_path = output_path+'\\'+layer_manejo.name()+".shp"
        new_Layer = QgsVectorFileWriter.writeAsVectorFormatV2(layer_manejo,
                                                          output_path+'\\'+layer_manejo.name(),
                                                          transform_context,
                                                          save_options)
        # saving layer_rede
        layer_rede_path = output_path+'\\'+layer_rede.name()+".shp"
        new_Layer = QgsVectorFileWriter.writeAsVectorFormatV2(layer_rede,
                                                          output_path+'\\'+layer_rede.name(),
                                                          transform_context,
                                                          save_options)
        # saving temp files
        for layer in lista_temp:
            new_Layer = QgsVectorFileWriter.writeAsVectorFormatV2(layer,
                                                              output_path+'\\'+layer.name(),
                                                              transform_context,
                                                              save_options)
            saved_layer = QgsVectorLayer(output_path+'\\'+layer.name()+".shp", layer.name(), 'ogr')
            QgsProject.instance().addMapLayer(saved_layer)
        
        # saving APP files
        for layer in lista_merge:
            new_Layer = QgsVectorFileWriter.writeAsVectorFormatV2(layer,
                                                              output_path+'\\'+layer.name(),
                                                              transform_context,
                                                              save_options)
            saved_layer = QgsVectorLayer(output_path+'\\'+layer.name()+".shp", layer.name(), 'ogr')
            QgsProject.instance().addMapLayer(saved_layer)

        # ----- takes only the area inside the Rede ---
        manejo_clip_output_path = output_path+'\\'+layer_manejo.name()+'_clip.shp'
        dentroAPP = processing.run('native:intersection', {'INPUT': layer_manejo,
                                                           'OVERLAY': layer_rede,
                                                           'OVERLAY_FIELDS': 'Area',
                                                           'OUTPUT': manejo_clip_output_path})

        # ----- makes a merge and a dissolve to have the APP area -----
        output_merge = output_path+'\\mergeAPP.shp'
        output_dissolve = output_path+'\\dissolveAPP.shp'
        merge_APP = processing.run("native:mergevectorlayers", {'LAYERS': lista_merge,
                                                                'OUTPUT': output_merge })
        dissolve_APP = processing.run("native:dissolve", {'INPUT': output_merge,
                                                          'OUTPUT': output_dissolve }) 

        # ----- areas dentro da REDE ------------
        lista_output_paths = [] #list to have all the outputs so we recalculate the area
        trad = QCoreApplication.translate('Evaluating','InsideNetwork') #DentroREDE
        output = output_path+'\\'+layer_manejo.name()+trad+'.shp'
        foraAPP = processing.run("native:difference", {'INPUT': manejo_clip_output_path,
                                                       'OVERLAY': output_dissolve,
                                                       'OUTPUT': output})
        lista_output_paths.append(output)
        
        # ----- areas dentro da APP ------------
        trad = QCoreApplication.translate('Evaluating','InsideAPP') #DentroAPP
        output = output_path+'\\'+layer_manejo.name()+trad+'.shp'
        dentroAPP = processing.run("native:intersection", {'INPUT': output_dissolve,
                                                           'OVERLAY': manejo_clip_output_path,
                                                           'INPUT_FIELDS': 'Area',
                                                           'OUTPUT': output})
        lista_output_paths.append(output)

        # Add layer_manejo_path so its area will be calculated and the report will have a total area
        lista_output_paths.append(manejo_clip_output_path)

        #recalcular do layer resultante
        cont_csv_row = 1  #because 0 is the header
        for full_path in lista_output_paths:
            lista_sum_area = []
            name_start_slice_index = full_path[::-1].index('\\')
            name_slice = full_path[-name_start_slice_index:]
            lista_report.append([name_slice[:-4]])
            new_Layer = QgsVectorLayer(full_path, name_slice, "ogr")
            caps = new_Layer.dataProvider().capabilities()
            features = new_Layer.getFeatures()
            listaFieldName = [] #lista para armazenar os fields (cabecalho)
            cabecalho = new_Layer.fields()
            for field in cabecalho:
                listaFieldName.append(field.name())
            contFid = 0
            for feature in features:
                geom = feature.geometry()
                fid = contFid   # ID of the feature we will modify
                if caps & QgsVectorDataProvider.ChangeAttributeValues:
                    calculo = geom.area()/10000
                    lista_sum_area.append(calculo)
                    attrs = { listaFieldName.index("Area") : calculo }   #changes values of attributes with index 0 (primeiro) and 1 (segundo), ou seja, modifica os dois
                    new_Layer.dataProvider().changeAttributeValues({ fid : attrs })
                    new_Layer.updateFields()
                    contFid += 1
            lista_report[cont_csv_row].append(sum(lista_sum_area))
            cont_csv_row += 1
            QgsProject.instance().addMapLayer(new_Layer)

        trad_report = QCoreApplication.translate('Evaluating','Report') #Relatorio
        csv_table = output_path+"\\"+trad_report+".csv"

        with open(csv_table, 'a') as file:
            writer = csv.writer(file, delimiter=',')
            for row in lista_report:
                writer.writerow(row)
            file.close()

        uri = "file:///{}?delimiter=','".format(csv_table)
        table = QgsVectorLayer(uri, trad_report, "delimitedtext")
        QgsProject.instance().addMapLayer(table)


    def createBufferLayers(self):
        """Creates buffers for the selected layer, according to size"""
        buffer_input = self.lineEdit.text()
        if buffer_input == '':
            pass
        else:
            layer_selecionado = self.mMapLayerComboBox.currentLayer() # gets the selected layer
            
            caps = layer_selecionado.dataProvider().capabilities()

            buffer_distance = float(buffer_input)
            in_geom = []
            lista_buffers = []
            features = layer_selecionado.getFeatures()
            contFid = 0
            for feature in features:
                geom = feature.geometry()
                in_geom.append(geom)
                fid = contFid   # ID of the feature we will modify
                if caps & QgsVectorDataProvider.ChangeAttributeValues:
                    bf_geom = geom.buffer(buffer_distance, -1)
                    lista_buffers.append(bf_geom)
                    contFid += 1

            crs = layer_selecionado.crs().toWkt()

            out_Layer_buffer = QgsVectorLayer('Polygon?crs='+ crs,
                                              layer_selecionado.name()+' buffer',
                                              'memory')
            prov = out_Layer_buffer.dataProvider()
            outGeom = QgsFeature()
            for i in lista_buffers:
                outGeom.setGeometry(i)
                prov.addFeatures([outGeom])

            trad_network = QCoreApplication.translate('Buffers','network line') #'linha Rede'
            if layer_selecionado.name() == trad_network:
                symbol = QgsFillSymbol.createSimple({'style': 'no',
                                                     'outline_color': 'red',
                                                     'outline_width': '0.8'})
                out_Layer_buffer.renderer().setSymbol(symbol)
                QgsProject.instance().addMapLayer(out_Layer_buffer)
            else:
                symbol = QgsFillSymbol.createSimple({'style': 'no',
                                                     'outline_color': '166,206,227,255',
                                                     'outline_width': '0.8'})
                out_Layer_buffer.renderer().setSymbol(symbol)
                QgsProject.instance().addMapLayer(out_Layer_buffer)


    def point2line(self): 
        """Makes a line between points"""
        layer_selecionado = self.mMapLayerComboBox_point.currentLayer() # gets the selected layer
        caps = layer_selecionado.dataProvider().capabilities()
        in_geom = []
        in_XY = []
        features = layer_selecionado.getFeatures()
        contFid = 0
        for feature in features:
            geom = feature.geometry()
            in_geom.append(geom)
            fid = contFid   # ID of the feature we will modify
            if caps & QgsVectorDataProvider.ChangeAttributeValues:

                pt_y = geom.asPoint().y()
                py_x = geom.asPoint().x()
                in_XY.append([py_x,pt_y])

                contFid += 1

        crs = layer_selecionado.crs().toWkt()
        trad_network = QCoreApplication.translate('Buffers','network line') #'linha Rede'
        out_Layer_line = QgsVectorLayer('Linestring?crs='+ crs,
                                        trad_network,
                                        'memory')
        prov = out_Layer_line.dataProvider()
        outGeom = QgsFeature()
        QgsPoint_list = []
        
        trad_message1 = QCoreApplication.translate('Message','Choose sequence of points')
        trad_message2 = QCoreApplication.translate('Message',
            "Do you want a sequence North -> South direction? Press 'YES'.\nPress 'NO' to choose West -> East sequence.")
        reply = QMessageBox.question(self, trad_message1, trad_message2, QMessageBox.Yes,QMessageBox.No,)
                
        if reply == QMessageBox.Yes:
            sorted_in_XY = sorted(in_XY, key=lambda y: y[1])  #sorted by y value, N/S
        else:
            sorted_in_XY = sorted(in_XY) #sorted by x value, W/E
        
        for _tuple in sorted_in_XY:
            QgsPoint_list.append(QgsPoint(_tuple[0],_tuple[1]))
        outGeom.setGeometry(QgsGeometry.fromPolyline(QgsPoint_list))
        prov.addFeatures([outGeom])

        QgsProject.instance().addMapLayer(out_Layer_line)


    def enableEvaluateButton(self):
        """Makes the evaluate button to be useable for the user"""
        self.evaluateButton.setEnabled(True)