# -*- coding: utf-8 -*-
"""
/***************************************************************************
 MakeSectorDialog
                                 A QGIS plugin
 This plugin to create sector, circle radius, and spidergraph from gcell file
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-07-18
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Imam Sibro Muhlisi
        email                : sibro.telco@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from pathlib import Path
import urllib.parse
from shapely.geometry import Point, Polygon
import pandas as pd
import geopandas as gpd
import math
from math import sin, cos, sqrt, atan2, radians
from datetime import datetime
import random
from random import randrange
import sys
# from .functions import *  # use this format to import from another file
import csv
# import logging
from shutil import rmtree

from PyQt5 import QtGui, QtCore
from PyQt5.QtCore import *
from PyQt5.QtGui import *
# from PyQt5 import QtGui, QtCore
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import *
from qgis.gui import *
from qgis import processing
from qgis.PyQt.QtCore import QVariant

user_path = str(os.environ['HOME'])
qgis_prefix = QgsApplication.prefixPath()
user_settingpath = str(QgsApplication.qgisSettingsDirPath())
cache_path_add = "Local/QGIS/QGIS3/cache"
cache_path_final = user_settingpath[:user_settingpath.find('Roaming')] + cache_path_add
# pembagi_radius = 110593 # for native algo to turn radius into unit meters
pembagi_radius = 110596.44  # this is more accurate, this for wedge buffers native qgis algo

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'make_sector_dialog_base.ui'))


class MakeSectorDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(MakeSectorDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        self.pbar.setValue(0)

        version = "Make Sector v1.1"
        # credit_label = "Copyright (c) 2024 Imam Sibro Muhlisi"
        # set label version
        self.label_version.setText(version)
        self.label_version.setStyleSheet("QLabel {color: blue;}")

        # set credit label
        # self.credit_label.setText(credit_label)

        self.text_logging.setReadOnly(True)

        # run refresh
        self.refresh_button()
        self.radius_button_refresh_func()
        self.spider_button_refresh_func()

        # for each button if clicked
        self.button_refresh.clicked.connect(self.refresh_button)
        self.button_close.clicked.connect(self.close_dialog)
        self.button_run.clicked.connect(self.button_run_func)
        self.radius_button_refresh.clicked.connect(self.radius_button_refresh_func)
        self.spider_button_refresh.clicked.connect(self.spider_button_refresh_func)
        self.spider_button_sel_desel_src.clicked.connect(self.spider_button_sel_desel_src_func)
        self.spider_button_sel_desel_tgt.clicked.connect(self.spider_button_sel_desel_tgt_func)

        # when combobox value changed
        self.combox_list_layer.currentIndexChanged.connect(self.combox_list_layer_changed)
        self.combox_lat.currentIndexChanged.connect(self.red_color_combox)
        self.combox_lon.currentIndexChanged.connect(self.red_color_combox)
        self.combox_az.currentIndexChanged.connect(self.red_color_combox)
        self.combox_bw.currentIndexChanged.connect(self.red_color_combox)
        self.combox_rad.currentIndexChanged.connect(self.red_color_combox)

        # radius combox
        self.radius_combox_list_layer.currentIndexChanged.connect(self.radius_combox_list_layer_changed)
        self.radius_combox_lat.currentIndexChanged.connect(self.radius_red_color_combox)
        self.radius_combox_lon.currentIndexChanged.connect(self.radius_red_color_combox)
        self.radius_combox_rad.currentIndexChanged.connect(self.radius_red_color_combox)

        # spider combox
        self.spider_combox_list_layer_src.currentIndexChanged.connect(self.spider_combox_list_layer_src_changed)
        self.spider_combox_list_layer_tgt.currentIndexChanged.connect(self.spider_combox_list_layer_tgt_changed)
        self.spider_combox_conn_src.currentIndexChanged.connect(self.spider_red_color_combox_src)
        self.spider_combox_lat_src.currentIndexChanged.connect(self.spider_red_color_combox_src)
        self.spider_combox_lon_src.currentIndexChanged.connect(self.spider_red_color_combox_src)
        self.spider_combox_conn_tgt.currentIndexChanged.connect(self.spider_red_color_combox_tgt)
        self.spider_combox_lat_tgt.currentIndexChanged.connect(self.spider_red_color_combox_tgt)
        self.spider_combox_lon_tgt.currentIndexChanged.connect(self.spider_red_color_combox_tgt)

        # when checkbox changed
        self.cbox_bw_custom_value.stateChanged.connect(lambda:self.cbstate(self.cbox_bw_custom_value))
        self.cbox_rad_custom_value.stateChanged.connect(lambda:self.cbstate(self.cbox_rad_custom_value))
        
        # radius checkbox
        self.radius_cbox_rad_custom_value.stateChanged.connect(lambda:self.cbstate(self.radius_cbox_rad_custom_value))
    
    def close_dialog(self):
        if self.status_label.text() != '...':
            self.refresh_button()
            self.radius_button_refresh_func()
            self.spider_button_refresh_func()

        self.status_label.setText("...")
        self.pbar.setValue(0)
        # self.text_logging.clear()
        self.close()
        return

    def logging(self, text):
        time_log = datetime.now().strftime("%Y-%m-%d, %H:%M:%S")
        self.text_logging.append(f'{time_log} - {text}')
    
    def button_status(self, status):
        status = status.lower()
        all_button_list = [self.button_run, self.button_close, self.button_refresh]

        if status == 'disable':
            for button in all_button_list:
                button.setEnabled(False)
        if status == 'enable':
            for button in all_button_list:
                button.setEnabled(True)
    
    def cbstate(self, b):
        list_combobox = [self.combox_bw, self.combox_rad]
        list_qlineedit = [self.doublespinbox_bw, self.doublespinbox_rad]

        # for checkbox beamwidth
        if self.tab_widget.currentIndex() == 0 and 'beamwidth' in b.text().lower():
            if b.isChecked() == True:
                list_combobox[0].setEnabled(False)
                list_qlineedit[0].setEnabled(True)
                return
            else:
                list_qlineedit[0].setEnabled(False)
                if self.combox_list_layer.currentText() != '':
                    list_combobox[0].setEnabled(True)
        # for checkbox radius
        if self.tab_widget.currentIndex() == 0 and 'radius' in b.text().lower():
            if b.isChecked() == True:
                list_combobox[1].setEnabled(False)
                list_qlineedit[1].setEnabled(True)
                return
            else:
                list_qlineedit[1].setEnabled(False)
                if self.combox_list_layer.currentText() != '':
                    list_combobox[1].setEnabled(True)
        
        # for radius tab
        if self.tab_widget.currentIndex() == 1 and 'radius' in b.text().lower():
            if b.isChecked() == True:
                self.radius_combox_rad.setEnabled(False)
                self.radius_doublespinbox_rad.setEnabled(True)
            else:
                self.radius_doublespinbox_rad.setEnabled(False)
                if self.radius_combox_list_layer.currentText() != '':
                    self.radius_combox_rad.setEnabled(True)
    
    def uncheckall_checkbox(self):
        checkbox_list = [self.cbox_bw_custom_value, self.cbox_rad_custom_value]
        for cbox in checkbox_list:
            cbox.setChecked(False)
        return
    
    def spider_button_sel_desel_src_func(self):
        if self.spider_button_sel_desel_src.text() == 'Select All':
            self.spider_mcombox_src.selectAllOptions()
            self.spider_button_sel_desel_src.setText('Deselect All')
        else:
            self.spider_mcombox_src.deselectAllOptions()
            self.spider_button_sel_desel_src.setText('Select All')
        return

    def spider_button_sel_desel_tgt_func(self):
        if self.spider_button_sel_desel_tgt.text() == 'Select All':
            self.spider_mcombox_tgt.selectAllOptions()
            self.spider_button_sel_desel_tgt.setText('Deselect All')
        else:
            self.spider_mcombox_tgt.deselectAllOptions()
            self.spider_button_sel_desel_tgt.setText('Select All')
        return
    
    def red_color_combox(self):
        # coloring empty combox
        combox_make_sector = [self.combox_list_layer, self.combox_lat, self.combox_lon, self.combox_az, self.combox_bw, self.combox_rad]
        
        all_combox = combox_make_sector
        for combox in all_combox:
            if combox.currentText() == '':
                combox.setStyleSheet("QComboBox {background-color: '#FDE9E5';}")
            else:
                combox.setStyleSheet("QComboBox {background-color: ;}")

    def radius_red_color_combox(self):
        # coloring empty combox
        combox_radius = [self.radius_combox_list_layer, self.radius_combox_lat, self.radius_combox_lon, self.radius_combox_rad]

        all_combox = combox_radius
        for combox in all_combox:
            if combox.currentText() == '':
                combox.setStyleSheet("QComboBox {background-color: '#FDE9E5';}")
            else:
                combox.setStyleSheet("QComboBox {background-color: ;}")
    
    def spider_red_color_combox_src(self):
        # coloring empty combox
        combox_spider = [self.spider_combox_list_layer_src, self.spider_combox_conn_src,
                         self.spider_combox_lat_src, self.spider_combox_lon_src]
        all_combox = combox_spider
        for combox in all_combox:
            if combox.currentText() == '':
                combox.setStyleSheet("QComboBox {background-color: '#FDE9E5';}")
            else:
                combox.setStyleSheet("QComboBox {background-color: ;}")

        return

    def spider_red_color_combox_tgt(self):
        # coloring empty combox
        combox_spider = [self.spider_combox_list_layer_tgt, self.spider_combox_conn_tgt,
                         self.spider_combox_lat_tgt, self.spider_combox_lon_tgt]
        all_combox = combox_spider
        for combox in all_combox:
            if combox.currentText() == '':
                combox.setStyleSheet("QComboBox {background-color: '#FDE9E5';}")
            else:
                combox.setStyleSheet("QComboBox {background-color: ;}")
    
    def some_combox(self, status):
        status = status.lower()
        make_sector_some_combox = [self.combox_lat, self.combox_lon, self.combox_az, self.combox_bw, self.combox_rad]

        some_combox = make_sector_some_combox
        # combox status
        if status == 'empty':
            for combox in some_combox:
                combox.clear()
        if status == 'disable':
            for combox in some_combox:
                combox.setEnabled(False)
                combox.setStyleSheet("QComboBox {background-color: '#D0CCCB';}")
        if status == 'enable':
            for combox in some_combox:
                combox.setEnabled(True)
                combox.setStyleSheet("QComboBox {background-color: ;}")
    
    def radius_some_combox(self, status):
        status = status.lower()
        radius_some_combox = [self.radius_combox_lat, self.radius_combox_lon, self.radius_combox_rad]

        some_combox = radius_some_combox
        # combox status
        if status == 'empty':
            for combox in some_combox:
                combox.clear()
        if status == 'disable':
            for combox in some_combox:
                combox.setEnabled(False)
                combox.setStyleSheet("QComboBox {background-color: '#D0CCCB';}")
        if status == 'enable':
            for combox in some_combox:
                combox.setEnabled(True)
                combox.setStyleSheet("QComboBox {background-color: ;}")
    
    def spider_some_combox(self, status):
        status = status.lower()
        spider_some_combox = [self.spider_combox_conn_src, self.spider_combox_lat_src, self.spider_combox_lon_src,
                              self.spider_combox_conn_tgt, self.spider_combox_lat_tgt, self.spider_combox_lon_tgt]

        some_combox = spider_some_combox
        # combox status
        if status == 'empty':
            for combox in some_combox:
                combox.clear()
        if status == 'disable':
            for combox in some_combox:
                combox.setEnabled(False)
                combox.setStyleSheet("QComboBox {background-color: '#D0CCCB';}")
        if status == 'enable':
            for combox in some_combox:
                combox.setEnabled(True)
                combox.setStyleSheet("QComboBox {background-color: ;}")

    def combox_list_layer_changed(self):
        combox_list_layer = self.combox_list_layer
        current_layer_name = combox_list_layer.currentText()

        # if user choose empty value
        if current_layer_name == '':
            # empty combox
            self.some_combox(status='empty')
            # disable combox
            self.some_combox(status='disable')
            return
        
        # list the columns
        try:
            layer = QgsProject.instance().mapLayersByName(current_layer_name)[0]
            self.status_label.setText("...")
        except:
            self.logging("Layer doesn't exist, please refresh!")
            self.status_label.setText("❌ Layer doesn't exist, please refresh!")
            return
        
        cols_ori = [f.name() for f in layer.fields()]
        cols_lower = [x.lower() for x in cols_ori]
        
        # empty combox
        self.some_combox(status='empty')

        # search some key in layer fields to autofill combox
        list_keyword = ['lat', 'lon', 'azim', 'beam', 'rad']
        list_combox = [self.combox_lat, self.combox_lon, self.combox_az, self.combox_bw, self.combox_rad]
        for (key, combox) in zip(list_keyword, list_combox):
            find_key_in_list = [x for x in cols_lower if key in x]
            if find_key_in_list:
                index = cols_lower.index(find_key_in_list[0])
                combox.addItems(cols_ori)
                combox.setCurrentIndex(index)
            else:
                combox.addItem('')
                combox.addItems(cols_ori)
        
        # enable combox
        self.some_combox(status='enable')

        # coloring combox
        self.red_color_combox()

    def radius_combox_list_layer_changed(self):
        combox_list_layer = self.radius_combox_list_layer
        current_layer_name = combox_list_layer.currentText()

        # if user choose empty value
        if current_layer_name == '':
            # empty combox
            self.radius_some_combox(status='empty')
            # disable combox
            self.radius_some_combox(status='disable')
            return
        
        # list the columns
        try:
            layer = QgsProject.instance().mapLayersByName(current_layer_name)[0]
            self.status_label.setText("...")
        except:
            self.logging("Layer doesn't exist, please refresh!")
            self.status_label.setText("❌ Layer doesn't exist, please refresh!")
            return
        
        cols_ori = [f.name() for f in layer.fields()]
        cols_lower = [x.lower() for x in cols_ori]

        # empty combox
        self.radius_some_combox(status='empty')

        # search some key in layer fields to autofill combox
        list_keyword = ['lat', 'lon', 'rad']
        list_combox = [self.radius_combox_lat, self.radius_combox_lon, self.radius_combox_rad]
        for (key, combox) in zip(list_keyword, list_combox):
            find_key_in_list = [x for x in cols_lower if key in x]
            if find_key_in_list:
                index = cols_lower.index(find_key_in_list[0])
                combox.addItems(cols_ori)
                combox.setCurrentIndex(index)
            else:
                combox.addItem('')
                combox.addItems(cols_ori)
        
        # enable combox
        self.radius_some_combox(status='enable')

        # coloring combox
        self.radius_red_color_combox()
    
    def spider_combox_list_layer_src_changed(self):
        combox_list_layer = self.spider_combox_list_layer_src
        current_layer_name = combox_list_layer.currentText()
        button_select = self.spider_button_sel_desel_src

        combox_list = [self.spider_combox_conn_src, self.spider_mcombox_src,
                       self.spider_combox_lat_src, self.spider_combox_lon_src]

        # is user choose empty value
        if current_layer_name == '':
            # empty combox and disable
            for combox in combox_list:
                combox.clear()
            
            # disable combox except mcombox
            for combox in combox_list:
                if combox != self.spider_mcombox_src:
                    combox.setEnabled(False)

            button_select.setEnabled(False)
            return
    
        # list the columns
        try:
            layer = QgsProject.instance().mapLayersByName(current_layer_name)[0]
            self.status_label.setText("...")
        except:
            self.logging("Layer doesn't exist, please refresh!")
            self.status_label.setText("❌ Layer doesn't exist, please refresh!")
            return
        
        cols_ori = [f.name() for f in layer.fields()]
        cols_lower = [x.lower() for x in cols_ori]

        # enable button
        button_select.setEnabled(True)
        
        # empty combox
        for combox in combox_list:
            combox.clear()

        # search some key in layer fields to autofill combox
        list_keyword = ['lat', 'lon']
        list_combox = [self.spider_combox_lat_src, self.spider_combox_lon_src]
        
        for (key, combox) in zip(list_keyword, list_combox):
            find_key_in_list = [x for x in cols_lower if key in x]
            if find_key_in_list:
                index = cols_lower.index(find_key_in_list[0])
                combox.addItems(cols_ori)
                combox.setCurrentIndex(index)
            else:
                combox.addItem('')
                combox.addItems(cols_ori)

        # add fields to combox conn
        combox_list[0].addItem('')
        combox_list[0].addItems(cols_ori)

        # add fields to mcombox
        for field in cols_ori:
            combox_list[1].addItemWithCheckState(field, False)

        # enable combox
        for combox in combox_list:
            combox.setEnabled(True)

        # coloring combox conn
        for combox in combox_list:
            if combox != self.spider_mcombox_src:
                if combox.currentText() == '':
                    combox.setStyleSheet("QComboBox {background-color: '#FDE9E5';}")
                else:
                    combox.setStyleSheet("QComboBox {background-color: ;}")
    
    def spider_combox_list_layer_tgt_changed(self):
        combox_list_layer = self.spider_combox_list_layer_tgt
        current_layer_name = combox_list_layer.currentText()
        button_select = self.spider_button_sel_desel_tgt

        combox_list = [self.spider_combox_conn_tgt, self.spider_mcombox_tgt,
                       self.spider_combox_lat_tgt, self.spider_combox_lon_tgt]

        # if user choose empty value
        if current_layer_name == '':
            # empty combox and disable
            for combox in combox_list:
                combox.clear()
            
            # disable combox except mcombox
            for combox in combox_list:
                if combox != self.spider_mcombox_tgt:
                    combox.setEnabled(False)

            button_select.setEnabled(False)
            return
        
        # enable button
        button_select.setEnabled(True)

        # empty combox
        for combox in combox_list:
            combox.clear()
    
        # list the columns
        layer = QgsProject.instance().mapLayersByName(current_layer_name)[0]
        cols_ori = [f.name() for f in layer.fields()]
        cols_lower = [x.lower() for x in cols_ori]

        # search some key in layer fields to autofill combox
        list_keyword = ['lat', 'lon']
        list_combox = [self.spider_combox_lat_tgt, self.spider_combox_lon_tgt]
        
        for (key, combox) in zip(list_keyword, list_combox):
            find_key_in_list = [x for x in cols_lower if key in x]
            if find_key_in_list:
                index = cols_lower.index(find_key_in_list[0])
                combox.addItems(cols_ori)
                combox.setCurrentIndex(index)
            else:
                combox.addItem('')
                combox.addItems(cols_ori)

        # add fields to combox conn
        combox_list[0].addItem('')
        combox_list[0].addItems(cols_ori)

        # add fields to mcombox
        for field in cols_ori:
            combox_list[1].addItemWithCheckState(field, False)

        # enable combox
        for combox in combox_list:
            combox.setEnabled(True)

        # coloring combox conn
        for combox in combox_list:
            if combox != self.spider_mcombox_tgt:
                if combox.currentText() == '':
                    combox.setStyleSheet("QComboBox {background-color: '#FDE9E5';}")
                else:
                    combox.setStyleSheet("QComboBox {background-color: ;}")

    def refresh_button(self):

        # activate first tab, make sector
        self.tab_widget.setCurrentIndex(0)

        # setup line edit
        self.doublespinbox_bw.setValue(60.00)
        self.doublespinbox_rad.setValue(0.00)
        # disable qlineedit
        self.doublespinbox_bw.setEnabled(False)
        self.doublespinbox_rad.setEnabled(False)

        # uncheck all cbox
        self.uncheckall_checkbox()

        # set label
        self.status_label.setText("...")

        # list all layer
        # all_layer_name = [layer.name() for layer in QgsProject.instance().mapLayers().values()]

        layer_all = [str(layer) for layer in QgsProject.instance().mapLayers().values()]
        layer_type = [layer[layer.find('(')+1:layer.find(')')] for layer in layer_all]
        layer_name = [layer.name() for layer in QgsProject.instance().mapLayers().values()]
        layer_name_and_type = []
        for (name, type) in zip(layer_name, layer_type):
            layer_name_and_type.append(name + '@' + type)

        # filter delimitedtext layer only
        final_layer_name_and_type = [layer for layer in layer_name_and_type if 'delimitedtext' in layer]
        final_layer = []
        for layer in final_layer_name_and_type:
            final_layer.append(layer[:layer.find('@')])

        # add layer to combox_list_layer
        self.some_combox(status='empty')
        self.combox_list_layer.clear()  # clear values
        self.combox_list_layer.addItem('')
        self.combox_list_layer.addItems(sorted(final_layer))

        # set unit for radius
        self.combox_rad_unit.clear()
        self.combox_rad_unit.addItems(['m', 'km'])

        # coloring combobox 
        self.red_color_combox()

        # button enable
        self.button_status('enable')

        # disable combox
        self.some_combox(status='disable')

    def radius_button_refresh_func(self):

        # set to empty
        combox_list = [self.radius_combox_list_layer, self.radius_combox_lat, self.radius_combox_lon, self.radius_combox_rad]
        for combox in combox_list:
            combox.clear()

        # layer list
        layer_all = [str(layer) for layer in QgsProject.instance().mapLayers().values()]
        layer_type = [layer[layer.find('(')+1:layer.find(')')] for layer in layer_all]
        layer_name = [layer.name() for layer in QgsProject.instance().mapLayers().values()]
        layer_name_and_type = []
        for (name, type) in zip(layer_name, layer_type):
            layer_name_and_type.append(name + '@' + type)

        # filter delimited and ogr layer type only
        final_layer_name_and_type = [layer for layer in layer_name_and_type if '@delimited' in layer or '@ogr' in layer]
        final_layer = []
        for layer in final_layer_name_and_type:
            final_layer.append(layer[:layer.find('@')])

        self.radius_combox_list_layer.addItem('')
        self.radius_combox_list_layer.addItems(sorted(final_layer))

        # set unit
        self.radius_combox_rad_unit.clear()
        self.radius_combox_rad_unit.addItems(['m', 'km'])

        # radius set spinbox to 0
        self.radius_doublespinbox_rad.setValue(0.00)
        self.radius_doublespinbox_rad.setEnabled(False)

        # checkbox
        self.radius_cbox_rad_custom_value.setChecked(False)

        # coloring combobox 
        self.radius_red_color_combox()

        # disable combox
        self.radius_some_combox(status='disable')

    def spider_button_refresh_func(self):
        
        # set color for frame src and tgt in tab spider
        # self.spider_frame_src.setStyleSheet("QFrame {background-color: rgba(10, 28, 239, .1);}")
        # self.spider_frame_tgt.setStyleSheet("QFrame {background-color: rgba(204, 204, 204, .5);}")

        # # set transparent color for label in spider
        # spider_label_list = [self.spider_label_layer_src, self.spider_label_connector_src, self.spider_label_field_src,
        #                      self.spider_label_layer_tgt, self.spider_label_connector_tgt, self.spider_label_field_tgt]

        # for label in spider_label_list:
        #     label.setStyleSheet("QLabel {background-color: rgba(140, 209, 41, .0);}")


        # set to empty
        combox_list = [self.spider_combox_list_layer_src, self.spider_combox_conn_src, self.spider_mcombox_src, self.spider_combox_lat_src, self.spider_combox_lon_src,
                       self.spider_combox_list_layer_tgt, self.spider_combox_conn_tgt, self.spider_mcombox_tgt, self.spider_combox_lat_tgt, self.spider_combox_lon_tgt]
        for combox in combox_list:
            combox.clear()

        # default text for mcombox
        # for combox in combox_list:
        #     if 'mcombox' in str(combox):
        #         combox.defaultText('Keep empty to select all')

        # layer list
        layer_all = [str(layer) for layer in QgsProject.instance().mapLayers().values()]
        layer_type = [layer[layer.find('(')+1:layer.find(')')] for layer in layer_all]
        layer_name = [layer.name() for layer in QgsProject.instance().mapLayers().values()]
        layer_name_and_type = []
        for (name, type) in zip(layer_name, layer_type):
            layer_name_and_type.append(name + '@' + type)

        # filter delimited and ogr layer type only
        final_layer_name_and_type = [layer for layer in layer_name_and_type if '@delimited' in layer or '@ogr' in layer]
        final_layer = []
        for layer in final_layer_name_and_type:
            final_layer.append(layer[:layer.find('@')])
        
        list_spider_combox_layer = [self.spider_combox_list_layer_src, self.spider_combox_list_layer_tgt]
        for combox in list_spider_combox_layer:
            combox.addItem('')
            combox.addItems(sorted(final_layer))

        # radius set spinbox to 0
        self.spider_doublespinbox_max_line.setValue(0.00)

        # set button text and disable
        self.spider_button_sel_desel_src.setText('Select All')
        self.spider_button_sel_desel_tgt.setText('Select All')

        self.spider_button_sel_desel_src.setEnabled(False)
        self.spider_button_sel_desel_tgt.setEnabled(False)

        # coloring combobox 
        self.spider_red_color_combox_src()
        self.spider_red_color_combox_tgt()

        # disable combox
        self.spider_some_combox(status='disable')

    def pbar_value(self, number):
        pbar_value = pbar_value + number
        return pbar_value
    
    def measure_distance_in_meters(self, src_lat, src_lon, tgt_lat, tgt_lon):
        try:
            d = QgsDistanceArea()
            d.setEllipsoid('WGS84')

            src_point = QgsPointXY(src_lon, src_lat)
            tgt_point = QgsPointXY(tgt_lon, tgt_lat)

            return d.measureLine(src_point, tgt_point)
        except:
            return None
    
    def make_point(self, lon, lat):
        try:
            lon = float(lon)
            lat = float(lat)
            return Point(lon, lat)
        except:
            return None
        
    def radius_final_rad(self, radius):
        try:
            x = float(radius)
            if self.radius_combox_rad_unit.currentText() == 'km':
                x = x*1000
            x = x / pembagi_radius
            return x
        except:
            return 0

    def run_create_sector_tab(self):
        # status label
        self.status_label.setText('Processing...')

        # checking all combox, is there any null
        all_combox = [self.combox_list_layer, self.combox_lat, self.combox_lon, self.combox_az]
        for combox in all_combox:
            if combox.currentText() == '':
                # logging
                self.status_label.setText('❌ Please check your columns!')
                return
            
        # check bandwidth column
        if self.combox_bw.currentText() == '' and self.doublespinbox_bw.value() <= 0.00:
            # logging
            self.status_label.setText('❌ Please check your beamwidth!')
            return
        
        if self.cbox_bw_custom_value.isChecked() == True and self.doublespinbox_bw.value() <= 0.00:
            # logging
            self.status_label.setText('❌ Please check your beamwidth!')
            return
        
        if self.cbox_bw_custom_value.isChecked() == False and self.combox_bw.currentText() == '':
            # logging
            self.status_label.setText('❌ Please check your beamwidth!')
            return
        
        # check radius column
        if self.combox_rad.currentText() == '' and self.doublespinbox_rad.value() <= 0.00:
            # logging
            self.status_label.setText('❌ Please check your radius!')
            return
        
        if self.cbox_rad_custom_value.isChecked() == True and self.doublespinbox_rad.value() <= 0.00:
            # logging
            self.status_label.setText('❌ Please check your radius!')
            return

        if self.cbox_rad_custom_value.isChecked() == False and self.combox_rad.currentText() == '':
            # logging
            self.status_label.setText('❌ Please check your radius!')
            return

        # logging
        self.logging("Run create sector..")

        # disable frame
        self.frame_main.setEnabled(False)

        # button disable
        self.button_status('disable')

        # activate Log tab
        self.tab_widget.setCurrentIndex(3)

        self.pbar.setValue(random.randint(0,3))

        # logging
        self.logging("Populate variable..")

        # for layer and column name
        layer = self.combox_list_layer.currentText()
        lat = self.combox_lat.currentText()
        lon = self.combox_lon.currentText()
        azimuth = self.combox_az.currentText()
        beamwidth = self.combox_bw.currentText()
        radius = self.combox_rad.currentText()

        # for beamwidth
        if self.cbox_bw_custom_value.isChecked() == True:
            beamwidth = float(self.doublespinbox_bw.value())
        
        # for radius
        if self.cbox_rad_custom_value.isChecked() == True:
            radius = float(self.doublespinbox_rad.value())
            if self.combox_rad_unit.currentText() == 'm':
                radius = radius/pembagi_radius
            if self.combox_rad_unit.currentText() == 'km':
                radius = radius*1000/pembagi_radius
            
            # # pengali is multiplier to change unit to meters, user input in meters default (only if using geopandas to create geometry) not applicable for qgis native algo
            # pengali = 9.05797/(10 ** 6)
            # radius = radius * pengali
        
        # process
        lyr = QgsProject.instance().mapLayersByName(layer)[0]
        lyr_name = lyr.name()
        lyr_source = lyr.source()

        self.pbar.setValue(random.randint(4,10))
        self.logging("Calculate radius..")

        # for new field if using km
        new_radius_field = f"{radius}_{random.randint(1,9)}"
        # if radius using column
        if radius == self.combox_rad.currentText():
            # read csv
            path_ori = lyr_source
            path_ori = path_ori[:path_ori.find('.csv')+4]
            path = path_ori
            if 'file:///' in path:
                path = path.replace('file:///', '')
            path = urllib.parse.unquote(path)
            path = Path(path)
            df = pd.read_csv(path)

            # fix unicode if any unicode
            for columns in df.items():
                if 'object' in str(df[columns[0]].dtype):
                    df[columns[0]] = df[columns[0]].str.normalize('NFKD')
            
            # add new column
            if self.combox_rad_unit.currentText() == 'km':
                df.loc[:, new_radius_field] = df.apply(lambda x: (x[radius]*1000/pembagi_radius), axis=1)
            if self.combox_rad_unit.currentText() == 'm':
                df.loc[:, new_radius_field] = df.apply(lambda x: (x[radius]/pembagi_radius), axis=1)

            # df.to_csv(path, index=False)
            with open (path, 'w', newline='') as file:
                writer = csv.writer(file)
                writer.writerow(list(df))

                for index, row in df.iterrows():
                    writer.writerow(df.loc[index, :].values.flatten().tolist())
        
            # csv seem cannot be reload - I dont know. we remove old csv, then reload the new one with same path
            layer_csv = QgsProject.instance().mapLayersByName(lyr_name)[0]
            crs_ori = layer_csv.crs()
            # layer_csv.reload()
            # remove old layer
            QgsProject.instance().removeMapLayer(layer_csv.id())

            # load the new one
            uri = path_ori + f'?delimiter=,&yField={lat}&xField={lon}'
            layer_csv_new = QgsVectorLayer(uri, lyr_name, 'delimitedtext')
            layer_csv_new.setCrs(crs_ori)
            QgsProject.instance().addMapLayer(layer_csv_new)

            # execute param
            layer_csv_new = QgsProject.instance().mapLayersByName(lyr_name)[0]
            lyr_source = layer_csv_new.source()

            radius = new_radius_field

            # # add new field and radius in meter
            # new_radius_field = f"{radius}_{random.randint(1,9)}"
            # pr = lyr.dataProvider()
            # pr.addAttributes([QgsField(new_radius_field, QVariant.String)])
            # lyr.updateFields()

            # with edit(lyr):
            #     for f in lyr.getFeatures():
            #         f[new_radius_field] = f[radius]*1000
            #         lyr.updateFeature(f)
            
            # radius = new_radius_field

        # logging
        self.pbar.setValue(random.randint(11,30))
        self.logging("Create wedge..")
        
        param_wedge = {}
        # jika tidak ada custom value untuk beamwidth dan radius
        if self.cbox_bw_custom_value.isChecked() == False and self.cbox_rad_custom_value.isChecked() == False:
            param_wedge = {'INPUT':lyr_source,'AZIMUTH':QgsProperty.fromExpression(f'"{azimuth}"'),'WIDTH':QgsProperty.fromExpression(f'"{beamwidth}"'),'OUTER_RADIUS':QgsProperty.fromExpression(f'"{radius}"'),'INNER_RADIUS':0,'OUTPUT':'TEMPORARY_OUTPUT'}
        # jika ada custom value untuk beamwidth tapi radius tidak
        if self.cbox_bw_custom_value.isChecked() == True and self.cbox_rad_custom_value.isChecked() == False:
            param_wedge = {'INPUT':lyr_source,'AZIMUTH':QgsProperty.fromExpression(f'"{azimuth}"'),'WIDTH':beamwidth,'OUTER_RADIUS':QgsProperty.fromExpression(f'"{radius}"'),'INNER_RADIUS':0,'OUTPUT':'TEMPORARY_OUTPUT'}
        # jika tidak ada custom value untuk beamwidth tapi radius ada
        if self.cbox_bw_custom_value.isChecked() == False and self.cbox_rad_custom_value.isChecked() == True:
            param_wedge = {'INPUT':lyr_source,'AZIMUTH':QgsProperty.fromExpression(f'"{azimuth}"'),'WIDTH':QgsProperty.fromExpression(f'"{beamwidth}"'),'OUTER_RADIUS':radius,'INNER_RADIUS':0,'OUTPUT':'TEMPORARY_OUTPUT'}
        # jika ada custom value untuk beamwidth dan radius
        if self.cbox_bw_custom_value.isChecked() == True and self.cbox_rad_custom_value.isChecked() == True:
            param_wedge = {'INPUT':lyr_source,'AZIMUTH':QgsProperty.fromExpression(f'"{azimuth}"'),'WIDTH':beamwidth,'OUTER_RADIUS':radius,'INNER_RADIUS':0,'OUTPUT':'TEMPORARY_OUTPUT'}

        # run native qgis wedge buffers
        layer_wedge = processing.run("native:wedgebuffers", param_wedge)

        # logging
        self.pbar.setValue(random.randint(31,70))
        self.logging("Wedge created..")

        gcell_layer = QgsProject.instance().addMapLayer(layer_wedge['OUTPUT'])

        # if radius using column and in km, delete new_radius_field after process
        if radius == new_radius_field:
            # read csv to delete column radius
            path_ori = lyr_source
            path_ori = path_ori[:path_ori.find('.csv')+4]
            path = path_ori
            if 'file:///' in path:
                path = path.replace('file:///', '')
            path = urllib.parse.unquote(path)
            path = Path(path)
            df = pd.read_csv(path)

            # fix unicode if any unicode
            for columns in df.items():
                if 'object' in str(df[columns[0]].dtype):
                    df[columns[0]] = df[columns[0]].str.normalize('NFKD')
            
            # now delete the new column added in before
            df.drop(columns=[new_radius_field], inplace=True)

            # df.to_csv(path, index=False)
            with open (path, 'w', newline='') as file:
                writer = csv.writer(file)
                writer.writerow(list(df))

                for index, row in df.iterrows():
                    writer.writerow(df.loc[index, :].values.flatten().tolist())
        
            # csv seem cannot be reload - I dont know. we remove old csv, then reload the new one with same path
            layer_csv = QgsProject.instance().mapLayersByName(lyr_name)[0]
            crs_ori = layer_csv.crs()
            # layer_csv.reload()
            # remove old layer
            QgsProject.instance().removeMapLayer(layer_csv.id())

            # load the new one
            uri = path_ori + f'?delimiter=,&yField={lat}&xField={lon}'
            layer_csv_new = QgsVectorLayer(uri, lyr_name, 'delimitedtext')
            layer_csv_new.setCrs(crs_ori)
            QgsProject.instance().addMapLayer(layer_csv_new)

            # execute param
            layer_csv_new = QgsProject.instance().mapLayersByName(lyr_name)[0]
            lyr_source = layer_csv_new.source()

            # delete new radius field in new layer
            with edit(gcell_layer):
                # Get the field index by its name:
                my_field = gcell_layer.fields().indexFromName(f'{radius}')
                # Delete the field by its index, note that it has to be in a list:
                gcell_layer.dataProvider().deleteAttributes([my_field])
            # Update the fields, so the changes are recognized:
            gcell_layer.updateFields()

        # logging
        self.pbar.setValue(random.randint(71,99))
        self.logging("Layer loaded..")
        
        # rename layer gcell
        gcell_layer_new_name = f'{lyr_name}_gcell_{random.randint(1,9)}'
        gcell_layer.setName(gcell_layer_new_name)

        self.pbar.setValue(random.randint(100,100))

        self.pbar.setValue(0)

        # logging
        self.logging(f"Create sector done for layer : {layer}..")

        # button enable
        self.button_status('enable')

        self.frame_main.setEnabled(True)

        # delete cache                                                           
        try: 
            rmtree(Path(cache_path_final), ignore_errors=True)
        except:
            self.logging("Warning : Cache can't be deleted.")

        self.logging("Processing done.")

        # set text
        self.status_label.setText("✅ New sector layer created successfully")

        return

    def run_radius_circle(self):
        # status label
        self.status_label.setText('Processing...')

        # checking all combox, is there any null
        all_combox = [self.radius_combox_list_layer, self.radius_combox_lat, self.radius_combox_lon]
        for combox in all_combox:
            if combox.currentText() == '':
                # logging
                self.status_label.setText('❌ Please check your columns!')
                return
        
        # check radius 
        if self.radius_combox_rad.currentText() == '' and self.radius_doublespinbox_rad.value() <= 0.00:
            self.status_label.setText('❌ Please check radius!')
            return

        if self.radius_cbox_rad_custom_value.isChecked() == True and self.radius_doublespinbox_rad.value() <= 0.00:
            self.status_label.setText('❌ Please check radius!')
            return
        
        if self.radius_cbox_rad_custom_value.isChecked() == False and self.radius_combox_rad.currentText() == '':
            self.status_label.setText('❌ Please check radius!')
            return

        # logging
        self.logging("Run circle radius..")
        
        # disable frame
        self.frame_main.setEnabled(False)

        # button disable
        self.button_status('disable')

        # activate Log tab
        self.tab_widget.setCurrentIndex(3)
        
        self.pbar.setValue(random.randint(0,15))

        # logging
        self.logging("Populate variable circle radius..")

        # for layer and column name
        layer_in_combox = self.radius_combox_list_layer.currentText()
        lat = self.radius_combox_lat.currentText()
        lon = self.radius_combox_lon.currentText()
        radius = self.radius_combox_rad.currentText()
        
        # for radius
        if self.radius_cbox_rad_custom_value.isChecked() == True:
            radius = float(self.radius_doublespinbox_rad.value())
            if self.radius_combox_rad_unit.currentText() == 'km':
                radius = radius*1000
            radius = radius / pembagi_radius
        
        # layer name and type
        layer_all = [str(layer) for layer in QgsProject.instance().mapLayers().values()]
        layer_type = [layer[layer.find('(')+1:layer.find(')')] for layer in layer_all]
        layer_name = [layer.name() for layer in QgsProject.instance().mapLayers().values()]
        layer_name_and_type = []
        for (name, type) in zip(layer_name, layer_type):
            layer_name_and_type.append(name + '@' + type)

        # get layer_id, layer_name, layer_source : 
        layers_id = QgsProject.instance().mapLayers()
        layers_name = layers_id.values()

        lyr_id_name_source = []
        for (layer_id, layer_name, layer_type) in zip(layers_id, layers_name, layer_name_and_type):
            if layer_name.name() == layer_in_combox:
                lyr_id_name_source.append(layer_id)
                lyr_id_name_source.append(layer_name.name())
                lyr_id_name_source.append(layer_name.source())
                lyr_id_name_source.append(layer_type)
        
        # get all fields name from layer id 
        all_fields_name = []
        map_layer = QgsProject.instance().mapLayer(lyr_id_name_source[0])
        fields = QgsProject.instance().mapLayer(lyr_id_name_source[0]).fields()
        for field in fields:
            all_fields_name.append(field.name())
        
        self.pbar.setValue(random.randint(16,30))
        self.logging("Done populate layers and fields..")
        
        radius_circle_field = 'rad_f'
        if radius == self.radius_combox_rad.currentText():
            radius_circle_field = 'rad_f'
            # check for column name, if same with 'radius_circle', change new name
            for x in range(len(all_fields_name)):
                if all_fields_name[x] == radius_circle_field:
                    radius_circle_field = f'{radius_circle_field}_{random.randint(1,99)}'
        
        # create empty dataframe    
        df = pd.DataFrame()
        
        if '@delimited' in lyr_id_name_source[3]:       # if csv, read by pandas
            # read csv
            path_ori = lyr_id_name_source[2]
            path_ori = path_ori[:path_ori.find('.csv')+4]
            path = path_ori
            if 'file:///' in path:
                path = path.replace('file:///', '')
            path = urllib.parse.unquote(path)
            path = Path(path)
            df = pd.read_csv(path)

            self.pbar.setValue(random.randint(31,40))
            self.logging("Layer is csv, reading by pandas..")

            # fix unicode if any unicode
            for columns in df.items():
                if 'object' in str(df[columns[0]].dtype):
                    df[columns[0]] = df[columns[0]].str.normalize('NFKD')
            
            # add new column
            if radius == self.radius_combox_rad.currentText():
                df.loc[:, radius_circle_field] = df.apply(lambda x: self.radius_final_rad(x[radius]), axis=1)
            else:
                df.loc[:, radius_circle_field] = df.apply(lambda x: (radius), axis=1)

            self.pbar.setValue(random.randint(41,55))
            self.logging("Add new column and overwrite..")

            # df.to_csv(path, index=False)
            with open (path, 'w', newline='') as file:
                writer = csv.writer(file)
                writer.writerow(list(df))

                for index, row in df.iterrows():
                    writer.writerow(df.loc[index, :].values.flatten().tolist())
        
            # csv seem cannot be reload - I dont know. we remove old csv, then reload the new one with same path
            layer_csv = QgsProject.instance().mapLayersByName(lyr_id_name_source[1])[0]
            crs_ori = layer_csv.crs()
            # layer_csv.reload()
            # remove old layer
            QgsProject.instance().removeMapLayer(layer_csv.id())

            self.pbar.setValue(random.randint(56,75))
            self.logging("Start processing buffer..")

            # load the new one
            uri = path_ori + f'?delimiter=,&yField={lat}&xField={lon}'
            layer_csv_new = QgsVectorLayer(uri, lyr_id_name_source[1], 'delimitedtext')
            layer_csv_new.setCrs(crs_ori)
            QgsProject.instance().addMapLayer(layer_csv_new)

            # execute param
            layer_csv_new = QgsProject.instance().mapLayersByName(lyr_id_name_source[1])[0]
            layer_csv_new_src = layer_csv_new.source()

            param_wedge = {}
            if radius == self.radius_combox_rad.currentText():
                param_wedge = { 'AZIMUTH' : 0, 'INNER_RADIUS' : 0, 'INPUT' : layer_csv_new_src, 'OUTER_RADIUS' : QgsProperty.fromExpression(f'"{radius_circle_field}"'), 'OUTPUT' : 'TEMPORARY_OUTPUT', 'WIDTH' : 360 }
            else:
                param_wedge = { 'AZIMUTH' : 0, 'INNER_RADIUS' : 0, 'INPUT' : layer_csv_new_src, 'OUTER_RADIUS' : radius, 'OUTPUT' : 'TEMPORARY_OUTPUT', 'WIDTH' : 360 }
            
            # process with native algo
            layer_wedge = processing.run("native:wedgebuffers", param_wedge)
            layer_vector = QgsProject.instance().addMapLayer(layer_wedge['OUTPUT'])
            layer_new_name = f'{lyr_id_name_source[1]}_radius_{random.randint(1,99)}'
            layer_vector.setName(layer_new_name)

            # delete radius field if using new radius field
            if radius == self.radius_combox_rad.currentText():
                with edit(layer_vector):
                    # Get the field index by its name:
                    my_field = layer_vector.fields().indexFromName(f'{radius_circle_field}')
                    # Delete the field by its index, note that it has to be in a list:
                    layer_vector.dataProvider().deleteAttributes([my_field])
                # Update the fields, so the changes are recognized:
                layer_vector.updateFields()
            
                # also delete new radius field in source csv
                df = pd.read_csv(path)

                # fix unicode if any unicode
                for columns in df.items():
                    if 'object' in str(df[columns[0]].dtype):
                        df[columns[0]] = df[columns[0]].str.normalize('NFKD')
                
                # drop columns
                df.drop(columns=[radius_circle_field], inplace=True)

                # df.to_csv(path, index=False)
                with open (path, 'w', newline='') as file:
                    writer = csv.writer(file)
                    writer.writerow(list(df))

                    for index, row in df.iterrows():
                        writer.writerow(df.loc[index, :].values.flatten().tolist())
            
                # csv seem cannot be reload - I dont know. we remove old csv, then reload the new one with same path
                layer_csv = QgsProject.instance().mapLayersByName(lyr_id_name_source[1])[0]
                crs_ori = layer_csv.crs()
                # layer_csv.reload()
                # remove old layer
                QgsProject.instance().removeMapLayer(layer_csv.id())

                # load the new one
                uri = path_ori + f'?delimiter=,&yField={lat}&xField={lon}'
                layer_csv_new = QgsVectorLayer(uri, lyr_id_name_source[1], 'delimitedtext')
                layer_csv_new.setCrs(crs_ori)
                QgsProject.instance().addMapLayer(layer_csv_new)

            # layer_need_to_rename.setOpacity(0.1)  # this cannot be change by user, use renderer instead
            layer_vector.renderer().symbol().setColor(QColor("#6f00ff"))
            layer_vector.renderer().symbol().setOpacity(0.05)

            # free memory
            del df

            self.pbar.setValue(random.randint(76,85))
            self.logging("All done, prepare clear cache..")
        
        if '@delimited' not in lyr_id_name_source[3]:
            layer_ogr = QgsProject.instance().mapLayersByName(lyr_id_name_source[1])[0]
            layer_ogr_crs = str(layer_ogr.crs())
            layer_ogr_crs = layer_ogr_crs[layer_ogr_crs.find(':')+1:len(layer_ogr_crs)-1].lower().strip()

            # List all columns / fields of layer_ogr
            cols = [f.name() for f in layer_ogr.fields()]

            # Get row value (features) from each field
            datagen = ([f[col] for col in cols] for f in layer_ogr.getFeatures())

            self.pbar.setValue(random.randint(31,40))
            self.logging("Layer is ogr, reading by pandas..")

            df = pd.DataFrame.from_records(data=datagen, columns=cols)       # coerce_float=True
            
            # get rid of unicode
            for columns in df.items():
                if 'object' in str(df[columns[0]].dtype):
                    df[columns[0]] = df[columns[0]].str.normalize('NFKD')
            
            # add new column
            if radius == self.radius_combox_rad.currentText():
                df.loc[:, radius_circle_field] = df.apply(lambda x: self.radius_final_rad(x[radius]), axis=1)
            else:
                df.loc[:, radius_circle_field] = df.apply(lambda x: (radius), axis=1)

            self.pbar.setValue(random.randint(41,55))
            self.logging("Add new column and overwrite..")
            
            # add geometry
            df.loc[:, 'geometry'] = df.apply(lambda x: self.make_point(x[lon], x[lat]), axis=1)

            # read by geopandas dataframe
            df = gpd.GeoDataFrame(df, crs=layer_ogr_crs, geometry='geometry')

            # set new name for layer
            layer_ogr_new_name = f'{lyr_id_name_source[1]}_buffer_{random.randint(1,99)}'

            df_layer = QgsVectorLayer(df.to_json(), layer_ogr_new_name, "ogr")
            layer_ogr_new = QgsProject.instance().addMapLayer(df_layer)

            self.pbar.setValue(random.randint(56,75))
            self.logging("Start processing buffer..")

            # execute param
            # layer_ogr_new = QgsProject.instance().mapLayersByName(layer_ogr_new_name)[0]
            layer_ogr_new_src = layer_ogr_new.source()

            param_wedge = {}
            if radius == self.radius_combox_rad.currentText():
                param_wedge = { 'AZIMUTH' : 0, 'INNER_RADIUS' : 0, 'INPUT' : layer_ogr_new_src, 'OUTER_RADIUS' : QgsProperty.fromExpression(f'"{radius_circle_field}"'), 'OUTPUT' : 'TEMPORARY_OUTPUT', 'WIDTH' : 360 }
            else:
                param_wedge = { 'AZIMUTH' : 0, 'INNER_RADIUS' : 0, 'INPUT' : layer_ogr_new_src, 'OUTER_RADIUS' : radius, 'OUTPUT' : 'TEMPORARY_OUTPUT', 'WIDTH' : 360 }

            # process with native algo
            layer_wedge = processing.run("native:wedgebuffers", param_wedge)
            layer_vector_new = QgsProject.instance().addMapLayer(layer_wedge['OUTPUT'])

            # delete radius field if using new radius field
            if radius == self.radius_combox_rad.currentText():
                with edit(layer_vector_new):
                    # Get the field index by its name:
                    my_field = layer_vector_new.fields().indexFromName(f'{radius_circle_field}')
                    # Delete the field by its index, note that it has to be in a list:
                    layer_vector_new.dataProvider().deleteAttributes([my_field])
                # Update the fields, so the changes are recognized:
                layer_vector_new.updateFields()

            layer_new_name = f'{lyr_id_name_source[1]}_radius_{random.randint(1,99)}'
            # layer_rad_new = QgsProject.instance().mapLayersByName('Buffers')[0]
            layer_vector_new.setName(layer_new_name)
            # layer_rad_new.setOpacity(0.1)  # user cannot change opacity if use this, use renderer instead
            layer_vector_new.renderer().symbol().setColor(QColor("#6f00ff"))
            layer_vector_new.renderer().symbol().setOpacity(0.05)

            # remove point layer
            layer_need_remove = QgsProject.instance().mapLayersByName(layer_ogr_new_name)[0]
            QgsProject.instance().removeMapLayer(layer_need_remove.id())

            # free memory
            del df
            del df_layer

            self.pbar.setValue(random.randint(76,85))
            self.logging("All done, prepare clear cache..")

        self.pbar.setValue(random.randint(86,98))

        # enable frame
        self.frame_main.setEnabled(True)

        # delete cache                                                           
        try: 
            rmtree(Path(cache_path_final), ignore_errors=True)
        except:
            self.logging("Warning : Cache can't be deleted.")

        self.pbar.setValue(random.randint(100,100))
        self.pbar.setValue(0)
        self.logging("Processing done.")
        
        # button enable
        self.button_status('enable')

        # status label
        self.status_label.setText('✅ New radius layer loaded successfully')

        return

    def run_spider_graph(self):

        # status label
        self.status_label.setText('Processing...')

        # checking all combox, is there any null
        all_combox = [self.spider_combox_list_layer_src, self.spider_combox_conn_src, self.spider_combox_lat_src, self.spider_combox_lon_src,
                       self.spider_combox_list_layer_tgt, self.spider_combox_conn_tgt, self.spider_combox_lat_tgt, self.spider_combox_lon_tgt]
        for combox in all_combox:
            if combox.currentText() == '':
                self.status_label.setText('❌ Please check your columns!')
                return  

        # populate variable
        src_layer_name = all_combox[0].currentText()
        src_field_conn = all_combox[1].currentText()
        src_lat = all_combox[2].currentText()
        src_lon = all_combox[3].currentText()
        tgt_layer_name = all_combox[4].currentText()
        tgt_field_conn = all_combox[5].currentText()
        tgt_lat = all_combox[6].currentText()
        tgt_lon = all_combox[7].currentText()

        if src_layer_name == tgt_layer_name:
            self.status_label.setText('❌ Source and target is same layer!')
            self.frame_main.setEnabled(True)
            return
        
        # disable frame
        self.frame_main.setEnabled(False)

        # button disable
        self.button_status('disable')

        # logging
        self.logging("Run circle radius..")

        self.pbar.setValue(random.randint(0,5))
        self.logging("Populating variables..")

        # activate Log tab
        self.tab_widget.setCurrentIndex(3)

        max_line_distance = self.spider_doublespinbox_max_line.value()
        if max_line_distance <= 0.00:
            max_line_distance = 20.00
        
        # query src fields
        src_layer_vector = QgsProject.instance().mapLayersByName(src_layer_name)[0]
        src_layer_all_fields = [f.name() for f in src_layer_vector.fields()]
        src_layer_vector_source = src_layer_vector.source()
        src_layer_crs = str(src_layer_vector.crs())
        src_layer_crs = src_layer_crs[src_layer_crs.find(':')+1:len(src_layer_crs)-1].lower().strip()

        # query tgt fields
        tgt_layer_vector = QgsProject.instance().mapLayersByName(tgt_layer_name)[0]
        tgt_layer_all_fields = [f.name() for f in tgt_layer_vector.fields()]
        tgt_layer_vector_source = tgt_layer_vector.source()
        tgt_layer_crs = str(tgt_layer_vector.crs())
        tgt_layer_crs = tgt_layer_crs[tgt_layer_crs.find(':')+1:len(tgt_layer_crs)-1].lower().strip()
        
        # check fields selected by user
        src_field_selected = self.spider_mcombox_src.checkedItems()
        tgt_field_selected = self.spider_mcombox_tgt.checkedItems()

        # if none selected field then select all
        if not src_field_selected:
            src_field_selected = src_layer_all_fields
        if not tgt_field_selected:
            tgt_field_selected = tgt_layer_all_fields
        
        # always add lat long in field
        src_lat_lon = [src_lat, src_lon]
        src_field_selected = src_field_selected + src_lat_lon
        src_field_selected = list(dict.fromkeys(src_field_selected))

        tgt_lat_lon = [tgt_lat, tgt_lon]
        tgt_field_selected = tgt_field_selected + tgt_lat_lon
        tgt_field_selected = list(dict.fromkeys(tgt_field_selected))

        tgt_lat_lon_new = []
        for x in tgt_lat_lon:
            if x in src_field_selected:
                tgt_lat_lon_new.append(f'{x}_right_{random.randint(1,9)}')
            else:
                tgt_lat_lon_new.append(x)
        tgt_lat = tgt_lat_lon_new[0]
        tgt_lon = tgt_lat_lon_new[1]

        self.pbar.setValue(random.randint(6,15))
        self.logging("Executing algorithm..")

        # execute algorithm
        param_hubline = {'HUBS': src_layer_vector_source,'HUB_FIELD': src_field_conn,'HUB_FIELDS':src_field_selected,
                         'SPOKES': tgt_layer_vector_source,'SPOKE_FIELD': tgt_field_conn,'SPOKE_FIELDS':tgt_field_selected,
                         'GEODESIC':False,'GEODESIC_DISTANCE':1000,'ANTIMERIDIAN_SPLIT':False,'OUTPUT':'TEMPORARY_OUTPUT'}
        
        layer_hubline = processing.run("native:hublines", param_hubline)
        QgsProject.instance().addMapLayer(layer_hubline['OUTPUT'])

        final_layer_name = f'spidergraph_{random.randint(1,99)}'
        final_layer = QgsProject.instance().mapLayersByName('Hub lines')[0]

        self.pbar.setValue(random.randint(16,40))
        self.logging("Calculating line distance..")

        # add new field and calculate distance
        distance_field = f"distance_bro_{random.randint(1,9)}"
        pr = final_layer.dataProvider()
        pr.addAttributes([QgsField(distance_field, QVariant.String)])
        final_layer.updateFields()

        with edit(final_layer):
            for f in final_layer.getFeatures():
                f[distance_field] = (self.measure_distance_in_meters(f[src_lat], f[src_lon], f[tgt_lat], f[tgt_lon])/1000)
                final_layer.updateFeature(f)
        
        self.pbar.setValue(random.randint(41,60))
        self.logging(f"Deleting features more than {max_line_distance} km..")

        # delete features that match with max distance length
        try:
            caps = final_layer.dataProvider().capabilities()
            features = final_layer.getFeatures()
            del_feats = []

            if caps & QgsVectorDataProvider.DeleteFeatures:
                for feature in features:
                    if feature[distance_field] != None or feature[distance_field] != '':
                        if float(feature[distance_field]) > max_line_distance:
                            del_feats.append(feature.id())
                res = final_layer.dataProvider().deleteFeatures(del_feats)
                final_layer.triggerRepaint()
        except:
            self.loggin("Can't filter line distance.")
            pass

        self.pbar.setValue(random.randint(61,80))
        self.logging("Prepare apply thematic..")

        # apply symbology categorized
        try:
            fni = final_layer.fields().indexFromName(src_field_conn)
            unique_values = final_layer.uniqueValues(fni)

            # fill categories
            categories = []
            for unique_value in unique_values:
                # initialize the default symbol for this geometry type
                symbol = QgsSymbol.defaultSymbol(final_layer.geometryType())

                # configure a symbol layer
                layer_style = {}
                layer_style['color'] = '%d, %d, %d' % (randrange(0, 256), randrange(0, 256), randrange(0, 256))
                symbol_layer = QgsSimpleFillSymbolLayer.create(layer_style)

                # replace default symbol layer with the configured one
                if symbol_layer is not None:
                    symbol.changeSymbolLayer(0, symbol_layer)
                # set opacity
                symbol.setOpacity(0.3)
                # symbol.symbolLayer(0).setStrokeStyle(Qt.PenStyle(Qt.NoPen)) # this is for point, can't used for line
                # create renderer object
                category = QgsRendererCategory(unique_value, symbol, str(unique_value))
                # entry for the list of category items
                categories.append(category)

            # create renderer object
            renderer = QgsCategorizedSymbolRenderer(src_field_conn, categories)

            # assign the created renderer to the layer
            if renderer is not None:
                final_layer.setRenderer(renderer)

            final_layer.triggerRepaint()
            self.logging("Thematic appied..")
        except:
            self.logging("Cannot apply thematic map..")
            pass

        # rename the layer
        final_layer.setName(final_layer_name)

        self.pbar.setValue(random.randint(81,90))
        self.logging("Delete cache process..")

        # delete cache                                                           
        try: 
            rmtree(Path(cache_path_final), ignore_errors=True)
        except:
            self.logging("Warning : Cache can't be deleted.")

        self.pbar.setValue(random.randint(91,97))
        self.logging("Almost done..")

        # enable frame
        self.frame_main.setEnabled(True)

        # button enable
        self.button_status('enable')

        self.pbar.setValue(random.randint(100,100))
        self.logging("Processing done.")
        self.pbar.setValue(0)

        # status label
        self.status_label.setText('✅ New Spidergraph layer loaded successfully')

        return

    def button_run_func(self):
        current_tab_index = self.tab_widget.currentIndex()

        # which tab is active?
        if current_tab_index == 0:
            self.run_create_sector_tab()
        if current_tab_index == 1:
            self.run_radius_circle()
        if current_tab_index == 2:
            self.run_spider_graph()
        
        return

def main():
    app = QtGui.QApplication(sys.argv)
    form = MakeSectorDialog()
    form.show()
    app.exec_()

if __name__ == '__main__':
    main()