################################################################################
#
# Copyright 2016 geoplaning GmbH 
# All rights reserved
#
# This program is released under the terms of the new BSD license. See the 
# LICENSE file for more information.
#
################################################################################


NSDWA = None

NSISYBAU2006 = {"d": "http://www.ofd-hannover.la/Identifikation"}
NSISYBAU2017 = {"d": "http://www.bfr-abwasser.de"}

Schacht_FelderDWA=[
"KG001","Knotenbezeichnung","string(33)",
"KG002","Alternative Knotenbezeichnung","string(33)",
"KG101","Strassenschluessel","string(16)",
"KG102","Strassenname","string",
"KG103","Ortsteilschluessel","string(16)",
"KG104","Ortteilname","string",
"KG105","Gemeindeschluessel","string(16)",
"KG106","Gebietsschluessel","string(16)",
"KG107","Einzugsgebietschluessel","string(26)",
"KG108","Nummer der Klaeranlage","string(16)",
"KG201","Rechtswert Deckel","double",
"KG202","Hochwert Deckel","double",
"KG203","Lagegenauigkeitsstufe Deckel","string(1)",
"KG204","Hoehe Deckel","double",
"KG205","Hoehengenauigkeitsstufe Deckel","string(1)",
"KG206","Rechtswert Sohle","double",
"KG207","Hochwert Sohle","double",
"KG208","Lagegenauigkeitsstufe Sohle","string(1)",
"KG209","Hoehe Sohle","double",
"KG210","Hoehengenauigkeitstufe Sohle","string(1)",
"KG211","Schachttiefe","double",
"KG301","Kanalart","string(1)",
"KG302","Kanalnutzung","string(2)",
"KG303","Baujahr","integer",
"KG304","Materialart","string(4)",
"KG305","Knotenart","string(1)",
"KG306","Bauwerksart","string(4)",
"KG307","Schachtform","string(1)",
"KG308","Schachtlaenge","integer",
"KG309","Schachtbreite","integer",
"KG310","Deckelform","string(1)",
"KG311","Deckelmaterial","string(4)",
"KG312","Deckelklasse","string(1)",
"KG313","Deckelbreite","integer",
"KG314","Deckellaenge","integer",
"KG315","Deckel verschraubt","string(1)",
"KG316","Gerinneform","string(1)",
"KG317","Gerinnematerial","string(4)",
"KG318","Gerinnebreite","integer",
"KG319","Gerinnelaenge","integer",
"KG320","Bermematerial","string(4)",
"KG321","Innenschutz","string(1)",
"KG322","Innenschutzmaterial","string(4)",
"KG323","Steighilfe","string(3)",
"KG324","Anzahl Steigeisen","integer",
"KG325","Steighilfenwerkstoff","string(4)",
"KG326","Messtechnik","string(1)",
"KG401","Funktionszustand","string(1)",
"KG402","Eigentum","string(2)",
"KG403","Wasserschutzzone","string(4)",
"KG404","Lage im Verkehrsraum","string(2)",
"KG405","Grundwasserstand","string(1)",
"KG406","ueberschwemmungsgebiet","string(1)",
"KG407","Status Daten","string(1)",
"KG408","Einstauhaeufigkeit ","string(1)",
"KG409","Bodengruppe","string(2)",
"KG998","Dokument","string",
"KG999","Bemerkung","string"
]



Schacht_FelderISYBAU=[
"d:Objektbezeichnung","Knotenbezeichnung","string(33)",
"d:AlteObjektbezeichnung","Alternative Knotenbezeichnung","string(33)",
"KG101","Strassenschluessel","string(16)",
"d:Lage/d:Strassenname","Strassenname","string",
"KG103","Ortsteilschluessel","string(16)",
"KG104","Ortteilname","string",
"KG105","Gemeindeschluessel","string(16)",
"KG106","Gebietsschluessel","string(16)",
"KG107","Einzugsgebietschluessel","string(26)",
"KG108","Nummer der Klaeranlage","string(16)",
"d:Geometrie/d:Geometriedaten/d:Knoten/d:Punkt[d:PunktattributAbwasser='DMP']/d:Rechtswert","Rechtswert Deckel","double",
"d:Geometrie/d:Geometriedaten/d:Knoten/d:Punkt[d:PunktattributAbwasser='DMP']/d:Hochwert","Hochwert Deckel","double",
"KG203","Lagegenauigkeitsstufe Deckel","string(1)",
"d:Geometrie/d:Geometriedaten/d:Knoten/d:Punkt[d:PunktattributAbwasser='DMP']/d:Punkthoehe","Hoehe Deckel","double",
"KG205","Hoehengenauigkeitsstufe Deckel","string(1)",
"d:Geometrie/d:Geometriedaten/d:Knoten/d:Punkt[d:PunktattributAbwasser='SMP']/d:Rechtswert","Rechtswert Sohle","double",
"d:Geometrie/d:Geometriedaten/d:Knoten/d:Punkt[d:PunktattributAbwasser='SMP']/d:Hochwert","Hochwert Sohle","double",
"KG208","Lagegenauigkeitsstufe Sohle","string(1)",
"d:Geometrie/d:Geometriedaten/d:Knoten/d:Punkt[d:PunktattributAbwasser='SMP']/d:Punkthoehe","Hoehe Sohle","double",
"KG210","Hoehengenauigkeitstufe Sohle","string(1)",
"d:Geometrie/d:Geometriedaten/d:Knoten/d:Schacht/d:Schachttiefe","Schachttiefe","double",
"KG301","Kanalart","string(1)",
"d:Entwaesserungsart","Kanalnutzung","string(2)",
"d:Baujahr","Baujahr","integer",
"d:Knoten/d:Schacht/d:Aufbau/d:MaterialAufbau","Materialart","string(4)",
"d:Knoten/d:KnotenTyp/d:KnotenTyp","Knotenart","string(1)",
"d:Knoten/d:Schacht/d:SchachtFunktion","Bauwerksart","string(4)",
"d:Knoten/d:Schacht/d:Aufbau/d:Aufbauform","Schachtform","string(1)",
"d:Knoten/d:Schacht/d:Aufbau/d:BreiteAufbau","Schachtlaenge","integer",
"d:Knoten/d:Schacht/d:Aufbau/d:Aufbauform","Schachtbreite","integer",
"d:Knoten/d:Schacht/d:Aufbau/d:Abdeckplatte","Abdeckplatte","string(1)",
"d:Knoten/d:Schacht/d:Aufbau/d:Konus","Konus","string(1)",
"KG311","Deckelmaterial","string(4)",
"d:Knoten/d:Schacht/d:Abdeckung/d:Abdeckungsklasse","Deckelklasse","string(1)",
"d:Knoten/d:Schacht/d:Abdeckung/d:BreiteDeckel","Deckelbreite","double",
"d:Knoten/d:Schacht/d:Abdeckung/d:LaengeDeckel","Deckellaenge","double",
"KG315","Deckel verschraubt","string(1)",
"d:Knoten/d:Schacht/d:Unterteil/d:Gerinneform","Gerinneform","string(1)",
"d:Knoten/d:Schacht/d:Unterteil/d:MaterialUnterteil","Gerinnematerial","string(4)",
"d:Knoten/d:Schacht/d:Unterteil/d:BreiteUnterteil","Gerinnebreite","double",
"d:Knoten/d:Schacht/d:Unterteil/d:LaengeUnterteil","Gerinnelaenge","double",
"KG320","Bermematerial","string(4)",
"d:Knoten/d:Schacht/d:Innenschutz","Innenschutz","string(1)",
"KG322","Innenschutzmaterial","string(4)",
"KG323","Steighilfe","string(3)",
"KG324","Anzahl Steigeisen","integer",
"KG325","Steighilfenwerkstoff","string(4)",
"KG326","Messtechnik","string(1)",
"KG401","Funktionsinspektion","string(1)",
"KG402","Eigentum","string(2)",
"d:Umweltparameter/d:Wasserschutzzone","Wasserschutzzone","string(4)",
"KG404","Lage im Verkehrsraum","string(2)",
"KG405","Grundwasserstand","string(1)",
"KG406","ueberschwemmungsgebiet","string(1)",
"KG407","Status Daten","string(1)",
"KG408","Einstauhaeufigkeit ","string(1)",
"KG409","Bodengruppe","string(2)",
"KG998","Dokument","string",
"KG999","Bemerkung","string"
]



Haltung_FelderDWA=[
"HG001","Haltungsbezeichnung","string(33)",
"HG002","Alternative Bezeichnung","string(33)",
"HG003","Schacht oben","string(16)",
"HG004","Schacht unten","string(16)",
"HG005","Bezeichnung Endpunkt","string(33)",
"HG006","Objekttyp bei Anschlussleitung","string(1)",
"HG007","Stationierung Anschlussleitung","double",
"HG008","Stationierungsrichtung Anschluss","string(1)",
"HG009","Lageangabe des Anschlusses","string(2)",
"HG010","Typ Endpunkt","string(2)",
"HG011","Leitungsbezeichnung","string(33)",
"HG012","Kind von","string(33)",
"HG101","Strassenschluessel","string(16)",
"HG102","Strassenname","string",
"HG103","Ortsteilschluessel","string(16)",
"HG104","Ortsteilname","string",
"HG105","Gemeindeschluessel","string(6)",
"HG106","Gebietsschluessel","string(6)",
"HG107","Einzugsgebietschluessel","string(6)",
"HG108","Nummer der Klaeranlage","string(16)",
"HG201","Rechtswert Rohrsohle oben","double",
"HG202","Hochwert Rohrsohle oben","double",
"HG203","Lagegenauigkeitsstufe RSo","string(1)",
"HG204","Hoehe Rohrsohle oben","double",
"HG205","Hoehengenauigkeitsstufe RSo","string(1)",
"HG206","Rechtswert Rohrsohle unten","double",
"HG207","Hochwert Rohrsohle unten","double",
"HG208","Lagegenauigkeitsstufe RHu","string(1)",
"HG209","Hoehe Rohrsohle unten","double",
"HG210","Hoehengenauigkeitsstufe RSu","string(1)",
"HG301","Kanalart","string(2)",
"HG302","Kanalnutzung","string(2)",
"HG303","Baujahr","integer",
"HG304","Materialart","string(4)",
"HG305","Profilart","string(2)",
"HG306","Profilbreite","integer",
"HG307","Profilhoehe","integer",
"HG308","Profilauskleidung","string(1)",
"HG309","Profilauskleidungsmaterial","string(4)",
"HG310","Haltungslaenge","double",
"HG311","Haltungsgefaelle","double",
"HG312","Mittlere Tiefe","double",
"HG313","Haltungsart","string(1)",
"HG314","Rohrlaenge","double",
"HG315","Status Profilangaben","string(1)",
"HG316","Profilauskleidung selbsttragend","string",
"HG401","Funktionszustand","string(1)",
"HG402","Eigentum","string(2)",
"HG403","Wasserschutzzone","string(4)",
"HG404","Lage im Verkehrsraum","string(2)",
"HG405","Grundwasserstand","string(1)",
"HG406","ueberschwemmungsgebiet","string(1)",
"HG407","Status Daten","string(1)",
"HG408","Einstauhaeufigkeit","string(1)",
"HG409","Bodengruppe","string(2)",
"HG410","Wanddicke","integer",
"HG411","Lagerungsart","string(1)",
"HG998","Dokument","string",
"HG999","Bemerkung","string"
]


Haltung_FelderISYBAU=[
"d:Objektbezeichnung","Haltungsbezeichnung","string(33)",
"HG002","Alternative Bezeichnung","string(33)",
"d:Kante/d:KnotenZulauf","Schacht oben","string(16)",
"d:Kante/d:KnotenAblauf","Schacht unten","string(16)",
"HG005","Bezeichnung Endpunkt","string(33)",
"HG006","Objekttyp bei Anschlussleitung","string(1)",
"HG007","Stationierung Anschlussleitung","double",
"HG008","Stationierungsrichtung Anschluss","string(1)",
"HG009","Lageangabe des Anschlusses","string(2)",
"HG010","Typ Endpunkt","string(2)",
"HG011","Leitungsbezeichnung","string(33)",
"HG012","Kind von","string(33)",
"HG101","Strassenschluessel","string(16)",
"d:Lage/d:Strassenname","Strassenname","string",
"HG103","Ortsteilschluessel","string(16)",
"d:Lage/d:Ortsteilname","Ortsteilname","string",
"HG105","Gemeindeschluessel","string(6)",
"HG106","Gebietsschluessel","string(6)",
"HG107","Einzugsgebietschluessel","string(6)",
"HG108","Nummer der Klaeranlage","string(16)",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Start/d:Rechtswert","Rechtswert Rohrsohle oben","double",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Start/d:Hochwert","Hochwert Rohrsohle oben","double",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Star/d:Lagegenauigkeitsstufe","Lagegenauigkeitsstufe RSo","integer",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Start/d:Punkthoehe","Hoehe Rohrsohle oben","double",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Start/d:Hoehengenauigkeitsstufe","Hoehengenauigkeitsstufe RSo","integer",

"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Ende/d:Rechtswert","Rechtswert Rohrsohle unten","double",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Ende/d:Hochwert","Hochwert Rohrsohle unten","double",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Ende/d:Lagegenauigkeitsstufe","Lagegenauigkeitsstufe RSu","integer",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Ende/d:Punkthoehe","Hoehe Rohrsohle unten","double",
"d:Geometrie/d:Geometriedaten/d:Kanten/d:Kante/d:Ende/d:Hoehengenauigkeitsstufe","Hoehengenauigkeitsstufe RSu","integer",
"d:Entwaesserungsart","Kanalart","string(2)",
"d:Umweltparameter/d:Abwasserart","Kanalnutzung","string(2)",
"d:Baujahr","Baujahr","integer",
"d:Kante/d:Material","Materialart","string(4)",
"d:Kante/d:Profil/d:Profilart","Profilart","string(2)",
"d:Kante/d:Profil/d:Profilbreite","Profilbreite","integer",
"d:Kante/d:Profil/d:Profilhoehe","Profilhoehe","integer",
"HG308","Profilauskleidung","string(1)",
"HG309","Profilauskleidungsmaterial","string(4)",
"d:Kante/d:Haltung/d:DMPLaenge","Haltungslaenge","double",
"HG311","Haltungsgefaelle","double",
"HG312","Mittlere Tiefe","double",
"HG313","Haltungsart","string(1)",
"d:Kante/d:Haltung/d:Rohrlaenge","Rohrlaenge","double",
"HG315","Status Profilangaben","string(1)",
"HG316","Profilauskleidung selbsttragend","string",
"HG401","Funktionsinspektion","string(1)",
"HG402","Eigentum","string(2)",
"d:Umweltparameter/d:Wasserschutzzone","Wasserschutzzone","string(4)",
"HG404","Lage im Verkehrsraum","string(2)",
"HG405","Grundwasserstand","string(1)",
"HG406","ueberschwemmungsgebiet","string(1)",
"HG407","Status Daten","string(1)",
"HG408","Einstauhaeufigkeit","string(1)",
"d:Umweltparameter/d:Bodenart","Bodengruppe","string(2)",
"HG410","Wanddicke","integer",
"HG411","Lagerungsart","string(1)",
"HG998","Dokument","string",
"HG999","Bemerkung","string"
]


Inspektions_Felder=[
"HI001","Auftraggeber","string",
"HI002","Projektnummer","string(8)",
"HI003","inspektionsnummer","string(16)",
"HI004","inspektionsgrund","string(1)",
"HI005","Kodierystem","string(20)",
"HI006","Eingesetzes Kamerasystem","string",
"HI007","Bearbeitungsstatus","string(2)",
"HI008","Bearbeitungshinweis","string",
"HI101","Inspektionsrichtung","string(1)",
"HI102","Bezugspunkt Start","string(1)",
"HI103","Inspektionsart","string(3)",
"HI104","Inspektionsdatum","string",
"HI105","Inspektionszeit","string(8)",
"HI106","Wetter","string(7)",
"HI107","Reinigung","string(1)",
"HI108","Temperatur","integer",
"HI109","Vorflutsicherung","string(1)",
"HI110","Wasserspiegel","integer",
"HI111","Firma","string",
"HI112","Inspekteur","string",
"HI113","Bauleitung","string",
"HI114","Videospeichermedium","string(4)",
"HI115","Name des Speichermediums","string",
"HI116","Dateiname digitales Video","string",
"HI117","Fotospeichermedium","string(7)",
"HI201","Meldung","string(1)",
"HI202","Datum der Meldung","string",
"HI203","Melder","string",
"HI204","Datum der Beurteilung","string",
"HI205","Beurteiler","string",
"HI206","max Haltungsklasse Dichtheit","integer",
"HI207","max Haltungsklasse Standsicherheit","integer",
"HI208","max Haltungsklasse Betriebssicherheit","integer",
"HI209","inspektionspunkte Dichtheit","integer",
"HI210","inspektionspunkte Standsicherheit","integer",
"HI211","inspektionspunkte Betriebssicherheit","integer",
"HI212","Bewertungspunkte Dichtheit","integer",
"HI213","Bewertungspunkte Standsicherheit","integer",
"HI214","Bewertungspunkte Betriebssicherheit","integer",
"HI215","Sanierungsbedarfszahl","integer",
"HI216","Beurteilung Klasse","integer",
"HI217","Prioritaet","integer",
"HI998","Dokument","string",
"HI999","Bemerkung","string"
]

Stations_Felder=[
"HZ001","Station","double",
"HZ002","Kode","string(5)",
"HZ014","Charakterisierung 1","string(6)",
"HZ015","Charakterisierung 2","string(2)",
"HZ003","Quantifizierung 1","double",
"HZ004","Quantifizierung 2","double",
"HZ005","Streckenschaden","string(3)",
"HZ006","Position von","string(2)",
"HZ007","Position nach","string(2)",
"HZ008","Videozaehlerstand","string",
"HZ009","Bildname","string",
"HZ010","Langtext","string",
"HZ011","Verbindung","string(1)",
"HZ012","Auskleidung","string",
"HZ016","Punktuelle Reparatur","string(1)",
"HZ017","Standardisierte Anmerkung","string",
"HZ201","Meldung","string(1)",
"HZ202","Datum der Meldung","string",
"HZ203","Melder","string",
"HZ204","Datum der Klassifizierung","string",
"HZ205","Klassifizierer","string",
"HZ206","Zustandsklasse Dichtheit","integer",
"HZ207","Zustandsklasse Standsicherheit","integer",
"HZ208","Zustandsklasse Betriebssicherheit","integer",
"HZ997","Platzhalter kameraspezifische Kennung","string",
"HZ998","Dokument","string",
"HZ999","Bemerkung","string"
]

Inspektions_FelderSchacht=[
"KI001","Auftraggeber","string",
"KI002","Projektnummer","string(8)",
"KI003","Inspektionsnummer","integer",
"KI004","Inspektionsgrund","string(1)",
"KI005","Kodiersystem","string(20)",
"KI006","Eingesetzes Kamerasystem","string",
"KI007","Bearbeitungsstatus","string(2)",
"KI008","Bearbeitungshinweis","string",
"KI101","vertikaler Bezugspunkt","string(5)",
"KI102","Bezugspunkt am Umfang","string(5)",
"KI103","Inspektionsart","string(3)",
"KI104","Inspektionsdatum","string",
"KI105","Inspektionszeit","string(8)",
"KI106","Wetter","string(7)",
"KI107","Reinigung","string(1)",
"KI108","Temperatur","integer",
"KI109","Vorflutsicherung","string(1)",
"KI110","Wasserspiegel","integer",
"KI111","Firma","string",
"KI112","Inspekteur","string",
"KI113","Bauleitung","string",
"KI114","Videospeichermedium","string(4)",
"KI115","Name des Speichermediums","string",
"KI116","Dateiname digitales Video","string",
"KI117","Fotospeichermedium","string(7)",
"KI118","Digitaler Fotoname","string",
"KI119","Betriebssicher","string",
"KI120","Konusrichtig","string",
"KI121","Umgebungsluft","string(1)",
"KI122","Umgebungsfoto","string",
"KI201","Meldung","string(1)",
"KI202","Datum der Meldung","string",
"KI203","Melder","string",
"KI204","Datum der Beurteilung","string",
"KI205","Beurteiler","string",
"KI206","max. Knotenklasse Dichtheit","integer",
"KI207","max. Knotenklasse Standsicherheit","integer",
"KI208","max. Knotenklasse Betriebssicherheit","integer",
"KI209","Zustandspunkte Dichtheit","integer",
"KI210","Zustandspunkte Standsicherheit","integer",
"KI211","Zustandspunkte Betriebssicherheit","integer",
"KI212","Bewertungspunkte Dichtheit","integer",
"KI213","Bewertungspunkte Standsicherheit","integer",
"KI214","Bewertungspunkte Betriebssicherheit","integer",
"KI215","Sanierungsbedarfszahl","integer",
"KI216","Beurteilung","integer",
"KI217","Prioritaet","integer",
"KI998","Dokument","string",
"KI999","Bemerkung","string"
]

Stations_FelderSchacht=[
"KZ001","Tiefe","double",
"KZ002","Kode","string(5)",
"KZ014","Charakterisierung 1","string(6)",
"KZ015","Charakterisierung 2","string(2)",
"KZ003","Quantifizierung 1","double",
"KZ004","Quantifizierung 2","double",
"KZ005","Streckenschaden","string(3)",
"KZ006","Position Beginn","string(2)",
"KZ007","Position Ende","string(2)",
"KZ008","Videozaehlerstand","string",
"KZ009","Bildname","string",
"KZ010","Langtext des Zustandes","string",
"KZ011","Verbindung","string(1)",
"KZ013","Schachtbereich","string(3)",
"KZ016","Punktuelle Reparatur","string(1)",
"KZ017","Standardisierte Anmerkung ","string(2)",
"KZ201","Meldung","string(1)",
"KZ202","Datum der Meldung","string",
"KZ203","Melder","string",
"KZ204","Datum der Klassifizierung","string",
"KZ205","Klassifizierer","string",
"KZ206","Zustandsklasse Dichtheit","integer",
"KZ207","Zustandsklasse Standsicherheit","integer",
"KZ208","Zustandsklasse Betriebssicherheit","integer",
"KZ997","Platzhalter für kameraspezifische Kennung","string",
"KZ998","Dokument","string",
"KZ999","Bemerkung","string"
]

linz_epsg_mapping = {
    'COLLTM2000':2114,
    'COLLTM1949':27214,
    'GAWLTM2000':2125,
    'GAWLTM1949':27225,
    'GREYTM2000':2118,
    'GREYTM1949':27218,
    'HAWKTM2000':2108,
    'HAWKTM1949':27208,
    'HOKITM2000':2121,
    'HOKITM1949':27221,
    'JACKTM2000':2123,
    'JACKTM1949':27223,
    'KARATM2000':2116,
    'KARATM1949':27216,
    'LINDTM2000':2127,
    'LINDTM1949':27227,
    'MARLTM2000':2120,
    'MARLTM1949':27220,
    'EDENTM2000':2105,
    'EDENTM1949':27205,
    'PLEATM2000':2124,
    'PLEATM1949':27224,
    'YORKTM2000':2129,
    'YORKTM1949':27229,
    'NICHTM2000':2128,
    'NICHTM1949':27228,
    'NELSTM2000':2115,
    'NELSTM1949':27215,
    'TAIETM2000':2131,
    'TAIETM1949':27231,
    'OBSETM2000':2130,
    'OBSETM1949':27230,
    'OKARTM2000':2122,
    'OKARTM1949':27222,
    'POVETM2000':2107,
    'POVETM1949':27207,
    'TARATM2000':2109,
    'TARATM1949':27209,
    'TIMATM2000':2126,
    'TIMATM1949':27226,
    'TUHITM2000':2110,
    'TUHITM1949':27210,
    'WAIRTM2000':2112,
    'WAIRTM1949':27212,
    'WANGTM2000':2111,
    'WANGTM1949':27211,
    'WELLTM2000':2113,
    'WELLTM1949':27213,
    'NZGD1949':4272,
    'NZGD2000':4167,
    'NZMG':27200,
    'NZTM':2193
}

latlon_coordsys = {
    'NZGD1949':1,
    'NZGD2000':1,
}
