# -*- coding: utf-8 -*-
"""
/***************************************************************************
 m150xml
                                 A QGIS plugin
 Import Lines and Points (Manholes and sewers) from  DWA XML 150
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-12-18
        git sha              : $Format:%H$
        copyright            : (C) 2019 by gerd 3er geoplaning GmbH
        email                : kontakt@geoplaning.de

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox
from qgis.PyQt.QtCore import  QRegExp, Qt

from qgis.core import *


# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .m150xml_dialog import m150xmlDialog
import os.path

import string
import math
import sys

from shapely.geometry import MultiPolygon,MultiLineString
from .m150xmlimp import *
from .m150xmlimpdata import *

class m150xml:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'm150xml_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&DWA M150 XML Import')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('m150xml', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/m150xml/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'M150 XML Import'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&DWA M150 XML Import'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = m150xmlDialog()
            self.browsePathSetting="/plugins/M150XML/BrowsePath"
            self._home = QSettings().value(self.browsePathSetting,'')

            #Signals
            self.dlg.uBrowseXmlFile.clicked.connect(self._browseXmlFile)
            self.dlg.uButtonBox.accepted.connect(self._accept)
            self.xOffset=0 #-32000000.0


        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def _browseXmlFile(self):
        filename = QFileDialog.getOpenFileName(self.dlg,"Select M150Xml file", self._home, "M150 Xml files (*.xml);;ISYBAU Xml files (*.xml);;All files (*.*)")[0]
        if filename:
            self.dlg.uXmlFile.setText(filename)


    def _accept(self):
        filename = unicode(self.dlg.uXmlFile.text())
        homedir = os.path.dirname(filename)
        settings = QSettings()
        settings.setValue(self.browsePathSetting,homedir)

       
        if not filename:
            QMessageBox.information(self.dlg,"M150Xml error","You must specify a M150Xml file to import")
            return
        if not os.path.exists(filename):
            QMessageBox.information(self.dlg,"M150Xml error","Cannot open " + filename)
            return

        #try:
        if QRegExp('\.xml$', Qt.CaseInsensitive).indexIn(filename)>-1:
            self.dlg.uXmlFile.setText(filename)

            data = M150XmlImp(filename)
            if self.dlg.uImportParcels.isChecked():
                self._createHaltungsLayer(data)
            if self.dlg.uImportMarks.isChecked():
                self._createSchachtLayer(data)                
            if self.dlg.uImportObs.isChecked():
                self._createInspektionsLayer(data)
                self._createStationsLayer(data)
                self._createInspektionsLayerSchacht(data)
                self._createStationsLayerSchacht(data)


        # except:
        #     raise
        #     message = unicode(sys.exc_info()[1])
        #     QMessageBox.information(self.dlg,"M150Xml error","Problem importing xml\n"+message)


    def _createSchachtLayer(self,data):
        name = "Schacht_M150"
        #uri="Point?"+"&".join(['field='+x for x in Schacht_Felder])
        uri ="Point?encoding=utf-8&field=oid:integer&"
            
        for i in range(0,len(data._Schacht_Felder),3):
            uri += "field="+ str(data._Schacht_Felder[i+1]).replace(' ','_')  +':'+ data._Schacht_Felder[i+2]+'&' 
            
        uri += "field=Temp:string"


        #epsg = data.coordSysEpsgId()
        #if epsg:
        #    uri += '&crs=epsg:'+unicode(epsg)

        uri += '&crs=epsg:'+unicode('25832')
        vl = QgsVectorLayer(uri,name,"memory")
        # Need to do something about crs()
        

        vl.startEditing()
        fields=vl.fields()
        pr=vl.dataProvider()
        lfdnr=0
        for schacht in data.schaechte():
        
            feat = QgsFeature(fields)
           

            lfdnr+=1
            feat['oid']=lfdnr

            #Felder fuettern
            for i in range(0,len(data._Schacht_Felder),3):
                if schacht[data._Schacht_Felder[i+1]]:
                    content = schacht[data._Schacht_Felder[i+1]]
                    feat.setAttribute(str(data._Schacht_Felder[i+1]).replace(' ','_'),content)

            # Koordinaten hinzufuegen'
            x=schacht['X1']+self.xOffset
            y=schacht['Y1']
            z=schacht['Z1']
            pt_z= QgsPoint(x,y,z).asWkt()
            feat.setGeometry(QgsGeometry.fromWkt(pt_z))
            
            

            #try:
            pr.addFeatures([feat])
            #except:
            #    raise
            #    gsMessageLog.logMessage("Attribute NOT loaded:"+str(lfdnr), 'M150xml', Qgis.Info)



        if lfdnr>0:
            vl.updateExtents()
            vl.commitChanges()
            ret = QgsProject.instance().addMapLayer(vl)
            
            locale_path = os.path.join(os.path.dirname(__file__),'BrowsePath')
            sldfilename = os.path.normpath(locale_path +'\\Schacht_M150.qml')

            if os.path.exists(sldfilename):
                # ret = vl.loadSldStyle(sldfilename)
                ret = vl.loadNamedStyle(sldfilename)
                if ret:
                    QgsMessageLog.logMessage("Style loaded", 'M150xml', Qgis.Info)
                else:
                    QgsMessageLog.logMessage("Style NOT loaded", 'M150xml', Qgis.Info)

            ret = vl.triggerRepaint()





    def _createHaltungsLayer(self,data):
        name = "Haltung_M150"
        
        uri ="LineString?encoding=utf-8&field=oid:integer&"
            
        for i in range(0,len(data._Haltung_Felder),3):
            uri += "field="+ str(data._Haltung_Felder[i+1]).replace(' ','_')  +':'+ data._Haltung_Felder[i+2]+'&' 
            
        uri += "field=Temp:string"



        #epsg = data.coordSysEpsgId()
        #if epsg:
        #    uri += '&crs=epsg:'+unicode(epsg)
        uri += '&crs=epsg:'+unicode('25832')
        vl = QgsVectorLayer(uri,name,"memory")
        # Need to do something about crs()
        

        vl.startEditing()
        fields=vl.fields()
        pr=vl.dataProvider()
        lfdnr=0
        for haltung in data.haltungen():
        
            feat = QgsFeature(fields)
           

            lfdnr+=1
            feat['oid']=lfdnr
            
            #Felder fuettern            

            for i in range(0,len(data._Haltung_Felder),3):
                if haltung[data._Haltung_Felder[i+1]] :
                    content = haltung[data._Haltung_Felder[i+1]]
                    feat.setAttribute(str(data._Haltung_Felder[i+1]).replace(' ','_'),content)

            # Koordinaten hinzufuegen'
            x1=haltung['X1']+self.xOffset
            y1=haltung['Y1']
            z1=haltung['Z1']
            x2=haltung['X2']+self.xOffset
            y2=haltung['Y2']
            z2=haltung['Z2']

            feat.setGeometry(QgsGeometry.fromPolyline( [QgsPoint(x1,y1,z1),QgsPoint(x2,y2,z2)]))
        
            try:
                pr.addFeatures([feat])
            except:
                raise
                QgsMessageLog.logMessage("Attribute NOT loaded:"+str(lfdnr), 'M150xml', Qgis.Info)



        if lfdnr>0:
            vl.updateExtents()
            vl.commitChanges()
            ret = QgsProject.instance().addMapLayer(vl)
                    
            locale_path = os.path.join(os.path.dirname(__file__),'BrowsePath')
            sldfilename = os.path.normpath(locale_path +'\\Haltung_M150.qml')

            if os.path.exists(sldfilename):
                # ret = vl.loadSldStyle(sldfilename)
                ret = vl.loadNamedStyle(sldfilename)
                if ret:
                    QgsMessageLog.logMessage("Style loaded", 'M150xml', Qgis.Info)
                else:
                    QgsMessageLog.logMessage("Style NOT loaded", 'M150xml', Qgis.Info)

            ret = vl.triggerRepaint()


    def _createInspektionsLayer(self,data):
        name = "Inspektion_M150"
       
        uri ="Point?encoding=utf-8&field=oid:integer&field=id:string(33)&"
            
            
        for i in range(0,len(Inspektions_Felder),3):
            uri += "field="+ str(Inspektions_Felder[i+1]).replace(' ','_')  +':'+ Inspektions_Felder[i+2]+'&'         

        uri += "field=Temp:string"



        #epsg = data.coordSysEpsgId()
        #if epsg:
        #    uri += '&crs=epsg:'+unicode(epsg)
        uri += '&crs=epsg:'+unicode('25832')
        vl = QgsVectorLayer(uri,name,"memory")
        # Need to do something about crs()
        

        vl.startEditing()
        fields=vl.fields()
        pr=vl.dataProvider()
        lfdnr=0
        for inspektion in data.inspektionen():
        
            feat = QgsFeature(fields)
            lfdnr+=1
            feat['oid']=lfdnr

            feat['id']=inspektion['ID']

            #Felder fuettern
            for i in range(0,len(Inspektions_Felder),3):
                if inspektion[Inspektions_Felder[i+1]] :

                    content = inspektion[Inspektions_Felder[i+1]]
                    feat.setAttribute(str(Inspektions_Felder[i+1]).replace(' ','_'),content)


            # Koordinaten hinzufuegen'
            x=(inspektion['X1']+inspektion['X2'])/2+self.xOffset
            y=(inspektion['Y1']+inspektion['Y2'])/2
            
            feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x,y)))
            
            try:
                pr.addFeatures([feat])
            except:
                raise
                gsMessageLog.logMessage("Attribute NOT loaded:"+str(lfdnr), 'M150xml', Qgis.Info)


        if lfdnr>0:
            vl.updateExtents()
            vl.commitChanges()
            ret = QgsProject.instance().addMapLayer(vl)
            
            
            locale_path = os.path.join(os.path.dirname(__file__),'BrowsePath')
            sldfilename = os.path.normpath(locale_path +'\\Inspektion_M150.qml')

            if os.path.exists(sldfilename):
                # ret = vl.loadSldStyle(sldfilename)
                ret = vl.loadNamedStyle(sldfilename)
                if ret:
                    QgsMessageLog.logMessage("Style loaded", 'M150xml', Qgis.Info)
                else:
                    QgsMessageLog.logMessage("Style NOT loaded", 'M150xml', Qgis.Info)

            ret = vl.triggerRepaint()

   

    def _createStationsLayer(self,data):
        name = "Stationen_M150"
       
        uri ="Point?encoding=utf-8&field=oid:integer&field=id:string(33)&field=id2:string(33)&field=ws:double&"
            
            
        for i in range(0,len(Stations_Felder),3):
            uri += "field="+ str(Stations_Felder[i+1]).replace(' ','_')  +':'+ Stations_Felder[i+2]+'&'         

        uri += "field=Temp:string"



        #epsg = data.coordSysEpsgId()
        #if epsg:
        #    uri += '&crs=epsg:'+unicode(epsg)
        uri += '&crs=epsg:'+unicode('25832')
        vl = QgsVectorLayer(uri,name,"memory")
        # Need to do something about crs()
        

        vl.startEditing()
        fields=vl.fields()
        pr=vl.dataProvider()
        lfdnr=0
        for station in data.stationen():
        
            feat = QgsFeature(fields)
            lfdnr+=1
            feat['oid']=lfdnr

            feat['id']=station['ID']
            feat['id2']=station['ID2']
            feat['ws']=station['ws']

            #Felder fuettern
            for i in range(0,len(Stations_Felder),3):
                if station[Stations_Felder[i+1]] :

                    content = station[Stations_Felder[i+1]]
                    feat.setAttribute(str(Stations_Felder[i+1]).replace(' ','_'),content)


            # Koordinaten hinzufuegen'
            x=station['X1']+self.xOffset
            y=station['Y1']
            
            feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x,y)))
            
            try:
                pr.addFeatures([feat])
            except:
                raise
                gsMessageLog.logMessage("Attribute NOT loaded:"+str(lfdnr), 'M150xml', Qgis.Info)



        if lfdnr>0:
            vl.updateExtents()
            vl.commitChanges()
            ret = QgsProject.instance().addMapLayer(vl)
            
            
            locale_path = os.path.join(os.path.dirname(__file__),'BrowsePath')
            sldfilename = os.path.normpath(locale_path +'\\Station_M150.qml')

            if os.path.exists(sldfilename):
                # ret = vl.loadSldStyle(sldfilename)
                ret = vl.loadNamedStyle(sldfilename)
                if ret:
                    QgsMessageLog.logMessage("Style loaded", 'M150xml', Qgis.Info)
                else:
                    QgsMessageLog.logMessage("Style NOT loaded", 'M150xml', Qgis.Info)

            ret = vl.triggerRepaint()

   
    def _createInspektionsLayerSchacht(self,data):
        name = "Inspektion_M150Schacht"
       
        uri ="Point?encoding=utf-8&field=oid:integer&field=id:string(33)&"
            
            
        for i in range(0,len(Inspektions_FelderSchacht),3):
            uri += "field="+ str(Inspektions_FelderSchacht[i+1]).replace(' ','_')  +':'+ Inspektions_FelderSchacht[i+2]+'&'         

        uri += "field=Temp:string"



        #epsg = data.coordSysEpsgId()
        #if epsg:
        #    uri += '&crs=epsg:'+unicode(epsg)
        uri += '&crs=epsg:'+unicode('25832')
        vl = QgsVectorLayer(uri,name,"memory")
        # Need to do something about crs()
        

        vl.startEditing()
        fields=vl.fields()
        pr=vl.dataProvider()
        
        lfdnr = 0


        for inspektionSchacht in data.inspektionenSchacht():
        
            feat = QgsFeature(fields)
            lfdnr+=1
            feat['oid']=lfdnr

            feat['id']=inspektionSchacht['ID']

            #Felder fuettern
            for i in range(0,len(Inspektions_Felder),3):
                if inspektionSchacht[Inspektions_FelderSchacht[i+1]] :
                    content = inspektionSchacht[Inspektions_FelderSchacht[i+1]]
                    feat.setAttribute(str(Inspektions_FelderSchacht[i+1]).replace(' ','_'),content)


            # Koordinaten hinzufuegen'
            x=inspektionSchacht['X1']+self.xOffset
            y=inspektionSchacht['Y1']
            
            feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x,y)))
            
            try:
                pr.addFeatures([feat])
            except:
                raise
                gsMessageLog.logMessage("Attribute NOT loaded:"+str(lfdnr), 'M150xml', Qgis.Info)


        if lfdnr>0:
            vl.updateExtents()
            vl.commitChanges()
            ret = QgsProject.instance().addMapLayer(vl)
            
            
            locale_path = os.path.join(os.path.dirname(__file__),'BrowsePath')
            sldfilename = os.path.normpath(locale_path +'\\Inspektion_M150Schacht.qml')

            if os.path.exists(sldfilename):
                # ret = vl.loadSldStyle(sldfilename)
                ret = vl.loadNamedStyle(sldfilename)
                if ret:
                    QgsMessageLog.logMessage("Style loaded", 'M150xml', Qgis.Info)
                else:
                    QgsMessageLog.logMessage("Style NOT loaded", 'M150xml', Qgis.Info)

            ret = vl.triggerRepaint()

   

    def _createStationsLayerSchacht(self,data):
        name = "Stationen_M150Schacht"
        
        uri ="Point?encoding=utf-8&field=oid:integer&field=id:string(33)&field=id2:string(33)&field=ws:double&"
            
            
        for i in range(0,len(Stations_FelderSchacht),3):
            uri += "field="+ str(Stations_FelderSchacht[i+1]).replace(' ','_')  +':'+ Stations_FelderSchacht[i+2]+'&'         

        uri += "field=Temp:string"



        #epsg = data.coordSysEpsgId()
        #if epsg:
        #    uri += '&crs=epsg:'+unicode(epsg)
        uri += '&crs=epsg:'+unicode('25832')
        vl = QgsVectorLayer(uri,name,"memory")
        # Need to do something about crs()
        

        vl.startEditing()
        fields=vl.fields()
        pr=vl.dataProvider()
        lfdnr=0
        for stationSchacht in data.stationenSchacht():
        
            feat = QgsFeature(fields)
            lfdnr+=1
            feat['oid']=lfdnr

            feat['id']=stationSchacht['ID']
            feat['id2']=stationSchacht['ID2']
            feat['ws']=stationSchacht['ws']

            #Felder fuettern
            for i in range(0,len(Stations_FelderSchacht),3):
                if stationSchacht[Stations_FelderSchacht[i+1]] :
                    content = stationSchacht[Stations_FelderSchacht[i+1]]
                    feat.setAttribute(str(Stations_FelderSchacht[i+1]).replace(' ','_'),content)


            # Koordinaten hinzufuegen'
            x=stationSchacht['X1']+self.xOffset
            y=stationSchacht['Y1']
            
            feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x,y)))
            
            try:
                pr.addFeatures([feat])
            except:
                raise
                gsMessageLog.logMessage("Attribute NOT loaded:"+str(lfdnr), 'M150xml', Qgis.Info)

        if lfdnr>0:
            vl.updateExtents()
            vl.commitChanges()
            ret = QgsProject.instance().addMapLayer(vl)
            
            
            locale_path = os.path.join(os.path.dirname(__file__),'BrowsePath')
            sldfilename = os.path.normpath(locale_path +'\\Station_M150Schacht.qml')

            if os.path.exists(sldfilename):
                # ret = vl.loadSldStyle(sldfilename)
                ret = vl.loadNamedStyle(sldfilename)
                if ret:
                    QgsMessageLog.logMessage("Style loaded", 'M150xml', Qgis.Info)
                else:
                    QgsMessageLog.logMessage("Style NOT loaded", 'M150xml', Qgis.Info)

            ret = vl.triggerRepaint()


