################################################################################
#
# Copyright 2016 geoplaning GmbH 
# All rights reserved
#
# This program is released under the terms of the new BSD license. See the 
# LICENSE file for more information.
#
################################################################################


import re
import xml.etree.ElementTree as et
import math
import string


# -*- coding: utf-8 -*-
import locale
locale.setlocale(locale.LC_ALL, '')

Schacht_Felder=[
'KG001','Knotenbezeichnung','string(33)',
'KG002','Alternative Knotenbezeichnung','string(33)',
'KG101','Strassenschluessel','string(16)',
'KG102','Strassenname','string',
'KG103','Ortsteilschluessel','string(16)',
'KG104','Ortteilname','string',
'KG105','Gemeindeschluessel','string(16)',
'KG106','Gebietsschluessel','string(16)',
'KG107','Einzugsgebietschluessel','string(26)',
'KG108','Nummer der Klaeranlage','string(16)',
'KG201','Rechtswert Deckel','double',
'KG202','Hochwert Deckel','double',
'KG203','Lagegenauigkeitsstufe Deckel','integer',
'KG204','Hoehe Deckel','double',
'KG205','Hoehengenauigkeitsstufe Deckel','integer',
'KG206','Rechtswert Sohle','double',
'KG207','Hochwert Sohle','double',
'KG208','Lagegenauigkeitsstufe Sohle','integer',
'KG209','Hoehe Sohle','double',
'KG210','Hoehengenauigkeitstufe Sohle','integer',
'KG211','Schachttiefe','double',
'KG301','Kanalart','string(1)',
'KG302','Kanalnutzung','string(2)',
'KG303','Baujahr','integer',
'KG304','Materialart','string(4)',
'KG305','Knotenart','string(1)',
'KG306','Bauwerksart','string(4)',
'KG307','Schachtform','string(1)',
'KG308','Schachtlaenge','integer',
'KG309','Schachtbreite','integer',
'KG310','Deckelform','string(1)',
'KG311','Deckelmaterial','string(4)',
'KG312','Deckelklasse','string(1)',
'KG313','Deckelbreite','integer',
'KG314','Deckellaenge','integer',
'KG315','Deckel verschraubt','string(1)',
'KG316','Gerinneform','string(1)',
'KG317','Gerinnematerial','string(4)',
'KG318','Gerinnebreite','integer',
'KG319','Gerinnelaenge','integer',
'KG320','Bermematerial','string(4)',
'KG321','Innenschutz','string(1)',
'KG322','Innenschutzmaterial','string(4)',
'KG323','Steighilfe','string(3)',
'KG324','Anzahl Steigeisen','integer',
'KG325','Steighilfenwerkstoff','string(4)',
'KG326','Messtechnik','string(1)',
'KG401','Funktionsinspektion','string(1)',
'KG402','Eigentum','string(2)',
'KG403','Wasserschutzzone','string(4)',
'KG404','Lage im Verkehrsraum','string(2)',
'KG405','Grundwasserstand','string(1)',
'KG406','ueberschwemmungsgebiet','string(1)',
'KG407','Status Daten','string(1)',
'KG408','Einstauhaeufigkeit ','string(1)',
'KG409','Bodengruppe','string(2)',
'KG998','Dokument','string',
'KG999','Bemerkung','string'
]



Haltung_Felder=[
'HG001','Haltungsbezeichnung','string(33)',
'HG002','Alternative Bezeichnung','string(33)',
'HG003','Schacht oben','string(16)',
'HG004','Schacht unten','string(16)',
'HG005','Bezeichnung Endpunkt','string(33)',
'HG006','Objekttyp bei Anschlussleitung','string(1)',
'HG007','Stationierung Anschlussleitung','string(1)',
'HG008','Stationierungsrichtung Anschluss','string(1)',
'HG009','Lageangabe des Anschlusses','string(2)',
'HG010','Typ Endpunkt','string(2)',
'HG011','Leitungsbezeichnung','string(33)',
'HG012','Kind von','string(33)',
'HG101','Strassenschluessel','string(16)',
'HG102','Strassenname','string',
'HG103','Ortsteilschluessel','string(16)',
'HG104','Ortsteilname','string',
'HG105','Gemeindeschluessel','string(6)',
'HG106','Gebietsschluessel','string(6)',
'HG107','Einzugsgebietschluessel','string(6)',
'HG108','Nummer der Klaeranlage','string(16)',
'HG201','Rechtswert Rohrsohle oben','double',
'HG202','Hochwert Rohrsohle oben','double',
'HG203','Lagegenauigkeitsstufe RSo','integer',
'HG204','Hoehe Rohrsohle oben','double',
'HG205','Hoehengenauigkeitsstufe RSo','integer',
'HG206','Rechtswert Rohrsohle unten','double',
'HG207','Hochwert Rohrsohle unten','double',
'HG208','Lagegenauigkeitsstufe RHu','integer',
'HG209','Hoehe Rohrsohle unten','double',
'HG210','Hoehengenauigkeitsstufe RSu','integer',
'HG301','Kanalart','string(2)',
'HG302','Kanalnutzung','string(2)',
'HG303','Baujahr','integer',
'HG304','Materialart','string(4)',
'HG305','Profilart','string(2)',
'HG306','Profilbreite','integer',
'HG307','Profilhoehe','integer',
'HG308','Profilauskleidung','string(1)',
'HG309','Profilauskleidungsmaterial','string(4)',
'HG310','Haltungslaenge','double',
'HG311','Haltungsgefaelle','double',
'HG312','Mittlere Tiefe','double',
'HG313','Haltungsart','string(1)',
'HG314','Rohrlaenge','double',
'HG315','Status Profilangaben','string(1)',
'HG316','Profilauskleidung selbsttragend','string',
'HG401','Funktionsinspektion','string(1)',
'HG402','Eigentum','string(2)',
'HG403','Wasserschutzzone','string(4)',
'HG404','Lage im Verkehrsraum','string(2)',
'HG405','Grundwasserstand','string(1)',
'HG406','ueberschwemmungsgebiet','string(1)',
'HG407','Status Daten','string(1)',
'HG408','Einstauhaeufigkeit','string(1)',
'HG409','Bodengruppe','string(2)',
'HG410','Wanddicke','integer',
'HG411','Lagerungsart','string(1)',
'HG998','Dokument','string',
'HG999','Bemerkung','string'
]

Inspektions_Felder=[
'HI001','Auftraggeber','string',
'HI002','Projektnummer','string(8)',
'HI003','inspektionsnummer','string(16)',
'HI004','inspektionsgrund','string(1)',
'HI005','Kodierystem','string(20)',
'HI006','Eingesetzes Kamerasystem','string',
'HI007','Bearbeitungsstatus','string(2)',
'HI008','Bearbeitungshinweis','string',
'HI101','inspektionsrichtung','string(1)',
'HI102','Bezugspunkt Start','string(1)',
'HI103','inspektionsart','string(3)',
'HI104','inspektionsdatum','string',
'HI105','inspektionszeit','string(8)',
'HI106','Wetter','string(7)',
'HI107','Reinigung','string(1)',
'HI108','Temperatur','integer',
'HI109','Vorflutsicherung','string(1)',
'HI110','Wasserspiegel','integer',
'HI111','Firma','string',
'HI112','Inspekteur','string',
'HI113','Bauleitung','string',
'HI114','Videospeichermedium','string(4)',
'HI115','Name des Speichermediums','string',
'HI116','Dateiname digitales Video','string',
'HI117','Fotospeichermedium','string(7)',
'HI201','Meldung','string(1)',
'HI202','Datum der Meldung','string',
'HI203','Melder','string',
'HI204','Datum der Beurteilung','string',
'HI205','Beurteiler','string',
'HI206','max Haltungsklasse Dichtheit','integer',
'HI207','max Haltungsklasse Standsicherheit','integer',
'HI208','max Haltungsklasse Betriebssicherheit','integer',
'HI209','inspektionspunkte Dichtheit','integer',
'HI210','inspektionspunkte Standsicherheit','integer',
'HI211','inspektionspunkte Betriebssicherheit','integer',
'HI212','Bewertungspunkte Dichtheit','integer',
'HI213','Bewertungspunkte Standsicherheit','integer',
'HI214','Bewertungspunkte Betriebssicherheit','integer',
'HI215','Sanierungsbedarfszahl','integer',
'HI216','Beurteilung Klasse','integer',
'HI217','Prioritaet','integer',
'HI998','Dokument','string',
'HI999','Bemerkung','string'
]

Stations_Felder=[
'HZ001','Station','double',
'HZ002','Kode','string(5)',
'HZ014','Charakterisierung 1','string(6)',
'HZ015','Charakterisierung 2','string(2)',
'HZ003','Quantifizierung 1','double',
'HZ004','Quantifizierung 2','double',
'HZ005','Streckenschaden','string(3)',
'HZ006','Position von','string(2)',
'HZ007','Position nach','string(2)',
'HZ008','Videozaehlerstand','string',
'HZ009','Bildname','string',
'HZ010','Langtext','string',
'HZ011','Verbindung','string(1)',
'HZ012','Auskleidung','string',
'HZ016','Punktuelle Reparatur','string(1)',
'HZ017','Standardisierte Anmerkung','string(2)',
'HZ201','Meldung','string(1)',
'HZ202','Datum der Meldung','string',
'HZ203','Melder','string',
'HZ204','Datum der Klassifizierung','string',
'HZ205','Klassifizierer','string',
'HZ206','Zustandsklasse Dichtheit','integer',
'HZ207','Zustandsklasse Standsicherheit','integer',
'HZ208','Zustandsklasse Betriebssicherheit','integer',
'HZ997','Platzhalter kameraspezifische Kennung','string',
'HZ998','Dokument','string',
'HZ999','Bemerkung','string'

]

Inspektions_FelderSchacht=[
'KI001','Auftraggeber','string',
'KI002','Projektnummer','string(8)',
'KI003','Inspektionsnummer','integer',
'KI004','Inspektionsgrund','string(1)',
'KI005','Kodiersystem','string(20)',
'KI006','Eingesetzes Kamerasystem','string',
'KI007','Bearbeitungsstatus','string(2)',
'KI008','Bearbeitungshinweis','string',
'KI101','vertikaler Bezugspunkt','string(5)',
'KI102','Bezugspunkt am Umfang','string(5)',
'KI103','Inspektionsart','string(3)',
'KI104','Inspektionsdatum','string',
'KI105','Inspektionszeit','string(8)',
'KI106','Wetter','string(7)',
'KI107','Reinigung','string(1)',
'KI108','Temperatur','integer',
'KI109','Vorflutsicherung','string(1)',
'KI110','Wasserspiegel','integer',
'KI111','Firma','string',
'KI112','Inspekteur','string',
'KI113','Bauleitung','string',
'KI114','Videospeichermedium','string(4)',
'KI115','Name des Speichermediums','string',
'KI116','Dateiname digitales Video','string',
'KI117','Fotospeichermedium','string(7)',
'KI118','Digitaler Fotoname','string',
'KI119','Betriebssicher','string',
'KI120','Konusrichtig','string',
'KI121','Umgebungsluft','string(1)',
'KI122','Umgebungsfoto','string',
'KI201','Meldung','string(1)',
'KI202','Datum der Meldung','string',
'KI203','Melder','string',
'KI204','Datum der Beurteilung','string',
'KI205','Beurteiler','string',
'KI206','max. Knotenklasse Dichtheit','integer',
'KI207','max. Knotenklasse Standsicherheit','integer',
'KI208','max. Knotenklasse Betriebssicherheit','integer',
'KI209','Zustandspunkte Dichtheit','integer',
'KI210','Zustandspunkte Standsicherheit','integer',
'KI211','Zustandspunkte Betriebssicherheit','integer',
'KI212','Bewertungspunkte Dichtheit','integer',
'KI213','Bewertungspunkte Standsicherheit','integer',
'KI214','Bewertungspunkte Betriebssicherheit','integer',
'KI215','Sanierungsbedarfszahl','integer',
'KI216','Beurteilung (Klasse)','integer',
'KI217','Prioritaet','integer',
'KI998','Dokument','string',
'KI999','Bemerkung','string'
]

Stations_FelderSchacht=[
'KZ001','Tiefe','double',
'KZ002','Kode','string(5)',
'KZ014','Charakterisierung 1','string(6)',
'KZ015','Charakterisierung 2','string(2)',
'KZ003','Quantifizierung 1','double',
'KZ004','Quantifizierung 2','double',
'KZ005','Streckenschaden','string(3)',
'KZ006','Position Beginn','string(2)',
'KZ007','Position Ende','string(2)',
'KZ008','Videozaehlerstand','string',
'KZ009','Bildname','string',
'KZ010','Langtext des Zustandes','string',
'KZ011','Verbindung','string(1)',
'KZ013','Schachtbereich','string(3)',
'KZ016','Punktuelle Reparatur','string(1)',
'KZ017','Standardisierte Anmerkung ','string(2)',
'KZ201','Meldung','string(1)',
'KZ202','Datum der Meldung','string',
'KZ203','Melder','string',
'KZ204','Datum der Klassifizierung','string',
'KZ205','Klassifizierer','string',
'KZ206','Zustandsklasse Dichtheit','integer',
'KZ207','Zustandsklasse Standsicherheit','integer',
'KZ208','Zustandsklasse Betriebssicherheit','integer',
'KZ997','Platzhalter für kameraspezifische Kennung','string',
'KZ998','Dokument','string',
'KZ999','Bemerkung','string'
]

linz_epsg_mapping = {
    'COLLTM2000':2114,
    'COLLTM1949':27214,
    'GAWLTM2000':2125,
    'GAWLTM1949':27225,
    'GREYTM2000':2118,
    'GREYTM1949':27218,
    'HAWKTM2000':2108,
    'HAWKTM1949':27208,
    'HOKITM2000':2121,
    'HOKITM1949':27221,
    'JACKTM2000':2123,
    'JACKTM1949':27223,
    'KARATM2000':2116,
    'KARATM1949':27216,
    'LINDTM2000':2127,
    'LINDTM1949':27227,
    'MARLTM2000':2120,
    'MARLTM1949':27220,
    'EDENTM2000':2105,
    'EDENTM1949':27205,
    'PLEATM2000':2124,
    'PLEATM1949':27224,
    'YORKTM2000':2129,
    'YORKTM1949':27229,
    'NICHTM2000':2128,
    'NICHTM1949':27228,
    'NELSTM2000':2115,
    'NELSTM1949':27215,
    'TAIETM2000':2131,
    'TAIETM1949':27231,
    'OBSETM2000':2130,
    'OBSETM1949':27230,
    'OKARTM2000':2122,
    'OKARTM1949':27222,
    'POVETM2000':2107,
    'POVETM1949':27207,
    'TARATM2000':2109,
    'TARATM1949':27209,
    'TIMATM2000':2126,
    'TIMATM1949':27226,
    'TUHITM2000':2110,
    'TUHITM1949':27210,
    'WAIRTM2000':2112,
    'WAIRTM1949':27212,
    'WANGTM2000':2111,
    'WANGTM1949':27211,
    'WELLTM2000':2113,
    'WELLTM1949':27213,
    'NZGD1949':4272,
    'NZGD2000':4167,
    'NZMG':27200,
    'NZTM':2193
}

latlon_coordsys = {
    'NZGD1949':1,
    'NZGD2000':1,
}



def float_de(s):
    if s.strip()=='':
        s='0'

    if s.find(",")>0:
        s = s.replace('.','').replace(',','.')

    try:
        a = float(s)
    except ValueError:
        QgsMessageLog.logMessage("String :"+str(s)+" ist keine Zahl", 'M150xml', Qgis.Warning)
        a = 0
    return a


def xmlZahlzuordnen(xmlAbschnitt,xmlFeld, Zielliste, Zielfeld):
    cs = xmlAbschnitt.findtext(xmlFeld,'')
    if not cs.strip()=='':
        Zielliste[Zielfeld] = float_de(cs)

def xmlListezuordnen(xmlAbschnitt, SuchListe, ZielListe):
    for i in range(0,len(SuchListe),3):
        cs = xmlAbschnitt.findtext(SuchListe[i],'')
        cs = cs.strip('\n').strip()
        if SuchListe[i+2]=='integer' and not cs.strip()=='':
            wert=int(cs)
        elif  SuchListe[i+2]=='double' and not cs.strip()=='':
            wert=float_de(cs)

        elif  SuchListe[i+2].find('string(')>0 and not cs.strip()=='':
            ls =int(typ[SuchListe[i+2].find("(")+1:SuchListe[i+2].find(")")])
            if len(cs)>ls:
                QgsMessageLog.logMessage("Attribute is cut:"+str(lfdnr)+" "+ str(Stations_Felder[i+1]), 'M150xml', Qgis.Info)

            wert=cs[0:ls]
        else:
            wert=cs

        ZielListe.update([(SuchListe[i] ,wert)])

def xmlAbschnitt_XY_lesen(p,Liste): 
    go = p.findall('GO/GP')
    pkt=0
    x=0
    y=0
    z=0

    for gp in go :

        cs = gp.findtext('GP005','')
        if not cs.strip()=='':
            x = float_de(cs)
        else:
            cs = gp.findtext('GP003','')
            if not cs.strip()=='':
                x = float_de(cs)
            else :
                x = 0.0


        cs = gp.findtext('GP006','')
        if not cs.strip()=='':
            y = float_de(cs)
            
        else:
            cs = gp.findtext('GP004','')
            if not cs.strip()=='':
                y = float_de(cs)
            else :
                y = 0.0

        cs = gp.findtext('GP007','')
        if not cs.strip()=='':
            z = float_de(cs)
        else:
            z = 0.0


        if pkt==0:
            Liste.update(X1=x)
            Liste.update(Y1=y)
            Liste.update(Z1=z)
                     
            z1=z
        else:

            Liste.update(X2=x)
            Liste.update(Y2=y)
            Liste.update(Z2=z)

            z2=z  
        pkt = pkt + 1






class M150XmlException( Exception ):

    def __init_(self,value):
        self._value = value

    def str(self):
       return self._value



class M150XmlImp (object):

    def __init__(self,file):
        data = et.ElementTree()
        data.parse(file)
        root = data.find(".")
        ns = root.tag.split("}")[0]+"}"
        self._file = unicode(file)
        self._data = data
        self._root = root
        self._ns = ns
        self._schaechte=[]
        self._haltungen=[]
        self._inspektionen=[]
        self._stationen=[]
        self._inspektionenSchacht=[]
        self._stationenSchacht=[]
        self._setups=None;
        self._parse()



    def _readHeader(self):
        ns = self._ns;
        cs = self._data.find(ns+'CoordinateSystem')
        if cs is not None:
            self._coordsys['name'] = cs.get('name')
            self._coordsys['description'] = cs.get('desc')
    
    def _parse(self):
        self._readHeader()
        self._readSchaechte()
        self._readHaltungen()
        self._readInspektionen()
        self._readStationen()
        self._readInspektionenSchacht()
        self._readStationenSchacht()

    def coordSys(self):
        return self._coordsys['name']
    
    def coordSysEpsgId(self):
        if self._coordsys['name'] in linz_epsg_mapping:
            return linz_epsg_mapping[self._coordsys['name']]

    def coordSysIsLatLon(self):
        return self._coordsys['name'] in latlon_coordsys

    def schaechte(self):
        for p in self._readSchaechte():
            yield p

    def haltungen(self):
        for p in self._readHaltungen():
            yield p


    def inspektionen(self):
        for p in self._readInspektionen():
            yield p

    def stationen(self):
        for p in self._readStationen():
            yield p

    def inspektionenSchacht(self):
        for p in self._readInspektionenSchacht():
            yield p

    def stationenSchacht(self):
        for p in self._readStationenSchacht():
            yield p


#http://www.dwa.de/rwservice/M150.zip
#https://docs.python.org/2/library/xml.etree.elementtree.html

    def _readSchaechte(self):
        ns = self._ns;
        

        x=0
        y=0
        z=0
        schaechte = self._data.findall('KG')
        for p in schaechte:
            schacht={}

            xmlListezuordnen(p, Schacht_Felder, schacht)


                        
             # falls keine Einzelpunkte definiert dan aus HG201 u. ff.
            xmlZahlzuordnen(p,'KG201', schacht, "X1")
            xmlZahlzuordnen(p,'KG202', schacht, "Y1")
            xmlZahlzuordnen(p,'KG204', schacht, "Z1")

            xmlZahlzuordnen(p,'KG206', schacht, "X2")
            xmlZahlzuordnen(p,'KG207', schacht, "Y2")
            xmlZahlzuordnen(p,'KG209', schacht, "Z2")

            xmlAbschnitt_XY_lesen(p,schacht)

            yield schacht
            self._schaechte.append(schacht)

    def _readHaltungen(self):
        ns = self._ns;
  
        
 
        
        haltungen = self._data.findall('HG')
        for p in haltungen:
            
            haltung={}

            xmlListezuordnen(p, Haltung_Felder, haltung)

             # falls keine Einzelpunkte definiert dan aus HG201 u. ff.
            xmlZahlzuordnen(p,'HG201', haltung, "X1")
            xmlZahlzuordnen(p,'HG202', haltung, "Y1")
            xmlZahlzuordnen(p,'HG204', haltung, "Z1")

            xmlZahlzuordnen(p,'HG206', haltung, "X2")
            xmlZahlzuordnen(p,'HG207', haltung, "Y2")
            xmlZahlzuordnen(p,'HG209', haltung, "Z2")

            xmlAbschnitt_XY_lesen(p,haltung)
 
            yield haltung
            self._haltungen.append(haltung)
            
            
    def _readInspektionen(self):
        ns = self._ns;
        
        
        haltungen = self._data.findall('HG')
       
        for p in haltungen:
            inspektion={}
            halnr = p.findtext('HG001','')

             # falls keine Einzelpunkte definiert dan aus HG201 u. ff.
            xmlZahlzuordnen(p,'HG201', inspektion, "X1")
            xmlZahlzuordnen(p,'HG202', inspektion, "Y1")
            xmlZahlzuordnen(p,'HG204', inspektion, "Z1")

            xmlZahlzuordnen(p,'HG206', inspektion, "X2")
            xmlZahlzuordnen(p,'HG207', inspektion, "Y2")
            xmlZahlzuordnen(p,'HG209', inspektion, "Z2")

            xmlAbschnitt_XY_lesen(p,inspektion)

            inspektionen = p.findall('HI')
            for ins in inspektionen:
                
                xmlListezuordnen(ins, Inspektions_Felder, inspektion)
            
                inspektion.update(ID=halnr) 

                        
                yield inspektion
                self._inspektionen.append(inspektion)

    def _readStationen(self):
        ns = self._ns;
        

        inspnr=0
        
        haltungen = self._data.findall('HG')
       
        for p in haltungen:
            station={}
            halnr = p.findtext('HG001','')

             # falls keine Einzelpunkte definiert dan aus HG201 u. ff.
            xmlZahlzuordnen(p,'HG201', station, "X1")
            xmlZahlzuordnen(p,'HG202', station, "Y1")
            xmlZahlzuordnen(p,'HG204', station, "Z1")

            xmlZahlzuordnen(p,'HG206', station, "X2")
            xmlZahlzuordnen(p,'HG207', station, "Y2")
            xmlZahlzuordnen(p,'HG209', station, "Z2")

            xmlAbschnitt_XY_lesen(p,station)
            x1=station['X1']
            y1=station['Y1']
            x2=station['X2']
            y2=station['Y2']
            

            inspektionen = p.findall('HI')
            for ins in inspektionen:
                insnr = ins.findtext('HI003','')
                fl = ins.findtext('HI101','')
                inspnr += 1

                stationen = ins.findall('HZ')
                for stat in stationen:
                    
                    xmlListezuordnen(stat, Stations_Felder, station)
                
                    station.update(ID=halnr) 
                    station.update(ID2=inspnr)

                    if ((y2-y1)**2+(x2-x1)**2)!=0:
                        laenge= math.sqrt(((y2-y1)**2+(x2-x1)**2))
                    else:
                        laenge =0

                    staa = float(station['HZ001'])

                    if fl =='I':
                        sta=laenge-staa
                    else:
                        sta = staa

                    winkel = math.atan2((y2-y1),(x2-x1))*180/math.pi
                    station.update(ws=winkel) 
                    
                    xs1=x1+math.cos(winkel/180*math.pi)*sta
                    ys1=y1+math.sin(winkel/180*math.pi)*sta
                        

                    station.update(X1=xs1)    
                    station.update(Y1=ys1)
                   
                                       
                    yield station
                    self._stationen.append(station)        



    def _readInspektionenSchacht(self):
        ns = self._ns;
        

        schaechte = self._data.findall('KG')
       
        for p in schaechte:
            inspektionSchacht={}

            schachtnr = p.findtext('KG001','')
            

             # falls keine Einzelpunkte definiert dan aus HG201 u. ff.
            xmlZahlzuordnen(p,'KG201', inspektionSchacht, "X1")
            xmlZahlzuordnen(p,'KG202', inspektionSchacht, "Y1")
            xmlZahlzuordnen(p,'KG204', inspektionSchacht, "Z1")

            xmlZahlzuordnen(p,'KG206', inspektionSchacht, "X2")
            xmlZahlzuordnen(p,'KG207', inspektionSchacht, "Y2")
            xmlZahlzuordnen(p,'KG209', inspektionSchacht, "Z2")
            
            xmlAbschnitt_XY_lesen(p,inspektionSchacht)

            inspektionenSchacht = p.findall('KI')
            for ins in inspektionenSchacht:
                xmlListezuordnen(ins, Inspektions_FelderSchacht, inspektionSchacht)
                inspektionSchacht.update(ID=schachtnr) 

                        
                yield inspektionSchacht
                self._inspektionenSchacht.append(inspektionSchacht)

    def _readStationenSchacht(self):
    
 
        inspnr=0

        schaechte = self._data.findall('KG')
       
       
        for p in schaechte:
            
            stationSchacht={}
            schachtnr = p.findtext('KG001','')
            

             # falls keine Einzelpunkte definiert dan aus HG201 u. ff.
            xmlZahlzuordnen(p,'KG201', stationSchacht, "X1")
            xmlZahlzuordnen(p,'KG202', stationSchacht, "Y1")
            xmlZahlzuordnen(p,'KG204', stationSchacht, "Z1")

            xmlZahlzuordnen(p,'KG206', stationSchacht, "X2")
            xmlZahlzuordnen(p,'KG207', stationSchacht, "Y2")
            xmlZahlzuordnen(p,'KG209', stationSchacht, "Z2")
            
            xmlAbschnitt_XY_lesen(p,stationSchacht)

            x1=stationSchacht['X1']
            y1=stationSchacht['Y1']
            stationSchacht['X2']=x1
            stationSchacht['Y2']=y1

            x2=stationSchacht['X2']
            y2=stationSchacht['Y2']


            inspektionenSchacht = p.findall('KI')

            for ins in inspektionenSchacht:

                insnr = ins.findtext('KI003','')
                fl = ins.findtext('KI101','')
                inspnr += 1

                stationenSchacht = ins.findall('KZ')
                for stat in stationenSchacht:

                    xmlListezuordnen(stat, Stations_FelderSchacht, stationSchacht)
                
                    stationSchacht.update(ID=schachtnr) 
                    stationSchacht.update(ID2=inspnr)

                    if ((y2-y1)**2+(x2-x1)**2)!=0:
                        laenge= math.sqrt(((y2-y1)**2+(x2-x1)**2))
                    else:
                        laenge =0

                    staa = float(stationSchacht['KZ001'])

                    if fl =='I':
                        sta=laenge-staa
                    else:
                        sta = staa

                    winkel =270 # math.atan2((y2-y1),(x2-x1))*180/math.pi
                    stationSchacht.update(ws=winkel) 
                    
                    xs1=x1+math.cos(winkel/180*math.pi)*sta
                    ys1=y1+math.sin(winkel/180*math.pi)*sta
                        

                    stationSchacht.update(X1=xs1)    
                    stationSchacht.update(Y1=ys1)
                   
                                       
                    yield stationSchacht
                    self._stationen.append(stationSchacht)        
                       