################################################################################
#
# Copyright 2016 geoplaning GmbH 
# All rights reserved
#
# This program is released under the terms of the new BSD license. See the 
# LICENSE file for more information.
#
################################################################################


import re
import xml.etree.ElementTree as et
import math
import string


# -*- coding: utf-8 -*-
import locale
locale.setlocale(locale.LC_ALL, '')

Schacht_Felder=['KG001','Knotenbezeichnung','string(16)',
'KG002','Alternative Knotenbezeichnung','string(10)',
'KG101','Straßenschlüssel','integer',
'KG102','Strassenname','string',
'KG103','Ortsteilschlüssel','integer',
'KG104','Ortteilname','string',
'KG105','Gemeindeschlüssel','string(6)',
'KG106','Gebietsschlüssel','string(6)',
'KG107','Einzugsgebietschlüssel','string(4)',
'KG108','Nummer der Kläranlage','integer',
'KG201','Rechtswert Deckel','double',
'KG202','Hochwert Deckel','double',
'KG203','Lagegenauigkeitsstufe Deckel','integer',
'KG204','Höhe Deckel','double',
'KG205','Höhengenauigkeitsstufe Deckel','integer',
'KG206','Rechtswert Sohle','double',
'KG207','Hochwert Sohle','double',
'KG208','Lagegenauigkeitsstufe Sohle','integer',
'KG209','Höhe Sohle','double',
'KG210','Höhengenauigkeitstufe Sohle','integer',
'KG211','Schachttiefe','double',
'KG301','Kanalart','string(1)',
'KG302','Kanalnutzung','string(2)',
'KG303','Baujahr','integer',
'KG304','Materialart','string(4)',
'KG305','Knotenart','string(1)',
'KG306','Bauwerksart','string(4)',
'KG307','Schachtform','string(1)',
'KG308','Schachtlänge','integer',
'KG309','Schachtbreite','integer',
'KG310','Deckelform','string(1)',
'KG311','Deckelmaterial','string(4)',
'KG312','Deckelklasse','string(1)',
'KG313','Deckelbreite','integer',
'KG314','Deckellänge','integer',
'KG315','Deckel verschraubt','string',
'KG316','Gerinneform','string(1)',
'KG317','Gerinnematerial','string(4)',
'KG318','Gerinnebreite','integer',
'KG319','Gerinnelänge','integer',
'KG320','Bermematerial','string(4)',
'KG321','Innenschutz','string(1)',
'KG322','Innenschutzmaterial','string(4)',
'KG323','Steighilfe','string(3)',
'KG324','Anzahl Steigeisen','integer',
'KG325','Steighilfenwerkstoff','string(4)',
'KG326','Messtechnik','string(1)',
'KG401','Funktionsinspektion','string(1)',
'KG402','Eigentum','string(2)',
'KG403','Wasserschutzzone','string(4)',
'KG404','Lage im Verkehrsraum','string(2)',
'KG405','Grundwasserstand','string(1)',
'KG406','Überschwemmungsgebiet','string(1)',
'KG407','Status Daten','string(1)',
'KG408','Einstauhäufigkeit ','string(1)',
'KG409','Bodengruppe','string(2)',
'KG998','Dokument','string',
'KG999','Bemerkung','string'
]



Haltung_Felder=['HG001','Haltungsbezeichnung','string(33)',
'HG002','Alternative Haltungsbezeichnung','string(16)',
'HG003','Schacht oben','string(16)',
'HG004','Schacht unten','string(16)',
'HG005','Bezeichnung Endpunkt','string(33)',
'HG006','Objekttyp bei Anschlussleitung','string(1)',
'HG007','Stationierung des Anschlussleitung','double',
'HG008','Stationierungsrichtung des Anschlusses','string(1)',
'HG009','Lageangabe des Anschlusses','string(2)',
'HG010','Typ Endpunkt','string(2)',
'HG011','Leitungsbezeichnung','string(33)',
'HG012','Kind von','string(33)',
'HG101','Straßenschlüssel','integer',
'HG102','Straßenname','string',
'HG103','Ortsteilschlüssel','integer',
'HG104','Ortsteilname','string',
'HG105','Gemeindeschlüssel','string(6)',
'HG106','Gebietsschlüssel','string(6)',
'HG107','Einzugsgebietschlüssel','string(6)',
'HG108','Nummer der Kläranlage','integer',
'HG201','Rechtswert Rohrsohle oben','double',
'HG202','Hochwert Rohrsohle oben','double',
'HG203','Lagegenauigkeitsstufe Rohrsohle oben','integer',
'HG204','Höhe Rohrsohle  oben','double',
'HG205','Höhengenauigkeitsstufe Rohrsohle oben','integer',
'HG206','Rechtswert Rohrsohle unten','double',
'HG207','Hochwert Rohrsohle unten','double',
'HG208','Lagegenauigkeitsstufe Rohrsohle unten','integer',
'HG209','Höhe Rohrsohle unten','double',
'HG210','Höhengenauigkeitsstufe Rohrsohle unten','integer',
'HG301','Kanalart','string(1)',
'HG302','Kanalnutzung','string(2)',
'HG303','Baujahr','integer',
'HG304','Materialart','string(4)',
'HG305','Profilart','string(2)',
'HG306','Profilbreite','integer',
'HG307','Profilhöhe','integer',
'HG308','Profilauskleidung','string(1)',
'HG309','Profilauskleidungsmaterial','string(4)',
'HG310','Haltungslänge','double',
'HG311','Haltungsgefälle','double',
'HG312','Mittlere Tiefe','double',
'HG313','Haltungsart','string(1)',
'HG314','Rohrlänge','double',
'HG315','Status Profilangaben','string(1)',
'HG316','Profilauskleidung selbsttragend','string',
'HG401','Funktionsinspektion','string(1)',
'HG402','Eigentum','string(2)',
'HG403','Wasserschutzzone','string(4)',
'HG404','Lage im Verkehrsraum','string(2)',
'HG405','Grundwasserstand','string(1)',
'HG406','Überschwemmungsgebiet','string(1)',
'HG407','Status Daten','string(1)',
'HG408','Einstauhäufigkeit ','string(1)',
'HG409','Bodengruppe','string(2)',
'HG410','Wanddicke','integer',
'HG411','Lagerungsart','string(1)',
'HG998','Dokument','string',
'HG999','Bemerkung','string'
]

Inspektions_Felder=['HI001','Auftraggeber','string',
'HI002','Projektnummer','string(8)',
'HI003','inspektionsnummer','integer',
'HI004','inspektionsgrund','string(1)',
'HI005','Kodierystem','string(20)',
'HI006','Eingesetzes Kamerasystem','string',
'HI007','Bearbeitungsstatus','string(2)',
'HI008','Bearbeitungshinweis','string',
'HI101','inspektionsrichtung','string(1)',
'HI102','Bezugspunkt Start','string(1)',
'HI103','inspektionsart','string(3)',
'HI104','inspektionsdatum','string',
'HI105','inspektionszeit','string(8)',
'HI106','Wetter','string(7)',
'HI107','Reinigung','string(1)',
'HI108','Temperatur','integer',
'HI109','Vorflutsicherung','string(1)',
'HI110','Wasserspiegel','integer',
'HI111','Firma','string',
'HI112','Inspekteur','string',
'HI113','Bauleitung','string',
'HI114','Videospeichermedium','string(4)',
'HI115','Name des Speichermediums','string',
'HI116','Dateiname digitales Video','string',
'HI117','Fotospeichermedium','string(7)',
'HI201','Meldung','string(1)',
'HI202','Datum der Meldung','string',
'HI203','Melder','string',
'HI204','Datum der Beurteilung','string',
'HI205','Beurteiler','string',
'HI206','max. Haltungsklasse Dichtheit','integer',
'HI207','max. Haltungsklasse Standsicherheit','integer',
'HI208','max. Haltungsklasse Betriebssicherheit','integer',
'HI209','inspektionspunkte Dichtheit','integer',
'HI210','inspektionspunkte Standsicherheit','integer',
'HI211','inspektionspunkte Betriebssicherheit','integer',
'HI212','Bewertungspunkte Dichtheit','integer',
'HI213','Bewertungspunkte Standsicherheit','integer',
'HI214','Bewertungspunkte Betriebssicherheit','integer',
'HI215','Sanierungsbedarfszahl','integer',
'HI216','Beurteilung (Klasse)','integer',
'HI217','Priorität','integer',
'HI998','Dokument','string',
'HI999','Bemerkung','string'
]

linz_epsg_mapping = {
    'COLLTM2000':2114,
    'COLLTM1949':27214,
    'GAWLTM2000':2125,
    'GAWLTM1949':27225,
    'GREYTM2000':2118,
    'GREYTM1949':27218,
    'HAWKTM2000':2108,
    'HAWKTM1949':27208,
    'HOKITM2000':2121,
    'HOKITM1949':27221,
    'JACKTM2000':2123,
    'JACKTM1949':27223,
    'KARATM2000':2116,
    'KARATM1949':27216,
    'LINDTM2000':2127,
    'LINDTM1949':27227,
    'MARLTM2000':2120,
    'MARLTM1949':27220,
    'EDENTM2000':2105,
    'EDENTM1949':27205,
    'PLEATM2000':2124,
    'PLEATM1949':27224,
    'YORKTM2000':2129,
    'YORKTM1949':27229,
    'NICHTM2000':2128,
    'NICHTM1949':27228,
    'NELSTM2000':2115,
    'NELSTM1949':27215,
    'TAIETM2000':2131,
    'TAIETM1949':27231,
    'OBSETM2000':2130,
    'OBSETM1949':27230,
    'OKARTM2000':2122,
    'OKARTM1949':27222,
    'POVETM2000':2107,
    'POVETM1949':27207,
    'TARATM2000':2109,
    'TARATM1949':27209,
    'TIMATM2000':2126,
    'TIMATM1949':27226,
    'TUHITM2000':2110,
    'TUHITM1949':27210,
    'WAIRTM2000':2112,
    'WAIRTM1949':27212,
    'WANGTM2000':2111,
    'WANGTM1949':27211,
    'WELLTM2000':2113,
    'WELLTM1949':27213,
    'NZGD1949':4272,
    'NZGD2000':4167,
    'NZMG':27200,
    'NZTM':2193
}

latlon_coordsys = {
    'NZGD1949':1,
    'NZGD2000':1,
}

class M150XmlException( Exception ):

    def __init_(self,value):
        self._value = value

    def str(self):
       return self._value



class M150XmlImp (object):

    def __init__(self,file):
        data = et.ElementTree()
        data.parse(file)
        root = data.find(".")
        ns = root.tag.split("}")[0]+"}"
        self._file = unicode(file)
        self._data = data
        self._root = root
        self._ns = ns
        self._schaechte=[]
        self._haltungen=[]
        self._inspektionen=[]
        self._setups=None;
        self._parse()



    def _readHeader(self):
        ns = self._ns;
        cs = self._data.find(ns+'CoordinateSystem')
        if cs is not None:
            self._coordsys['name'] = cs.get('name')
            self._coordsys['description'] = cs.get('desc')
    
    def _parse(self):
        self._readHeader()
        self._readSchaechte()
        self._readHaltungen()
        self._readInspektionen()


    def coordSys(self):
        return self._coordsys['name']
    
    def coordSysEpsgId(self):
        if self._coordsys['name'] in linz_epsg_mapping:
            return linz_epsg_mapping[self._coordsys['name']]

    def coordSysIsLatLon(self):
        return self._coordsys['name'] in latlon_coordsys

    def schaechte(self):
        for p in self._readSchaechte():
            yield p

    def haltungen(self):
        for p in self._readHaltungen():
            yield p

    def inspektionen(self):
        for p in self._readInspektionen():
            yield p



#http://www.dwa.de/rwservice/M150.zip
#https://docs.python.org/2/library/xml.etree.elementtree.html

    def _readSchaechte(self):
        ns = self._ns;
        

        x=0
        y=0
        z=0
        schaechte = self._data.findall('KG')
        for p in schaechte:
            schacht={}
            for feld in Schacht_Felder[0::3]:
                cs = p.findtext(feld,'')
                schacht.update([(feld ,cs)])
                
            z1=0.0
            z2=0.0

            go = p.findall('GO/GP')

            pkt=0

            schacht.update(X1=0)
            schacht.update(Y1=0)
            schacht.update(X2=0)
            schacht.update(Y2=0)
                    
            for gp in go :

                cs = gp.findtext('GP005','')
                if not cs.strip()=='':
                    x = float(cs)
                else:
                    cs = gp.findtext('GP003','')
                    if not cs.strip()=='':
                        x = float(cs)
                    else :
                        x = 0


                cs = gp.findtext('GP006','')
                if not cs.strip()=='':
                    y = float(cs)
                    
                else:
                    cs = gp.findtext('GP004','')
                    if not cs.strip()=='':
                        y = float(cs)
                    else :
                        y = 0.0

                cs = gp.findtext('GP007','')
                if not cs.strip()=='':
                    z = float(cs)
                else:
                    z = 0.0


                if pkt==0:
                    schacht.update(X1=x)
                    schacht.update(KG201=x)
                    schacht.update(Y1=y)
                    schacht.update(KG202=y)
                    schacht.update(Z1=z)
                    schacht.update(KG204=z)                        
                    z1=z
                else:

                    schacht.update(X2=x)
                    schacht.update(KG206=x)
                    schacht.update(Y2=y)
                    schacht.update(KG207=y)
                    schacht.update(Z2=z)
                    schacht.update(KG209=z)  
                pkt = pkt + 1


            yield schacht
            self._schaechte.append(schacht)

    def _readHaltungen(self):
        ns = self._ns;
  
        
 
        
        haltungen = self._data.findall('HG')
        for p in haltungen:
            
            haltung={}
            for feld in Haltung_Felder[0::3]:
                cs = p.findtext(feld,'')
                haltung.update([(feld ,cs)])

 
            go = p.findall('GO/GP')

            pkt=0
            haltung.update(X1=0)
            haltung.update(Y1=0)
            haltung.update(X2=0)
            haltung.update(Y2=0)

            for gp in go :

                cs = gp.findtext('GP005','')
                if not cs.strip()=='':
                    x = float(cs)
                else:
                    cs = gp.findtext('GP003','')
                    if not cs.strip()=='':
                        x = float(cs)
                    else :
                        x = 0


                cs = gp.findtext('GP006','')
                if not cs.strip()=='':
                    y = float(cs)
                else:
                    cs = gp.findtext('GP004','')
                    if not cs.strip()=='':
                        y = float(cs)
                    else :
                        y = 0.0

                cs = gp.findtext('GP007','')
                if not cs.strip()=='':
                    z = float(cs)
                else:
                    z = 0.0


                if pkt==0:
                    haltung.update(X1=x)
                    haltung.update(HG201=x)
                    haltung.update(Y1=y)
                    haltung.update(HG202=y)
                    haltung.update(Z1=z)                        
                    haltung.update(HG204=z)
                else:
                    haltung.update(X2=x)
                    haltung.update(HG206=x)
                    haltung.update(Y2=y)
                    haltung.update(HG207=y)
                    haltung.update(Z2=z)                        
                    haltung.update(HG209=z)


  
                pkt = pkt + 1

 
            yield haltung
            self._haltungen.append(haltung)
            
            
    def _readInspektionen(self):
        ns = self._ns;
        

        x=0
        y=0
        z=0
        haltungen = self._data.findall('HG')
       
        for p in haltungen:
            halnr = p.findtext('HG001','')

            go = p.findall('GO/GP')

            pkt=0


            for gp in go :

                cs = gp.findtext('GP005','')
                if not cs.strip()=='':
                    x = float(cs)
                else:
                    cs = gp.findtext('GP003','')
                    if not cs.strip()=='':
                        x = float(cs)
                    else :
                        x = 0
                cs = gp.findtext('GP006','')
                if not cs.strip()=='':
                    y = float(cs)
                else:
                    cs = gp.findtext('GP004','')
                    if not cs.strip()=='':
                        y = float(cs)
                    else :
                        y = 0.0

                if pkt==0:
                    x1=x
                    y1=y
                else:
                    x2=x
                    y2=y
  
                pkt = pkt + 1

            inspektionen = p.findall('HI')
            for ins in inspektionen:
                inspektion={}
                for feld in Inspektions_Felder[0::3]:
                    cs = ins.findtext(feld,'')
                    inspektion.update([(feld ,cs)])
                
                inspektion.update(ID=halnr) 
                inspektion.update(X1=x1)    
                inspektion.update(X1=x1)
                inspektion.update(Y1=y1)
                inspektion.update(X2=x2)
                inspektion.update(Y2=y2)
                        



                yield inspektion
                self._inspektionen.append(inspektion)