# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SeismicMicrozonation
                                 A QGIS plugin
 Lateral spreading for seismic microzonation
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-02-02
        copyright            : (C) 2025 by Giuseppe Cosentino
        email                : giuseppe.cosentino@cnr.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Giuseppe Cosentino'
__date__ = '2025-02-01'
__copyright__ = '(C) 2025 by Giuseppe Cosentino'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterFeatureSink
import os
import processing


class SeismicMicrozonationAlgorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterRasterLayer('digital_terrain_model_dtm', 'Digital Terrain Model (DTM)', defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('layer_with_il_index', 'Layer with IL index', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterField('il_index', 'IL index', type=QgsProcessingParameterField.Numeric, parentLayerParameterName='layer_with_il_index', allowMultiple=False, defaultValue=None))
        self.addParameter(QgsProcessingParameterRasterDestination('Slope', 'slope%', createByDefault=True, defaultValue=''))
        self.addParameter(QgsProcessingParameterFeatureSink('Sz_rz_lateral_spreading', 'SZ_RZ_lateral_spreading', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue='TEMPORARY_OUTPUT'))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(48, model_feedback)
        results = {}
        outputs = {}

        # Ritaglia raster con maschera
        alg_params = {
            'ALPHA_BAND': False,
            'CROP_TO_CUTLINE': True,
            'DATA_TYPE': 0,  # Usa Il Tipo Dati del Layer in Ingresso
            'EXTRA': '',
            'INPUT': parameters['digital_terrain_model_dtm'],
            'KEEP_RESOLUTION': False,
            'MASK': parameters['layer_with_il_index'],
            'MULTITHREADING': False,
            'NODATA': None,
            'OPTIONS': '',
            'SET_RESOLUTION': False,
            'SOURCE_CRS': 'ProjectCrs',
            'TARGET_CRS': 'ProjectCrs',
            'TARGET_EXTENT': parameters['layer_with_il_index'],
            'X_RESOLUTION': None,
            'Y_RESOLUTION': None,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RitagliaRasterConMaschera'] = processing.run('gdal:cliprasterbymasklayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Pendenza
        alg_params = {
            'AS_PERCENT': True,
            'BAND': 1,
            'COMPUTE_EDGES': False,
            'EXTRA': '',
            'INPUT': outputs['RitagliaRasterConMaschera']['OUTPUT'],
            'OPTIONS': '',
            'SCALE': 1,
            'ZEVENBERGEN': False,
            'OUTPUT': parameters['Slope']
        }
        outputs['Pendenza'] = processing.run('gdal:slope', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Slope'] = outputs['Pendenza']['OUTPUT']

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}
        
        # Imposta stile layer
        alg_params = {
            'INPUT': outputs['Pendenza']['OUTPUT'],
            'STYLE': os.path.join(os.path.dirname(__file__), "styles", "slope.qml")
        }
        outputs['ImpostaStileLayer'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Poligonizzazione (da raster a vettore)
        alg_params = {
            'BAND': 1,
            'EIGHT_CONNECTEDNESS': False,
            'EXTRA': '',
            'FIELD': 'DN',
            'INPUT': outputs['Pendenza']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['PoligonizzazioneDaRasterAVettore'] = processing.run('gdal:polygonize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Intersezione_01
        # prende gli attributi sia del raster che del vettore 
        alg_params = {
            'GRID_SIZE': None,
            'INPUT': outputs['PoligonizzazioneDaRasterAVettore']['OUTPUT'],
            'INPUT_FIELDS': [''],
            'OVERLAY': parameters['layer_with_il_index'],
            'OVERLAY_FIELDS': [''],
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersezione_01'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Rinomina campo Indice di liquefazione
        # Rinominato il campo ha i volore del Indice di liquefazione per poter fare l'estrazione degli oggetti (poichè salvando il modello in python le funzionalità di qgis delle espressioni non funzionano quando si deve fare l'intersezione )
        alg_params = {
            'FIELD': parameters['il_index'],
            'INPUT': outputs['Intersezione_01']['OUTPUT'],
            'NEW_NAME': 'Index',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RinominaCampoIndiceDiLiquefazione'] = processing.run('native:renametablefield', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # RZ (5< IL< =15) AND (Slope > 5)
        alg_params = {
            'EXPRESSION': '("INDEX" >5 AND "INDEX" <= 15) AND ("DN" > 5)\r\n',
            'INPUT': outputs['RinominaCampoIndiceDiLiquefazione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Rz5Il15AndSlope5'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # RZ ("IL" >15) AND ("slope" > 2)
        alg_params = {
            'EXPRESSION': '("INDEX" >15) AND ("DN" > 2)',
            'INPUT': outputs['RinominaCampoIndiceDiLiquefazione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RzIl15AndSlope2'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # SZ0 (0<IL<=2) and (2< slope <=5)
        alg_params = {
            'EXPRESSION': '("INDEX" > 0 AND "INDEX"<=2) and ("DN" > 2 AND "DN" <=5)',
            'INPUT': outputs['RinominaCampoIndiceDiLiquefazione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Sz00il2And2Slope5'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # SZ (0< IL<=2) and (5< slope <=15)
        alg_params = {
            'EXPRESSION': '("INDEX" > 0 AND "INDEX"<=2) AND ("DN" > 5 AND "DN" <=15)',
            'INPUT': outputs['RinominaCampoIndiceDiLiquefazione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Sz0Il2And5Slope15'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Dissolvi104
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['RzIl15AndSlope2']['OUTPUT'],
            'SEPARATE_DISJOINT': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi104'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Dissolvi300
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['Sz00il2And2Slope5']['OUTPUT'],
            'SEPARATE_DISJOINT': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi300'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # RZ (2< IL<=5) and (slope >5 )
        alg_params = {
            'EXPRESSION': '("INDEX">2 AND "INDEX"<=5) \r\nAND ("DN" > 5 )',
            'INPUT': outputs['RinominaCampoIndiceDiLiquefazione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Rz2Il5AndSlope5'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Dissolvi103
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['Rz5Il15AndSlope5']['OUTPUT'],
            'SEPARATE_DISJOINT': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi103'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # SZ (5< IL<=15) AND (2< slope <=5)
        alg_params = {
            'EXPRESSION': '("INDEX"> 5 AND "INDEX"<= 15) AND \r\n("DN">2 AND DN <=5)',
            'INPUT': outputs['RinominaCampoIndiceDiLiquefazione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Sz5Il15And2Slope5'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # RZ (0< IL<=2) and (slope >15)
        alg_params = {
            'EXPRESSION': '("INDEX" > 0 AND "INDEX"<=2) \r\nAND ("DN" >15)',
            'INPUT': outputs['RinominaCampoIndiceDiLiquefazione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Rz0Il2AndSlope15'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # SZ (2< IL<=5) and (2< slope<=5)
        alg_params = {
            'EXPRESSION': '("INDEX" > 2 AND "INDEX"<=5) AND ("DN" > 2 AND "DN" <=5)',
            'INPUT': outputs['RinominaCampoIndiceDiLiquefazione']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Sz2Il5And2Slope5'] = processing.run('native:extractbyexpression', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # Dissolvi102
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['Rz2Il5AndSlope5']['OUTPUT'],
            'SEPARATE_DISJOINT': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi102'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}

        # Calcolatore_104
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'code',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Decimale (doppia precisione)
            'FORMULA': '104',
            'INPUT': outputs['Dissolvi104']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calcolatore_104'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # Calcolatore_103
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'code',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Decimale (doppia precisione)
            'FORMULA': '103',
            'INPUT': outputs['Dissolvi103']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calcolatore_103'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # Dissolvi101
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['Rz0Il2AndSlope15']['OUTPUT'],
            'SEPARATE_DISJOINT': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi101'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # Calcolatore_300
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'code',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Decimale (doppia precisione)
            'FORMULA': '300',
            'INPUT': outputs['Dissolvi300']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calcolatore_300'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # Dissolvi202
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['Sz2Il5And2Slope5']['OUTPUT'],
            'SEPARATE_DISJOINT': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi202'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # Dissolvi201
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['Sz0Il2And5Slope15']['OUTPUT'],
            'SEPARATE_DISJOINT': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi201'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # Riorganizza_104
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['Calcolatore_104']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorganizza_104'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # Calcolatore_202
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'code',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Decimale (doppia precisione)
            'FORMULA': '202',
            'INPUT': outputs['Dissolvi202']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calcolatore_202'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # Riorganizza_103
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['Calcolatore_103']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorganizza_103'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # Calcolatore_201
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'code',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Decimale (doppia precisione)
            'FORMULA': '201',
            'INPUT': outputs['Dissolvi201']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calcolatore_201'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(27)
        if feedback.isCanceled():
            return {}

        # Formula_103
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'formula',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,  # Testo (stringa)
            'FORMULA': "'RZ=(5<IL<=15)and(Slope>5)'",
            'INPUT': outputs['Riorganizza_103']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Formula_103'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(28)
        if feedback.isCanceled():
            return {}

        # Calcolatore_102
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'code',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Decimale (doppia precisione)
            'FORMULA': '102',
            'INPUT': outputs['Dissolvi102']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calcolatore_102'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(29)
        if feedback.isCanceled():
            return {}

        # Calcolatore_101
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'code',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,  # Intero (32 bit)
            'FORMULA': '101',
            'INPUT': outputs['Dissolvi101']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calcolatore_101'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(30)
        if feedback.isCanceled():
            return {}

        # Riorganizza_102
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['Calcolatore_102']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorganizza_102'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(31)
        if feedback.isCanceled():
            return {}

        # Riorganizza_300
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['Calcolatore_300']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorganizza_300'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(32)
        if feedback.isCanceled():
            return {}

        # Dissolvi203
        alg_params = {
            'FIELD': [''],
            'INPUT': outputs['Sz5Il15And2Slope5']['OUTPUT'],
            'SEPARATE_DISJOINT': True,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Dissolvi203'] = processing.run('native:dissolve', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(33)
        if feedback.isCanceled():
            return {}

        # Riorganizza_201
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['Calcolatore_201']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorganizza_201'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(34)
        if feedback.isCanceled():
            return {}

        # Formula_104
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'formula',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,  # Testo (stringa)
            'FORMULA': "'RZ=(IL>15)and(slope>2)'",
            'INPUT': outputs['Riorganizza_104']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Formula_104'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(35)
        if feedback.isCanceled():
            return {}

        # Riorganizza_202
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['Calcolatore_202']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorganizza_202'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(36)
        if feedback.isCanceled():
            return {}

        # Calcolatore_203
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'code',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,  # Decimale (doppia precisione)
            'FORMULA': '203',
            'INPUT': outputs['Dissolvi203']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calcolatore_203'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(37)
        if feedback.isCanceled():
            return {}

        # Riorganizza_101
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['Calcolatore_101']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorganizza_101'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(38)
        if feedback.isCanceled():
            return {}

        # Formula_102
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'formula',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,  # Testo (stringa)
            'FORMULA': "'RZ=(2<IL<=5)and(slope>5)'",
            'INPUT': outputs['Riorganizza_102']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Formula_102'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(39)
        if feedback.isCanceled():
            return {}

        # Formula_300
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'formula',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,  # Testo (stringa)
            'FORMULA': "'SZ0=(0<IL<=2)and(2<slope<=5)'",
            'INPUT': outputs['Riorganizza_300']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Formula_300'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(40)
        if feedback.isCanceled():
            return {}

        # Formula_201
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'formula',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,  # Testo (stringa)
            'FORMULA': "'SZ=(0<IL<=2)and(5<slope<=15)'",
            'INPUT': outputs['Riorganizza_201']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Formula_201'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(41)
        if feedback.isCanceled():
            return {}

        # Formula_101
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'formula',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,  # Testo (stringa)
            'FORMULA': "'RZ=(0<IL<=2)and(slope>15)'",
            'INPUT': outputs['Riorganizza_101']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Formula_101'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(42)
        if feedback.isCanceled():
            return {}

        # Formula_202
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'formula',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,  # Testo (stringa)
            'FORMULA': "'SZ=(2<IL<=5)and(2<slope<=5)'",
            'INPUT': outputs['Riorganizza_202']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Formula_202'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(43)
        if feedback.isCanceled():
            return {}

        # Riorganizza_203
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'}],
            'INPUT': outputs['Calcolatore_203']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Riorganizza_203'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(44)
        if feedback.isCanceled():
            return {}

        # Formula_203
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'formula',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 2,  # Testo (stringa)
            'FORMULA': "'SZ=(5<IL<=15)and(2<slope<=5)'",
            'INPUT': outputs['Riorganizza_203']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Formula_203'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(45)
        if feedback.isCanceled():
            return {}

        # Fondi vettori
        alg_params = {
            'CRS': 'ProjectCrs',
            'LAYERS': [outputs['Formula_102']['OUTPUT'],outputs['Formula_103']['OUTPUT'],outputs['Formula_104']['OUTPUT'],outputs['Formula_201']['OUTPUT'],outputs['Formula_202']['OUTPUT'],outputs['Formula_203']['OUTPUT'],outputs['Formula_300']['OUTPUT'],outputs['Formula_101']['OUTPUT']],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['FondiVettori'] = processing.run('native:mergevectorlayers', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(46)
        if feedback.isCanceled():
            return {}

        # Riorganizza_final_LS
        alg_params = {
            'FIELDS_MAPPING': [{'alias': '','comment': '','expression': '"fid"','length': 0,'name': 'fid','precision': 0,'sub_type': 0,'type': 4,'type_name': 'int8'},{'alias': '','comment': '','expression': '"code"','length': 0,'name': 'code','precision': 0,'sub_type': 0,'type': 6,'type_name': 'double precision'},{'alias': '','comment': '','expression': '"formula"','length': 0,'name': 'formula','precision': 0,'sub_type': 0,'type': 10,'type_name': 'text'}],
            'INPUT': outputs['FondiVettori']['OUTPUT'],
            'OUTPUT': parameters['Sz_rz_lateral_spreading']
        }
        outputs['Riorganizza_final_ls'] = processing.run('native:refactorfields', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['Sz_rz_lateral_spreading'] = outputs['Riorganizza_final_ls']['OUTPUT']

        feedback.setCurrentStep(47)
        if feedback.isCanceled():
            return {}
        output_layer_name = "SZ_RZ_lateral_spreading"

        # Imposta stile layer
        alg_params = {
            'INPUT': outputs['Riorganizza_final_ls']['OUTPUT'],
            'STYLE': os.path.join(os.path.dirname(__file__), "styles", "style.qml")
        }
        outputs['ImpostaStileLayer'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        input_layer = outputs['Riorganizza_final_ls']['OUTPUT'] 
        return results

    def name(self):
        return 'Lateral Spreading'

    def displayName(self):
        return 'Lateral Spreading'

    def group(self):
        return ''

    def groupId(self):
        return ''

    def shortHelpString(self):
        return """<html><body><p><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN" "http://www.w3.org/TR/REC-html40/strict.dtd">
<html><head><meta name="qrichtext" content="1" /><style type="text/css">
</style></head><body style=" font-family:'MS Shell Dlg 2'; font-size:9.5pt; font-weight:400; font-style:normal;">
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-size:12pt; font-weight:600;">Lateral spreading for seismic microzonation</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-weight:600; color:#000000;">The tool calculates zones subject to lateral spreading:</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-weight:600; color:#33a02c;">A) Low Susceptibility Zones (Z0): </span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#000000;">2 &lt; Slope% ≤ 5 and 0 &lt; IL ≤ 2</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-weight:600; color:#ff7f00;">B) Susceptibility Zones (SZ)</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#000000;">0&lt; IL ≤ 2 and 5 &lt; Slope% ≤ 15</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#000000;">2&lt; IL ≤ 5 and 2 &lt; Slope% &gt; 5</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#000000;">5 &lt; IL ≤ 15 and 2 &lt; Slope% ≤ 5</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" font-weight:600; color:#fc3300;">C) Respect Zones (RZ)</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#000000;">0&lt; IL ≤ 2 and Slope% &gt; 15</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#000000;">2&lt; IL ≤ 5 and Slope% &gt; 5</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#000000;">5&lt; IL ≤ 15 and Slope% &gt; 5</span></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#000000;">IL &gt;15 and Slope% &gt; 2</span></p>
<p style="-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px; color:#000000;"><br /></p>
<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><span style=" color:#666666;">*IL = liquefaction index</span></p></body></html></p>
<p><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN" "http://www.w3.org/TR/REC-html40/strict.dtd">
<html><head><meta name="qrichtext" content="1" /><style type="text/css">
</style></head><body style=" font-family:'MS Shell Dlg 2'; font-size:9.5pt; font-weight:400; font-style:normal;">
<p style="-qt-paragraph-type:empty; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"><br /></p></body></html></p><br><p align="right">Autore algoritmo: Giuseppe Cosentino (Pino)</p><p align="right">Versione algoritmo: 0.3 20250202</p></body></html>"""

    def createInstance(self):
        return SeismicMicrozonationAlgorithm()
