# -*- coding: utf-8 -*-
"""
/***************************************************************************
 longitudinalDockWidget
                                 A QGIS plugin
 longitudinal section
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-12-07
        git sha              : $Format:%H$
        copyright            : (C) 2019 by g3er@geoplaning.de

        email                : g3er@geoplaning.de

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from __future__ import unicode_literals
import os
import numpy as np
import qgis

from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtWidgets import QApplication, QMessageBox
from qgis.PyQt.QtCore import pyqtSignal,QVariant, Qt, QSettings

#from .identifygeometry import IdentifyGeometry

#matplotlib
import matplotlib
from matplotlib.backends.backend_qt5agg import FigureCanvasQTAgg as FigureCanvas
from matplotlib.backends.backend_qt5agg import NavigationToolbar2QT as NavigationToolbar
from matplotlib.figure import Figure
from matplotlib.ticker import ScalarFormatter
from matplotlib.pyplot  import subplots, legend
import matplotlib.pyplot as plt
from matplotlib.patches import Ellipse, Rectangle
from matplotlib.legend_handler import HandlerPatch
import matplotlib.patches as mpatches


from . import gpi_utils as gpiutils

from qgis.core import QgsVectorLayer, QgsFeature, QgsGeometry, QgsProject, QgsPointXY,QgsRectangle,QgsFeatureRequest,QgsDistanceArea
from qgis.gui import QgsMapToolEmitPoint
import processing

from .. import dxfwrite
from ..dxfwrite import DXFEngine as dxf

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'longitudinal_dockwidget_base.ui'))

class HandlerEllipse(HandlerPatch):
    def create_artists(self, legend, orig_handle,
                       xdescent, ydescent, width, height, fontsize, trans):
        center = 0.5 * width - 0.5 * xdescent, 0.5 * height - 0.5 * ydescent
        p = mpatches.Ellipse(xy=center, width=width + xdescent,
                             height=height + ydescent)
        self.update_prop(p, orig_handle, legend)
        p.set_transform(trans)
        return [p]



class longitudinalDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()
    proj = QgsProject.instance()
    
    iface= qgis.utils.iface
    sourceFeatID= None
    pointFeatureList= None
    lineFeatureList = None



    def __init__(self, parent=None):
        """Constructor."""
        super(longitudinalDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)


        # add matplotlib figure to dialog
        self.figure = Figure()
        self.axes = self.figure.add_subplot(111)
        #self.figure.subplots_adjust(left=.1, bottom=0.15, right=.78, top=.9, wspace=None)
        self.mplCanvas = FigureCanvas(self.figure)
        
        self.mpltoolbar = NavigationToolbar(self.mplCanvas, self.toolbarWidget)
        lstActions = self.mpltoolbar.actions()
        self.mpltoolbar.removeAction(lstActions[7])
        self.layoutPlot.addWidget(self.mplCanvas)
        self.layoutPlot.addWidget(self.mpltoolbar)
        self.figure.patch.set_visible(False)
        self.layoutPlot.minimumSize() 

        self.tabWidget.setCurrentIndex(1)
        
        ##connections      
        #self.buttonBox.accepted.connect(self.accept)
        #self.buttonBox.rejected.connect(self.reject)
        self.tabWidget.currentChanged.connect(self.accept)
        

        # Select feature on screen
        self.sourceIdEmitPoint = QgsMapToolEmitPoint(self.iface.mapCanvas())
        self.iface.mapCanvas().mapToolSet.connect(self.deactivated)
        self.sourceIdEmitPoint.canvasClicked.connect(self.setSourceId)
        self.iface.mapCanvas().setMapTool(self.sourceIdEmitPoint)        

        #self.uLineLayer.currentIndexChanged.connect(self.reloadLineFields)
        #self.uPointLayer.currentIndexChanged.connect(self.reloadPointFields)
         
        self.uCopytoClip.clicked.connect(self.copyClipboard)
        self.uCopytoDXF.clicked.connect(self.outDXF)

        self.manageGui()



    #Qgis mapTool deactivated signal
    def deactivated(self):
        curMapTool = self.iface.mapCanvas().mapTool()
        #if current mapTool is not this tool (self.sourceIdEmitPoint) deactivates this tool
        if curMapTool != self.sourceIdEmitPoint:
            self.iface.mapCanvas().unsetMapTool(self.sourceIdEmitPoint)
            self.buttonSelectSourceId.setChecked(False)



    def manageGui(self):
        # print('manageGui')
        self.uPointLayer.clear()
        self.uPointLayer.addItems(gpiutils.getPointLayerNames())
        
        self.uLineLayer.clear()
        self.uLineLayer.addItems(gpiutils.getLineLayerNames())
        #try to find activelayer and select it in the point combobox


#        try:
#            lyrName = qgis.utils.iface.activeLayer().name()
#            if lyrName in Lstptos:
#                self.uLineLayer.setCurrentText(lyrName)
#        except Exception as e:
#            print('Erro:',str(e))
#            pass

        # search for old settings
        settings = QSettings()
        #try: 
  
        self.uLineLayer.setCurrentText(settings.value('/longitudinal/LineLayer'))
        self.reloadLineFields()
        
        self.uPointLayer.setCurrentText(settings.value('/longitudinal/PointLayer'))
        self.reloadPointFields()


        self.uZfield1.setCurrentText(settings.value('/longitudinal/zField1'))
        self.uZfield2.setCurrentText(settings.value('/longitudinal/zField2'))
        
        self.uZfieldP1.setCurrentText(settings.value('/longitudinal/zFieldP1'))
        self.uZfieldP2.setCurrentText(settings.value('/longitudinal/zFieldP2'))

        self.uDiameter.setCurrentText(settings.value('/longitudinal/uDiameter'))
        self.uDiameterP.setCurrentText(settings.value('/longitudinal/uDiameterP'))
        self.uLineID.setCurrentText(settings.value('/longitudinal/LineID'))
        self.uPointID.setCurrentText(settings.value('/longitudinal/PointID'))

        self.labXAxis.setText(settings.value('/longitudinal/labXAxis'))
        self.labYAxis.setText(settings.value('/longitudinal/labYAxis'))
        self.labHeader.setText(settings.value('/longitudinal/labHeader'))

        self.labYScale.setText(settings.value('/longitudinal/labYScale'))
        self.labLegend.setText(settings.value('/longitudinal/labLegend'))

        # Wenn Layerame gewechselt wird Felder aktualisieren
        self.uLineLayer.currentIndexChanged.connect(self.reloadLineFields)
        self.uPointLayer.currentIndexChanged.connect(self.reloadPointFields)


        #except Exception as e:
        #    print('Erro:',str(e))
        #    pass

    def reloadLineFields(self):
        # print('reload fields')
        self.uZfield1.clear()
        self.uZfield2.clear()
        self.uDiameter.clear()
        self.uLineID.clear()


        if self.uLineLayer.currentText():
            line_layer = self.proj.mapLayersByName(self.uLineLayer.currentText())[0] #processing.getObject(str())
           
            self.uZfield1.addItems(gpiutils.getFieldNames(line_layer, [QVariant.Int, QVariant.Double]))
            self.uZfield2.addItems(gpiutils.getFieldNames(line_layer, [QVariant.Int, QVariant.Double]))
            self.uDiameter.addItems(gpiutils.getFieldNames(line_layer, [QVariant.Int, QVariant.Double]))
            self.uLineID.addItems(gpiutils.getFieldNames(line_layer, [QVariant.Int, QVariant.Double, 10]))# 10 is for string
            
    def reloadPointFields(self):
        # print('reload fields')
        self.uZfieldP1.clear()
        self.uZfieldP2.clear()
        self.uDiameterP.clear()
        self.uPointID.clear()

        if self.uPointLayer.currentText():
            
            point_layer = self.proj.mapLayersByName(self.uPointLayer.currentText())[0] #processing.getObject(str())

            self.uZfieldP1.addItems(gpiutils.getFieldNames(point_layer, [QVariant.Int, QVariant.Double]))
            self.uZfieldP2.addItems(gpiutils.getFieldNames(point_layer, [QVariant.Int, QVariant.Double]))
            self.uDiameterP.addItems(gpiutils.getFieldNames(point_layer, [QVariant.Int, QVariant.Double]))
            self.uPointID.addItems(gpiutils.getFieldNames(point_layer, [QVariant.Int, QVariant.Double, 10]))# 10 is for string


                
    def copyClipboard (self):
        if self.values is None:
            return
        else:
            clipboard = QApplication.clipboard()
            if self.uNoHeader.isChecked():
                
                clipboard.setText('\n'.join('%.3f\t%.3f' % x for x in zip(self.values[0],self.values[1])))
            else:
                clipboard.setText('distance\televation\tpointID\n'+'\n'.join('%.3f\t%.3f\t%s' % x for x in zip(self.values[0],self.values[1],self.values[2])))
            

    def restoreGui(self):
        self.buttonBox.rejected.connect(self.reject)
        self.btnClose.clicked.disconnect(self.stopProcessing)
        self.btnClose.setText(self.tr("Close"))
        self.btnOk.setEnabled(True)
        self.uprogressBar.setMaximum(100)

 

    def accept(self):
        
        #nur ausfuehren wenn Laengsschnitt angezeigt wird
        if not self.tabWidget.currentIndex()==0:
            return

        # Wenn kein LineLayer gewaehlt oder vorhanden
        if self.uLineLayer.currentText() == '':
            QMessageBox.warning(self,'Warning','Please select some LineLayer')
            self.tabWidget.setCurrentIndex(1)
            return        
        
        zField1 = self.uZfield1.currentText()
        zField2 = self.uZfield2.currentText()
        zFieldP1 = self.uZfieldP1.currentText()
        zFieldP2 = self.uZfieldP2.currentText()
        uDiameter = self.uDiameter.currentText()
        uDiameterP = self.uDiameterP.currentText()

        LineID = self.uLineID.currentText()
        PointID = self.uPointID.currentText()

        settings = QSettings()
        settings.setValue('/longitudinal/LineLayer',self.uLineLayer.currentText())
        settings.setValue('/longitudinal/PointLayer',self.uPointLayer.currentText())

        settings.setValue('/longitudinal/zField1',zField1)
        settings.setValue('/longitudinal/zField2',zField2)
        settings.setValue('/longitudinal/zFieldP1',zFieldP1)
        settings.setValue('/longitudinal/zFieldP2',zFieldP2)
        settings.setValue('/longitudinal/uDiameter',uDiameter)
        settings.setValue('/longitudinal/uDiameterP',uDiameterP)
  
        settings.setValue('/longitudinal/LineID',self.uLineID.currentText())
        settings.setValue('/longitudinal/PointID',self.uPointID.currentText())
      
        settings.setValue('/longitudinal/labXAxis',self.labXAxis.text())
        settings.setValue('/longitudinal/labYAxis',self.labYAxis.text())
        settings.setValue('/longitudinal/labHeader',self.labHeader.text())

        settings.setValue('/longitudinal/labYScale',self.labYScale.text())
        settings.setValue('/longitudinal/labLegend',self.labLegend.text())



        LineLayer = self.proj.mapLayersByName(self.uLineLayer.currentText())[0] #processing.getObject(str())
        PointLayer = self.proj.mapLayersByName(self.uPointLayer.currentText())[0] #processing.getObject(str())


        if LineLayer.selectedFeatureCount() == 0 :
            if self.tabWidget.currentIndex()==0:
                QMessageBox.warning(self,'Warning','Please select some lineFeatures')
                self.tabWidget.setCurrentIndex(1)
            return

        lineFeatureList = LineLayer.selectedFeatures()
        pointFeatureList = PointLayer.selectedFeatures()
        



        #lineFeatureList =sorted(lineFeatureList,key = lambda zz: zz[zField1],reverse = True)
        
        #print ('Unsortierte Liste:'  + str(len(lineFeatureList)) )       
        #for lineFeature in lineFeatureList:   
        #    print(lineFeature.id())

        #Sortieren der Linienliste
        #lineFeatureList = Linesorted(lineFeatureList)
        
        lineFeatureList = gpiutils.Linesorted(LineLayer,lineFeatureList,float(self.spinBoxTol.value()),self.uIdirection.isChecked)

        #print ('Sortierte Liste:' + str(len(lineFeatureList)))
        #for lineFeature in lineFeatureList:   
        #    print(lineFeature.id())

        selfeatP=[]
        selfpointFeatureList=[]
        for lineFeature in lineFeatureList:
            selP = gpiutils.selectPointFeaturefromlineFeature(LineLayer,lineFeature,PointLayer,float(self.spinBoxTol.value()))                
            if selP[0] :
                selfeatP.append(selP[0].id())
                selfpointFeatureList.append(selP[0])
            else:
                QMessageBox.warning(self,'Warning','No Upperpoint from lineFeature '+lineFeature[LineID]+ ' found')
                selectedFeatureID = []
                selectedFeatureID.append(lineFeature.id())
                LineLayer.removeSelection()                    
                LineLayer.selectByIds(selectedFeatureID)
                self.iface.mapCanvas().zoomToSelected(LineLayer)
                self.tabWidget.setCurrentIndex(1)
                return
                


        # und den Endschacht
                      
        if selP[1] :
            selfeatP.append(selP[1].id())
            selfpointFeatureList.append(selP[1])
        else:
            QMessageBox.warning(self,'Warning','No Downpoint from lineFeature '+lineFeature[LineID]+ ' found')
            selectedFeatureID = []
            selectedFeatureID.append(lineFeature.id())
            LineLayer.removeSelection()                    
            LineLayer.selectByIds(selectedFeatureID)
            self.iface.mapCanvas().zoomToSelected(LineLayer)
            self.tabWidget.setCurrentIndex(1)
            return


        PointLayer.removeSelection()                    
        PointLayer.selectByIds(selfeatP)
        pointFeatureList = selfpointFeatureList


        self.uSelectedLine.setText('Now selected Lines '+ str(len(lineFeatureList)))
        self.uSelectedPoints.setText('Now selected Points '+ str(len(pointFeatureList)))

        self.lineFeatureList=lineFeatureList
        self.pointFeatureList=pointFeatureList

        lineList = []
        zListSohle = []
        zListScheitel = []

        zminList = []
        distList = []
        distListSchacht = []

        zListGelaende=[]
        zListSchacht=[]

        pointIdList = []
        
        linelength=0
        lfdnr=0

        for lineFeature in lineFeatureList:

            lineGeom = lineFeature.geometry()
            #print ("Perimeter:", lineGeom.length())

            #Haltung

            if lineFeature[uDiameter] :
                zRohrbreite=round(lineFeature[uDiameter],2)
                if zRohrbreite<=0 or zRohrbreite>5000 :
                        zRohrbreite =1.0
            else:
                zRohrbreite =1  

            zListSohle.append(lineFeature[zField1])
            zListScheitel.append(lineFeature[zField1]+zRohrbreite/1000)

            selpoint=PointLayer.getFeature(selfeatP[lfdnr])
            zListGelaende.append(selpoint[zFieldP1]) #Gelaendehoehe

            #Schacht
            if selpoint[uDiameterP] :
                zSchachtbreite=round(selpoint[uDiameterP],2)
                if zSchachtbreite<=0 or zSchachtbreite>5 :
                        zSchachtbreite =1.0
            else:
                zSchachtbreite =1  
            # Abstand
            distList.append(linelength) #Laenge
                                      
            #Sohle
            distListSchacht.append(linelength-zSchachtbreite/2)
            zListSchacht.append(selpoint[zFieldP2])
            #Schacht oben links
            distListSchacht.append(linelength-zSchachtbreite/2)
            zListSchacht.append(selpoint[zFieldP1])
            #Schacht oben rechts
            distListSchacht.append(linelength+zSchachtbreite/2)
            zListSchacht.append(selpoint[zFieldP1])            
            #Schacht unten
            distListSchacht.append(linelength+zSchachtbreite/2)
            zListSchacht.append(selpoint[zFieldP2])            

            pointIdList.append(selpoint[PointID])
            

            try:
                linelength+=lineGeom.length()
            except:
                QMessageBox.warning(self,'Warning','No length from geometry')
                return

            # Abstand
            distList.append(round(linelength,3)-zSchachtbreite/2)

            zListSohle.append(lineFeature[zField2])
            zListScheitel.append(lineFeature[zField2]+zRohrbreite/1000)
            
            selpoint=PointLayer.getFeature(selfeatP[lfdnr+1])
            zListGelaende.append(selpoint[zFieldP1])

            #Schacht 2                       
            distListSchacht.append(linelength-zSchachtbreite/2)
            zListSchacht.append(lineFeature[zField2])

            distListSchacht.append(linelength-zSchachtbreite/2)
            zListSchacht.append(selpoint[zFieldP1])

            distListSchacht.append(linelength+zSchachtbreite/2)
            zListSchacht.append(selpoint[zFieldP1])            

            distListSchacht.append(linelength+zSchachtbreite/2)
            zListSchacht.append(selpoint[zFieldP2])            

            #Beschriftung

            pointIdList.append(selpoint[PointID])


            lfdnr+=1



        zmin= round(min(zListSohle),0)-1
        anzListe=   len(zListSohle)    
        zminList=[zmin]*anzListe

        for i in range(0,anzListe,2):
            zminList[i]=zListSohle[i]

        self.values = [distList, zListSohle, zListScheitel, zListGelaende, distListSchacht, zListSchacht,pointIdList,zminList]
        self.refreshPlot()
        self.uCopytoClip.setEnabled(True)
        self.uCopytoDXF.setEnabled(True)
        


    def refreshPlot(self):
        self.axes.clear()

        if self.values is None:
            return
        l4, = self.axes.plot(np.array(self.values[4]),np.array(self.values[5]),label = 'Schacht')
        l1, = self.axes.plot(np.array(self.values[0]),np.array(self.values[1]),label = 'Sohle')
        l2, = self.axes.plot(np.array(self.values[0]),np.array(self.values[2]),label = 'Scheitel')
        l3, = self.axes.plot(np.array(self.values[0]),np.array(self.values[3]),label = 'Gelaende')
        
        l4.set_color('#0015ffff')
        l1.set_color('#d028a6ff')
        l2.set_color('#d028a6ff')
        l3.set_color('#b27f4fff')

        ###to draw labels from jorgealmerio 
        if self.uIDlabels.isChecked():
            for i,linha in enumerate(np.array(self.values[6])):
                
                if i%2 : #nur jede 2. Beschriftung
                    id=''
                else:
                    id=self.values[6][i]

                dist=self.values[0][i]
                z=self.values[1][i]
                self.axes.annotate(id,(dist,z),fontsize=7, rotation=00,horizontalalignment='left', verticalalignment='top' )

        if self.uIDlabels.isChecked():
            for i,linha in enumerate(np.array(self.values[3])):
               
                if i%2:#nur jede 2. Beschriftung
                    id=''
                else:
                    id=self.values[3][i]

                dist=self.values[0][i]
                z=self.values[3][i]
                self.axes.annotate(id,(dist,z),fontsize=6, rotation=0,horizontalalignment='right', verticalalignment='bottom' )

        self.axes.grid()
        formatter = ScalarFormatter(useOffset=False)
        self.axes.yaxis.set_major_formatter(formatter)

        self.axes.set_ylabel(str(self.labYAxis.text()))
        self.axes.set_xlabel(str(self.labXAxis.text()))
        self.axes.set_title(str(self.labHeader.text()))
        self.axes.yaxis.get_label().set_color(l1.get_color())

        self.mplCanvas.draw()  
    
   
    def clickedOnCanvasAction(self,clickedPoint):
        
            self.iface.mapCanvas().setMapTool(self.module.mapSelectionTool)
            crsCanvas = self.module.iface.mapCanvas().mapSettings().destinationCrs() # get current crs
            crsWGS84 = QgsCoordinateReferenceSystem(4326)  # WGS 84
            xform = QgsCoordinateTransform(crsCanvas, crsWGS84, QgsProject.instance())
            wgs84point = xform.transform(clickedPoint)
            self.lon_widget.setText(str(wgs84point.x()))
            self.lat_widget.setText(str(wgs84point.y()))
            super(mapillaryFilter, self).show()
            self.raise_() 
    

    def display_point(self,mouse_point, mouse_button): 

        coords = "Map Coordinates: {:.4f}, {:.4f}".format(mouse_point.x(), mouse_point.y())

        print (coords)

        layer = self.iface.activeLayer()
        feats = [ feat for feat in layer.getFeatures() ]
        
        geo_pt =  QgsGeometry.fromPointXY(QgsPointXY(mouse_point.x(), mouse_point.y()))
        print (geo_pt)


        id = -1

        for feat in feats:
            if geo_pt.distance(feat.geometry())<1:
                id = feat.id()
                break

        if id != -1:
            print (id)
        else:
            print ("no feature selected")


    def getStatsByCat(self, layer):
        #Returns features table with count grouped by PVM
        # featStats = self.getStatsByCat(layer)
        params = {'INPUT':layer,
            'VALUES_FIELD_NAME':'',
            'CATEGORIES_FIELD_NAME':['PVM'],
            'OUTPUT':'TEMPORARY_OUTPUT'}
        res = processing.run('qgis:statisticsbycategories', params)
        return res['OUTPUT'] 


    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()
    

    def setSourceId(self, pt):

        if not self.buttonSelectSourceId.isChecked():
            return
        
        proj = QgsProject.instance()
        layer = self.proj.mapLayersByName(self.uLineLayer.currentText())[0] 
        
        layer.removeSelection()
        width = self.iface.mapCanvas().mapUnitsPerPixel() * 4
        rect = QgsRectangle(pt.x() - width,
                                pt.y() - width,
                                pt.x() + width,
                                pt.y() + width)

        layer.selectByRect(rect)
        selected_features = layer.selectedFeatures()
        if layer.selectedFeatureCount()>1:
            QMessageBox.Warning(self, 'Warning',
                    'WARNING: more than one feature selected!\n')
            return

        if layer.selectedFeatureCount()==0:
            return

        for feat in selected_features:
            self.sourceFeatID=feat.id()
        
        gpiutils.selectDownstream(layer,self.sourceFeatID,float(self.spinBoxTol.value()),self.uIdirection.isChecked())
        
        self.buttonSelectSourceId.setChecked(False)


    def outDXF(self):
        #,iface, wdg, mdl, library, profiles, type="3D"
        #self.values = [distList, zListSohle, zListScheitel, zListGelaende, distListSchacht, zListSchacht,pointIdList,zminList]
        zField1 = self.uZfield1.currentText()
        zField2 = self.uZfield2.currentText()
        zFieldP1 = self.uZfieldP1.currentText()
        zFieldP2 = self.uZfieldP2.currentText()
        uDiameter = self.uDiameter.currentText()
        uDiameterP = self.uDiameterP.currentText()


        LineID = self.uLineID.currentText()
        PointID = self.uPointID.currentText()

        

        fileName = gpiutils.getSaveFileName(None,
                                   caption = "Save As",
                                   directory = "",
                                   #filter = "Profile of " + name + ".png",
                                   filter = "dxf (*.dxf)")

        if fileName and len(self.lineFeatureList):

            
            drawing = dxf.drawing(fileName)
            drawing.add_layer("Laengs_Haltung")

            
            #Legende     
            scaleY =1    
            scaleY=self.labYScale.text()
            zeilenh=2
            schrifth=.3
            schriftX=-5
            linelength=schriftX
            
            #sZeilen="Höhe geplant [müNN],Geländehöhe [müNN],Sohlhöhe [müNN],Tiefe [m],Länge [m],Gefälle [o/oo],Nennweite [mm],Name"
            sZeilen = self.labLegend.text()
            sZeilen = sZeilen.split(',')


            lineFeature=self.lineFeatureList[len(self.lineFeatureList)-1]
            bezugsh=round(lineFeature[zField2] ,0)
            drawing.add(dxf.text(bezugsh,[linelength,bezugsh,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))

            for ze in range(1, len(sZeilen)+1):
                drawing.add(dxf.text(sZeilen[ze-1],[linelength,bezugsh-zeilenh*ze,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))

            linelength=0
            lfdnr =0
            pGelaende=[]
            pSchacht=[]
            pSohle=[]
            pScheitel=[]

            ###to draw 
            for lineFeature in self.lineFeatureList:

                lineGeom = lineFeature.geometry()

               
                #Schacht waehlen
                pointFeature= self.pointFeatureList[lfdnr]
                
                #Sohle
                zDeckelSchacht=round(pointFeature[zFieldP1],2)
                zSohleSchacht=round(pointFeature[zFieldP2],2)

                if pointFeature[uDiameterP] :
                    zSchachtbreite=round(pointFeature[uDiameterP],2)
                    if zSchachtbreite<=0:
                         zSchachtbreite =1.0
                else:
                    zSchachtbreite =1

                zNameSchacht= pointFeature[PointID]

                pSchacht.append([linelength-zSchachtbreite/2,zDeckelSchacht,0])
                pSchacht.append([linelength-zSchachtbreite/2,zSohleSchacht,0])
                pSchacht.append([linelength+zSchachtbreite/2,zSohleSchacht,0])
                pSchacht.append([linelength+zSchachtbreite/2,zDeckelSchacht,0]) 

                drawing.add(dxf.polyline(pSchacht, color=7, layer="Laengs_Schacht"))
                #drawing.add(dxf.text(zNameSchacht,[linelength,zDeckelSchacht,0],schrifth,color=7,rotation=0, layer="Laengs_Schacht"))
                drawing.add(dxf.text(zNameSchacht,[linelength,bezugsh-zeilenh*8,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                pSchacht=[]


                #Haltung


                if lineFeature[uDiameter] :
                    zRohrbreite=round(lineFeature[uDiameter],2)
                    if zRohrbreite<=0 or zRohrbreite>5000 :
                            zRohrbreite =1.0
                else:
                    zRohrbreite =1  

                zSohleO=round(lineFeature[zField1],2)
                zScheitelO=round(lineFeature[zField1]+zRohrbreite/1000,2)
                zSohleU=round(lineFeature[zField2],2)
                zScheitelU=round(lineFeature[zField2]+zRohrbreite/1000,2)
                zName= lineFeature[LineID]
                laenge=round(lineGeom.length(),2)
                gefaelle=round((zSohleO-zSohleU)/laenge*1000,0)
                tiefe=round(zDeckelSchacht-zSohleSchacht,2)


                pGelaende.append([linelength,zDeckelSchacht,0])

                pSohle.append([linelength+zSchachtbreite/2,zSohleO,0])
                pScheitel.append([linelength+zSchachtbreite/2,zScheitelO,0])


                # Legende
                drawing.add(dxf.text(zDeckelSchacht,        [linelength,bezugsh-zeilenh*1,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                drawing.add(dxf.text(zDeckelSchacht,        [linelength,bezugsh-zeilenh*2,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                drawing.add(dxf.text(zSohleSchacht,         [linelength,bezugsh-zeilenh*3,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                drawing.add(dxf.text(tiefe,                 [linelength,bezugsh-zeilenh*4,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                drawing.add(dxf.text(laenge,                [linelength+laenge/2,bezugsh-zeilenh*5,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                drawing.add(dxf.text(gefaelle,              [linelength+laenge/2,bezugsh-zeilenh*6,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                drawing.add(dxf.text(zRohrbreite,           [linelength+laenge/2,bezugsh-zeilenh*7,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                drawing.add(dxf.text(zName,                 [linelength+laenge/2,bezugsh-zeilenh*8,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
                #drawing.add(dxf.text(zNameSchacht,          [linelength+laenge/2,zDeckelSchacht,0],schrifth,color=7,rotation=0, layer="Laengs_Schacht"))

                #Legende senkrecht
                drawing.add(dxf.polyline([[linelength,zSohleSchacht,0],[linelength,bezugsh-zeilenh*len(sZeilen),0]], color=7, layer="Laengs_Legende"))

                #GesamtLaenge 
                try:
                    linelength+=laenge
                except:
                    QMessageBox.warning(self,'Warning','No length from geometry')
                    return

                pSohle.append([linelength-zSchachtbreite/2,zSohleU,0])
                pScheitel.append([linelength-zSchachtbreite/2,zScheitelU,0])
                
                lfdnr+=1



            #Endschacht            
            pointFeature= self.pointFeatureList[lfdnr]



            #Sohle
            zDeckelSchacht=pointFeature[zFieldP1]
            zSohleSchacht=pointFeature[zFieldP2]
            tiefe=round(zDeckelSchacht-zSohleSchacht,2)
            zNameSchacht= lineFeature[LineID]

            pSchacht.append([linelength-zSchachtbreite/2,zDeckelSchacht,0])
            pSchacht.append([linelength-zSchachtbreite/2,zSohleSchacht,0])
            pSchacht.append([linelength+zSchachtbreite/2,zSohleSchacht,0])
            pSchacht.append([linelength+zSchachtbreite/2,zDeckelSchacht,0])              
            drawing.add(dxf.polyline(pSchacht, color=7, layer="Laengs_Schacht"))
            drawing.add(dxf.text(zNameSchacht,[linelength,zDeckelSchacht,0],schrifth,color=7,rotation=0, layer="Laengs_Schacht"))
            drawing.add(dxf.text(zName,       [linelength,bezugsh-zeilenh*8,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))

            pSchacht=[]  


            # Legende
            drawing.add(dxf.text(zDeckelSchacht,        [linelength,bezugsh-zeilenh*1,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
            drawing.add(dxf.text(zDeckelSchacht,        [linelength,bezugsh-zeilenh*2,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
            drawing.add(dxf.text(zSohleSchacht,         [linelength,bezugsh-zeilenh*3,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
            drawing.add(dxf.text(tiefe,                 [linelength,bezugsh-zeilenh*4,0],schrifth,color=7,rotation=0, layer="Laengs_Legende"))
            drawing.add(dxf.polyline([[linelength,zSohleSchacht,0],[linelength,bezugsh-zeilenh*len(sZeilen),0]], color=7, layer="Laengs_Legende"))

            # Endpunkt der Haltung
           
            pGelaende.append([linelength,zDeckelSchacht,0])
            pSohle.append([linelength-zSchachtbreite/2,zSohleU,0])
            pScheitel.append([linelength-zSchachtbreite/2,zScheitelU,0])

            drawing.add(dxf.polyline(pSohle, color=7, layer="Laengs_Haltung"))
            drawing.add(dxf.polyline(pScheitel, color=7, layer="Laengs_Haltung"))
            drawing.add(dxf.polyline(pGelaende, color=7, layer="Laengs_Gelaende"))

            #Legende
            for ze in range(0, len(sZeilen)+1):
                drawing.add(dxf.polyline([[schriftX,bezugsh-zeilenh*ze-schrifth/2,0],[linelength-schriftX,bezugsh-zeilenh*ze-schrifth/2,0]], color=7, layer="Laengs_Legende"))

            drawing.save()
