# -*- coding: utf-8 -*-
"""
/***************************************************************************
 lockedlayers
                                 A QGIS plugin
 A tool to change which layers are locked in a composer map
                              -------------------
        begin                : 2012-07-03
        copyright            : (C) 2012 by James Stott / Nicholas Pearson Associates
        email                : james.stott@npaconsult.co.uk

 Icon from http://www.famfamfam.com/lab/icons/silk/

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
from os import path
import inspect
# Initialize Qt resources from file resources.py
import resources
# Import the code for the dialog
from lockedlayersdialog import lockedlayersDialog

class lockedlayers:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # Create the dialog and keep reference
        self.dlg = lockedlayersDialog(self.iface)
        # initialize plugin directory
        self.plugin_dir = QFileInfo(QgsApplication.qgisUserDbFilePath()).path() + "/python/plugins/lockedlayers"
        # initialize locale
        localePath = ""
        locale = QSettings().value("locale/userLocale").toString()[0:2]

        if QFileInfo(self.plugin_dir).exists():
            localePath = self.plugin_dir + "/i18n/lockedlayers_" + locale + ".qm"

        if QFileInfo(localePath).exists():
            self.translator = QTranslator()
            self.translator.load(localePath)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)


    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/lockedlayers/icon.png"), \
            u"Locked Layers Editor", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu(u"&Locked Layers Editor", self.action)
        
        # help
        self.helpAction = QAction(QIcon(":/plugins/lockedlayers/help.png"), \
                              "Help", self.iface.mainWindow())
        self.helpAction.setWhatsThis("Locked Layer Editor Help")
        self.iface.addPluginToMenu("Locked Layers Editor", self.helpAction)
        QObject.connect(self.helpAction, SIGNAL("activated()"), self.help)

        # try and add it to the composer windows - maybe later

        """composerList = self.iface.activeComposers()
        QMessageBox.information( self.iface.mainWindow(),"Info", str(len(composerList)))
        if(len(composerList) < 1):
            return
        j = 0
        for i in composerList:

            composerView = composerList[j]
            composer = composerView.composerWindow()
            toolBar = composer.addToolBar("Locked Layers Toolbar")
            toolBar.addAction(self.action)
            self.mToolBar = toolBar
            QMessageBox.information( self.iface.mainWindow(),"Info", str(self.mToolBar.windowTitle()))
            j += 1

        if(composer is None):
            return


        #composerAdded (QgsComposerView *v) self.iface.composerAdded


        #QMessageBox.information( self.iface.mainWindow(),"Info", "Test")"""

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&Locked Layers Editor",self.action)
        self.iface.removeToolBarIcon(self.action)
        self.iface.removePluginMenu("&Locked Layers Editor",self.helpAction)

        """ # Again for later once main functionality is working.
        composerList = self.iface.activeComposers()
        if(len(composerList) < 1):
            return

        composerView = composerList[0]
        composer = composerView.composerWindow()



        #if self.mToolBar.windowTitle() == "Locked Layers Toolbar":
            #composer.removeToolBar(self.mToolBar)

        #if(composer is None):
            #return

        #j = 0
        #for i in composerList:

            #if self.mToolBar.windowTitle() == "Locked Layers Toolbar":
                #QMessageBox.information( self.iface.mainWindow(),"Info", "Test")
                #composer.removeToolBar(self.mToolBar)
                #j += 1"""


    # run method that performs all the real work
    def run(self):
        # check if we have any composers present, if we do show the dialog
        composerList = self.iface.activeComposers()
        if(len(composerList) > 0):
            #self.dlg.populateTable()
            self.dlg.clearTable()
            self.dlg.findComposers()
        
            self.dlg.show()
            # Run the dialog event loop
            result = self.dlg.exec_()
            # See if OK was pressed
            if result == 1:
                # do something useful (delete the line containing pass and
                # substitute with your code)
                #self.dlg.unlockLayers()
                pass
        else:
            QMessageBox.information( self.iface.mainWindow(),"Info", "You do not have any composers open")

    def help(self):
        file = inspect.getsourcefile(lockedlayers)
        file = 'file://' + path.join(path.dirname(file),'help/index.html')
        file = file.replace("\\","/")
        self.iface.openURL(file, False)


