# -*- coding: utf-8 -*-
"""
/***************************************************************************
 lockedlayersDialog
                                 A QGIS plugin
 A tool to change which layers are locked in a composer map
                             -------------------
        begin                : 2012-07-03
        copyright            : (C) 2012 by James Stott / Nicholas Pearson Associates
        email                : james.stott@npaconsult.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis import core, gui
from ui_lockedlayers import Ui_lockedlayers
# create the dialog for zoom to point
class lockedlayersDialog(QtGui.QDialog):
    def __init__(self,iface):
        QtGui.QDialog.__init__(self)
        # Set up the user interface from Designer.
        self.iface = iface
        self.ui = Ui_lockedlayers()
        self.ui.setupUi(self)

        # set column widths and headers for the table part of the dialog

        item = QtGui.QTableWidgetItem()
        self.ui.tableWidget.setHorizontalHeaderItem(0, item)
        self.ui.tableWidget.setColumnWidth (0, 240)
        self.ui.tableWidget.horizontalHeaderItem(0).setText("Layer ID")
        item = QtGui.QTableWidgetItem()
        self.ui.tableWidget.setHorizontalHeaderItem(2, item)
        self.ui.tableWidget.setColumnWidth (2, 240)
        self.ui.tableWidget.horizontalHeaderItem(2).setText("Layer Name")
        item = QtGui.QTableWidgetItem()
        self.ui.tableWidget.setHorizontalHeaderItem(1, item)
        self.ui.tableWidget.setColumnWidth (1, 240)
        self.ui.tableWidget.horizontalHeaderItem(1).setText("Layer Title")

        self.table = self.ui.tableWidget
        self.table.setRowCount(0) # set the row count to zero

        # connect the toolbar button to an action
        self.action = QAction(QIcon(":/plugins/lockedlayers/icon.png"), \
            u"Locked Layers Editor", self.iface.mainWindow())
        # connect the action to the run method
        self.connect(self.ui.comboComposer, SIGNAL('activated(QString)'), self.populateTable)



    def findComposers(self):
        self.ui.comboComposer.clear() # clear the composers combo box
        self.ui.comboComposer.addItem("") # add a blank item as the first row
        composers = self.iface.activeComposers() # find all the composers
        
        for cv in composers: # cycle through composers
            if self.noComposerMaps(cv) == 1: # check if there is only 1 composer map on the composer
                for item1 in cv.composition().items(): # cycle through all items on the composer
                    if item1.type() == 65641: # and just return the one composerMap?
                        #if item1.keepLayerSet(): # check if the composermap item has locked layers turned on or not
                        self.ui.comboComposer.addItem(cv.composerWindow().windowTitle(), QVariant(cv)) # add the composer to the combobox if it does

    def populateTable(self,text):

        if self.ui.comboComposer.currentIndex() != 0: # check if the combobox is anything other than the blank first row.
            
            self.table.setRowCount(0) # set the row count to zero
            composers = self.iface.activeComposers() # find all composers
            i = 0
            for cv in composers: # cycle through the composer views
                if cv.composerWindow().windowTitle() == self.ui.comboComposer.currentText(): # check if the composer has the same name as the combobox selection
                    for item1 in cv.composition().items(): # cycle all items on the composer
                        if item1.type() == 65641: # 65641 = ComposerMap? # look for composermap
                            for layer in self.iface.legendInterface().layers(): # get each layer in the project

                                self.table.setRowCount(self.table.rowCount()+1) # add a row to the table
                                
                                # start with the layer id for each layer in column 0 
                                nameItem = QTableWidgetItem(str(layer.id())) 
                                nameItem.setFlags(QtCore.Qt.ItemIsUserCheckable|QtCore.Qt.ItemIsSelectable|QtCore.Qt.ItemIsEnabled)
                                nameItem.setCheckState(QtCore.Qt.Unchecked)

                                # check which layers are currently locked to the layerset...
                                for item2 in item1.layerSet():
                                    if layer.id() == str(item2):

                                        nameItem.setCheckState(QtCore.Qt.Checked)# ...and check the checkbox if it is
                                        nameItem.setData(QtCore.Qt.UserRole,str(item2))
                                        pass

                                    else:
                                        nameItem.setData(QtCore.Qt.UserRole,str(item2)) # ...if not then leave it unchecked it

                                self.table.setItem(i,0,nameItem)
                                # then the layer name in column 2 - Layer Name
                                nameItem1 = QTableWidgetItem(str(layer.name()))
                                nameItem1.setFlags(QtCore.Qt.ItemIsUserCheckable|QtCore.Qt.ItemIsSelectable|QtCore.Qt.ItemIsEnabled)
                                nameItem1.setData(QtCore.Qt.UserRole,str(layer.name()))
                                self.table.setItem(i,2,nameItem1)
                                # and the layer title in column 1 - Layer Title (I use these sometimes when I do want a layer name on the legend
                                nameItem2 = QTableWidgetItem(str(layer.title()))
                                nameItem2.setFlags(QtCore.Qt.ItemIsUserCheckable|QtCore.Qt.ItemIsSelectable|QtCore.Qt.ItemIsEnabled)
                                nameItem2.setData(QtCore.Qt.UserRole,str(layer.title()))
                                self.table.setItem(i,1,nameItem2)
                                i += 1

        else:
            self.table.setRowCount(0) # clear the table if the user selects the blank top row.

    # check the number of composermaps on a single composer. 
    # In the future I will try and support multiple composermaps.

    def noComposerMaps(self,composerName): 
        i = 0
        for item1 in composerName.composition().items(): # cycle all items on the composer
            
            if item1.type() == 65641:
                i += 1
        
        if i > 1: # if there is more than 1 composer map, tell the user this is the reason why it wont work on this composer.
            
            QMessageBox.information( self.iface.mainWindow(),"Info", "Window '" +str(composerName.composerWindow().windowTitle()) + "' has more than 1 composermap. The plugin only supports 1 map per composer at the moment.")
        
        return(i) # return the number of composermaps items
                

    # clear the table of data

    def clearTable(self):
        #
        self.table.clearContents()
        self.table.setRowCount(0)


    # if the user selects the ok button, replace the layer set with the new layerset
    # based on the users choice of layers.

    def accept(self):

        self.newlist = []

        if self.ui.comboComposer.currentIndex() != 0:
            #self.newlist = []

            for row in range(self.table.rowCount()):
                self.table.item(row,0)


            for row in range(self.table.rowCount()):
                if self.table.item(row,0).checkState():

                    index = self.table.item(row,0).data(QtCore.Qt.UserRole).toInt()[1]
                    name = self.table.item(row,0).data(QtCore.Qt.UserRole).toInt()[1]
                    self.newlist.append(self.table.item(row,0).text())

        
            composers = self.iface.activeComposers()
            i = 0
            for cv in composers:
                if cv.composerWindow().windowTitle() == self.ui.comboComposer.currentText():
                    for item1 in cv.composition().items():
                        if item1.type() == 65641:
                            
                            QMessageBox.information( self.iface.mainWindow(),"Info", str(len(self.newlist)))
                            if len(self.newlist) == 0:
                                
                                item1.setKeepLayerSet(False)

                            else:
                                item1.setLayerSet(self.newlist)
                                item1.setKeepLayerSet(True)
                                
                    item1.updateItem()

        super(lockedlayersDialog,self).accept()
