# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LocatePlleXY
                                 A QGIS plugin
 Plugin de recherche et localisation par coordonnées XY ou identifiant parcellaire (Nature, Numéro, Indice)
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-23
        git sha              : $Format:%H$
        copyright            : (C) 2025 by California29
        email                : gabrieltorue@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QPushButton
from qgis.PyQt.QtWidgets import QMessageBox
from qgis.core import QgsPointXY, QgsCoordinateReferenceSystem, QgsCoordinateTransform, QgsProject
from qgis.utils import iface
from qgis.PyQt.QtWidgets import QDockWidget
from qgis.PyQt.QtCore import Qt

from .LocatePlleXY_dialog import LocatePlleXYDialog
import os.path


class LocatePlleXY:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        self.project_signals_connected = False  # Nouveau flag pour gérer les connexions
        self.button_connections_done = False
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'LocatePlleXY_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&GeoParcelle')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
        # self.button_connections_done = False
    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('LocatePlleXY', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/LocatePlleXY/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Localiser Plle/XY'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True
        self.toolbar = self.iface.addToolBar("GeoParcelle")
        self.toolbar.setObjectName("GeoParcelle")

        self.action = QAction(QIcon(os.path.join(self.plugin_dir, "icon.png")), "Localiser Plle/XY", self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.toolbar.addAction(self.action)

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        # Déconnecter les signaux du projet
        if self.project_signals_connected:
            QgsProject.instance().layersAdded.disconnect(self.refresh_layer_list)
            QgsProject.instance().layersRemoved.disconnect(self.refresh_layer_list)
            self.project_signals_connected = False
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&GeoParcelle'),
                action)
            self.iface.removeToolBarIcon(action)
        # Supprimer l’icône de la barre d’outils
        if hasattr(self, 'toolbar'):
            del self.toolbar
        try:
            iface.removeDockWidget(self.dock_widget)
        except Exception:
            pass
    def refresh_layer_list(self):
        """Actualise la liste des couches vectorielles dans le combobox"""
        current_selection = None
        if self.dlg.comboLayer.currentIndex() >= 0:
            current_selection = self.dlg.comboLayer.currentData()
        
        self.dlg.comboLayer.clear()
        vector_layers = []
        
        for layer in QgsProject.instance().mapLayers().values():
            if layer.type() == layer.VectorLayer:
                vector_layers.append(layer)
                self.dlg.comboLayer.addItem(layer.name(), layer.id())
        
        # Restaurer la sélection précédente si possible
        if current_selection:
            index = self.dlg.comboLayer.findData(current_selection)
            if index >= 0:
                self.dlg.comboLayer.setCurrentIndex(index)
                return
        
        # Sélectionner la première couche par défaut
        if vector_layers:
            self.dlg.comboLayer.setCurrentIndex(0)
    def update_field_comboboxes(self):
        """Met à jour les combobox de champs selon la couche sélectionnée"""
        idx = self.dlg.comboLayer.currentIndex()
        if idx < 0:
            return
            
        layer_id = self.dlg.comboLayer.itemData(idx)
        layer = QgsProject.instance().mapLayer(layer_id)
        
        if not layer:
            return
            
        # Mettre à jour les champs
        field_names = {field.name().lower(): field.name() for field in layer.fields()}
        
        # Récupération des valeurs uniques pour Nature
        if 'nature' in field_names:
            real_nature = field_names['nature']
            nature_values = set(str(feat[real_nature]) for feat in layer.getFeatures())
            self.dlg.comboNature.clear()
            self.dlg.comboNature.addItems(sorted(nature_values))
        else:
            self.dlg.comboNature.clear()
        
        # Récupération des valeurs uniques pour Indice
        if 'indice' in field_names:
            real_indice = field_names['indice']
            indice_values = set(str(feat[real_indice]) for feat in layer.getFeatures())
            self.dlg.comboIndice.clear()
            self.dlg.comboIndice.addItems(sorted(indice_values))
        else:
            self.dlg.comboIndice.clear()


    def run(self):
            self.initialize_plugin()

    def initialize_plugin(self):
        """Initialise l'interface du plugin et l'affiche en onglet avec le panneau 'Couches'."""
        if not hasattr(self, 'dock_widget'):
            self.dlg = LocatePlleXYDialog()

            self.dock_widget = QDockWidget("GeoParcelle", self.iface.mainWindow())
            self.dock_widget.setWidget(self.dlg)
            self.dock_widget.setObjectName("LocatePlleXYDock")
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dock_widget)

            # 🔁 Tenter de le tabifier avec le panneau "Couches"
            for widget in self.iface.mainWindow().findChildren(QDockWidget):
                if widget.windowTitle().lower() == "couches":
                    self.iface.mainWindow().tabifyDockWidget(widget, self.dock_widget)
                    break

        self.dock_widget.show()
        self.dock_widget.raise_()  # Rend le panneau actif si tabulé
        # Initialiser la liste des couches
        self.refresh_layer_list()
        # Connecter les signaux pour actualisation automatique
        if not self.project_signals_connected:
            QgsProject.instance().layersAdded.connect(self.refresh_layer_list)
            QgsProject.instance().layersRemoved.connect(self.refresh_layer_list)
            self.project_signals_connected = True
        # Mettre à jour les champs pour la couche actuelle
        self.update_field_comboboxes()
        
        # Connecter le changement de couche à l'update des champs
        self.dlg.comboLayer.currentIndexChanged.connect(self.update_field_comboboxes)

        # Remplir la combo des couches - UNIQUEMENT VECTORIELLES
        self.dlg.comboLayer.clear()
        vector_layers = []
        for layer in QgsProject.instance().mapLayers().values():
            if layer.type() == layer.VectorLayer:  # <-- FILTRE IMPORTANT
                vector_layers.append(layer)
                self.dlg.comboLayer.addItem(layer.name(), layer.id())
        
        # Remplir les listes déroulantes seulement si on a des couches vectorielles

        if vector_layers:
            layer = vector_layers[0]
            field_names = {field.name().lower(): field.name() for field in layer.fields()}
            
            # Récupération des valeurs uniques
            nature_values = set()
            num_values = set()
            indice_values = set()
            
            # Utiliser les noms réels des champs
            real_nature = field_names.get('nature')
            real_indice = field_names.get('indice')
            
            if real_nature and real_indice:
                for f in layer.getFeatures():
                    if real_nature:
                        nature_values.add(str(f[real_nature]))
                    if real_indice:
                        indice_values.add(str(f[real_indice]))
            
            # Mettre à jour les combobox
            if real_nature:
                self.dlg.comboNature.clear()
                self.dlg.comboNature.addItems(sorted(nature_values))
            
            if real_indice:
                self.dlg.comboIndice.clear()
                self.dlg.comboIndice.addItems(sorted(indice_values))
        
        else:
            # Message si aucune couche vectorielle trouvée
            self.dlg.comboNature.clear()
            self.dlg.comboIndice.clear()
            QMessageBox.warning(None, "Aucune couche", "Aucune couche vectorielle trouvée dans le projet")

        # Évite de connecter les boutons plusieurs fois
        if not self.button_connections_done:
            self.dlg.btnLocate.clicked.connect(self.locate_coordinates)
            self.dlg.btnLocateByID.clicked.connect(self.locate_by_parcelle)
            # Ajout du nouveau bouton pour vérifier les chevauchements
            self.dlg.btnCheckOverlap = QPushButton("Smart Repérage")
            self.dlg.verticalLayout.addWidget(self.dlg.btnCheckOverlap)  # Ajout dans la disposition
            self.dlg.btnCheckOverlap.clicked.connect(self.check_parcel_overlap)
            self.button_connections_done = True



    def check_parcel_overlap(self):
        """Vérifie si la parcelle sélectionnée chevauche ses voisines et calcule la surface de chevauchement"""
        from qgis.core import QgsFeatureRequest, QgsGeometry, QgsCoordinateReferenceSystem, QgsCoordinateTransform
        from qgis.PyQt.QtWidgets import QMessageBox
        
        try:
            # Récupérer la couche active
            idx = self.dlg.comboLayer.currentIndex()
            if idx < 0:
                QMessageBox.warning(None, "Erreur", "Aucune couche sélectionnée")
                return
                
            layer_id = self.dlg.comboLayer.itemData(idx)
            layer = QgsProject.instance().mapLayer(layer_id)
            
            if not layer:
                QMessageBox.warning(None, "Erreur", "Couche invalide")
                return
                
            # Vérifier qu'une seule parcelle est sélectionnée
            selected_ids = layer.selectedFeatureIds()
            if len(selected_ids) != 1:
                QMessageBox.warning(None, "Sélection", "Veuillez sélectionner exactement une parcelle.")
                return
                
            # Récupérer la parcelle sélectionnée et sauvegarder son ID
            selected_id = selected_ids[0]
            selected_feature = next(layer.getFeatures(QgsFeatureRequest().setFilterFid(selected_id)))
            selected_geom = selected_feature.geometry()
            
            # Trouver les parcelles voisines (qui touchent la sélection)
            bbox = selected_geom.boundingBox()
            request = QgsFeatureRequest().setFilterRect(bbox).setFlags(QgsFeatureRequest.ExactIntersect)
            
            overlapping_parcels = []  # Liste de tuples (feature, surface_chevauchement)
            neighbor_parcels = []
            completely_overlapped_parcels = []  # Parcelles qui contiennent totalement la sélection
            contained_parcels = []  # Parcelles qui sont contenues dans la sélection
            
            # Préparer la transformation CRS si nécessaire (pour calcul de surface)
            crs_src = layer.crs()
            crs_dest = QgsCoordinateReferenceSystem("EPSG:26191")  # Lambert Maroc Nord Zone 1
            transform = QgsCoordinateTransform(crs_src, crs_dest, QgsProject.instance())
            
            for feature in layer.getFeatures(request):
                if feature.id() == selected_id:
                    continue
                    
                neighbor_geom = feature.geometry()
                
                # CAS 1: Vérifier si la parcelle sélectionnée est complètement contenue dans une autre
                if selected_geom.within(neighbor_geom):
                    completely_overlapped_parcels.append(feature)
                
                # CAS 2: Vérifier si la parcelle sélectionnée contient complètement une autre parcelle
                elif selected_geom.contains(neighbor_geom):
                    contained_parcels.append(feature)
                
                # Vérifier si elles se touchent (adjacentes)
                elif selected_geom.touches(neighbor_geom):
                    neighbor_parcels.append(feature)
                
                # Vérifier le chevauchement partiel (erreur)
                elif selected_geom.overlaps(neighbor_geom):
                    # Calculer la zone de chevauchement
                    intersection = selected_geom.intersection(neighbor_geom)
                    if not intersection.isEmpty() and intersection.isGeosValid():
                        # Transformer en CRS projeté pour un calcul de surface précis
                        intersection_proj = QgsGeometry(intersection)
                        intersection_proj.transform(transform)
                        area = intersection_proj.area()
                        
                        # Formater la surface
                        if area > 10000:  # > 1 hectare
                            area_str = f"{area/10000:.4f} ha"
                        else:
                            area_str = f"{area:.2f} m²"
                    else:
                        area_str = "Surface non calculable"
                    
                    overlapping_parcels.append((feature, area_str))
            
            # Préparer le message de résultat
            result_message = "Résultat de l'analyse:\n\n"
            
            # Liste pour stocker toutes les parcelles à sélectionner
            all_selected_ids = [selected_id]
            
            # CAS 1: Parcelle contenue dans d'autres
            if completely_overlapped_parcels:
                result_message += "🚨 ATTENTION : Cette parcelle tombe en totalité sur d'autres parcelles !\n"
                result_message += f"Parcelles englobantes ({len(completely_overlapped_parcels)}):\n"
                for parcel in completely_overlapped_parcels:
                    field_names = {field.name().lower(): field.name() for field in layer.fields()}
                    nature = parcel[field_names['nature']] if 'nature' in field_names else "?"
                    num = parcel[field_names['num']] if 'num' in field_names else "?"
                    indice = parcel[field_names['indice']] if 'indice' in field_names else "?"
                    
                    result_message += f"- {nature}{num}/{indice}\n"
                    all_selected_ids.append(parcel.id())
                result_message += "\n"
            
            # CAS 2: Parcelle conteneur d'autres parcelles
            if contained_parcels:
                result_message += "🔍 La parcelle sélectionnée contient en totalité d'autres parcelles :\n"
                result_message += f"Parcelles contenues ({len(contained_parcels)}):\n"
                for parcel in contained_parcels:
                    field_names = {field.name().lower(): field.name() for field in layer.fields()}
                    nature = parcel[field_names['nature']] if 'nature' in field_names else "?"
                    num = parcel[field_names['num']] if 'num' in field_names else "?"
                    indice = parcel[field_names['indice']] if 'indice' in field_names else "?"
                    
                    result_message += f"- {nature}{num}/{indice}\n"
                    all_selected_ids.append(parcel.id())
                
                # # Calculer la surface totale des parcelles contenues
                # total_area = 0
                # for parcel in contained_parcels:
                #     geom_proj = QgsGeometry(parcel.geometry())
                #     geom_proj.transform(transform)
                #     total_area += geom_proj.area()
                
                # # Formater la surface totale
                # if total_area > 10000:
                #     total_area_str = f"{total_area/10000:.4f} ha"
                # else:
                #     total_area_str = f"{total_area:.2f} m²"
                
                # # Calculer le ratio surface contenue / surface sélectionnée
                # selected_geom_proj = QgsGeometry(selected_geom)
                # selected_geom_proj.transform(transform)
                # selected_area = selected_geom_proj.area()
                
                # if selected_area > 0:
                #     ratio = (total_area / selected_area) * 100
                #     result_message += f"Surface totale des parcelles contenues : {total_area_str} ({ratio:.1f}% de la parcelle sélectionnée)\n"
                # result_message += "\n"
            
            # CAS 3: Chevauchements partiels
            if overlapping_parcels:
                result_message += "⚠️ Chevauchements partiels détectés :\n"
                for parcel, area in overlapping_parcels:
                    field_names = {field.name().lower(): field.name() for field in layer.fields()}
                    nature = parcel[field_names['nature']] if 'nature' in field_names else "?"
                    num = parcel[field_names['num']] if 'num' in field_names else "?"
                    indice = parcel[field_names['indice']] if 'indice' in field_names else "?"
                    
                    result_message += f"- {nature}{num}/{indice} (Surface chevauchement: {area})\n"
                    all_selected_ids.append(parcel.id())
                result_message += "\n"
            
            # Aucun problème détecté
            if not completely_overlapped_parcels and not contained_parcels and not overlapping_parcels:
                result_message += "✅ Aucun chevauchement problématique détecté\n\n"
            
            # Parcelles adjacentes (normales)
            result_message += f"Parcelles riveraines ({len(neighbor_parcels)}):\n"
            for parcel in neighbor_parcels:
                field_names = {field.name().lower(): field.name() for field in layer.fields()}
                nature = parcel[field_names['nature']] if 'nature' in field_names else "?"
                num = parcel[field_names['num']] if 'num' in field_names else "?"
                indice = parcel[field_names['indice']] if 'indice' in field_names else "?"
                
                result_message += f"- {nature}{num}/{indice}\n"
            
            # Appliquer la sélection
            layer.selectByIds(all_selected_ids)
            
            # Afficher les résultats
            QMessageBox.information(None, "Vérification des chevauchements", result_message)
            
            # Calculer l'étendue pour le zoom
            extent = selected_geom.boundingBox()
            
            # Étendre l'étendue selon les cas détectés
            if completely_overlapped_parcels:
                for f in completely_overlapped_parcels:
                    extent.combineExtentWith(f.geometry().boundingBox())
            
            if contained_parcels:
                for f in contained_parcels:
                    extent.combineExtentWith(f.geometry().boundingBox())
            
            if overlapping_parcels:
                for f, _ in overlapping_parcels:
                    extent.combineExtentWith(f.geometry().boundingBox())
            
            if neighbor_parcels:
                for f in neighbor_parcels:
                    extent.combineExtentWith(f.geometry().boundingBox())
            
            # Appliquer le zoom
            self.iface.mapCanvas().setExtent(extent)
            self.iface.mapCanvas().refresh()
                
        except Exception as e:
            QMessageBox.warning(None, "Erreur", f"Erreur lors de la vérification :\n{str(e)}")




    def locate_coordinates(self):
        from qgis.core import (
            QgsPointXY,
            QgsCoordinateReferenceSystem,
            QgsCoordinateTransform,
            QgsProject
        )
        from qgis.PyQt.QtWidgets import QMessageBox
        from qgis.gui import QgsVertexMarker
        from PyQt5.QtGui import QColor

        try:
            x = float(self.dlg.lineEdit_x.text())
            y = float(self.dlg.lineEdit_y.text())

            crs_src = QgsCoordinateReferenceSystem("EPSG:26191")  # Lambert Maroc Nord Zone 1
            crs_dest = self.iface.mapCanvas().mapSettings().destinationCrs()

            transform = QgsCoordinateTransform(crs_src, crs_dest, QgsProject.instance())
            point_lambert = QgsPointXY(x, y)
            point_proj = transform.transform(point_lambert)

            # Centrer la carte
            self.iface.mapCanvas().setCenter(point_proj)
            self.iface.mapCanvas().zoomScale(5000)
            self.iface.mapCanvas().refresh()

            # Supprimer l'ancien marqueur s'il existe
            if hasattr(self, 'marker') and self.marker is not None:
                self.iface.mapCanvas().scene().removeItem(self.marker)

            # Ajouter un nouveau marqueur rouge
            self.marker = QgsVertexMarker(self.iface.mapCanvas())
            self.marker.setCenter(point_proj)
            self.marker.setColor(QColor(255, 0, 0))  # Rouge
            self.marker.setIconSize(12)
            self.marker.setIconType(QgsVertexMarker.ICON_CROSS)  # ou ICON_BOX, ICON_X
            self.marker.setPenWidth(3)

        except Exception as e:
            QMessageBox.warning(None, "Erreur", f"Erreur lors de la localisation :\n{str(e)}")
    def locate_by_parcelle(self):
        from qgis.core import (
            QgsProject, QgsExpression, QgsFeatureRequest, QgsRectangle
        )
        from qgis.PyQt.QtWidgets import QMessageBox

        try:

            # Récupérer la couche
            idx = self.dlg.comboLayer.currentIndex()
            layer_id = self.dlg.comboLayer.itemData(idx)
            layer = QgsProject.instance().mapLayer(layer_id)
            
            # Trouver les noms réels des champs (insensibles à la casse)
            field_names = {field.name().lower(): field.name() for field in layer.fields()}
            
            target_fields = {
                'nature': 'nature',
                'num': 'num',
                'indice': 'indice'
            }
            
            # Vérifier la présence des champs
            missing_fields = []
            for key, target in target_fields.items():
                if target not in field_names:
                    missing_fields.append(target)
            
            if missing_fields:
                QMessageBox.warning(None, "Champs manquants", 
                    f"Champs requis non trouvés : {', '.join(missing_fields)}")
                return
            
            # Récupérer les noms réels des champs
            real_nature = field_names['nature']
            real_num = field_names['num']
            real_indice = field_names['indice']


            nature = self.dlg.comboNature.currentText().strip()
            indice = self.dlg.comboIndice.currentText().strip()
            numero = self.dlg.lineEdit_numero.text().strip()

            if not nature or not numero or not indice:
                QMessageBox.warning(None, "Champs manquants", "Veuillez remplir tous les champs : Nature, Numéro et Indice.")
                return

            # Récupérer la couche sélectionnée
            idx = self.dlg.comboLayer.currentIndex()
            layer_id = self.dlg.comboLayer.itemData(idx)
            layer = QgsProject.instance().mapLayer(layer_id)

            if not layer:
                QMessageBox.warning(None, "Erreur", "Aucune couche valide sélectionnée.")
                return

            # Requête SQL — adapte les noms de champs si nécessaire
            expression = f"""
                "{real_nature}" = '{nature}' AND 
                "{real_num}" = '{numero}' AND 
                "{real_indice}" = '{indice}'
            """
            request = QgsFeatureRequest().setFilterExpression(expression)

            matching_features = [f for f in layer.getFeatures(request)]

            if not matching_features:
                QMessageBox.information(None, "Aucune parcelle", "Aucune parcelle trouvée avec ces identifiants.")
                return

            # Obtenir les IDs des entités
            ids = [f.id() for f in matching_features]

            # Sélectionner les entités dans la couche
            layer.removeSelection()
            layer.selectByIds(ids)

            # Zoomer sur l’étendue combinée des entités sélectionnées
            extent = matching_features[0].geometry().boundingBox()
            for f in matching_features[1:]:
                extent.combineExtentWith(f.geometry().boundingBox())

            self.iface.mapCanvas().setExtent(extent)
            self.iface.mapCanvas().refresh()

        except Exception as e:
            QMessageBox.warning(None, "Erreur", f"Erreur lors de la recherche :\n{str(e)}")
    def toggle_dock_visibility(self):
        if self.dock_widget.isVisible():
            self.dock_widget.hide()
        else:
            self.dock_widget.show()

