# -*- coding: utf-8 -*-
"""
/***************************************************************************
 localCoordinateDigitizer
                                 A QGIS plugin
 Digitizes in distances from a local reference point
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-08-02
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Morten Sickel
        email                : morten@sickel.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.core import QgsMapLayerProxyModel, QgsFeature, QgsVectorLayer, QgsPoint, QgsGeometry, QgsPointXY
# Initialize Qt resources from file resources.py
from .resources import *
from qgis.core import Qgis

# Import the code for the DockWidget
from .localcoordinates_dockwidget import localCoordinateDigitizerDockWidget
import os.path
import math

class localCoordinateDigitizer:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'localCoordinateDigitizer_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Digitize local coordinates')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'localCoordinateDigitizer')
        self.toolbar.setObjectName(u'localCoordinateDigitizer')

        #print "** INITIALIZING localCoordinateDigitizer"

        self.pluginIsActive = False
        self.dockwidget = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('localCoordinateDigitizer', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/localcoordinates/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Digitize local coordinates'),
            callback=self.run,
            parent=self.iface.mainWindow())

    #--------------------------------------------------------------------------

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING localCoordinateDigitizer"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD localCoordinateDigitizer"

        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Digitize local coordinates'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    #--------------------------------------------------------------------------

    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING localCoordinateDigitizer"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)
            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = localCoordinateDigitizerDockWidget()
                self.dockwidget.mlReference.setFilters(QgsMapLayerProxyModel.LineLayer)
                self.dockwidget.mlWork.setFilters(QgsMapLayerProxyModel.LineLayer)
                # Todo: Show only writeable layers for mlWork
                self.origin=None #QgsReferencedPointXY()
                self.angle=None 
                self.dockwidget.pbAddLine.clicked.connect(self.addline)
                self.dockwidget.pbSwap.clicked.connect(self.swapends)
                
                self.dockwidget.mlReference.currentIndexChanged['QString'].connect(self.setcoordinatesystem)
            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)
            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()
    
    
    def swapends(self):
      dw=self.dockwidget
      oldfromx=dw.lefromX.text()
      oldfromy=dw.lefromY.text()
      dw.lefromX.setText(dw.letoX.text())
      dw.lefromY.setText(dw.letoY.text())
      dw.letoX.setText(oldfromx)
      dw.letoY.setText(oldfromy)
    
    def reproject(self,x,y):
      # Projects the local coordinate into map coordinates
      if x !=0:
        v1=math.atan(y/x)
      else:
        v1=math.pi/2
      print(v1)
      if y < 0 and x<=0:
        v1=v1+math.pi
      print(v1)
      l=math.sqrt(x**2+y**2)
      v2=v1-self.angle
      y=math.sin(v2)*l
      x=math.cos(v2)*l
      point=QgsPoint(x+self.origin.x(),y+self.origin.y())
      return(point)
      
    
    def addline(self):
      if self.angle==None:
        # This should not happen, but put a warning anyhow
        # TODO: Use a proper type of warning
        message="Reference layer not selected"
        level=Qgis.Warning
        self.iface.messageBar().pushMessage("Local coordinates", message, level=level)
        return(None)
      dw=self.dockwidget
      # TODO: Handle missing or invalid values
      toxy=dw.letoX.text()!='' and dw.letoY.text() != ''
      try:
        x0=float(dw.lefromX.text())
        y0=float(dw.lefromY.text())
        print(x0,y0)
        p0=self.reproject(x0,y0)
        if toxy:
          x1=float(dw.letoX.text())
          y1=float(dw.letoY.text())
        else:
          ang=float(dw.leangle.text())/180*math.pi
          length=float(dw.lelength.text())
          x1=x0+math.sin(ang)*length
          y1=y0+math.cos(ang)*length
          dw.letoX.setText(str(x1))
          dw.letoY.setText(str(y1))
        
        print(x1,y1)
        p1=self.reproject(x1,y1)
        line = QgsGeometry.fromPolyline([p0,p1])  
        worklayer=dw.mlWork.currentLayer()
        pr=worklayer.dataProvider()
        seg = QgsFeature()
        # add the geometry to the feature, 
        seg.setGeometry(line)
        # add the geometry to the layer
        pr.addFeatures( [ seg ] )
        # update extent of the layer (not necessary)
        worklayer.updateExtents()
        # Reload the layer to show the new line
        worklayer.reload()
      except Exception as e:
        message="Could not add line, check number formats"
        level=Qgis.Warning
        print(e)
        self.iface.messageBar().pushMessage("Local coordinates", message, level=level)

    
    def setcoordinatesystem(self):
      # TODO: Check if there is at least one line in the layer
      self.dockwidget.pbAddLine.setEnabled(True)
      axislayer = self.dockwidget.mlReference.currentLayer()
      # TODO: Use the first feature in a less kludgy way...
      feat = QgsFeature()
      geom=None
      for feature in axislayer.getFeatures():
        if geom==None:
          geom = feature.geometry().asPolyline()
          print("origin:    {},{}".format(geom[0].x(),geom[0].y()))
          print("lastpoint: {},{}".format(geom[1].x(),geom[1].y()))
          self.origin=geom[0]
      # feature=axislayer.nextFeature(feat)
      #geom = feature.geometry().asPolyline()
      self.origin=geom[0]
      self.angle=math.atan(abs(geom[1].y()-geom[0].y())/abs(geom[1].x()-geom[0].x()))
          


